/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.com.univocity.parsers.common.input;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.ArgumentUtils;

public final class BomInput
extends InputStream {
    public static final byte[] UTF_8_BOM = ArgumentUtils.toByteArray(239, 187, 191);
    public static final byte[] UTF_16BE_BOM = ArgumentUtils.toByteArray(254, 255);
    public static final byte[] UTF_16LE_BOM = ArgumentUtils.toByteArray(255, 254);
    public static final byte[] UTF_32BE_BOM = ArgumentUtils.toByteArray(0, 0, 254, 255);
    public static final byte[] UTF_32LE_BOM = ArgumentUtils.toByteArray(255, 254, 0, 0);
    private int bytesRead;
    private int b1;
    private int b2;
    private int b3;
    private int b4;
    private String encoding;
    private final InputStream input;
    private IOException exception;

    public BomInput(InputStream input) {
        this.input = input;
        try {
            this.b1 = this.next();
            if (this.b1 == 239) {
                this.b2 = this.next();
                if (this.b2 == 187 && (this.b3 = this.next()) == 191) {
                    this.setEncoding("UTF-8");
                }
            } else if (this.b1 == 254) {
                this.b2 = this.next();
                if (this.b2 == 255) {
                    this.setEncoding("UTF-16BE");
                }
            } else if (this.b1 == 255) {
                this.b2 = this.next();
                if (this.b2 == 254) {
                    this.b3 = this.next();
                    if (this.b3 == 0) {
                        this.b4 = this.next();
                        if (this.b4 == 0) {
                            this.setEncoding("UTF-32LE");
                        } else {
                            this.setEncoding("UTF-16LE");
                        }
                    } else {
                        this.setEncoding("UTF-16LE");
                    }
                }
            } else if (this.b1 == 0 && (this.b2 = this.next()) == 0 && (this.b3 = this.next()) == 254 && (this.b4 = this.next()) == 255) {
                this.setEncoding("UTF-32BE");
            }
        }
        catch (IOException e) {
            this.exception = e;
        }
    }

    private void setEncoding(String encoding) {
        this.encoding = encoding;
        if (encoding.equals("UTF-16LE")) {
            if (this.bytesRead == 3) {
                this.bytesRead = 1;
                this.b1 = this.b3;
                return;
            }
            if (this.bytesRead == 4) {
                this.bytesRead = 2;
                this.b1 = this.b3;
                this.b2 = this.b4;
                return;
            }
        }
        this.bytesRead = 0;
    }

    private int next() throws IOException {
        int out = this.input.read();
        ++this.bytesRead;
        return out;
    }

    @Override
    public final int read() throws IOException {
        if (this.bytesRead > 0) {
            int out = this.b1;
            if (this.bytesRead == 2) {
                out = this.b2;
            } else if (this.bytesRead == 3) {
                out = this.b3;
            } else if (this.bytesRead == 4) {
                out = this.b4;
            }
            if (--this.bytesRead == 0 && this.exception != null) {
                throw this.exception;
            }
            return out;
        }
        return this.input.read();
    }

    public final boolean hasBytesStored() {
        return this.bytesRead > 0;
    }

    public final Charset getCharset() {
        if (this.encoding == null) {
            return null;
        }
        return Charset.forName(this.encoding);
    }

    public final String getEncoding() {
        return this.encoding;
    }
}

