/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.MethodOrdererContext;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.ClassTestDescriptor;
import org.junit.jupiter.engine.descriptor.JupiterTestDescriptor;
import org.junit.jupiter.engine.descriptor.MethodBasedTestDescriptor;
import org.junit.jupiter.engine.discovery.DefaultMethodDescriptor;
import org.junit.jupiter.engine.discovery.DefaultMethodOrdererContext;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.util.BlacklistedExceptions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.TestDescriptor;

class MethodOrderingVisitor
implements TestDescriptor.Visitor {
    private static final Logger logger = LoggerFactory.getLogger(MethodOrderingVisitor.class);
    private final JupiterConfiguration configuration;

    MethodOrderingVisitor(JupiterConfiguration configuration) {
        this.configuration = configuration;
    }

    public void visit(TestDescriptor testDescriptor) {
        if (testDescriptor instanceof ClassTestDescriptor) {
            ClassTestDescriptor classTestDescriptor = (ClassTestDescriptor)testDescriptor;
            try {
                this.orderContainedMethods(classTestDescriptor, classTestDescriptor.getTestClass());
            }
            catch (Throwable t) {
                BlacklistedExceptions.rethrowIfBlacklisted((Throwable)t);
                logger.error(t, () -> "Failed to order methods for " + classTestDescriptor.getTestClass());
            }
        }
    }

    private void orderContainedMethods(ClassTestDescriptor classTestDescriptor, Class<?> testClass) {
        AnnotationSupport.findAnnotation(testClass, TestMethodOrder.class).map(TestMethodOrder::value).map(x$0 -> (MethodOrderer)ReflectionUtils.newInstance((Class)x$0, (Object[])new Object[0])).ifPresent(methodOrderer -> {
            Set children = classTestDescriptor.getChildren();
            List nonMethodTestDescriptors = children.stream().filter(testDescriptor -> !(testDescriptor instanceof MethodBasedTestDescriptor)).collect(Collectors.toList());
            List methodDescriptors = children.stream().filter(MethodBasedTestDescriptor.class::isInstance).map(MethodBasedTestDescriptor.class::cast).map(DefaultMethodDescriptor::new).collect(Collectors.toCollection(ArrayList::new));
            LinkedHashSet originalMethodDescriptors = new LinkedHashSet(methodDescriptors);
            methodOrderer.orderMethods((MethodOrdererContext)new DefaultMethodOrdererContext(methodDescriptors, testClass, this.configuration));
            int difference = methodDescriptors.size() - originalMethodDescriptors.size();
            if (difference > 0) {
                logger.warn(() -> String.format("MethodOrderer [%s] added %s MethodDescriptor(s) for test class [%s] which will be ignored.", methodOrderer.getClass().getName(), difference, testClass.getName()));
            } else if (difference < 0) {
                logger.warn(() -> String.format("MethodOrderer [%s] removed %s MethodDescriptor(s) for test class [%s] which will be retained with arbitrary ordering.", methodOrderer.getClass().getName(), -difference, testClass.getName()));
            }
            Set sortedMethodTestDescriptors = methodDescriptors.stream().filter(originalMethodDescriptors::contains).map(DefaultMethodDescriptor::getTestDescriptor).collect(Collectors.toCollection(LinkedHashSet::new));
            Stream.concat(sortedMethodTestDescriptors.stream(), nonMethodTestDescriptors.stream()).forEach(arg_0 -> ((ClassTestDescriptor)classTestDescriptor).removeChild(arg_0));
            Stream.concat(sortedMethodTestDescriptors.stream(), nonMethodTestDescriptors.stream()).forEach(arg_0 -> ((ClassTestDescriptor)classTestDescriptor).addChild(arg_0));
            methodOrderer.getDefaultExecutionMode().map(JupiterTestDescriptor::toExecutionMode).ifPresent(classTestDescriptor::setDefaultChildExecutionMode);
        });
    }
}

