/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.ExecutableInvoker;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.MediaType;
import org.junit.jupiter.api.function.ThrowingConsumer;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.LauncherStoreFacade;
import org.junit.jupiter.engine.execution.DefaultExecutableInvoker;
import org.junit.jupiter.engine.extension.ExtensionContextInternal;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.UnrecoverableExceptions;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.reporting.FileEntry;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.engine.support.hierarchical.Node;
import org.junit.platform.engine.support.store.Namespace;
import org.junit.platform.engine.support.store.NamespacedHierarchicalStore;

abstract class AbstractExtensionContext<T extends TestDescriptor>
implements ExtensionContextInternal,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractExtensionContext.class);
    private final ExtensionContext parent;
    private final EngineExecutionListener engineExecutionListener;
    private final T testDescriptor;
    private final Set<String> tags;
    private final JupiterConfiguration configuration;
    private final ExecutableInvoker executableInvoker;
    private final ExtensionRegistry extensionRegistry;
    private final LauncherStoreFacade launcherStoreFacade;
    private final NamespacedHierarchicalStore<Namespace> valuesStore;

    AbstractExtensionContext(ExtensionContext parent, EngineExecutionListener engineExecutionListener, T testDescriptor, JupiterConfiguration configuration, ExtensionRegistry extensionRegistry, LauncherStoreFacade launcherStoreFacade) {
        Preconditions.notNull(testDescriptor, (String)"TestDescriptor must not be null");
        Preconditions.notNull((Object)configuration, (String)"JupiterConfiguration must not be null");
        Preconditions.notNull((Object)extensionRegistry, (String)"ExtensionRegistry must not be null");
        this.executableInvoker = new DefaultExecutableInvoker(this, extensionRegistry);
        this.parent = parent;
        this.engineExecutionListener = engineExecutionListener;
        this.testDescriptor = testDescriptor;
        this.configuration = configuration;
        this.extensionRegistry = extensionRegistry;
        this.launcherStoreFacade = launcherStoreFacade;
        this.tags = testDescriptor.getTags().stream().map(TestTag::getName).collect(Collectors.collectingAndThen(Collectors.toCollection(LinkedHashSet::new), Collections::unmodifiableSet));
        this.valuesStore = AbstractExtensionContext.createStore(parent, launcherStoreFacade, this.createCloseAction());
    }

    private NamespacedHierarchicalStore.CloseAction<Namespace> createCloseAction() {
        return (__, ___, value) -> {
            boolean isAutoCloseEnabled = this.configuration.isClosingStoredAutoCloseablesEnabled();
            if (value instanceof AutoCloseable && isAutoCloseEnabled) {
                ((AutoCloseable)value).close();
                return;
            }
            if (value instanceof ExtensionContext.Store.CloseableResource) {
                if (isAutoCloseEnabled) {
                    LOGGER.warn(() -> "Type implements CloseableResource but not AutoCloseable: " + value.getClass().getName());
                }
                ((ExtensionContext.Store.CloseableResource)value).close();
            }
        };
    }

    private static NamespacedHierarchicalStore<Namespace> createStore(ExtensionContext parent, LauncherStoreFacade launcherStoreFacade, NamespacedHierarchicalStore.CloseAction<Namespace> closeAction) {
        NamespacedHierarchicalStore<Namespace> parentStore = parent == null ? launcherStoreFacade.getRequestLevelStore() : ((AbstractExtensionContext)parent).valuesStore;
        return new NamespacedHierarchicalStore(parentStore, closeAction);
    }

    @Override
    public void close() {
        this.valuesStore.close();
    }

    public String getUniqueId() {
        return this.getTestDescriptor().getUniqueId().toString();
    }

    public String getDisplayName() {
        return this.getTestDescriptor().getDisplayName();
    }

    public void publishReportEntry(Map<String, String> values) {
        this.engineExecutionListener.reportingEntryPublished(this.testDescriptor, ReportEntry.from(values));
    }

    public void publishFile(String name, MediaType mediaType, ThrowingConsumer<Path> action) {
        Preconditions.notNull((Object)name, (String)"name must not be null");
        Preconditions.notNull((Object)mediaType, (String)"mediaType must not be null");
        Preconditions.notNull(action, (String)"action must not be null");
        this.publishFileEntry(name, action, file -> {
            Preconditions.condition((boolean)Files.isRegularFile(file, new LinkOption[0]), () -> "Published path must be a regular file: " + file);
            return FileEntry.from((Path)file, (String)mediaType.toString());
        });
    }

    public void publishDirectory(String name, ThrowingConsumer<Path> action) {
        Preconditions.notNull((Object)name, (String)"name must not be null");
        Preconditions.notNull(action, (String)"action must not be null");
        ThrowingConsumer enhancedAction = path -> {
            Files.createDirectory(path, new FileAttribute[0]);
            action.accept(path);
        };
        this.publishFileEntry(name, (ThrowingConsumer<Path>)enhancedAction, file -> {
            Preconditions.condition((boolean)Files.isDirectory(file, new LinkOption[0]), () -> "Published path must be a directory: " + file);
            return FileEntry.from((Path)file, null);
        });
    }

    private void publishFileEntry(String name, ThrowingConsumer<Path> action, Function<Path, FileEntry> fileEntryCreator) {
        Path dir = this.createOutputDirectory();
        Path path = dir.resolve(name);
        Preconditions.condition((boolean)path.getParent().equals(dir), () -> "name must not contain path separators: " + name);
        try {
            action.accept((Object)path);
        }
        catch (Throwable t) {
            UnrecoverableExceptions.rethrowIfUnrecoverable((Throwable)t);
            throw new JUnitException("Failed to publish path", t);
        }
        Preconditions.condition((boolean)Files.exists(path, new LinkOption[0]), () -> "Published path must exist: " + path);
        FileEntry fileEntry = fileEntryCreator.apply(path);
        this.engineExecutionListener.fileEntryPublished(this.testDescriptor, fileEntry);
    }

    private Path createOutputDirectory() {
        try {
            return this.configuration.getOutputDirectoryProvider().createOutputDirectory(this.testDescriptor);
        }
        catch (IOException e) {
            throw new JUnitException("Failed to create output directory", (Throwable)e);
        }
    }

    public Optional<ExtensionContext> getParent() {
        return Optional.ofNullable(this.parent);
    }

    public ExtensionContext getRoot() {
        if (this.parent != null) {
            return this.parent.getRoot();
        }
        return this;
    }

    protected T getTestDescriptor() {
        return this.testDescriptor;
    }

    public ExtensionContext.Store getStore(ExtensionContext.Namespace namespace) {
        return this.launcherStoreFacade.getStoreAdapter(this.valuesStore, namespace);
    }

    public ExtensionContext.Store getStore(ExtensionContext.StoreScope scope, ExtensionContext.Namespace namespace) {
        switch (scope) {
            case LAUNCHER_SESSION: {
                return this.launcherStoreFacade.getSessionLevelStore(namespace);
            }
            case EXECUTION_REQUEST: {
                return this.launcherStoreFacade.getRequestLevelStore(namespace);
            }
            case EXTENSION_CONTEXT: {
                return this.getStore(namespace);
            }
        }
        throw new JUnitException("Unknown StoreScope: " + scope);
    }

    public Set<String> getTags() {
        return new LinkedHashSet<String>(this.tags);
    }

    public Optional<String> getConfigurationParameter(String key) {
        return this.configuration.getRawConfigurationParameter(key);
    }

    public <V> Optional<V> getConfigurationParameter(String key, Function<String, V> transformer) {
        return this.configuration.getRawConfigurationParameter(key, transformer);
    }

    public ExecutionMode getExecutionMode() {
        return this.toJupiterExecutionMode(this.getPlatformExecutionMode());
    }

    public ExecutableInvoker getExecutableInvoker() {
        return this.executableInvoker;
    }

    @Override
    public <E extends Extension> List<E> getExtensions(Class<E> extensionType) {
        return this.extensionRegistry.getExtensions(extensionType);
    }

    protected abstract Node.ExecutionMode getPlatformExecutionMode();

    private ExecutionMode toJupiterExecutionMode(Node.ExecutionMode mode) {
        switch (mode) {
            case CONCURRENT: {
                return ExecutionMode.CONCURRENT;
            }
            case SAME_THREAD: {
                return ExecutionMode.SAME_THREAD;
            }
        }
        throw new JUnitException("Unknown ExecutionMode: " + mode);
    }
}

