/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.util.Optional;
import java.util.logging.Logger;
import org.junit.jupiter.api.TestInstance;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.ConfigurationParameters;

final class TestInstanceLifecycleUtils {
    private static final Logger logger = Logger.getLogger(TestInstanceLifecycleUtils.class.getName());

    private TestInstanceLifecycleUtils() {
    }

    static TestInstance.Lifecycle getTestInstanceLifecycle(Class<?> testClass, ConfigurationParameters configParams) {
        Preconditions.notNull(testClass, (String)"testClass must not be null");
        Preconditions.notNull((Object)configParams, (String)"ConfigurationParameters must not be null");
        return AnnotationUtils.findAnnotation(testClass, TestInstance.class).map(TestInstance::value).orElseGet(() -> TestInstanceLifecycleUtils.getDefaultTestInstanceLifecycle(configParams));
    }

    static TestInstance.Lifecycle getDefaultTestInstanceLifecycle(ConfigurationParameters configParams) {
        Preconditions.notNull((Object)configParams, (String)"ConfigurationParameters must not be null");
        String propertyName = "junit.jupiter.testinstance.lifecycle.default";
        Optional optional = configParams.get(propertyName);
        String constantName = null;
        if (optional.isPresent()) {
            try {
                constantName = ((String)optional.get()).trim().toUpperCase();
                TestInstance.Lifecycle lifecycle = TestInstance.Lifecycle.valueOf((String)constantName);
                logger.info(() -> String.format("Using default test instance lifecycle mode '%s' set via the '%s' configuration parameter.", lifecycle, propertyName));
                return lifecycle;
            }
            catch (Exception ex) {
                String constant = constantName;
                logger.warning(() -> String.format("Invalid test instance lifecycle mode '%s' set via the '%s' configuration parameter. Falling back to %s lifecycle semantics.", constant, propertyName, TestInstance.Lifecycle.PER_METHOD.name()));
            }
        }
        return TestInstance.Lifecycle.PER_METHOD;
    }
}

