/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.extension.ContainerExtensionContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.jupiter.engine.extension.RepeatedTestDisplayNameFormatter;
import org.junit.jupiter.engine.extension.RepeatedTestInvocationContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.StringUtils;

class RepeatedTestExtension
implements TestTemplateInvocationContextProvider {
    private static final Logger logger = Logger.getLogger(RepeatedTestExtension.class.getName());

    RepeatedTestExtension() {
    }

    public boolean supports(ContainerExtensionContext context) {
        return AnnotationUtils.isAnnotated((Optional)context.getTestMethod(), RepeatedTest.class);
    }

    public Stream<TestTemplateInvocationContext> provide(ContainerExtensionContext context) {
        Method testMethod = (Method)Preconditions.notNull(context.getTestMethod().orElse(null), (String)"test method must not be null");
        String displayName = context.getDisplayName();
        RepeatedTest repeatedTest = (RepeatedTest)AnnotationUtils.findAnnotation((AnnotatedElement)testMethod, RepeatedTest.class).get();
        int totalRepetitions = this.totalRepetitions(repeatedTest, testMethod);
        RepeatedTestDisplayNameFormatter formatter = this.displayNameFormatter(repeatedTest, testMethod, displayName);
        return IntStream.rangeClosed(1, totalRepetitions).mapToObj(repetition -> new RepeatedTestInvocationContext(repetition, totalRepetitions, formatter));
    }

    private int totalRepetitions(RepeatedTest repeatedTest, Method method) {
        int repetitions = repeatedTest.value();
        if (repetitions < 1) {
            String message = "Configuration error: @RepeatedTest on method [%s] must be declared with a positive 'value'. Defaulting to 1 repetition.";
            logger.warning(String.format(message, method));
            repetitions = 1;
        }
        return repetitions;
    }

    private RepeatedTestDisplayNameFormatter displayNameFormatter(RepeatedTest repeatedTest, Method method, String displayName) {
        String pattern = repeatedTest.name().trim();
        if (StringUtils.isBlank((String)pattern)) {
            logger.warning(String.format("Configuration error: @RepeatedTest on method [%s] must be declared with a non-empty name.", method));
            pattern = (String)AnnotationUtils.getDefaultValue((Annotation)repeatedTest, (String)"name", String.class).get();
        }
        return new RepeatedTestDisplayNameFormatter(pattern, displayName);
    }
}

