/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Executable;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.support.hierarchical.Node;

@API(value=API.Usage.Internal)
public abstract class JupiterTestDescriptor
extends AbstractTestDescriptor
implements Node<JupiterEngineExecutionContext> {
    JupiterTestDescriptor(UniqueId uniqueId, String displayName) {
        super(uniqueId, displayName);
    }

    protected Set<TestTag> getTags(AnnotatedElement element) {
        return AnnotationUtils.findRepeatableAnnotations((AnnotatedElement)element, Tag.class).stream().map(Tag::value).filter(StringUtils::isNotBlank).map(TestTag::create).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    protected static <E extends AnnotatedElement> String determineDisplayName(E element, Function<E, String> defaultDisplayNameGenerator) {
        return AnnotationUtils.findAnnotation(element, DisplayName.class).map(DisplayName::value).filter(StringUtils::isNotBlank).orElseGet(() -> (String)defaultDisplayNameGenerator.apply(element));
    }

    public boolean isLeaf() {
        return !this.isContainer();
    }

    protected ExtensionRegistry populateNewExtensionRegistryFromExtendWith(AnnotatedElement annotatedElement, ExtensionRegistry existingExtensionRegistry) {
        List<Class<? extends Extension>> extensionTypes = AnnotationUtils.findRepeatableAnnotations((AnnotatedElement)annotatedElement, ExtendWith.class).stream().map(ExtendWith::value).flatMap(Arrays::stream).collect(Collectors.toList());
        return ExtensionRegistry.createRegistryFrom(existingExtensionRegistry, extensionTypes);
    }

    protected void executeAndMaskThrowable(Executable executable) {
        try {
            executable.execute();
        }
        catch (Throwable throwable) {
            ExceptionUtils.throwAsUncheckedException((Throwable)throwable);
        }
    }
}

