/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import org.junit.jupiter.api.AssertionUtils;
import org.junit.jupiter.api.function.Executable;
import org.opentest4j.AssertionFailedError;

class AssertThrows {
    AssertThrows() {
    }

    static <T extends Throwable> T assertThrows(Class<T> expectedType, Executable executable) {
        try {
            executable.execute();
        }
        catch (Throwable actualException) {
            if (expectedType.isInstance(actualException)) {
                return (T)actualException;
            }
            String message = AssertionUtils.format(expectedType, actualException.getClass(), "Unexpected exception type thrown");
            throw new AssertionFailedError(message, actualException);
        }
        throw new AssertionFailedError(String.format("Expected %s to be thrown, but nothing was thrown.", AssertionUtils.getCanonicalName(expectedType)));
    }
}

