/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.Arrays;
import java.util.stream.Stream;
import org.junit.jupiter.api.function.Executable;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.opentest4j.MultipleFailuresError;

class AssertAll {
    AssertAll() {
    }

    static void assertAll(Executable ... executables) {
        AssertAll.assertAll(null, executables);
    }

    static void assertAll(String heading, Executable ... executables) {
        Preconditions.notEmpty((Object[])executables, (String)"executables array must not be null or empty");
        Preconditions.containsNoNullElements((Object[])executables, (String)"individual executables must not be null");
        AssertAll.assertAll(heading, Arrays.stream(executables));
    }

    static void assertAll(Stream<Executable> executables) {
        AssertAll.assertAll(null, executables);
    }

    static void assertAll(String heading, Stream<Executable> executables) {
        Preconditions.notNull(executables, (String)"executables must not be null");
        MultipleFailuresError multipleFailuresError = new MultipleFailuresError(heading);
        executables.forEach(executable -> {
            try {
                executable.execute();
            }
            catch (AssertionError assertionError) {
                multipleFailuresError.addFailure(assertionError);
            }
            catch (Throwable t) {
                ExceptionUtils.throwAsUncheckedException((Throwable)t);
            }
        });
        if (multipleFailuresError.hasFailures()) {
            throw multipleFailuresError;
        }
    }
}

