/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.support.hierarchical;

import java.util.Collections;
import java.util.List;
import org.junit.gen5.commons.util.ExceptionUtils;

final class BlacklistedExceptions {
    private static final List<Class<? extends Throwable>> blacklist = Collections.singletonList(OutOfMemoryError.class);

    private BlacklistedExceptions() {
    }

    static void rethrowIfBlacklisted(Throwable exception) {
        if (blacklist.stream().anyMatch(exceptionType -> exceptionType.isInstance(exception))) {
            ExceptionUtils.throwAsUncheckedException((Throwable)exception);
        }
    }
}

