/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.maven.AbstractMainSchemaMojo;

@Mojo(name="verify", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class VerifySchemaMojo
extends AbstractMainSchemaMojo {
    public static final String OLD_SCHEMAS_DEFAULT = "${basedir}/src/main/jsimpledb/old";
    @Parameter(defaultValue="${basedir}/src/main/jsimpledb/current-schema.xml", property="expectedSchemaFile")
    private File expectedSchemaFile;
    @Parameter(defaultValue="${project.build.directory}/actual-jsimpledb-schema.xml", property="actualSchemaFile")
    private File actualSchemaFile;
    @Parameter(defaultValue="true")
    private boolean autoGenerate;
    @Parameter(defaultValue="true")
    private boolean matchNames;
    @Parameter(defaultValue="${basedir}/src/main/jsimpledb/old", property="oldSchemasDirectory")
    private File oldSchemasDirectory;

    @Override
    protected void execute(JSimpleDB jdb) throws MojoExecutionException, MojoFailureException {
        if (!this.expectedSchemaFile.exists()) {
            if (!this.autoGenerate) {
                throw new MojoFailureException("expected schema file " + this.expectedSchemaFile + " does not exist");
            }
            this.generate(jdb.getSchemaModel(), this.expectedSchemaFile);
            return;
        }
        if (!this.verify(jdb.getSchemaModel(), this.expectedSchemaFile, this.matchNames)) {
            this.getLog().info((CharSequence)("Recommended actions to take:\n  (a) If no schema change was intended, undo whatever Java model class change(s) caused the schema difference.\n  (b) Otherwise:\n      1. Move " + this.expectedSchemaFile + " into " + this.oldSchemasDirectory + "\n      2. Copy " + this.actualSchemaFile + " to " + this.expectedSchemaFile + "\n      3. Update your configured JSimpleDB schema version number (or use -1 to auto-generate)"));
        }
        final ArrayList oldSchemaFiles = new ArrayList();
        if (this.oldSchemasDirectory.exists()) {
            try {
                Files.walkFileTree(this.oldSchemasDirectory.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                        if (path.getNameCount() != 0 && path.getName(path.getNameCount() - 1).toString().endsWith(".xml")) {
                            oldSchemaFiles.add(path.toFile());
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                throw new MojoExecutionException("error walking output directory hierarchy", (Exception)e);
            }
        }
        if (!this.verify(jdb, oldSchemaFiles.iterator())) {
            throw new MojoFailureException("current schema conflicts with one or more old schema versions");
        }
    }
}

