/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.AssignableNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleAsgnNode
extends AssignableNode {
    private ListNode headNode;
    private Node restNode;

    public MultipleAsgnNode(SourcePosition position, ListNode headNode, Node restNode) {
        super(position);
        this.headNode = (ListNode)this.adopt(headNode);
        this.restNode = this.adopt(restNode);
        assert (headNode != null || restNode != null) : "MultipleAsgnNode with neither vars nor splat";
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.MULTIPLEASGNNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitMultipleAsgnNode(this);
    }

    public Node getRest() {
        return this.restNode;
    }

    @Deprecated
    public Node getArgsNode() {
        return this.getRest();
    }

    public ListNode getHead() {
        return this.headNode;
    }

    @Deprecated
    public ListNode getHeadNode() {
        return this.getHead();
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.headNode, this.restNode, this.getValue());
    }

    @Override
    public SourcePosition getLeftHandSidePosition() {
        if (this.getHead() != null) {
            if (this.getRest() != null) {
                return this.getHead().getPosition().union(this.getRest().getPosition());
            }
            return this.getHead().getPosition();
        }
        return this.getRest().getPosition();
    }
}

