/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.parser;

import org.jrubyparser.BlockStaticScope;
import org.jrubyparser.IRubyWarnings;
import org.jrubyparser.ISourcePositionHolder;
import org.jrubyparser.LocalStaticScope;
import org.jrubyparser.RegexpOptions;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.StaticScope;
import org.jrubyparser.ast.AliasNode;
import org.jrubyparser.ast.AndNode;
import org.jrubyparser.ast.ArgsCatNode;
import org.jrubyparser.ast.ArgsNode;
import org.jrubyparser.ast.ArgsPushNode;
import org.jrubyparser.ast.ArgumentNode;
import org.jrubyparser.ast.ArrayNode;
import org.jrubyparser.ast.AssignableNode;
import org.jrubyparser.ast.AttrAssignNode;
import org.jrubyparser.ast.BackRefNode;
import org.jrubyparser.ast.BeginNode;
import org.jrubyparser.ast.BignumNode;
import org.jrubyparser.ast.BinaryOperatorNode;
import org.jrubyparser.ast.BlockArg18Node;
import org.jrubyparser.ast.BlockArgNode;
import org.jrubyparser.ast.BlockNode;
import org.jrubyparser.ast.BlockPassNode;
import org.jrubyparser.ast.CallNode;
import org.jrubyparser.ast.CaseNode;
import org.jrubyparser.ast.ClassVarAsgnNode;
import org.jrubyparser.ast.ClassVarDeclNode;
import org.jrubyparser.ast.ClassVarNode;
import org.jrubyparser.ast.Colon2ConstNode;
import org.jrubyparser.ast.Colon2ImplicitNode;
import org.jrubyparser.ast.Colon2MethodNode;
import org.jrubyparser.ast.Colon2Node;
import org.jrubyparser.ast.Colon3Node;
import org.jrubyparser.ast.ConstDeclNode;
import org.jrubyparser.ast.ConstNode;
import org.jrubyparser.ast.DAsgnNode;
import org.jrubyparser.ast.DRegexpNode;
import org.jrubyparser.ast.DStrNode;
import org.jrubyparser.ast.DotNode;
import org.jrubyparser.ast.EncodingNode;
import org.jrubyparser.ast.EvStrNode;
import org.jrubyparser.ast.FCallNode;
import org.jrubyparser.ast.FalseNode;
import org.jrubyparser.ast.FileNode;
import org.jrubyparser.ast.FixnumNode;
import org.jrubyparser.ast.FlipNode;
import org.jrubyparser.ast.FloatNode;
import org.jrubyparser.ast.GlobalAsgnNode;
import org.jrubyparser.ast.GlobalVarNode;
import org.jrubyparser.ast.IArgumentNode;
import org.jrubyparser.ast.ILiteralNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.IfNode;
import org.jrubyparser.ast.InstAsgnNode;
import org.jrubyparser.ast.InstVarNode;
import org.jrubyparser.ast.IterNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.LocalAsgnNode;
import org.jrubyparser.ast.Match2Node;
import org.jrubyparser.ast.Match3Node;
import org.jrubyparser.ast.MatchNode;
import org.jrubyparser.ast.MultipleAsgnNode;
import org.jrubyparser.ast.NewlineNode;
import org.jrubyparser.ast.NilImplicitNode;
import org.jrubyparser.ast.NilNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NthRefNode;
import org.jrubyparser.ast.OpElementAsgnNode;
import org.jrubyparser.ast.OrNode;
import org.jrubyparser.ast.RegexpNode;
import org.jrubyparser.ast.RestArgNode;
import org.jrubyparser.ast.RootNode;
import org.jrubyparser.ast.SValueNode;
import org.jrubyparser.ast.SelfNode;
import org.jrubyparser.ast.SplatNode;
import org.jrubyparser.ast.StrNode;
import org.jrubyparser.ast.SuperNode;
import org.jrubyparser.ast.SymbolNode;
import org.jrubyparser.ast.TrueNode;
import org.jrubyparser.ast.UndefNode;
import org.jrubyparser.ast.WhenNode;
import org.jrubyparser.ast.YieldNode;
import org.jrubyparser.lexer.Lexer;
import org.jrubyparser.lexer.SyntaxException;
import org.jrubyparser.lexer.Token;
import org.jrubyparser.parser.ParserConfiguration;
import org.jrubyparser.parser.ParserResult;

public class ParserSupport {
    protected Lexer lexer;
    protected StaticScope currentScope;
    private int inSingleton;
    private boolean inDefinition;
    protected IRubyWarnings warnings;
    private ParserConfiguration configuration;
    private ParserResult result;

    public static boolean isConstant(String id) {
        return Character.isUpperCase(id.charAt(0));
    }

    public void reset() {
        this.inSingleton = 0;
        this.inDefinition = false;
    }

    public StaticScope getCurrentScope() {
        return this.currentScope;
    }

    public ParserConfiguration getConfiguration() {
        return this.configuration;
    }

    public void popCurrentScope() {
        this.currentScope = this.currentScope.getEnclosingScope();
    }

    public void pushBlockScope() {
        this.currentScope = new BlockStaticScope(this.currentScope);
    }

    public void pushLocalScope() {
        this.currentScope = new LocalStaticScope(this.currentScope);
    }

    public Node arg_concat(SourcePosition position, Node node1, Node node2) {
        return node2 == null ? node1 : new ArgsCatNode(position, node1, node2);
    }

    public Node arg_blk_pass(Node firstNode, BlockPassNode secondNode) {
        if (secondNode != null) {
            secondNode.setArgsNode(firstNode);
            secondNode.setPosition(this.union(firstNode, secondNode));
            return secondNode;
        }
        return firstNode;
    }

    public Node gettable2(Node node) {
        switch (node.getNodeType()) {
            case DASGNNODE: 
            case LOCALASGNNODE: {
                return this.currentScope.declare(node.getPosition(), ((INameNode)((Object)node)).getName());
            }
            case CONSTDECLNODE: {
                return new ConstNode(node.getPosition(), ((INameNode)((Object)node)).getName());
            }
            case INSTASGNNODE: {
                return new InstVarNode(node.getPosition(), ((INameNode)((Object)node)).getName());
            }
            case CLASSVARDECLNODE: 
            case CLASSVARASGNNODE: {
                return new ClassVarNode(node.getPosition(), ((INameNode)((Object)node)).getName());
            }
            case GLOBALASGNNODE: {
                return new GlobalVarNode(node.getPosition(), ((INameNode)((Object)node)).getName());
            }
        }
        this.getterIdentifierError(node.getPosition(), ((INameNode)((Object)node)).getName());
        return null;
    }

    public Node gettable(Token token) {
        switch (token.getType()) {
            case 286: {
                return new SelfNode(token.getPosition());
            }
            case 287: {
                return new NilNode(token.getPosition());
            }
            case 288: {
                return new TrueNode(token.getPosition());
            }
            case 289: {
                return new FalseNode(token.getPosition());
            }
            case 303: {
                return new FileNode(token.getPosition(), token.getPosition().getFile());
            }
            case 302: {
                return new FixnumNode(token.getPosition(), token.getPosition().getEndLine() + 1);
            }
            case 304: {
                return new EncodingNode(token.getPosition());
            }
            case 306: {
                return this.currentScope.declare(token.getPosition(), (String)token.getValue());
            }
            case 310: {
                return new ConstNode(token.getPosition(), (String)token.getValue());
            }
            case 309: {
                return new InstVarNode(token.getPosition(), (String)token.getValue());
            }
            case 311: {
                return new ClassVarNode(token.getPosition(), (String)token.getValue());
            }
            case 308: {
                return new GlobalVarNode(token.getPosition(), (String)token.getValue());
            }
        }
        this.getterIdentifierError(token.getPosition(), (String)token.getValue());
        return null;
    }

    protected void getterIdentifierError(SourcePosition position, String identifier) {
        throw new SyntaxException(SyntaxException.PID.BAD_IDENTIFIER, position, "identifier " + identifier + " is not valid", identifier);
    }

    public AssignableNode assignable(Token lhs, Node value) {
        this.checkExpression(value);
        switch (lhs.getType()) {
            case 286: {
                throw new SyntaxException(SyntaxException.PID.CANNOT_CHANGE_SELF, lhs.getPosition(), "Can't change the value of self", new Object[0]);
            }
            case 287: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, lhs.getPosition(), "Can't assign to nil", "nil");
            }
            case 288: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, lhs.getPosition(), "Can't assign to true", "true");
            }
            case 289: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, lhs.getPosition(), "Can't assign to false", "false");
            }
            case 303: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, lhs.getPosition(), "Can't assign to __FILE__", "__FILE__");
            }
            case 302: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, lhs.getPosition(), "Can't assign to __LINE__", "__LINE__");
            }
            case 306: {
                return this.currentScope.assign(value != NilImplicitNode.NIL ? this.union(lhs, value) : lhs.getPosition(), (String)lhs.getValue(), this.makeNullNil(value));
            }
            case 310: {
                if (this.isInDef() || this.isInSingle()) {
                    throw new SyntaxException(SyntaxException.PID.DYNAMIC_CONSTANT_ASSIGNMENT, lhs.getPosition(), "dynamic constant assignment", new Object[0]);
                }
                return new ConstDeclNode(lhs.getPosition(), (String)lhs.getValue(), null, value);
            }
            case 309: {
                return new InstAsgnNode(lhs.getPosition(), (String)lhs.getValue(), value);
            }
            case 311: {
                if (this.isInDef() || this.isInSingle()) {
                    return new ClassVarAsgnNode(lhs.getPosition(), (String)lhs.getValue(), value);
                }
                return new ClassVarDeclNode(lhs.getPosition(), (String)lhs.getValue(), value);
            }
            case 308: {
                return new GlobalAsgnNode(lhs.getPosition(), (String)lhs.getValue(), value);
            }
        }
        throw new SyntaxException(SyntaxException.PID.BAD_IDENTIFIER, lhs.getPosition(), "identifier " + (String)lhs.getValue() + " is not valid", lhs.getValue());
    }

    public Node newline_node(Node node, SourcePosition position) {
        if (node == null) {
            return null;
        }
        return node instanceof NewlineNode ? node : new NewlineNode(position, node);
    }

    public SourcePosition union(ISourcePositionHolder first, ISourcePositionHolder second) {
        while (first instanceof NewlineNode) {
            first = ((NewlineNode)first).getNextNode();
        }
        while (second instanceof NewlineNode) {
            second = ((NewlineNode)second).getNextNode();
        }
        if (second == null) {
            return first.getPosition();
        }
        if (first == null) {
            return second.getPosition();
        }
        return first.getPosition().union(second.getPosition());
    }

    public SourcePosition union(SourcePosition first, SourcePosition second) {
        if (first.getStartOffset() < second.getStartOffset()) {
            return first.union(second);
        }
        return second.union(first);
    }

    public Node addRootNode(Node topOfAST, SourcePosition position) {
        SourcePosition sourcePosition = position = topOfAST != null ? topOfAST.getPosition() : position;
        if (this.result.getBeginNodes().isEmpty()) {
            if (topOfAST == null) {
                topOfAST = NilImplicitNode.NIL;
            }
            return new RootNode(position, this.result.getScope(), topOfAST);
        }
        BlockNode newTopOfAST = new BlockNode(position);
        for (Node beginNode : this.result.getBeginNodes()) {
            this.appendToBlock(newTopOfAST, beginNode);
        }
        if (topOfAST != null) {
            newTopOfAST.add(topOfAST);
        }
        return new RootNode(position, this.result.getScope(), newTopOfAST);
    }

    public Node appendToBlock(Node head, Node tail) {
        if (tail == null) {
            return head;
        }
        if (head == null) {
            return tail;
        }
        if (!(head instanceof BlockNode)) {
            head = new BlockNode(head.getPosition()).add(head);
        }
        if (this.warnings.isVerbose() && this.isBreakStatement(((ListNode)head).getLast())) {
            this.warnings.warning(IRubyWarnings.ID.STATEMENT_NOT_REACHED, tail.getPosition(), "Statement not reached.", new Object[0]);
        }
        ((ListNode)head).addAll(tail);
        head.setPosition(this.union(head, tail));
        return head;
    }

    public Node getOperatorCallNode(Node firstNode, String operator) {
        this.checkExpression(firstNode);
        return new CallNode(firstNode.getPosition(), firstNode, operator, null);
    }

    public Node getOperatorCallNode(Node firstNode, String operator, Node secondNode) {
        return this.getOperatorCallNode(firstNode, operator, secondNode, null);
    }

    public Node getOperatorCallNode(Node firstNode, String operator, Node secondNode, SourcePosition defaultPosition) {
        if (defaultPosition != null) {
            firstNode = this.checkForNilNode(firstNode, defaultPosition);
            secondNode = this.checkForNilNode(secondNode, defaultPosition);
        }
        this.checkExpression(firstNode);
        this.checkExpression(secondNode);
        return new CallNode(this.union(firstNode.getPosition(), secondNode.getPosition()), firstNode, operator, new ArrayNode(secondNode.getPosition(), secondNode));
    }

    public Node getMatchNode(Node firstNode, Node secondNode) {
        if (firstNode instanceof DRegexpNode || firstNode instanceof RegexpNode) {
            return new Match2Node(firstNode.getPosition(), firstNode, secondNode);
        }
        if (secondNode instanceof DRegexpNode || secondNode instanceof RegexpNode) {
            return new Match3Node(firstNode.getPosition(), secondNode, firstNode);
        }
        return this.getOperatorCallNode(firstNode, "=~", secondNode);
    }

    public Node aryset(Node receiver, Node index) {
        this.checkExpression(receiver);
        return this.new_attrassign(receiver.getPosition(), receiver, "[]=", index);
    }

    public Node attrset(Node receiver, String name) {
        this.checkExpression(receiver);
        return this.new_attrassign(receiver.getPosition(), receiver, name + "=", null);
    }

    public void backrefAssignError(Node node) {
        if (node instanceof NthRefNode) {
            String varName = "$" + ((NthRefNode)node).getMatchNumber();
            throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, node.getPosition(), "Can't set variable " + varName + '.', varName);
        }
        if (node instanceof BackRefNode) {
            String varName = "$" + ((BackRefNode)node).getType();
            throw new SyntaxException(SyntaxException.PID.INVALID_ASSIGNMENT, node.getPosition(), "Can't set variable " + varName + '.', varName);
        }
    }

    public Node arg_add(SourcePosition position, Node node1, Node node2) {
        if (node1 == null) {
            if (node2 == null) {
                return new ArrayNode(position, NilImplicitNode.NIL);
            }
            return new ArrayNode(node2.getPosition(), node2);
        }
        if (node1 instanceof ArrayNode) {
            return ((ArrayNode)node1).add(node2);
        }
        return new ArgsPushNode(position, node1, node2);
    }

    public Node node_assign(Node lhs, Node rhs) {
        if (lhs == null) {
            return null;
        }
        Node newNode = lhs;
        this.checkExpression(rhs);
        if (lhs instanceof AssignableNode) {
            ((AssignableNode)lhs).setValueNode(rhs);
            lhs.setPosition(this.union(lhs, rhs));
        } else if (lhs instanceof IArgumentNode) {
            IArgumentNode invokableNode = (IArgumentNode)((Object)lhs);
            return invokableNode.setArgsNode(this.arg_add(lhs.getPosition(), invokableNode.getArgsNode(), rhs));
        }
        return newNode;
    }

    public Node ret_args(Node node, SourcePosition position) {
        if (node != null) {
            if (node instanceof BlockPassNode) {
                throw new SyntaxException(SyntaxException.PID.DYNAMIC_CONSTANT_ASSIGNMENT, position, "Dynamic constant assignment.", new Object[0]);
            }
            if (node instanceof ArrayNode && ((ArrayNode)node).size() == 1) {
                node = ((ArrayNode)node).get(0);
            } else if (node instanceof SplatNode) {
                node = new SValueNode(position, node);
            }
        }
        return node;
    }

    public boolean isBreakStatement(Node node) {
        block4: while (true) {
            if (node == null) {
                return false;
            }
            switch (node.getNodeType()) {
                case NEWLINENODE: {
                    node = ((NewlineNode)node).getNextNode();
                    continue block4;
                }
                case BREAKNODE: 
                case NEXTNODE: 
                case REDONODE: 
                case RETRYNODE: 
                case RETURNNODE: {
                    return true;
                }
            }
            break;
        }
        return false;
    }

    public void warnUnlessEOption(IRubyWarnings.ID id, Node node, String message) {
        this.warnings.warn(id, node.getPosition(), message, new Object[0]);
    }

    public void warningUnlessEOption(IRubyWarnings.ID id, Node node, String message) {
        this.warnings.warning(id, node.getPosition(), message, new Object[0]);
    }

    public boolean checkExpression(Node node) {
        boolean conditional = false;
        block9: while (node != null) {
            switch (node.getNodeType()) {
                case DEFNNODE: 
                case DEFSNODE: {
                    this.warnings.warning(IRubyWarnings.ID.VOID_VALUE_EXPRESSION, node.getPosition(), "void value expression", new Object[0]);
                    return false;
                }
                case BREAKNODE: 
                case NEXTNODE: 
                case REDONODE: 
                case RETRYNODE: 
                case RETURNNODE: {
                    if (!conditional) {
                        throw new SyntaxException(SyntaxException.PID.VOID_VALUE_EXPRESSION, node.getPosition(), "void value expression", new Object[0]);
                    }
                    return false;
                }
                case BLOCKNODE: {
                    node = ((BlockNode)node).getLast();
                    continue block9;
                }
                case BEGINNODE: {
                    node = ((BeginNode)node).getBodyNode();
                    continue block9;
                }
                case IFNODE: {
                    if (!this.checkExpression(((IfNode)node).getThenBody())) {
                        return false;
                    }
                    node = ((IfNode)node).getElseBody();
                    continue block9;
                }
                case ANDNODE: 
                case ORNODE: {
                    conditional = true;
                    node = ((BinaryOperatorNode)((Object)node)).getSecondNode();
                    continue block9;
                }
                case NEWLINENODE: {
                    node = ((NewlineNode)node).getNextNode();
                    continue block9;
                }
            }
            return true;
        }
        return true;
    }

    public boolean isLiteral(Node node) {
        return node != null && (node instanceof FixnumNode || node instanceof BignumNode || node instanceof FloatNode || node instanceof SymbolNode || node instanceof RegexpNode && ((RegexpNode)node).getOptions().isLiteral());
    }

    private void handleUselessWarn(Node node, String useless) {
        this.warnings.warn(IRubyWarnings.ID.USELESS_EXPRESSION, node.getPosition(), "Useless use of " + useless + " in void context.", useless);
    }

    public void checkUselessStatement(Node node) {
        if (!this.warnings.isVerbose()) {
            return;
        }
        block11: while (true) {
            if (node == null) {
                return;
            }
            switch (node.getNodeType()) {
                case NEWLINENODE: {
                    node = ((NewlineNode)node).getNextNode();
                    continue block11;
                }
                case CALLNODE: {
                    String name = ((CallNode)node).getName();
                    if (name == "+" || name == "-" || name == "*" || name == "/" || name == "%" || name == "**" || name == "+@" || name == "-@" || name == "|" || name == "^" || name == "&" || name == "<=>" || name == ">" || name == ">=" || name == "<" || name == "<=" || name == "==" || name == "!=") {
                        this.handleUselessWarn(node, name);
                    }
                    return;
                }
                case BACKREFNODE: 
                case DVARNODE: 
                case GLOBALVARNODE: 
                case LOCALVARNODE: 
                case NTHREFNODE: 
                case CLASSVARNODE: 
                case INSTVARNODE: {
                    this.handleUselessWarn(node, "a variable");
                    return;
                }
                case BIGNUMNODE: 
                case DREGEXPNODE: 
                case DSTRNODE: 
                case DSYMBOLNODE: 
                case FIXNUMNODE: 
                case FLOATNODE: 
                case REGEXPNODE: 
                case STRNODE: 
                case SYMBOLNODE: {
                    this.handleUselessWarn(node, "a literal");
                    return;
                }
                case DOTNODE: {
                    this.handleUselessWarn(node, ((DotNode)node).isExclusive() ? "..." : "..");
                    return;
                }
                case DEFINEDNODE: {
                    this.handleUselessWarn(node, "defined?");
                    return;
                }
                case FALSENODE: {
                    this.handleUselessWarn(node, "false");
                    return;
                }
                case NILNODE: {
                    this.handleUselessWarn(node, "nil");
                    return;
                }
                case TRUENODE: {
                    this.handleUselessWarn(node, "true");
                    return;
                }
            }
            break;
        }
    }

    public void checkUselessStatements(BlockNode blockNode) {
        if (this.warnings.isVerbose()) {
            Node lastNode = blockNode.getLast();
            for (int i = 0; i < blockNode.size(); ++i) {
                Node currentNode = blockNode.get(i);
                if (lastNode == currentNode) continue;
                this.checkUselessStatement(currentNode);
            }
        }
    }

    private boolean checkAssignmentInCondition(Node node) {
        if (node instanceof MultipleAsgnNode) {
            throw new SyntaxException(SyntaxException.PID.MULTIPLE_ASSIGNMENT_IN_CONDITIONAL, node.getPosition(), "Multiple assignment in conditional.", new Object[0]);
        }
        if (node instanceof LocalAsgnNode || node instanceof DAsgnNode || node instanceof GlobalAsgnNode || node instanceof InstAsgnNode) {
            Node valueNode = ((AssignableNode)node).getValueNode();
            if (valueNode instanceof ILiteralNode || valueNode instanceof NilNode || valueNode instanceof TrueNode || valueNode instanceof FalseNode) {
                this.warnings.warn(IRubyWarnings.ID.ASSIGNMENT_IN_CONDITIONAL, node.getPosition(), "Found '=' in conditional, should be '=='.", new Object[0]);
            }
            return true;
        }
        return false;
    }

    protected Node makeNullNil(Node node) {
        return node == null ? NilImplicitNode.NIL : node;
    }

    private Node cond0(Node node) {
        this.checkAssignmentInCondition(node);
        Node leftNode = null;
        Node rightNode = null;
        switch (node.getNodeType()) {
            case DREGEXPNODE: {
                SourcePosition position = node.getPosition();
                return new Match2Node(position, node, new GlobalVarNode(position, "$_"));
            }
            case ANDNODE: {
                leftNode = this.cond0(((AndNode)node).getFirstNode());
                rightNode = this.cond0(((AndNode)node).getSecondNode());
                return new AndNode(node.getPosition(), this.makeNullNil(leftNode), this.makeNullNil(rightNode));
            }
            case ORNODE: {
                leftNode = this.cond0(((OrNode)node).getFirstNode());
                rightNode = this.cond0(((OrNode)node).getSecondNode());
                return new OrNode(node.getPosition(), this.makeNullNil(leftNode), this.makeNullNil(rightNode));
            }
            case DOTNODE: {
                DotNode dotNode = (DotNode)node;
                if (dotNode.isLiteral()) {
                    return node;
                }
                String label = String.valueOf("FLIP" + node.hashCode());
                this.currentScope.getLocalScope().addVariable(label);
                int slot = this.currentScope.isDefined(label);
                return new FlipNode(node.getPosition(), this.getFlipConditionNode(((DotNode)node).getBeginNode()), this.getFlipConditionNode(((DotNode)node).getEndNode()), dotNode.isExclusive(), slot);
            }
            case REGEXPNODE: {
                this.warningUnlessEOption(IRubyWarnings.ID.REGEXP_LITERAL_IN_CONDITION, node, "regex literal in condition");
                return new MatchNode(node.getPosition(), node);
            }
        }
        return node;
    }

    public Node getConditionNode(Node node) {
        if (node == null) {
            return NilImplicitNode.NIL;
        }
        if (node instanceof NewlineNode) {
            return new NewlineNode(node.getPosition(), this.cond0(((NewlineNode)node).getNextNode()));
        }
        return this.cond0(node);
    }

    private Node getFlipConditionNode(Node node) {
        return node;
    }

    public SplatNode newSplatNode(SourcePosition position, Node node) {
        return new SplatNode(position, this.makeNullNil(node));
    }

    public ArrayNode newArrayNode(SourcePosition position, Node firstNode) {
        return new ArrayNode(position, this.makeNullNil(firstNode));
    }

    public AndNode newAndNode(SourcePosition position, Node left, Node right) {
        this.checkExpression(left);
        if (left == null && right == null) {
            return new AndNode(position, this.makeNullNil(left), this.makeNullNil(right));
        }
        return new AndNode(this.union(left, right), this.makeNullNil(left), this.makeNullNil(right));
    }

    public OrNode newOrNode(SourcePosition position, Node left, Node right) {
        this.checkExpression(left);
        if (left == null && right == null) {
            return new OrNode(position, this.makeNullNil(left), this.makeNullNil(right));
        }
        return new OrNode(this.union(left, right), this.makeNullNil(left), this.makeNullNil(right));
    }

    public CaseNode newCaseNode(SourcePosition position, Node expression, Node firstWhenNode) {
        ArrayNode cases = new ArrayNode(firstWhenNode != null ? firstWhenNode.getPosition() : position);
        CaseNode caseNode = new CaseNode(position, expression, cases);
        Node current = firstWhenNode;
        while (current != null) {
            if (!(current instanceof WhenNode)) {
                caseNode.setElseNode(current);
                break;
            }
            cases.add(current);
            current = ((WhenNode)current).getNextCase();
        }
        return caseNode;
    }

    public WhenNode newWhenNode(SourcePosition position, Node expressionNodes, Node bodyNode, Node nextCase) {
        Node element;
        if (bodyNode == null) {
            bodyNode = NilImplicitNode.NIL;
        }
        if (expressionNodes instanceof SplatNode || expressionNodes instanceof ArgsCatNode) {
            return new WhenNode(position, expressionNodes, bodyNode, nextCase);
        }
        ListNode list = (ListNode)expressionNodes;
        if (list.size() == 1 && !((element = list.get(0)) instanceof SplatNode)) {
            return new WhenNode(position, element, bodyNode, nextCase);
        }
        return new WhenNode(position, expressionNodes, bodyNode, nextCase);
    }

    public Node getReturnArgsNode(Node node) {
        if (node instanceof ArrayNode && ((ArrayNode)node).size() == 1) {
            return ((ListNode)node).get(0);
        }
        if (node instanceof BlockPassNode) {
            throw new SyntaxException(SyntaxException.PID.BLOCK_ARG_UNEXPECTED, node.getPosition(), "Block argument should not be given.", new Object[0]);
        }
        return node;
    }

    public Node new_opElementAsgnNode(SourcePosition position, Node receiverNode, String operatorName, Node argsNode, Node valueNode) {
        return new OpElementAsgnNode(position, receiverNode, operatorName, argsNode, valueNode);
    }

    public Node new_attrassign(SourcePosition position, Node receiver, String name, Node args) {
        return new AttrAssignNode(position, receiver, name, args);
    }

    public Node new_call(Node receiver, Token name, Node args, Node iter) {
        SourcePosition position;
        if (args instanceof BlockPassNode && iter != null) {
            throw new SyntaxException(SyntaxException.PID.BLOCK_ARG_AND_BLOCK_GIVEN, iter.getPosition(), "Both block arg and actual block given.", new Object[0]);
        }
        ISourcePositionHolder holder = this.getRightmostHolderForCall(name, args, iter);
        if (receiver == null) {
            receiver = NilImplicitNode.NIL;
            position = holder.getPosition();
        } else {
            position = receiver instanceof NilImplicitNode ? holder.getPosition() : this.union(receiver, holder);
        }
        if (args == null) {
            args = new ListNode(name.getPosition());
        }
        return new CallNode(position, receiver, (String)name.getValue(), args, (IterNode)iter);
    }

    private ISourcePositionHolder getRightmostHolderForCall(Token name, Node args, Node iter) {
        if (iter != null) {
            return iter;
        }
        if (args != null) {
            return args;
        }
        return name;
    }

    public Node new_aref(Node receiver, Token name, Node argsNode) {
        ArrayNode args;
        if (argsNode instanceof ArrayNode && (args = (ArrayNode)argsNode).size() == 1 && args.get(0) instanceof FixnumNode) {
            return new CallNode(this.union(receiver, args), receiver, "[]", args);
        }
        return this.new_call(receiver, name, argsNode, null);
    }

    public Colon2Node new_colon2(SourcePosition position, Node leftNode, String name) {
        if (ParserSupport.isConstant(name)) {
            if (leftNode == null) {
                return new Colon2ImplicitNode(position, name);
            }
            return new Colon2ConstNode(position, leftNode, name);
        }
        return new Colon2MethodNode(position, leftNode, name);
    }

    public Colon3Node new_colon3(SourcePosition position, String name) {
        return new Colon3Node(position, name);
    }

    public Node new_fcall(Token operation, Node args, Node iter) {
        SourcePosition position = this.union(operation, iter != null ? iter : args);
        if (args == null) {
            args = new ListNode(operation.getPosition());
        }
        return new FCallNode(position, (String)operation.getValue(), args, (IterNode)iter);
    }

    public Node new_super(Node args, Token operation) {
        if (args != null && args instanceof BlockPassNode) {
            return new SuperNode(this.union(operation, args), ((BlockPassNode)args).getArgsNode(), args);
        }
        return new SuperNode(operation.getPosition(), args);
    }

    public void initTopLocalVariables() {
        this.currentScope = new LocalStaticScope(null);
        this.result.setScope(this.currentScope);
    }

    public boolean isInSingle() {
        return this.inSingleton != 0;
    }

    public void setInSingle(int inSingle) {
        this.inSingleton = inSingle;
    }

    public boolean isInDef() {
        return this.inDefinition;
    }

    public void setInDef(boolean inDef) {
        this.inDefinition = inDef;
    }

    public int getInSingle() {
        return this.inSingleton;
    }

    public ParserResult getResult() {
        return this.result;
    }

    public void setResult(ParserResult result) {
        this.result = result;
    }

    public void setConfiguration(ParserConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setLexer(Lexer lexer) {
        this.lexer = lexer;
    }

    public void setWarnings(IRubyWarnings warnings) {
        this.warnings = warnings;
    }

    public Node literal_concat(SourcePosition position, Node head, Node tail) {
        if (head == null) {
            return tail;
        }
        if (tail == null) {
            return head;
        }
        if (head instanceof EvStrNode) {
            head = new DStrNode(this.union(head.getPosition(), position)).add(head);
        }
        if (tail instanceof StrNode) {
            if (head instanceof StrNode) {
                return new StrNode(this.union(head, tail), (StrNode)head, (StrNode)tail);
            }
            head.setPosition(this.union(head, tail));
            return ((ListNode)head).add(tail);
        }
        if (tail instanceof DStrNode) {
            if (head instanceof StrNode) {
                ((DStrNode)tail).prepend(head);
                return tail;
            }
            return ((ListNode)head).addAll(tail);
        }
        if (head instanceof StrNode) {
            if (((StrNode)head).getValue().length() == 0) {
                head = new DStrNode(head.getPosition());
            } else {
                head.getPosition().adjustStartOffset(-1);
                head = new DStrNode(head.getPosition()).add(head);
            }
        }
        return ((DStrNode)head).add(tail);
    }

    public Node newEvStrNode(SourcePosition position, Node node) {
        Node head = node;
        while (node != null) {
            if (node instanceof StrNode || node instanceof DStrNode || node instanceof EvStrNode) {
                return node;
            }
            if (!(node instanceof NewlineNode)) break;
            node = ((NewlineNode)node).getNextNode();
        }
        return new EvStrNode(position, head);
    }

    public Node new_yield(SourcePosition position, Node node) {
        boolean state = true;
        if (node != null) {
            if (node instanceof BlockPassNode) {
                throw new SyntaxException(SyntaxException.PID.BLOCK_ARG_UNEXPECTED, node.getPosition(), "Block argument should not be given.", new Object[0]);
            }
            if (node instanceof ArrayNode && ((ArrayNode)node).size() == 1) {
                node = ((ArrayNode)node).get(0);
                state = false;
            }
            if (node != null && node instanceof SplatNode) {
                state = true;
            }
        } else {
            state = false;
        }
        return new YieldNode(position, node, state);
    }

    public Node negateInteger(Node integerNode) {
        if (integerNode instanceof FixnumNode) {
            FixnumNode fixnumNode = (FixnumNode)integerNode;
            fixnumNode.setValue(-fixnumNode.getValue());
            return fixnumNode;
        }
        if (integerNode instanceof BignumNode) {
            BignumNode bignumNode = (BignumNode)integerNode;
            bignumNode.setValue(bignumNode.getValue().negate());
        }
        return integerNode;
    }

    public FloatNode negateFloat(FloatNode floatNode) {
        floatNode.setValue(-floatNode.getValue());
        return floatNode;
    }

    public SourcePosition createEmptyArgsNodePosition(SourcePosition pos) {
        return new SourcePosition(pos.getFile(), pos.getStartLine(), pos.getEndLine(), pos.getEndOffset() - 1, pos.getEndOffset() - 1);
    }

    public Node unwrapNewlineNode(Node node) {
        if (node instanceof NewlineNode) {
            return ((NewlineNode)node).getNextNode();
        }
        return node;
    }

    private Node checkForNilNode(Node node, SourcePosition defaultPosition) {
        return node == null ? new NilNode(defaultPosition) : node;
    }

    public Node new_args(SourcePosition position, ListNode pre, ListNode optional, RestArgNode rest, ListNode post, BlockArgNode block) {
        return new ArgsNode(position, pre, optional, rest, post, block);
    }

    public Node newAlias(SourcePosition position, Node newNode, Node oldNode) {
        return new AliasNode(position, newNode, oldNode);
    }

    public Node newUndef(SourcePosition position, Node nameNode) {
        return new UndefNode(position, nameNode);
    }

    public BlockArg18Node newBlockArg18(SourcePosition position, Node blockValue, Node args) {
        return new BlockArg18Node(position, blockValue, args);
    }

    public BlockArgNode newBlockArg(SourcePosition position, Token nameToken) {
        String identifier = (String)nameToken.getValue();
        if (this.getCurrentScope().getLocalScope().isDefined(identifier) >= 0) {
            throw new SyntaxException(SyntaxException.PID.BAD_IDENTIFIER, position, this.lexer.getCurrentLine(), "duplicate block argument name");
        }
        return new BlockArgNode(position, this.getCurrentScope().getLocalScope().addVariable(identifier), identifier);
    }

    public IterNode new_iter(SourcePosition position, Node vars, StaticScope scope, Node body) {
        if (vars != null && vars instanceof BlockPassNode) {
            vars = ((BlockPassNode)vars).getArgsNode();
        }
        return new IterNode(position, vars, scope, body);
    }

    public void yyerror(String message) {
        throw new SyntaxException(SyntaxException.PID.GRAMMAR_ERROR, this.lexer.getPosition(), message, new Object[0]);
    }

    public void yyerror(String message, String[] expected, String found) {
        String text = message + ", unexpected " + found + "\n";
        throw new SyntaxException(SyntaxException.PID.GRAMMAR_ERROR, this.lexer.getPosition(), text, found);
    }

    public void warn(IRubyWarnings.ID id, SourcePosition position, String message, Object ... data) {
        this.warnings.warn(id, position, message, data);
    }

    public void warning(IRubyWarnings.ID id, SourcePosition position, String message, Object ... data) {
        if (this.warnings.isVerbose()) {
            this.warnings.warning(id, position, message, data);
        }
    }

    public boolean is_local_id(Token identifier) {
        String name = (String)identifier.getValue();
        return this.lexer.isIdentifierChar(name.charAt(0));
    }

    public ListNode list_append(Node list, Node item) {
        if (list == null) {
            return new ArrayNode(item.getPosition(), item);
        }
        if (!(list instanceof ListNode)) {
            return new ArrayNode(list.getPosition(), list).add(item);
        }
        return ((ListNode)list).add(item);
    }

    public Node new_bv(Token identifier) {
        if (!this.is_local_id(identifier)) {
            this.getterIdentifierError(identifier.getPosition(), (String)identifier.getValue());
        }
        this.shadowing_lvar(identifier);
        return this.arg_var(identifier);
    }

    public ArgumentNode arg_var(Token identifier) {
        String name = (String)identifier.getValue();
        StaticScope current = this.getCurrentScope();
        if (name == "_") {
            int count = 0;
            while (current.exists(name) >= 0) {
                name = "_$" + count++;
            }
        }
        return new ArgumentNode(identifier.getPosition(), name, this.getCurrentScope().addVariableThisScope(name));
    }

    public Token formal_argument(Token identifier) {
        if (!this.is_local_id(identifier)) {
            this.yyerror("formal argument must be local variable");
        }
        return this.shadowing_lvar(identifier);
    }

    public Token shadowing_lvar(Token identifier) {
        String name = (String)identifier.getValue();
        if (name == "_") {
            return identifier;
        }
        StaticScope current = this.getCurrentScope();
        if (current instanceof BlockStaticScope) {
            if (current.exists(name) >= 0) {
                this.yyerror("duplicated argument name");
            }
            if (this.warnings.isVerbose() && current.isDefined(name) >= 0) {
                this.warnings.warning(IRubyWarnings.ID.STATEMENT_NOT_REACHED, identifier.getPosition(), "shadowing outer local variable - " + name, new Object[0]);
            }
        } else if (current.exists(name) >= 0) {
            this.yyerror("duplicated argument name");
        }
        return identifier;
    }

    public ListNode list_concat(Node first, Node second) {
        if (first instanceof ListNode) {
            if (second instanceof ListNode) {
                return ((ListNode)first).addAll((ListNode)second);
            }
            return ((ListNode)first).addAll(second);
        }
        return new ArrayNode(first.getPosition(), first).add(second);
    }

    public Node splat_array(Node node) {
        if (node instanceof SplatNode) {
            node = ((SplatNode)node).getValue();
        }
        if (node instanceof ArrayNode) {
            return node;
        }
        return null;
    }

    public Node arg_append(Node node1, Node node2) {
        if (node1 == null) {
            return new ArrayNode(node2.getPosition(), node2);
        }
        if (node1 instanceof ListNode) {
            return ((ListNode)node1).add(node2);
        }
        if (node1 instanceof BlockPassNode) {
            return this.arg_append(((BlockPassNode)node1).getBodyNode(), node2);
        }
        if (node1 instanceof ArgsPushNode) {
            ArgsPushNode pushNode = (ArgsPushNode)node1;
            Node body = pushNode.getSecondNode();
            return new ArgsCatNode(pushNode.getPosition(), pushNode.getFirstNode(), new ArrayNode(body.getPosition(), body).add(node2));
        }
        return new ArgsPushNode(this.union(node1, node2), node1, node2);
    }

    public void regexpFragmentCheck(RegexpNode end, String value) {
    }

    protected void checkRegexpSyntax(String value, RegexpOptions options) {
    }

    public Node newRegexpNode(SourcePosition position, Node contents, RegexpNode end) {
        boolean is19;
        RegexpOptions options = end.getOptions();
        boolean bl = is19 = !this.lexer.isOneEight();
        if (contents == null) {
            String newValue = "";
            this.regexpFragmentCheck(end, newValue);
            return new RegexpNode(position, newValue, options.withoutOnce());
        }
        if (contents instanceof StrNode) {
            String meat = ((StrNode)contents).getValue();
            this.regexpFragmentCheck(end, meat);
            this.checkRegexpSyntax(meat, options.withoutOnce());
            return new RegexpNode(contents.getPosition(), meat, options.withoutOnce());
        }
        if (contents instanceof DStrNode) {
            DStrNode dStrNode = (DStrNode)contents;
            for (Node fragment : dStrNode.childNodes()) {
                if (!(fragment instanceof StrNode)) continue;
                this.regexpFragmentCheck(end, ((StrNode)fragment).getValue());
            }
            return new DRegexpNode(position, options, is19).addAll((DStrNode)contents);
        }
        return new DRegexpNode(position, options, is19).add(contents);
    }

    public SourcePosition getPosition2(ISourcePositionHolder pos) {
        return pos == null ? this.lexer.getPosition(null, false) : pos.getPosition();
    }

    public SourcePosition getPosition(ISourcePositionHolder start) {
        return this.getPosition(start, false);
    }

    public SourcePosition getPosition(ISourcePositionHolder start, boolean inclusive) {
        if (start != null) {
            return this.lexer.getPosition(start.getPosition(), inclusive);
        }
        return this.lexer.getPosition(null, inclusive);
    }
}

