/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.IsNilNode;
import org.jruby.truffle.core.cast.ArrayCastNode;
import org.jruby.truffle.core.cast.ArrayCastNodeGen;
import org.jruby.truffle.core.proc.ProcType;
import org.jruby.truffle.language.LazyRubyNode;
import org.jruby.truffle.language.LexicalScope;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyRootNode;
import org.jruby.truffle.language.SourceIndexLength;
import org.jruby.truffle.language.arguments.MissingArgumentBehavior;
import org.jruby.truffle.language.arguments.ProfileArgumentNode;
import org.jruby.truffle.language.arguments.ReadBlockNode;
import org.jruby.truffle.language.arguments.ReadPreArgumentNode;
import org.jruby.truffle.language.arguments.ShouldDestructureNode;
import org.jruby.truffle.language.control.AndNode;
import org.jruby.truffle.language.control.IfElseNode;
import org.jruby.truffle.language.control.NotNode;
import org.jruby.truffle.language.control.SequenceNode;
import org.jruby.truffle.language.locals.FlipFlopStateNode;
import org.jruby.truffle.language.locals.LocalVariableType;
import org.jruby.truffle.language.locals.ReadLocalVariableNode;
import org.jruby.truffle.language.locals.WriteLocalVariableNode;
import org.jruby.truffle.language.methods.Arity;
import org.jruby.truffle.language.methods.BlockDefinitionNode;
import org.jruby.truffle.language.methods.CatchForLambdaNode;
import org.jruby.truffle.language.methods.CatchForMethodNode;
import org.jruby.truffle.language.methods.CatchForProcNode;
import org.jruby.truffle.language.methods.ExceptionTranslatingNode;
import org.jruby.truffle.language.methods.MethodDefinitionNode;
import org.jruby.truffle.language.methods.SharedMethodInfo;
import org.jruby.truffle.language.methods.UnsupportedOperationBehavior;
import org.jruby.truffle.language.supercall.ReadSuperArgumentsNode;
import org.jruby.truffle.language.supercall.ReadZSuperArgumentsNode;
import org.jruby.truffle.language.supercall.SuperCallNode;
import org.jruby.truffle.language.supercall.ZSuperOutsideMethodNode;
import org.jruby.truffle.parser.BodyTranslator;
import org.jruby.truffle.parser.LoadArgumentsTranslator;
import org.jruby.truffle.parser.ParameterCollector;
import org.jruby.truffle.parser.ReloadArgumentsTranslator;
import org.jruby.truffle.parser.TranslatorEnvironment;
import org.jruby.truffle.parser.ast.ArgsParseNode;
import org.jruby.truffle.parser.ast.AssignableParseNode;
import org.jruby.truffle.parser.ast.BlockParseNode;
import org.jruby.truffle.parser.ast.CallParseNode;
import org.jruby.truffle.parser.ast.ConstParseNode;
import org.jruby.truffle.parser.ast.DAsgnParseNode;
import org.jruby.truffle.parser.ast.KeywordArgParseNode;
import org.jruby.truffle.parser.ast.LocalAsgnParseNode;
import org.jruby.truffle.parser.ast.MethodDefParseNode;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.SuperParseNode;
import org.jruby.truffle.parser.ast.UnnamedRestArgParseNode;
import org.jruby.truffle.parser.ast.ZSuperParseNode;
import org.jruby.truffle.tools.ChaosNodeGen;

public class MethodTranslator
extends BodyTranslator {
    private final ArgsParseNode argsNode;
    private boolean isBlock;

    public MethodTranslator(Node currentNode, RubyContext context, BodyTranslator parent, TranslatorEnvironment environment, boolean isBlock, Source source, ArgsParseNode argsNode) {
        super(currentNode, context, parent, environment, source, false);
        this.isBlock = isBlock;
        this.argsNode = argsNode;
    }

    public BlockDefinitionNode compileBlockNode(SourceIndexLength sourceSection, String methodName, ParseNode bodyNode, SharedMethodInfo sharedMethodInfo, ProcType type, String[] variables) {
        Object frameOnStackMarkerSlot;
        RubyNode preludeProc;
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        this.declareArguments();
        Arity arity = MethodTranslator.getArity(this.argsNode);
        Arity arityForCheck = this.argsNode.getRestArgNode() instanceof UnnamedRestArgParseNode && !((UnnamedRestArgParseNode)this.argsNode.getRestArgNode()).isStar() ? arity.withRest(false) : arity;
        boolean isProc = type == ProcType.PROC;
        LoadArgumentsTranslator loadArgumentsTranslator = new LoadArgumentsTranslator(this.currentNode, this.context, this.source, isProc, this);
        RubyNode loadArguments = this.argsNode.accept(loadArgumentsTranslator);
        if (this.shouldConsiderDestructuringArrayArg(arity)) {
            ProfileArgumentNode readArrayNode = new ProfileArgumentNode(new ReadPreArgumentNode(0, MissingArgumentBehavior.RUNTIME_ERROR));
            ArrayCastNode castArrayNode = ArrayCastNodeGen.create(readArrayNode);
            String[] arraySlot = this.environment.declareVar(this.environment.allocateLocalTemp("destructure"));
            WriteLocalVariableNode writeArrayNode = WriteLocalVariableNode.createWriteLocalVariableNode(this.context, (FrameSlot)arraySlot, castArrayNode);
            LoadArgumentsTranslator destructureArgumentsTranslator = new LoadArgumentsTranslator(this.currentNode, this.context, this.source, isProc, this);
            destructureArgumentsTranslator.pushArraySlot((FrameSlot)arraySlot);
            RubyNode newDestructureArguments = this.argsNode.accept(destructureArgumentsTranslator);
            ShouldDestructureNode shouldDestructure = new ShouldDestructureNode(readArrayNode);
            RubyNode arrayWasNotNil = MethodTranslator.sequence(sourceSection, Arrays.asList(new RubyNode[]{writeArrayNode, new NotNode(new IsNilNode(new ReadLocalVariableNode(LocalVariableType.FRAME_LOCAL, (FrameSlot)arraySlot)))}));
            AndNode shouldDestructureAndArrayWasNotNil = new AndNode(shouldDestructure, arrayWasNotNil);
            preludeProc = new IfElseNode(shouldDestructureAndArrayWasNotNil, newDestructureArguments, loadArguments);
        } else {
            preludeProc = loadArguments;
        }
        RubyNode checkArity = MethodTranslator.createCheckArityNode(arityForCheck);
        RubyNode preludeLambda = MethodTranslator.sequence(sourceSection, Arrays.asList(checkArity, (RubyNode)NodeUtil.cloneNode((Node)loadArguments)));
        if (!this.translatingForStatement) {
            for (String var : variables) {
                this.environment.declareVar(var);
            }
        }
        RubyNode body = this.translateNodeOrNil(sourceSection, bodyNode);
        if (this.context.getOptions().CHAOS) {
            body = ChaosNodeGen.create(body);
        }
        CatchForProcNode bodyProc = new CatchForProcNode(this.composeBody(sourceSection, preludeProc, (RubyNode)NodeUtil.cloneNode((Node)body)));
        bodyProc.unsafeSetSourceSection(MethodTranslator.enclosing(sourceSection, body));
        RubyRootNode newRootNodeForProcs = new RubyRootNode(this.context, this.translateSourceSection(this.source, sourceSection), this.environment.getFrameDescriptor(), this.environment.getSharedMethodInfo(), bodyProc, this.environment.needsDeclarationFrame());
        RubyNode composed = this.composeBody(sourceSection, preludeLambda, body);
        CatchForLambdaNode bodyLambda = new CatchForLambdaNode(this.environment.getReturnID(), composed);
        RubyRootNode newRootNodeForLambdas = new RubyRootNode(this.context, this.translateSourceSection(this.source, sourceSection), this.environment.getFrameDescriptor(), this.environment.getSharedMethodInfo(), bodyLambda, this.environment.needsDeclarationFrame());
        RootCallTarget callTargetAsLambda = Truffle.getRuntime().createCallTarget((RootNode)newRootNodeForLambdas);
        RootCallTarget callTargetAsProc = Truffle.getRuntime().createCallTarget((RootNode)newRootNodeForProcs);
        if (this.frameOnStackMarkerSlotStack.isEmpty()) {
            frameOnStackMarkerSlot = null;
        } else {
            frameOnStackMarkerSlot = this.frameOnStackMarkerSlotStack.peek();
            if (frameOnStackMarkerSlot == BAD_FRAME_SLOT) {
                frameOnStackMarkerSlot = null;
            }
        }
        BlockDefinitionNode ret = new BlockDefinitionNode(type, this.environment.getSharedMethodInfo(), (CallTarget)callTargetAsProc, (CallTarget)callTargetAsLambda, this.environment.getBreakID(), frameOnStackMarkerSlot);
        ret.unsafeSetSourceSection(sourceSection);
        return ret;
    }

    private boolean shouldConsiderDestructuringArrayArg(Arity arity) {
        if (arity.hasKeywordsRest()) {
            return true;
        }
        if (!arity.hasRest() && arity.getOptional() == 0 && arity.getRequired() <= 1) {
            return false;
        }
        return !arity.hasRest() || arity.getRequired() != 0;
    }

    private RubyNode composeBody(SourceIndexLength preludeSourceSection, RubyNode prelude, RubyNode body) {
        SourceIndexLength sourceSection = MethodTranslator.enclosing(preludeSourceSection, body);
        body = MethodTranslator.sequence(sourceSection, Arrays.asList(prelude, body));
        if (this.environment.getFlipFlopStates().size() > 0) {
            body = MethodTranslator.sequence(sourceSection, Arrays.asList(this.initFlipFlopStates(sourceSection), body));
        }
        return body;
    }

    public RubyNode compileMethodBody(SourceIndexLength sourceSection, String methodName, ParseNode bodyNode, SharedMethodInfo sharedMethodInfo) {
        return this.doCompileMethodBody(sourceSection, methodName, bodyNode, sharedMethodInfo);
    }

    public RubyNode doCompileMethodBody(SourceIndexLength sourceSection, String methodName, ParseNode bodyNode, SharedMethodInfo sharedMethodInfo) {
        ParseNode[] statements;
        this.declareArguments();
        Arity arity = MethodTranslator.getArity(this.argsNode);
        LoadArgumentsTranslator loadArgumentsTranslator = new LoadArgumentsTranslator(this.currentNode, this.context, this.source, false, this);
        RubyNode loadArguments = this.argsNode.accept(loadArgumentsTranslator);
        boolean isPrimitive = false;
        if (bodyNode instanceof BlockParseNode && (statements = ((BlockParseNode)bodyNode).children()).length >= 0 && statements[0] instanceof CallParseNode) {
            CallParseNode callNode = (CallParseNode)statements[0];
            ParseNode receiver = callNode.getReceiverNode();
            if (callNode.getName().equals("primitive") && receiver instanceof ConstParseNode && ((ConstParseNode)receiver).getName().equals("Truffle")) {
                isPrimitive = true;
            }
        }
        RubyNode body = isPrimitive ? this.translateRubiniusPrimitive(sourceSection, (BlockParseNode)bodyNode, loadArguments) : this.translateNodeOrNil(sourceSection, bodyNode);
        SourceIndexLength bodySourceSection = body.getSourceIndexLength();
        RubyNode checkArity = MethodTranslator.createCheckArityNode(arity);
        body = isPrimitive ? MethodTranslator.sequence(bodySourceSection, Arrays.asList(checkArity, body)) : MethodTranslator.sequence(bodySourceSection, Arrays.asList(checkArity, loadArguments, body));
        if (this.environment.getFlipFlopStates().size() > 0) {
            body = MethodTranslator.sequence(bodySourceSection, Arrays.asList(this.initFlipFlopStates(sourceSection), body));
        }
        body = new CatchForMethodNode(this.environment.getReturnID(), body);
        body = new ExceptionTranslatingNode(body, UnsupportedOperationBehavior.TYPE_ERROR);
        if (this.context.getOptions().CHAOS) {
            body = ChaosNodeGen.create(body);
        }
        body.unsafeSetSourceSection(sourceSection);
        return body;
    }

    public MethodDefinitionNode compileMethodNode(SourceIndexLength sourceSection, String methodName, MethodDefParseNode defNode, ParseNode bodyNode, SharedMethodInfo sharedMethodInfo) {
        RubyNode body;
        SourceIndexLength sourceIndexLength = defNode.getPosition();
        SourceSection fullMethodSourceSection = sourceIndexLength.toSourceSection(this.source);
        if (this.context.getOptions().LAZY_TRANSLATION) {
            TranslatorState state = this.getCurrentState();
            body = new LazyRubyNode(() -> {
                this.restoreState(state);
                return this.compileMethodBody(sourceSection, methodName, bodyNode, sharedMethodInfo);
            });
        } else {
            body = this.compileMethodBody(sourceSection, methodName, bodyNode, sharedMethodInfo);
        }
        RubyRootNode rootNode = new RubyRootNode(this.context, fullMethodSourceSection, this.environment.getFrameDescriptor(), this.environment.getSharedMethodInfo(), body, this.environment.needsDeclarationFrame());
        RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)rootNode);
        MethodDefinitionNode ret = new MethodDefinitionNode(methodName, this.environment.getSharedMethodInfo(), (CallTarget)callTarget);
        ret.unsafeSetSourceSection(sourceSection);
        return ret;
    }

    private void declareArguments() {
        ParameterCollector parameterCollector = new ParameterCollector();
        this.argsNode.accept(parameterCollector);
        for (String parameter : parameterCollector.getParameters()) {
            this.environment.declareVar(parameter);
        }
    }

    public static Arity getArity(ArgsParseNode argsNode) {
        String[] keywordArguments;
        if (argsNode.hasKwargs() && argsNode.getKeywordCount() > 0) {
            ParseNode[] keywordNodes = argsNode.getKeywords().children();
            int keywordsCount = keywordNodes.length;
            keywordArguments = new String[keywordsCount];
            for (int i = 0; i < keywordsCount; ++i) {
                KeywordArgParseNode kwarg = (KeywordArgParseNode)keywordNodes[i];
                AssignableParseNode assignableNode = kwarg.getAssignable();
                if (assignableNode instanceof LocalAsgnParseNode) {
                    keywordArguments[i] = ((LocalAsgnParseNode)assignableNode).getName();
                    continue;
                }
                if (assignableNode instanceof DAsgnParseNode) {
                    keywordArguments[i] = ((DAsgnParseNode)assignableNode).getName();
                    continue;
                }
                throw new UnsupportedOperationException("unsupported keyword arg " + kwarg);
            }
        } else {
            keywordArguments = Arity.NO_KEYWORDS;
        }
        return new Arity(argsNode.getPreCount(), argsNode.getOptionalArgsCount(), argsNode.hasRestArg(), argsNode.getPostCount(), keywordArguments, argsNode.hasKeyRest());
    }

    @Override
    public RubyNode visitSuperNode(SuperParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        BodyTranslator.ArgumentsAndBlockTranslation argumentsAndBlock = this.translateArgumentsAndBlock(sourceSection, node.getIterNode(), node.getArgsNode(), this.environment.getNamedMethodName());
        ReadSuperArgumentsNode arguments = new ReadSuperArgumentsNode(argumentsAndBlock.getArguments(), argumentsAndBlock.isSplatted());
        RubyNode block = this.executeOrInheritBlock(argumentsAndBlock.getBlock());
        return MethodTranslator.withSourceSection(sourceSection, new SuperCallNode(arguments, block));
    }

    @Override
    public RubyNode visitZSuperNode(ZSuperParseNode node) {
        SourceIndexLength sourceSection = node.getPosition();
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        if (this.environment.isBlock()) {
            this.environment.setNeedsDeclarationFrame();
        }
        this.currentCallMethodName = this.environment.getNamedMethodName();
        RubyNode blockNode = node.getIterNode() != null ? node.getIterNode().accept(this) : null;
        boolean insideDefineMethod = false;
        MethodTranslator methodArgumentsTranslator = this;
        while (methodArgumentsTranslator.isBlock) {
            if (!(methodArgumentsTranslator.parent instanceof MethodTranslator)) {
                return MethodTranslator.withSourceSection(sourceSection, new ZSuperOutsideMethodNode(insideDefineMethod));
            }
            if (methodArgumentsTranslator.currentCallMethodName != null && methodArgumentsTranslator.currentCallMethodName.equals("define_method")) {
                insideDefineMethod = true;
            }
            methodArgumentsTranslator = (MethodTranslator)methodArgumentsTranslator.parent;
        }
        ReloadArgumentsTranslator reloadTranslator = new ReloadArgumentsTranslator(this.currentNode, this.context, this.source, this);
        ArgsParseNode argsNode = methodArgumentsTranslator.argsNode;
        SequenceNode reloadSequence = (SequenceNode)reloadTranslator.visitArgsNode(argsNode);
        ReadZSuperArgumentsNode arguments = new ReadZSuperArgumentsNode(reloadTranslator.getRestParameterIndex(), reloadSequence.getSequence());
        RubyNode block = this.executeOrInheritBlock(blockNode);
        return MethodTranslator.withSourceSection(sourceSection, new SuperCallNode(arguments, block));
    }

    private RubyNode executeOrInheritBlock(RubyNode blockNode) {
        if (blockNode != null) {
            return blockNode;
        }
        return new ReadBlockNode(this.context.getCoreLibrary().getNilObject());
    }

    @Override
    protected FlipFlopStateNode createFlipFlopState(SourceIndexLength sourceSection, int depth) {
        if (this.isBlock) {
            this.environment.setNeedsDeclarationFrame();
            return this.parent.createFlipFlopState(sourceSection, depth + 1);
        }
        return super.createFlipFlopState(sourceSection, depth);
    }

    public TranslatorState getCurrentState() {
        return new TranslatorState(this.getEnvironment().unsafeGetLexicalScope(), this.getEnvironment().isDynamicConstantLookup());
    }

    public void restoreState(TranslatorState state) {
        this.getEnvironment().getParseEnvironment().setDynamicConstantLookup(state.dynamicConstantLookup);
        this.getEnvironment().getParseEnvironment().resetLexicalScope(state.scope);
    }

    public static class TranslatorState {
        private final LexicalScope scope;
        private final boolean dynamicConstantLookup;

        private TranslatorState(LexicalScope scope, boolean dynamicConstantLookup) {
            this.scope = scope;
            this.dynamicConstantLookup = dynamicConstantLookup;
        }
    }
}

