/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.objects.WriteObjectFieldNode;
import org.jruby.truffle.language.objects.WriteObjectFieldNodeGen;

public class WriteInstanceVariableNode
extends RubyNode {
    private final String name;
    @Node.Child
    private RubyNode receiver;
    @Node.Child
    private RubyNode rhs;
    @Node.Child
    private WriteObjectFieldNode writeNode;
    private final ConditionProfile objectProfile = ConditionProfile.createBinaryProfile();

    public WriteInstanceVariableNode(String name, RubyNode receiver, RubyNode rhs) {
        this.name = name;
        this.receiver = receiver;
        this.rhs = rhs;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object object = this.receiver.execute(frame);
        Object value = this.rhs.execute(frame);
        if (this.objectProfile.profile(object instanceof DynamicObject)) {
            if (this.writeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeNode = (WriteObjectFieldNode)this.insert(WriteObjectFieldNodeGen.create(this.name));
            }
        } else {
            throw new RaiseException(this.coreExceptions().frozenError(object, this));
        }
        this.writeNode.execute((DynamicObject)object, value);
        return value;
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        return this.coreStrings().ASSIGNMENT.createInstance();
    }
}

