/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.objects;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.instrumentation.Instrumentable;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.core.hash.Entry;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.objects.AllocateObjectNodeGen;
import org.jruby.truffle.language.objects.AllocateObjectNodeWrapper;

@Instrumentable(factory=AllocateObjectNodeWrapper.class)
@NodeChildren(value={@NodeChild(value="classToAllocate"), @NodeChild(value="values")})
public abstract class AllocateObjectNode
extends RubyNode {
    private final boolean useCallerFrameForTracing;

    public static AllocateObjectNode create() {
        return AllocateObjectNodeGen.create(null, null);
    }

    public AllocateObjectNode() {
        this(true);
    }

    public AllocateObjectNode(boolean useCallerFrameForTracing) {
        this.useCallerFrameForTracing = useCallerFrameForTracing;
    }

    public DynamicObject allocate(DynamicObject classToAllocate, Object ... values) {
        return this.executeAllocate(classToAllocate, values);
    }

    public DynamicObject allocateArray(DynamicObject classToAllocate, Object store, int size) {
        return this.allocate(classToAllocate, store, size);
    }

    public DynamicObject allocateHash(DynamicObject classToAllocate, Object store, int size, Entry firstInSequence, Entry lastInSequence, DynamicObject defaultBlock, Object defaultValue, boolean compareByIdentity) {
        return this.allocate(classToAllocate, store, size, firstInSequence, lastInSequence, defaultBlock, defaultValue, compareByIdentity);
    }

    protected abstract DynamicObject executeAllocate(DynamicObject var1, Object[] var2);

    @Specialization(guards={"cachedClassToAllocate == classToAllocate", "!cachedIsSingleton", "!isTracing()"}, assumptions={"getTracingAssumption()"}, limit="getCacheLimit()")
    public DynamicObject allocateCached(DynamicObject classToAllocate, Object[] values, @Cached(value="classToAllocate") DynamicObject cachedClassToAllocate, @Cached(value="isSingleton(classToAllocate)") boolean cachedIsSingleton, @Cached(value="getInstanceFactory(classToAllocate)") DynamicObjectFactory factory) {
        return factory.newInstance(values);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(contains={"allocateCached"}, guards={"!isSingleton(classToAllocate)", "!isTracing()"}, assumptions={"getTracingAssumption()"})
    public DynamicObject allocateUncached(DynamicObject classToAllocate, Object[] values) {
        return this.getInstanceFactory(classToAllocate).newInstance(values);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"!isSingleton(classToAllocate)", "isTracing()"}, assumptions={"getTracingAssumption()"})
    public DynamicObject allocateTracing(DynamicObject classToAllocate, Object[] values) {
        AllocateObjectNode allocatingNode;
        FrameInstance allocatingFrameInstance;
        DynamicObject object = this.getInstanceFactory(classToAllocate).newInstance(values);
        if (this.useCallerFrameForTracing) {
            allocatingFrameInstance = this.getContext().getCallStack().getCallerFrameIgnoringSend();
            allocatingNode = this.getContext().getCallStack().getTopMostUserCallNode();
        } else {
            allocatingFrameInstance = Truffle.getRuntime().getCurrentFrame();
            allocatingNode = this;
        }
        Frame allocatingFrame = allocatingFrameInstance.getFrame(FrameInstance.FrameAccess.READ_ONLY, true);
        Object allocatingSelf = RubyArguments.getSelf(allocatingFrame);
        String allocatingMethod = RubyArguments.getMethod(allocatingFrame).getName();
        SourceSection allocatingSourceSection = allocatingNode.getEncapsulatingSourceSection();
        this.getContext().getObjectSpaceManager().traceAllocation(object, this.string(Layouts.CLASS.getFields(this.coreLibrary().getLogicalClass(allocatingSelf)).getName()), this.getSymbol(allocatingMethod), this.string(allocatingSourceSection.getSource().getName()), allocatingSourceSection.getStartLine());
        return object;
    }

    protected DynamicObjectFactory getInstanceFactory(DynamicObject classToAllocate) {
        return Layouts.CLASS.getInstanceFactory(classToAllocate);
    }

    private DynamicObject string(String value) {
        return this.createString(StringOperations.encodeRope(value, (Encoding)UTF8Encoding.INSTANCE));
    }

    @Specialization(guards={"isSingleton(classToAllocate)"})
    public DynamicObject allocateSingleton(DynamicObject classToAllocate, Object[] values) {
        throw new RaiseException(this.coreExceptions().typeErrorCantCreateInstanceOfSingletonClass(this));
    }

    protected Assumption getTracingAssumption() {
        return this.getContext().getObjectSpaceManager().getTracingAssumption();
    }

    protected boolean isTracing() {
        return this.getContext().getObjectSpaceManager().isTracing();
    }

    protected boolean isSingleton(DynamicObject classToAllocate) {
        return Layouts.CLASS.getIsSingleton(classToAllocate);
    }

    protected int getCacheLimit() {
        return this.getContext().getOptions().ALLOCATE_CLASS_CACHE;
    }
}

