/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.constants;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.language.RubyConstant;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.constants.GetConstantNode;
import org.jruby.truffle.language.constants.LookupConstantWithDynamicScopeNode;
import org.jruby.truffle.language.constants.LookupConstantWithDynamicScopeNodeGen;
import org.jruby.truffle.language.control.RaiseException;

public class ReadConstantWithDynamicScopeNode
extends RubyNode {
    private final String name;
    @Node.Child
    private LookupConstantWithDynamicScopeNode lookupConstantNode;
    @Node.Child
    private GetConstantNode getConstantNode = GetConstantNode.create();

    public ReadConstantWithDynamicScopeNode(String name) {
        this.name = name;
        this.lookupConstantNode = LookupConstantWithDynamicScopeNodeGen.create(name);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        RubyConstant constant = this.lookupConstantNode.executeLookupConstant(frame);
        DynamicObject module = this.lookupConstantNode.getLexicalScope(frame).getLiveModule();
        return this.getConstantNode.executeGetConstant(frame, module, this.name, constant, this.lookupConstantNode);
    }

    public Object readConstant(VirtualFrame frame, Object module, String name) {
        return this.execute(frame);
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        RubyConstant constant;
        try {
            constant = this.lookupConstantNode.executeLookupConstant(frame);
        }
        catch (RaiseException e) {
            if (Layouts.BASIC_OBJECT.getLogicalClass(e.getException()) == this.coreLibrary().getNameErrorClass()) {
                return this.nil();
            }
            throw e;
        }
        if (constant == null) {
            return this.nil();
        }
        return this.create7BitString("constant", (Encoding)UTF8Encoding.INSTANCE);
    }
}

