/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.string;

import java.nio.charset.StandardCharsets;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jruby.truffle.core.rope.Rope;

public class ByteList {
    private byte[] bytes;
    private int begin;
    private int realSize;
    private Encoding encoding = ASCIIEncoding.INSTANCE;
    private static final int DEFAULT_SIZE = 4;

    public ByteList() {
        this(4);
    }

    public ByteList(int size) {
        this.bytes = new byte[size];
        this.realSize = 0;
    }

    public ByteList(byte[] bytes, Encoding encoding) {
        this.bytes = bytes;
        this.realSize = bytes.length;
        this.encoding = ByteList.safeEncoding(encoding);
    }

    public ByteList(byte[] wrap) {
        this(wrap, true);
    }

    public ByteList(byte[] wrap, boolean copy) {
        this(wrap, (Encoding)ASCIIEncoding.INSTANCE, copy);
    }

    public ByteList(byte[] wrap, Encoding encoding, boolean copy) {
        assert (wrap != null);
        this.bytes = copy ? (byte[])wrap.clone() : wrap;
        this.realSize = wrap.length;
        this.encoding = ByteList.safeEncoding(encoding);
    }

    public ByteList(byte[] wrap, int index, int len) {
        this(wrap, index, len, true);
    }

    public ByteList(byte[] wrap, int index, int len, boolean copy) {
        this(wrap, index, len, (Encoding)ASCIIEncoding.INSTANCE, copy);
    }

    public ByteList(byte[] wrap, int index, int len, Encoding encoding, boolean copy) {
        assert (wrap != null) : "'wrap' must not be null";
        assert (index >= 0 && index <= wrap.length) : "'index' is not without bounds of 'wrap' array";
        assert (wrap.length >= index + len) : "'index' + 'len' is longer than the 'wrap' array";
        if (copy) {
            this.bytes = new byte[len];
            System.arraycopy(wrap, index, this.bytes, 0, len);
        } else {
            this.begin = index;
            this.bytes = wrap;
        }
        this.realSize = len;
        this.encoding = ByteList.safeEncoding(encoding);
    }

    public ByteList(ByteList wrap, int index, int len) {
        this(wrap.bytes, wrap.begin + index, len);
        this.encoding = wrap.encoding;
    }

    public void fill(int b, int len) {
        while (--len >= 0) {
            this.append(b);
        }
    }

    public ByteList dup() {
        ByteList dup = this.dup(this.realSize);
        return dup;
    }

    public ByteList dup(int length) {
        ByteList dup = new ByteList(length);
        dup.append(this.bytes, this.begin, this.realSize);
        dup.encoding = ByteList.safeEncoding(this.encoding);
        return dup;
    }

    public void ensure(int length) {
        if (this.begin + length > this.bytes.length) {
            byte[] tmp = new byte[Math.min(Integer.MAX_VALUE, length + (length >>> 1))];
            System.arraycopy(this.bytes, this.begin, tmp, 0, this.realSize);
            this.bytes = tmp;
            this.begin = 0;
        }
    }

    public ByteList append(byte b) {
        this.grow(1);
        this.bytes[this.begin + this.realSize] = b;
        ++this.realSize;
        return this;
    }

    public ByteList append(int b) {
        this.append((byte)b);
        return this;
    }

    public ByteList append(byte[] moreBytes) {
        assert (moreBytes != null) : "moreBytes is null";
        this.grow(moreBytes.length);
        System.arraycopy(moreBytes, 0, this.bytes, this.begin + this.realSize, moreBytes.length);
        this.realSize += moreBytes.length;
        return this;
    }

    public ByteList append(ByteList moreBytes, int index, int len) {
        return this.append(moreBytes.bytes, moreBytes.begin + index, len);
    }

    public ByteList append(byte[] moreBytes, int start, int len) {
        assert (moreBytes != null) : "moreBytes is null";
        assert (len >= 0 && moreBytes.length - start >= len) : "Bad length";
        this.grow(len);
        System.arraycopy(moreBytes, start, this.bytes, this.begin + this.realSize, len);
        this.realSize += len;
        return this;
    }

    public int length() {
        return this.realSize;
    }

    public int get(int index) {
        assert (index >= 0) : "index must be positive";
        return this.bytes[this.begin + index];
    }

    public void set(int index, int b) {
        assert (index >= 0) : "index must be positive";
        assert (this.begin + index < this.begin + this.realSize) : "index is too large";
        this.bytes[this.begin + index] = (byte)b;
    }

    public int indexOf(ByteList find, int i) {
        return ByteList.indexOf(this.bytes, this.begin, this.realSize, find.bytes, find.begin, find.realSize, i);
    }

    public int indexOf(Rope find) {
        return ByteList.indexOf(this.bytes, this.begin, this.realSize, find.getBytes(), 0, find.byteLength(), 0);
    }

    static int indexOf(byte[] source, int sourceOffset, int sourceCount, byte[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        byte first = target[targetOffset];
        int max = sourceOffset + (sourceCount - targetCount);
        for (int i = sourceOffset + fromIndex; i <= max; ++i) {
            if (source[i] != first) {
                while (++i <= max && source[i] != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end && source[j] == target[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i - sourceOffset;
        }
        return -1;
    }

    public boolean equals(Object other) {
        if (other instanceof ByteList) {
            return this.equal((ByteList)other);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equal(ByteList other) {
        if (other == this) {
            return true;
        }
        int last = this.realSize;
        if (last == other.realSize) {
            byte[] buf = this.bytes;
            byte[] otherBuf = other.bytes;
            int first = -1;
            while (--last > first && buf[this.begin + last] == otherBuf[other.begin + last] && ++first < last && buf[this.begin + first] == otherBuf[other.begin + first]) {
            }
            return first >= last;
        }
        return false;
    }

    public byte[] unsafeBytes() {
        return this.bytes;
    }

    public byte[] bytes() {
        byte[] newBytes = new byte[this.realSize];
        System.arraycopy(this.bytes, this.begin, newBytes, 0, this.realSize);
        return newBytes;
    }

    public int begin() {
        return this.begin;
    }

    private void grow(int increaseRequested) {
        if (increaseRequested < 0) {
            return;
        }
        int newSize = this.realSize + increaseRequested;
        if (newSize > this.bytes.length - this.begin) {
            byte[] newBytes = new byte[newSize + (newSize >> 1)];
            if (this.bytes.length != 0) {
                System.arraycopy(this.bytes, this.begin, newBytes, 0, this.realSize);
            }
            this.bytes = newBytes;
            this.begin = 0;
        }
    }

    public String toString() {
        return new String(this.bytes(), StandardCharsets.US_ASCII);
    }

    public byte[] getUnsafeBytes() {
        return this.bytes;
    }

    public int getBegin() {
        return this.begin;
    }

    public int getRealSize() {
        return this.realSize();
    }

    public void setRealSize(int realSize) {
        this.realSize(realSize);
    }

    public int realSize() {
        return this.realSize;
    }

    public void realSize(int realSize) {
        assert (realSize >= 0);
        this.realSize = realSize;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Encoding encoding) {
        assert (encoding != null);
        this.encoding = ByteList.safeEncoding(encoding);
    }

    public static Encoding safeEncoding(Encoding incoming) {
        if (incoming == null) {
            return ASCIIEncoding.INSTANCE;
        }
        return incoming;
    }
}

