/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.read.bytes;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.read.SourceNode;
import org.jruby.truffle.core.rope.AsciiOnlyLeafRope;

@NodeChildren(value={@NodeChild(value="value", type=SourceNode.class)})
public abstract class ReadMIMEStringNode
extends FormatNode {
    @Specialization
    public Object read(VirtualFrame frame, byte[] source) {
        int position = this.getSourcePosition(frame);
        int length = this.getSourceLength(frame);
        ByteBuffer encode = ByteBuffer.wrap(source, position, length - position);
        byte[] lElem = new byte[Math.max(encode.remaining(), 0)];
        int index = 0;
        while (encode.hasRemaining()) {
            int c = ReadMIMEStringNode.safeGet(encode);
            if (c != 61) {
                lElem[index++] = (byte)c;
                continue;
            }
            if (!encode.hasRemaining()) break;
            encode.mark();
            int c1 = ReadMIMEStringNode.safeGet(encode);
            if (c1 == 10 || c1 == 13) continue;
            int d1 = Character.digit(c1, 16);
            if (d1 == -1) {
                encode.reset();
                break;
            }
            encode.mark();
            if (!encode.hasRemaining()) break;
            int c2 = ReadMIMEStringNode.safeGet(encode);
            int d2 = Character.digit(c2, 16);
            if (d2 == -1) {
                encode.reset();
                break;
            }
            byte value = (byte)(d1 << 4 | d2);
            lElem[index++] = value;
        }
        this.setSourcePosition(frame, encode.position());
        return Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), new AsciiOnlyLeafRope(Arrays.copyOfRange(lElem, 0, index), (Encoding)USASCIIEncoding.INSTANCE));
    }
}

