/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.encoding;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.dsl.internal.SuppressFBWarnings;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import java.util.Arrays;
import java.util.List;
import org.jcodings.Encoding;
import org.jruby.truffle.core.encoding.EncodingNodes;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypesGen;
import org.jruby.truffle.language.SnippetNode;

@GeneratedBy(value=EncodingNodes.class)
public final class EncodingNodesFactory {
    public static List<NodeFactory<? extends RubyNode>> getFactories() {
        return Arrays.asList(AsciiCompatibleNodeFactory.getInstance(), CompatibleQueryNodeFactory.getInstance(), ListNodeFactory.getInstance(), LocaleCharacterMapNodeFactory.getInstance(), DummyNodeFactory.getInstance(), ToSNodeFactory.getInstance(), AllocateNodeFactory.getInstance(), EncodingGetObjectEncodingNodeFactory.getInstance(), EncodingReplicateNodeFactory.getInstance(), GetEncodingObjectByIndexNodeFactory.getInstance());
    }

    @GeneratedBy(value=EncodingNodes.CheckEncodingNode.class)
    public static final class CheckEncodingNodeGen
    extends EncodingNodes.CheckEncodingNode
    implements SpecializedNode {
        @Node.Child
        private RubyNode first_;
        @Node.Child
        private RubyNode second_;
        @Node.Child
        private BaseNode_ specialization_;

        private CheckEncodingNodeGen(RubyNode first, RubyNode second) {
            this.first_ = first;
            this.second_ = second;
            this.specialization_ = UninitializedNode_.create(this);
        }

        public NodeCost getCost() {
            return this.specialization_.getNodeCost();
        }

        @Override
        public Encoding executeCheckEncoding(Object firstValue, Object secondValue) {
            return this.specialization_.executeEncoding(firstValue, secondValue);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.specialization_.execute(frameValue);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.specialization_.executeVoid(frameValue);
        }

        public SpecializationNode getSpecializationNode() {
            return this.specialization_;
        }

        public Node deepCopy() {
            return SpecializationNode.updateRoot((Node)super.deepCopy());
        }

        public static EncodingNodes.CheckEncodingNode create(RubyNode first, RubyNode second) {
            return new CheckEncodingNodeGen(first, second);
        }

        @GeneratedBy(methodName="checkEncoding(Object, Object, BranchProfile)", value=EncodingNodes.CheckEncodingNode.class)
        private static final class CheckEncodingNode_
        extends BaseNode_ {
            private final BranchProfile errorProfile;

            CheckEncodingNode_(CheckEncodingNodeGen root, BranchProfile errorProfile) {
                super(root, 1);
                this.errorProfile = errorProfile;
            }

            @Override
            public Encoding executeEncoding(Object firstValue, Object secondValue) {
                return this.root.checkEncoding(firstValue, secondValue, this.errorProfile);
            }

            static BaseNode_ create(CheckEncodingNodeGen root, BranchProfile errorProfile) {
                return new CheckEncodingNode_(root, errorProfile);
            }
        }

        @GeneratedBy(value=EncodingNodes.CheckEncodingNode.class)
        private static final class UninitializedNode_
        extends BaseNode_ {
            UninitializedNode_(CheckEncodingNodeGen root) {
                super(root, Integer.MAX_VALUE);
            }

            @Override
            public Encoding executeEncoding(Object firstValue, Object secondValue) {
                return (Encoding)this.uninitialized(null, firstValue, secondValue);
            }

            static BaseNode_ create(CheckEncodingNodeGen root) {
                return new UninitializedNode_(root);
            }
        }

        @GeneratedBy(value=EncodingNodes.CheckEncodingNode.class)
        private static abstract class BaseNode_
        extends SpecializationNode {
            @CompilerDirectives.CompilationFinal
            protected CheckEncodingNodeGen root;

            BaseNode_(CheckEncodingNodeGen root, int index) {
                super(index);
                this.root = root;
            }

            protected final void setRoot(Node root) {
                this.root = (CheckEncodingNodeGen)root;
            }

            protected final Node[] getSuppliedChildren() {
                return new Node[]{this.root.first_, this.root.second_};
            }

            public final Object acceptAndExecute(Frame frameValue, Object firstValue, Object secondValue) {
                return this.executeEncoding(firstValue, secondValue);
            }

            public abstract Encoding executeEncoding(Object var1, Object var2);

            public Object execute(VirtualFrame frameValue) {
                Object firstValue_ = this.root.first_.execute(frameValue);
                Object secondValue_ = this.root.second_.execute(frameValue);
                return this.executeEncoding(firstValue_, secondValue_);
            }

            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected final SpecializationNode createNext(Frame frameValue, Object firstValue, Object secondValue) {
                BranchProfile errorProfile1 = BranchProfile.create();
                return CheckEncodingNode_.create(this.root, errorProfile1);
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.GetEncodingObjectByIndexNode.class)
    public static final class GetEncodingObjectByIndexNodeFactory
    implements NodeFactory<EncodingNodes.GetEncodingObjectByIndexNode> {
        private static GetEncodingObjectByIndexNodeFactory getEncodingObjectByIndexNodeFactoryInstance;

        private GetEncodingObjectByIndexNodeFactory() {
        }

        public Class<EncodingNodes.GetEncodingObjectByIndexNode> getNodeClass() {
            return EncodingNodes.GetEncodingObjectByIndexNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public EncodingNodes.GetEncodingObjectByIndexNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return GetEncodingObjectByIndexNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.GetEncodingObjectByIndexNode> getInstance() {
            if (getEncodingObjectByIndexNodeFactoryInstance == null) {
                getEncodingObjectByIndexNodeFactoryInstance = new GetEncodingObjectByIndexNodeFactory();
            }
            return getEncodingObjectByIndexNodeFactoryInstance;
        }

        public static EncodingNodes.GetEncodingObjectByIndexNode create(RubyNode[] arguments) {
            return new GetEncodingObjectByIndexNodeGen(arguments);
        }

        @GeneratedBy(value=EncodingNodes.GetEncodingObjectByIndexNode.class)
        public static final class GetEncodingObjectByIndexNodeGen
        extends EncodingNodes.GetEncodingObjectByIndexNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private GetEncodingObjectByIndexNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                return this.specialization_.executeDynamicObject(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="getEncoding(int)", value=EncodingNodes.GetEncodingObjectByIndexNode.class)
            private static final class GetEncodingNode_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                GetEncodingNode_(GetEncodingObjectByIndexNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((GetEncodingNode_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDynamicObject(frameValue);
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDynamicObject_(frameValue, ex.getResult());
                    }
                    return this.root.getEncoding(arguments0Value_);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.getEncoding(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(GetEncodingObjectByIndexNodeGen root, Object arguments0Value) {
                    return new GetEncodingNode_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=EncodingNodes.GetEncodingObjectByIndexNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(GetEncodingObjectByIndexNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(GetEncodingObjectByIndexNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=EncodingNodes.GetEncodingObjectByIndexNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(GetEncodingObjectByIndexNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(GetEncodingObjectByIndexNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=EncodingNodes.GetEncodingObjectByIndexNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected GetEncodingObjectByIndexNodeGen root;

                BaseNode_(GetEncodingObjectByIndexNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (GetEncodingObjectByIndexNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    return (DynamicObject)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return GetEncodingNode_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.EncodingReplicateNode.class)
    public static final class EncodingReplicateNodeFactory
    implements NodeFactory<EncodingNodes.EncodingReplicateNode> {
        private static EncodingReplicateNodeFactory encodingReplicateNodeFactoryInstance;

        private EncodingReplicateNodeFactory() {
        }

        public Class<EncodingNodes.EncodingReplicateNode> getNodeClass() {
            return EncodingNodes.EncodingReplicateNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public EncodingNodes.EncodingReplicateNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return EncodingReplicateNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.EncodingReplicateNode> getInstance() {
            if (encodingReplicateNodeFactoryInstance == null) {
                encodingReplicateNodeFactoryInstance = new EncodingReplicateNodeFactory();
            }
            return encodingReplicateNodeFactoryInstance;
        }

        public static EncodingNodes.EncodingReplicateNode create(RubyNode[] arguments) {
            return new EncodingReplicateNodeGen(arguments);
        }

        @GeneratedBy(value=EncodingNodes.EncodingReplicateNode.class)
        public static final class EncodingReplicateNodeGen
        extends EncodingNodes.EncodingReplicateNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private EncodingReplicateNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="encodingReplicate(VirtualFrame, DynamicObject, DynamicObject, SnippetNode)", value=EncodingNodes.EncodingReplicateNode.class)
            private static final class EncodingReplicateNode_
            extends BaseNode_ {
                @Node.Child
                private SnippetNode snippetNode;

                EncodingReplicateNode_(EncodingReplicateNodeGen root, SnippetNode snippetNode) {
                    super(root, 1);
                    this.snippetNode = snippetNode;
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments1Value_)) {
                            return this.root.encodingReplicate(frameValue, arguments0Value_, arguments1Value_, this.snippetNode);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EncodingReplicateNodeGen root, SnippetNode snippetNode) {
                    return new EncodingReplicateNode_(root, snippetNode);
                }
            }

            @GeneratedBy(value=EncodingNodes.EncodingReplicateNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(EncodingReplicateNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EncodingReplicateNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=EncodingNodes.EncodingReplicateNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected EncodingReplicateNodeGen root;

                BaseNode_(EncodingReplicateNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (EncodingReplicateNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments1Value_;
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && RubyGuards.isRubyString(arguments1Value_ = (DynamicObject)arguments1Value)) {
                        SnippetNode snippetNode1 = new SnippetNode();
                        return EncodingReplicateNode_.create(this.root, snippetNode1);
                    }
                    return null;
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.EncodingGetObjectEncodingNode.class)
    public static final class EncodingGetObjectEncodingNodeFactory
    implements NodeFactory<EncodingNodes.EncodingGetObjectEncodingNode> {
        private static EncodingGetObjectEncodingNodeFactory encodingGetObjectEncodingNodeFactoryInstance;

        private EncodingGetObjectEncodingNodeFactory() {
        }

        public Class<EncodingNodes.EncodingGetObjectEncodingNode> getNodeClass() {
            return EncodingNodes.EncodingGetObjectEncodingNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public EncodingNodes.EncodingGetObjectEncodingNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return EncodingGetObjectEncodingNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.EncodingGetObjectEncodingNode> getInstance() {
            if (encodingGetObjectEncodingNodeFactoryInstance == null) {
                encodingGetObjectEncodingNodeFactoryInstance = new EncodingGetObjectEncodingNodeFactory();
            }
            return encodingGetObjectEncodingNodeFactoryInstance;
        }

        public static EncodingNodes.EncodingGetObjectEncodingNode create(RubyNode[] arguments) {
            return new EncodingGetObjectEncodingNodeGen(arguments);
        }

        @GeneratedBy(value=EncodingNodes.EncodingGetObjectEncodingNode.class)
        public static final class EncodingGetObjectEncodingNodeGen
        extends EncodingNodes.EncodingGetObjectEncodingNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private EncodingGetObjectEncodingNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="encodingGetObjectEncodingNil(DynamicObject)", value=EncodingNodes.EncodingGetObjectEncodingNode.class)
            private static final class EncodingGetObjectEncodingNilNode_
            extends BaseNode_ {
                EncodingGetObjectEncodingNilNode_(EncodingGetObjectEncodingNodeGen root) {
                    super(root, 5);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (!(!(arguments0Value instanceof DynamicObject) || RubyGuards.isRubyString(arguments0Value_ = (DynamicObject)arguments0Value) || RubyGuards.isRubySymbol(arguments0Value_) || RubyGuards.isRubyEncoding(arguments0Value_) || RubyGuards.isRubyRegexp(arguments0Value_))) {
                        return this.root.encodingGetObjectEncodingNil(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(EncodingGetObjectEncodingNodeGen root) {
                    return new EncodingGetObjectEncodingNilNode_(root);
                }
            }

            @GeneratedBy(methodName="encodingGetObjectEncodingRegexp(DynamicObject)", value=EncodingNodes.EncodingGetObjectEncodingNode.class)
            private static final class EncodingGetObjectEncodingRegexpNode_
            extends BaseNode_ {
                EncodingGetObjectEncodingRegexpNode_(EncodingGetObjectEncodingNodeGen root) {
                    super(root, 4);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyRegexp(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.encodingGetObjectEncodingRegexp(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(EncodingGetObjectEncodingNodeGen root) {
                    return new EncodingGetObjectEncodingRegexpNode_(root);
                }
            }

            @GeneratedBy(methodName="encodingGetObjectEncoding(DynamicObject)", value=EncodingNodes.EncodingGetObjectEncodingNode.class)
            private static final class EncodingGetObjectEncodingNode_
            extends BaseNode_ {
                EncodingGetObjectEncodingNode_(EncodingGetObjectEncodingNodeGen root) {
                    super(root, 3);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyEncoding(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.encodingGetObjectEncoding(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(EncodingGetObjectEncodingNodeGen root) {
                    return new EncodingGetObjectEncodingNode_(root);
                }
            }

            @GeneratedBy(methodName="encodingGetObjectEncodingSymbol(DynamicObject)", value=EncodingNodes.EncodingGetObjectEncodingNode.class)
            private static final class EncodingGetObjectEncodingSymbolNode_
            extends BaseNode_ {
                EncodingGetObjectEncodingSymbolNode_(EncodingGetObjectEncodingNodeGen root) {
                    super(root, 2);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubySymbol(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.encodingGetObjectEncodingSymbol(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(EncodingGetObjectEncodingNodeGen root) {
                    return new EncodingGetObjectEncodingSymbolNode_(root);
                }
            }

            @GeneratedBy(methodName="encodingGetObjectEncodingString(DynamicObject)", value=EncodingNodes.EncodingGetObjectEncodingNode.class)
            private static final class EncodingGetObjectEncodingStringNode_
            extends BaseNode_ {
                EncodingGetObjectEncodingStringNode_(EncodingGetObjectEncodingNodeGen root) {
                    super(root, 1);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyString(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.encodingGetObjectEncodingString(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(EncodingGetObjectEncodingNodeGen root) {
                    return new EncodingGetObjectEncodingStringNode_(root);
                }
            }

            @GeneratedBy(value=EncodingNodes.EncodingGetObjectEncodingNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(EncodingGetObjectEncodingNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(EncodingGetObjectEncodingNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=EncodingNodes.EncodingGetObjectEncodingNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(EncodingGetObjectEncodingNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(EncodingGetObjectEncodingNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=EncodingNodes.EncodingGetObjectEncodingNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected EncodingGetObjectEncodingNodeGen root;

                BaseNode_(EncodingGetObjectEncodingNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (EncodingGetObjectEncodingNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (RubyGuards.isRubyString(arguments0Value_)) {
                            return EncodingGetObjectEncodingStringNode_.create(this.root);
                        }
                        if (RubyGuards.isRubySymbol(arguments0Value_)) {
                            return EncodingGetObjectEncodingSymbolNode_.create(this.root);
                        }
                        if (RubyGuards.isRubyEncoding(arguments0Value_)) {
                            return EncodingGetObjectEncodingNode_.create(this.root);
                        }
                        if (RubyGuards.isRubyRegexp(arguments0Value_)) {
                            return EncodingGetObjectEncodingRegexpNode_.create(this.root);
                        }
                        if (!(RubyGuards.isRubyString(arguments0Value_) || RubyGuards.isRubySymbol(arguments0Value_) || RubyGuards.isRubyEncoding(arguments0Value_) || RubyGuards.isRubyRegexp(arguments0Value_))) {
                            return EncodingGetObjectEncodingNilNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.AllocateNode.class)
    public static final class AllocateNodeFactory
    implements NodeFactory<EncodingNodes.AllocateNode> {
        private static AllocateNodeFactory allocateNodeFactoryInstance;

        private AllocateNodeFactory() {
        }

        public Class<EncodingNodes.AllocateNode> getNodeClass() {
            return EncodingNodes.AllocateNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode.class));
        }

        public EncodingNodes.AllocateNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode)) {
                return AllocateNodeFactory.create((RubyNode)((Object)arguments[0]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.AllocateNode> getInstance() {
            if (allocateNodeFactoryInstance == null) {
                allocateNodeFactoryInstance = new AllocateNodeFactory();
            }
            return allocateNodeFactoryInstance;
        }

        public static EncodingNodes.AllocateNode create(RubyNode operand) {
            return new AllocateNodeGen(operand);
        }

        @GeneratedBy(value=EncodingNodes.AllocateNode.class)
        public static final class AllocateNodeGen
        extends EncodingNodes.AllocateNode {
            @Node.Child
            private RubyNode operand_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AllocateNodeGen(RubyNode operand) {
                this.operand_ = operand;
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject operandValue_;
                try {
                    operandValue_ = this.operand_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.allocate(operandValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object operandValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.operand_}, new Object[]{operandValue});
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.ToSNode.class)
    public static final class ToSNodeFactory
    implements NodeFactory<EncodingNodes.ToSNode> {
        private static ToSNodeFactory toSNodeFactoryInstance;

        private ToSNodeFactory() {
        }

        public Class<EncodingNodes.ToSNode> getNodeClass() {
            return EncodingNodes.ToSNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public EncodingNodes.ToSNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ToSNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.ToSNode> getInstance() {
            if (toSNodeFactoryInstance == null) {
                toSNodeFactoryInstance = new ToSNodeFactory();
            }
            return toSNodeFactoryInstance;
        }

        public static EncodingNodes.ToSNode create(RubyNode[] arguments) {
            return new ToSNodeGen(arguments);
        }

        @GeneratedBy(value=EncodingNodes.ToSNode.class)
        public static final class ToSNodeGen
        extends EncodingNodes.ToSNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ToSNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.toS(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.DummyNode.class)
    public static final class DummyNodeFactory
    implements NodeFactory<EncodingNodes.DummyNode> {
        private static DummyNodeFactory dummyNodeFactoryInstance;

        private DummyNodeFactory() {
        }

        public Class<EncodingNodes.DummyNode> getNodeClass() {
            return EncodingNodes.DummyNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public EncodingNodes.DummyNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return DummyNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.DummyNode> getInstance() {
            if (dummyNodeFactoryInstance == null) {
                dummyNodeFactoryInstance = new DummyNodeFactory();
            }
            return dummyNodeFactoryInstance;
        }

        public static EncodingNodes.DummyNode create(RubyNode[] arguments) {
            return new DummyNodeGen(arguments);
        }

        @GeneratedBy(value=EncodingNodes.DummyNode.class)
        @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
        public static final class DummyNodeGen
        extends EncodingNodes.DummyNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeIsDummyCached_;
            @Node.Child
            private BaseNode_ specialization_;

            private DummyNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.specialization_.executeBoolean(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="isDummyUncached(DynamicObject)", value=EncodingNodes.DummyNode.class)
            private static final class IsDummyUncachedNode_
            extends BaseNode_ {
                IsDummyUncachedNode_(DummyNodeGen root) {
                    super(root, 2);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    return this.root.isDummyUncached(arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        return this.root.isDummyUncached(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(DummyNodeGen root) {
                    return new IsDummyUncachedNode_(root);
                }
            }

            @GeneratedBy(methodName="isDummyCached(DynamicObject, DynamicObject, boolean)", value=EncodingNodes.DummyNode.class)
            private static final class IsDummyCachedNode_
            extends BaseNode_ {
                private final DynamicObject cachedEncoding;
                private final boolean isDummy;

                IsDummyCachedNode_(DummyNodeGen root, DynamicObject cachedEncoding, boolean isDummy) {
                    super(root, 1);
                    this.cachedEncoding = cachedEncoding;
                    this.isDummy = isDummy;
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    if (newNode.getClass() == IsDummyUncachedNode_.class) {
                        this.removeSame("Contained by isDummyUncached(DynamicObject)");
                    }
                    return super.merge(newNode, frameValue, arguments0Value);
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    return arguments0Value instanceof DynamicObject && (arguments0Value_ = (DynamicObject)arguments0Value) == this.cachedEncoding;
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    if (arguments0Value_ == this.cachedEncoding) {
                        return this.root.isDummyCached(arguments0Value_, this.cachedEncoding, this.isDummy);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && (arguments0Value_ = (DynamicObject)arguments0Value) == this.cachedEncoding) {
                        return this.root.isDummyCached(arguments0Value_, this.cachedEncoding, this.isDummy);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(DummyNodeGen root, DynamicObject cachedEncoding, boolean isDummy) {
                    return new IsDummyCachedNode_(root, cachedEncoding, isDummy);
                }
            }

            @GeneratedBy(value=EncodingNodes.DummyNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(DummyNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(DummyNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=EncodingNodes.DummyNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(DummyNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Boolean)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(DummyNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=EncodingNodes.DummyNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected DummyNodeGen root;

                BaseNode_(DummyNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (DummyNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeBoolean_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract boolean executeBoolean_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeBoolean_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) {
                    return (Boolean)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        boolean isDummy1;
                        BaseNode_ s;
                        DynamicObject arguments0Value_;
                        DynamicObject cachedEncoding1 = arguments0Value_ = (DynamicObject)arguments0Value;
                        if (arguments0Value_ == cachedEncoding1 && !this.root.excludeIsDummyCached_ && this.countSame(s = IsDummyCachedNode_.create(this.root, cachedEncoding1, isDummy1 = EncodingNodes.DummyNode.isDummy(cachedEncoding1))) < this.root.getCacheLimit()) {
                            return s;
                        }
                        this.root.excludeIsDummyCached_ = true;
                        return IsDummyUncachedNode_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.LocaleCharacterMapNode.class)
    public static final class LocaleCharacterMapNodeFactory
    implements NodeFactory<EncodingNodes.LocaleCharacterMapNode> {
        private static LocaleCharacterMapNodeFactory localeCharacterMapNodeFactoryInstance;

        private LocaleCharacterMapNodeFactory() {
        }

        public Class<EncodingNodes.LocaleCharacterMapNode> getNodeClass() {
            return EncodingNodes.LocaleCharacterMapNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(new Object[0]);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public EncodingNodes.LocaleCharacterMapNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return LocaleCharacterMapNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.LocaleCharacterMapNode> getInstance() {
            if (localeCharacterMapNodeFactoryInstance == null) {
                localeCharacterMapNodeFactoryInstance = new LocaleCharacterMapNodeFactory();
            }
            return localeCharacterMapNodeFactoryInstance;
        }

        public static EncodingNodes.LocaleCharacterMapNode create(RubyNode[] arguments) {
            return new LocaleCharacterMapNodeGen(arguments);
        }

        @GeneratedBy(value=EncodingNodes.LocaleCharacterMapNode.class)
        public static final class LocaleCharacterMapNodeGen
        extends EncodingNodes.LocaleCharacterMapNode
        implements SpecializedNode {
            @Node.Child
            private BaseNode_ specialization_ = UninitializedNode_.create(this);

            private LocaleCharacterMapNodeGen(RubyNode[] arguments) {
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="localeCharacterMap(GetRubyEncodingNode)", value=EncodingNodes.LocaleCharacterMapNode.class)
            private static final class LocaleCharacterMapNode_
            extends BaseNode_ {
                @Node.Child
                private EncodingNodes.GetRubyEncodingNode getRubyEncodingNode;

                LocaleCharacterMapNode_(LocaleCharacterMapNodeGen root, EncodingNodes.GetRubyEncodingNode getRubyEncodingNode) {
                    super(root, 1);
                    this.getRubyEncodingNode = getRubyEncodingNode;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.root.localeCharacterMap(this.getRubyEncodingNode);
                }

                static BaseNode_ create(LocaleCharacterMapNodeGen root, EncodingNodes.GetRubyEncodingNode getRubyEncodingNode) {
                    return new LocaleCharacterMapNode_(root, getRubyEncodingNode);
                }
            }

            @GeneratedBy(value=EncodingNodes.LocaleCharacterMapNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(LocaleCharacterMapNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.uninitialized((Frame)frameValue);
                }

                static BaseNode_ create(LocaleCharacterMapNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=EncodingNodes.LocaleCharacterMapNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected LocaleCharacterMapNodeGen root;

                BaseNode_(LocaleCharacterMapNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (LocaleCharacterMapNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[0];
                }

                public final Object acceptAndExecute(Frame frameValue) {
                    return this.execute((VirtualFrame)frameValue);
                }

                public abstract Object execute(VirtualFrame var1);

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue) {
                    EncodingNodes.GetRubyEncodingNode getRubyEncodingNode1 = EncodingNodes.GetRubyEncodingNode.create();
                    return LocaleCharacterMapNode_.create(this.root, getRubyEncodingNode1);
                }
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.ListNode.class)
    public static final class ListNodeFactory
    implements NodeFactory<EncodingNodes.ListNode> {
        private static ListNodeFactory listNodeFactoryInstance;

        private ListNodeFactory() {
        }

        public Class<EncodingNodes.ListNode> getNodeClass() {
            return EncodingNodes.ListNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(new Object[0]);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public EncodingNodes.ListNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ListNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.ListNode> getInstance() {
            if (listNodeFactoryInstance == null) {
                listNodeFactoryInstance = new ListNodeFactory();
            }
            return listNodeFactoryInstance;
        }

        public static EncodingNodes.ListNode create(RubyNode[] arguments) {
            return new ListNodeGen(arguments);
        }

        @GeneratedBy(value=EncodingNodes.ListNode.class)
        public static final class ListNodeGen
        extends EncodingNodes.ListNode {
            private ListNodeGen(RubyNode[] arguments) {
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.list();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.CompatibleQueryNode.class)
    public static final class CompatibleQueryNodeFactory
    implements NodeFactory<EncodingNodes.CompatibleQueryNode> {
        private static CompatibleQueryNodeFactory compatibleQueryNodeFactoryInstance;

        private CompatibleQueryNodeFactory() {
        }

        public Class<EncodingNodes.CompatibleQueryNode> getNodeClass() {
            return EncodingNodes.CompatibleQueryNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public EncodingNodes.CompatibleQueryNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return CompatibleQueryNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.CompatibleQueryNode> getInstance() {
            if (compatibleQueryNodeFactoryInstance == null) {
                compatibleQueryNodeFactoryInstance = new CompatibleQueryNodeFactory();
            }
            return compatibleQueryNodeFactoryInstance;
        }

        public static EncodingNodes.CompatibleQueryNode create(RubyNode[] arguments) {
            return new CompatibleQueryNodeGen(arguments);
        }

        @GeneratedBy(value=EncodingNodes.CompatibleQueryNode.class)
        public static final class CompatibleQueryNodeGen
        extends EncodingNodes.CompatibleQueryNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private CompatibleQueryNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public DynamicObject executeCompatibleQuery(Object arguments0Value, Object arguments1Value) {
                return this.specialization_.executeDynamicObject1(arguments0Value, arguments1Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="isCompatible(Object, Object, ConditionProfile)", value=EncodingNodes.CompatibleQueryNode.class)
            private static final class IsCompatibleNode_
            extends BaseNode_ {
                private final ConditionProfile noNegotiatedEncodingProfile;

                IsCompatibleNode_(CompatibleQueryNodeGen root, ConditionProfile noNegotiatedEncodingProfile) {
                    super(root, 1);
                    this.noNegotiatedEncodingProfile = noNegotiatedEncodingProfile;
                }

                @Override
                public DynamicObject executeDynamicObject1(Object arguments0Value, Object arguments1Value) {
                    return this.root.isCompatible(arguments0Value, arguments1Value, this.noNegotiatedEncodingProfile);
                }

                static BaseNode_ create(CompatibleQueryNodeGen root, ConditionProfile noNegotiatedEncodingProfile) {
                    return new IsCompatibleNode_(root, noNegotiatedEncodingProfile);
                }
            }

            @GeneratedBy(value=EncodingNodes.CompatibleQueryNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(CompatibleQueryNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject1(Object arguments0Value, Object arguments1Value) {
                    return (DynamicObject)this.uninitialized(null, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompatibleQueryNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=EncodingNodes.CompatibleQueryNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected CompatibleQueryNodeGen root;

                BaseNode_(CompatibleQueryNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (CompatibleQueryNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeDynamicObject1(arguments0Value, arguments1Value);
                }

                public abstract DynamicObject executeDynamicObject1(Object var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.executeDynamicObject1(arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    ConditionProfile noNegotiatedEncodingProfile1 = ConditionProfile.createBinaryProfile();
                    return IsCompatibleNode_.create(this.root, noNegotiatedEncodingProfile1);
                }
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.NegotiateCompatibleEncodingNode.class)
    @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
    public static final class NegotiateCompatibleEncodingNodeGen
    extends EncodingNodes.NegotiateCompatibleEncodingNode
    implements SpecializedNode {
        @Node.Child
        private RubyNode first_;
        @Node.Child
        private RubyNode second_;
        @CompilerDirectives.CompilationFinal
        private boolean excludeNegotiateSameEncodingCached_;
        @CompilerDirectives.CompilationFinal
        private boolean excludeNegotiateStringStringCached_;
        @CompilerDirectives.CompilationFinal
        private boolean excludeNegotiateStringObjectCached_;
        @CompilerDirectives.CompilationFinal
        private boolean excludeNegotiateObjectObjectCached_;
        @Node.Child
        private BaseNode_ specialization_;

        private NegotiateCompatibleEncodingNodeGen(RubyNode first, RubyNode second) {
            this.first_ = first;
            this.second_ = second;
            this.specialization_ = UninitializedNode_.create(this);
        }

        public NodeCost getCost() {
            return this.specialization_.getNodeCost();
        }

        @Override
        public Encoding executeNegotiate(Object firstValue, Object secondValue) {
            return this.specialization_.executeEncoding(firstValue, secondValue);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.specialization_.execute(frameValue);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.specialization_.executeVoid(frameValue);
        }

        public SpecializationNode getSpecializationNode() {
            return this.specialization_;
        }

        public Node deepCopy() {
            return SpecializationNode.updateRoot((Node)super.deepCopy());
        }

        public static EncodingNodes.NegotiateCompatibleEncodingNode create(RubyNode first, RubyNode second) {
            return new NegotiateCompatibleEncodingNodeGen(first, second);
        }

        @GeneratedBy(methodName="negotiateObjectObjectUncached(Object, Object)", value=EncodingNodes.NegotiateCompatibleEncodingNode.class)
        private static final class NegotiateObjectObjectUncachedNode_
        extends BaseNode_ {
            NegotiateObjectObjectUncachedNode_(NegotiateCompatibleEncodingNodeGen root) {
                super(root, 9);
            }

            @Override
            public Encoding executeEncoding(Object firstValue, Object secondValue) {
                if (this.root.getEncoding(firstValue) != this.root.getEncoding(secondValue) && !RubyGuards.isRubyString(firstValue) && !RubyGuards.isRubyString(secondValue)) {
                    return this.root.negotiateObjectObjectUncached(firstValue, secondValue);
                }
                return this.getNext().executeEncoding(firstValue, secondValue);
            }

            static BaseNode_ create(NegotiateCompatibleEncodingNodeGen root) {
                return new NegotiateObjectObjectUncachedNode_(root);
            }
        }

        @GeneratedBy(methodName="negotiateObjectObjectCached(Object, Object, Encoding, Encoding, Encoding)", value=EncodingNodes.NegotiateCompatibleEncodingNode.class)
        private static final class NegotiateObjectObjectCachedNode_
        extends BaseNode_ {
            private final Encoding firstEncoding;
            private final Encoding secondEncoding;
            private final Encoding negotiatedEncoding;

            NegotiateObjectObjectCachedNode_(NegotiateCompatibleEncodingNodeGen root, Encoding firstEncoding, Encoding secondEncoding, Encoding negotiatedEncoding) {
                super(root, 8);
                this.firstEncoding = firstEncoding;
                this.secondEncoding = secondEncoding;
                this.negotiatedEncoding = negotiatedEncoding;
            }

            public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object firstValue, Object secondValue) {
                if (newNode.getClass() == NegotiateObjectObjectUncachedNode_.class) {
                    this.removeSame("Contained by negotiateObjectObjectUncached(Object, Object)");
                }
                return super.merge(newNode, frameValue, firstValue, secondValue);
            }

            public boolean isIdentical(SpecializationNode other, Frame frameValue, Object firstValue, Object secondValue) {
                if (!RubyGuards.isRubyString(firstValue) && !RubyGuards.isRubyString(secondValue) && this.root.getEncoding(firstValue) == this.firstEncoding && this.root.getEncoding(secondValue) == this.secondEncoding) {
                    assert (this.firstEncoding != this.secondEncoding);
                    assert (this.firstEncoding != null);
                    assert (this.secondEncoding != null);
                    return true;
                }
                return false;
            }

            @Override
            public Encoding executeEncoding(Object firstValue, Object secondValue) {
                if (!RubyGuards.isRubyString(firstValue) && !RubyGuards.isRubyString(secondValue) && this.root.getEncoding(firstValue) == this.firstEncoding && this.root.getEncoding(secondValue) == this.secondEncoding) {
                    assert (this.firstEncoding != this.secondEncoding);
                    assert (this.firstEncoding != null);
                    assert (this.secondEncoding != null);
                    return this.root.negotiateObjectObjectCached(firstValue, secondValue, this.firstEncoding, this.secondEncoding, this.negotiatedEncoding);
                }
                return this.getNext().executeEncoding(firstValue, secondValue);
            }

            static BaseNode_ create(NegotiateCompatibleEncodingNodeGen root, Encoding firstEncoding, Encoding secondEncoding, Encoding negotiatedEncoding) {
                return new NegotiateObjectObjectCachedNode_(root, firstEncoding, secondEncoding, negotiatedEncoding);
            }
        }

        @GeneratedBy(methodName="negotiateObjectString(Object, DynamicObject)", value=EncodingNodes.NegotiateCompatibleEncodingNode.class)
        private static final class NegotiateObjectStringNode_
        extends BaseNode_ {
            NegotiateObjectStringNode_(NegotiateCompatibleEncodingNodeGen root) {
                super(root, 7);
            }

            @Override
            public Encoding executeEncoding(Object firstValue, Object secondValue) {
                if (secondValue instanceof DynamicObject) {
                    DynamicObject secondValue_ = (DynamicObject)secondValue;
                    if (this.root.getEncoding(firstValue) != this.root.getEncoding(secondValue_) && !RubyGuards.isRubyString(firstValue) && RubyGuards.isRubyString(secondValue_)) {
                        return this.root.negotiateObjectString(firstValue, secondValue_);
                    }
                }
                return this.getNext().executeEncoding(firstValue, secondValue);
            }

            static BaseNode_ create(NegotiateCompatibleEncodingNodeGen root) {
                return new NegotiateObjectStringNode_(root);
            }
        }

        @GeneratedBy(methodName="negotiateStringObjectUncached(DynamicObject, Object)", value=EncodingNodes.NegotiateCompatibleEncodingNode.class)
        private static final class NegotiateStringObjectUncachedNode_
        extends BaseNode_ {
            NegotiateStringObjectUncachedNode_(NegotiateCompatibleEncodingNodeGen root) {
                super(root, 6);
            }

            @Override
            public Encoding executeEncoding(Object firstValue, Object secondValue) {
                DynamicObject firstValue_;
                if (firstValue instanceof DynamicObject && this.root.getEncoding(firstValue_ = (DynamicObject)firstValue) != this.root.getEncoding(secondValue) && RubyGuards.isRubyString(firstValue_) && !RubyGuards.isRubyString(secondValue)) {
                    return this.root.negotiateStringObjectUncached(firstValue_, secondValue);
                }
                return this.getNext().executeEncoding(firstValue, secondValue);
            }

            static BaseNode_ create(NegotiateCompatibleEncodingNodeGen root) {
                return new NegotiateStringObjectUncachedNode_(root);
            }
        }

        @GeneratedBy(methodName="negotiateStringObjectCached(DynamicObject, Object, Encoding, Encoding, CodeRange, Encoding)", value=EncodingNodes.NegotiateCompatibleEncodingNode.class)
        private static final class NegotiateStringObjectCachedNode_
        extends BaseNode_ {
            private final Encoding firstEncoding;
            private final Encoding secondEncoding;
            private final CodeRange codeRange;
            private final Encoding negotiatedEncoding;

            NegotiateStringObjectCachedNode_(NegotiateCompatibleEncodingNodeGen root, Encoding firstEncoding, Encoding secondEncoding, CodeRange codeRange, Encoding negotiatedEncoding) {
                super(root, 5);
                this.firstEncoding = firstEncoding;
                this.secondEncoding = secondEncoding;
                this.codeRange = codeRange;
                this.negotiatedEncoding = negotiatedEncoding;
            }

            public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object firstValue, Object secondValue) {
                if (newNode.getClass() == NegotiateStringObjectUncachedNode_.class) {
                    this.removeSame("Contained by negotiateStringObjectUncached(DynamicObject, Object)");
                }
                return super.merge(newNode, frameValue, firstValue, secondValue);
            }

            public boolean isIdentical(SpecializationNode other, Frame frameValue, Object firstValue, Object secondValue) {
                DynamicObject firstValue_;
                if (firstValue instanceof DynamicObject && RubyGuards.isRubyString(firstValue_ = (DynamicObject)firstValue) && !RubyGuards.isRubyString(secondValue) && this.root.getCodeRange(firstValue_) == this.codeRange && this.root.getEncoding(firstValue_) == this.firstEncoding && this.root.getEncoding(secondValue) == this.secondEncoding) {
                    assert (this.firstEncoding != this.secondEncoding);
                    return true;
                }
                return false;
            }

            @Override
            public Encoding executeEncoding(Object firstValue, Object secondValue) {
                DynamicObject firstValue_;
                if (firstValue instanceof DynamicObject && RubyGuards.isRubyString(firstValue_ = (DynamicObject)firstValue) && !RubyGuards.isRubyString(secondValue) && this.root.getCodeRange(firstValue_) == this.codeRange && this.root.getEncoding(firstValue_) == this.firstEncoding && this.root.getEncoding(secondValue) == this.secondEncoding) {
                    assert (this.firstEncoding != this.secondEncoding);
                    return this.root.negotiateStringObjectCached(firstValue_, secondValue, this.firstEncoding, this.secondEncoding, this.codeRange, this.negotiatedEncoding);
                }
                return this.getNext().executeEncoding(firstValue, secondValue);
            }

            static BaseNode_ create(NegotiateCompatibleEncodingNodeGen root, Encoding firstEncoding, Encoding secondEncoding, CodeRange codeRange, Encoding negotiatedEncoding) {
                return new NegotiateStringObjectCachedNode_(root, firstEncoding, secondEncoding, codeRange, negotiatedEncoding);
            }
        }

        @GeneratedBy(methodName="negotiateStringStringUncached(DynamicObject, DynamicObject)", value=EncodingNodes.NegotiateCompatibleEncodingNode.class)
        private static final class NegotiateStringStringUncachedNode_
        extends BaseNode_ {
            NegotiateStringStringUncachedNode_(NegotiateCompatibleEncodingNodeGen root) {
                super(root, 4);
            }

            @Override
            public Encoding executeEncoding(Object firstValue, Object secondValue) {
                if (firstValue instanceof DynamicObject && secondValue instanceof DynamicObject) {
                    DynamicObject firstValue_ = (DynamicObject)firstValue;
                    DynamicObject secondValue_ = (DynamicObject)secondValue;
                    if (this.root.getEncoding(firstValue_) != this.root.getEncoding(secondValue_) && RubyGuards.isRubyString(firstValue_) && RubyGuards.isRubyString(secondValue_)) {
                        return this.root.negotiateStringStringUncached(firstValue_, secondValue_);
                    }
                }
                return this.getNext().executeEncoding(firstValue, secondValue);
            }

            static BaseNode_ create(NegotiateCompatibleEncodingNodeGen root) {
                return new NegotiateStringStringUncachedNode_(root);
            }
        }

        @GeneratedBy(methodName="negotiateStringStringCached(DynamicObject, DynamicObject, Encoding, Encoding, boolean, boolean, CodeRange, CodeRange, Encoding)", value=EncodingNodes.NegotiateCompatibleEncodingNode.class)
        private static final class NegotiateStringStringCachedNode_
        extends BaseNode_ {
            private final Encoding firstEncoding;
            private final Encoding secondEncoding;
            private final boolean isFirstEmpty;
            private final boolean isSecondEmpty;
            private final CodeRange firstCodeRange;
            private final CodeRange secondCodeRange;
            private final Encoding negotiatedEncoding;

            NegotiateStringStringCachedNode_(NegotiateCompatibleEncodingNodeGen root, Encoding firstEncoding, Encoding secondEncoding, boolean isFirstEmpty, boolean isSecondEmpty, CodeRange firstCodeRange, CodeRange secondCodeRange, Encoding negotiatedEncoding) {
                super(root, 3);
                this.firstEncoding = firstEncoding;
                this.secondEncoding = secondEncoding;
                this.isFirstEmpty = isFirstEmpty;
                this.isSecondEmpty = isSecondEmpty;
                this.firstCodeRange = firstCodeRange;
                this.secondCodeRange = secondCodeRange;
                this.negotiatedEncoding = negotiatedEncoding;
            }

            public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object firstValue, Object secondValue) {
                if (newNode.getClass() == NegotiateStringStringUncachedNode_.class) {
                    this.removeSame("Contained by negotiateStringStringUncached(DynamicObject, DynamicObject)");
                }
                return super.merge(newNode, frameValue, firstValue, secondValue);
            }

            public boolean isIdentical(SpecializationNode other, Frame frameValue, Object firstValue, Object secondValue) {
                if (firstValue instanceof DynamicObject && secondValue instanceof DynamicObject) {
                    DynamicObject firstValue_ = (DynamicObject)firstValue;
                    DynamicObject secondValue_ = (DynamicObject)secondValue;
                    if (RubyGuards.isRubyString(firstValue_) && RubyGuards.isRubyString(secondValue_) && this.root.isEmpty(firstValue_) == this.isFirstEmpty && this.root.isEmpty(secondValue_) == this.isSecondEmpty && this.root.getCodeRange(firstValue_) == this.firstCodeRange && this.root.getCodeRange(secondValue_) == this.secondCodeRange && this.root.getEncoding(firstValue_) == this.firstEncoding && this.root.getEncoding(secondValue_) == this.secondEncoding) {
                        assert (this.firstEncoding != this.secondEncoding);
                        return true;
                    }
                }
                return false;
            }

            @Override
            public Encoding executeEncoding(Object firstValue, Object secondValue) {
                if (firstValue instanceof DynamicObject && secondValue instanceof DynamicObject) {
                    DynamicObject firstValue_ = (DynamicObject)firstValue;
                    DynamicObject secondValue_ = (DynamicObject)secondValue;
                    if (RubyGuards.isRubyString(firstValue_) && RubyGuards.isRubyString(secondValue_) && this.root.isEmpty(firstValue_) == this.isFirstEmpty && this.root.isEmpty(secondValue_) == this.isSecondEmpty && this.root.getCodeRange(firstValue_) == this.firstCodeRange && this.root.getCodeRange(secondValue_) == this.secondCodeRange && this.root.getEncoding(firstValue_) == this.firstEncoding && this.root.getEncoding(secondValue_) == this.secondEncoding) {
                        assert (this.firstEncoding != this.secondEncoding);
                        return this.root.negotiateStringStringCached(firstValue_, secondValue_, this.firstEncoding, this.secondEncoding, this.isFirstEmpty, this.isSecondEmpty, this.firstCodeRange, this.secondCodeRange, this.negotiatedEncoding);
                    }
                }
                return this.getNext().executeEncoding(firstValue, secondValue);
            }

            static BaseNode_ create(NegotiateCompatibleEncodingNodeGen root, Encoding firstEncoding, Encoding secondEncoding, boolean isFirstEmpty, boolean isSecondEmpty, CodeRange firstCodeRange, CodeRange secondCodeRange, Encoding negotiatedEncoding) {
                return new NegotiateStringStringCachedNode_(root, firstEncoding, secondEncoding, isFirstEmpty, isSecondEmpty, firstCodeRange, secondCodeRange, negotiatedEncoding);
            }
        }

        @GeneratedBy(methodName="negotiateSameEncodingUncached(Object, Object)", value=EncodingNodes.NegotiateCompatibleEncodingNode.class)
        private static final class NegotiateSameEncodingUncachedNode_
        extends BaseNode_ {
            NegotiateSameEncodingUncachedNode_(NegotiateCompatibleEncodingNodeGen root) {
                super(root, 2);
            }

            @Override
            public Encoding executeEncoding(Object firstValue, Object secondValue) {
                if (this.root.getEncoding(firstValue) == this.root.getEncoding(secondValue)) {
                    return this.root.negotiateSameEncodingUncached(firstValue, secondValue);
                }
                return this.getNext().executeEncoding(firstValue, secondValue);
            }

            static BaseNode_ create(NegotiateCompatibleEncodingNodeGen root) {
                return new NegotiateSameEncodingUncachedNode_(root);
            }
        }

        @GeneratedBy(methodName="negotiateSameEncodingCached(DynamicObject, DynamicObject, Encoding)", value=EncodingNodes.NegotiateCompatibleEncodingNode.class)
        private static final class NegotiateSameEncodingCachedNode_
        extends BaseNode_ {
            private final Encoding cachedEncoding;

            NegotiateSameEncodingCachedNode_(NegotiateCompatibleEncodingNodeGen root, Encoding cachedEncoding) {
                super(root, 1);
                this.cachedEncoding = cachedEncoding;
            }

            public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object firstValue, Object secondValue) {
                if (newNode.getClass() == NegotiateSameEncodingUncachedNode_.class) {
                    this.removeSame("Contained by negotiateSameEncodingUncached(Object, Object)");
                }
                return super.merge(newNode, frameValue, firstValue, secondValue);
            }

            public boolean isIdentical(SpecializationNode other, Frame frameValue, Object firstValue, Object secondValue) {
                if (firstValue instanceof DynamicObject && secondValue instanceof DynamicObject) {
                    DynamicObject firstValue_ = (DynamicObject)firstValue;
                    DynamicObject secondValue_ = (DynamicObject)secondValue;
                    if (this.root.getEncoding(firstValue_) == this.root.getEncoding(secondValue_) && this.root.getEncoding(firstValue_) == this.cachedEncoding) {
                        return true;
                    }
                }
                return false;
            }

            @Override
            public Encoding executeEncoding(Object firstValue, Object secondValue) {
                if (firstValue instanceof DynamicObject && secondValue instanceof DynamicObject) {
                    DynamicObject firstValue_ = (DynamicObject)firstValue;
                    DynamicObject secondValue_ = (DynamicObject)secondValue;
                    if (this.root.getEncoding(firstValue_) == this.root.getEncoding(secondValue_) && this.root.getEncoding(firstValue_) == this.cachedEncoding) {
                        return this.root.negotiateSameEncodingCached(firstValue_, secondValue_, this.cachedEncoding);
                    }
                }
                return this.getNext().executeEncoding(firstValue, secondValue);
            }

            static BaseNode_ create(NegotiateCompatibleEncodingNodeGen root, Encoding cachedEncoding) {
                return new NegotiateSameEncodingCachedNode_(root, cachedEncoding);
            }
        }

        @GeneratedBy(value=EncodingNodes.NegotiateCompatibleEncodingNode.class)
        private static final class PolymorphicNode_
        extends BaseNode_ {
            PolymorphicNode_(NegotiateCompatibleEncodingNodeGen root) {
                super(root, 0);
            }

            public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object firstValue, Object secondValue) {
                return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, firstValue, secondValue));
            }

            @Override
            public Encoding executeEncoding(Object firstValue, Object secondValue) {
                return this.getNext().executeEncoding(firstValue, secondValue);
            }

            static BaseNode_ create(NegotiateCompatibleEncodingNodeGen root) {
                return new PolymorphicNode_(root);
            }
        }

        @GeneratedBy(value=EncodingNodes.NegotiateCompatibleEncodingNode.class)
        private static final class UninitializedNode_
        extends BaseNode_ {
            UninitializedNode_(NegotiateCompatibleEncodingNodeGen root) {
                super(root, Integer.MAX_VALUE);
            }

            @Override
            public Encoding executeEncoding(Object firstValue, Object secondValue) {
                return (Encoding)this.uninitialized(null, firstValue, secondValue);
            }

            static BaseNode_ create(NegotiateCompatibleEncodingNodeGen root) {
                return new UninitializedNode_(root);
            }
        }

        @GeneratedBy(value=EncodingNodes.NegotiateCompatibleEncodingNode.class)
        private static abstract class BaseNode_
        extends SpecializationNode {
            @CompilerDirectives.CompilationFinal
            protected NegotiateCompatibleEncodingNodeGen root;

            BaseNode_(NegotiateCompatibleEncodingNodeGen root, int index) {
                super(index);
                this.root = root;
            }

            protected final void setRoot(Node root) {
                this.root = (NegotiateCompatibleEncodingNodeGen)root;
            }

            protected final Node[] getSuppliedChildren() {
                return new Node[]{this.root.first_, this.root.second_};
            }

            public final Object acceptAndExecute(Frame frameValue, Object firstValue, Object secondValue) {
                return this.executeEncoding(firstValue, secondValue);
            }

            public abstract Encoding executeEncoding(Object var1, Object var2);

            public Object execute(VirtualFrame frameValue) {
                Object firstValue_ = this.root.first_.execute(frameValue);
                Object secondValue_ = this.root.second_.execute(frameValue);
                return this.executeEncoding(firstValue_, secondValue_);
            }

            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected final SpecializationNode createNext(Frame frameValue, Object firstValue, Object secondValue) {
                Encoding negotiatedEncoding8;
                Encoding secondEncoding8;
                Encoding firstEncoding8;
                BaseNode_ s;
                DynamicObject secondValue_;
                DynamicObject firstValue_;
                if (firstValue instanceof DynamicObject && secondValue instanceof DynamicObject) {
                    firstValue_ = (DynamicObject)firstValue;
                    secondValue_ = (DynamicObject)secondValue;
                    Encoding cachedEncoding1 = this.root.getEncoding(firstValue_);
                    if (this.root.getEncoding(firstValue_) == this.root.getEncoding(secondValue_) && this.root.getEncoding(firstValue_) == cachedEncoding1 && !this.root.excludeNegotiateSameEncodingCached_ && this.countSame(s = NegotiateSameEncodingCachedNode_.create(this.root, cachedEncoding1)) < this.root.getCacheLimit()) {
                        return s;
                    }
                }
                if (this.root.getEncoding(firstValue) == this.root.getEncoding(secondValue)) {
                    this.root.excludeNegotiateSameEncodingCached_ = true;
                    return NegotiateSameEncodingUncachedNode_.create(this.root);
                }
                if (firstValue instanceof DynamicObject) {
                    Encoding negotiatedEncoding5;
                    BaseNode_ s2;
                    firstValue_ = (DynamicObject)firstValue;
                    if (secondValue instanceof DynamicObject) {
                        Encoding negotiatedEncoding3;
                        BaseNode_ s3;
                        secondValue_ = (DynamicObject)secondValue;
                        Encoding firstEncoding3 = this.root.getEncoding(firstValue_);
                        Encoding secondEncoding3 = this.root.getEncoding(secondValue_);
                        boolean isFirstEmpty3 = this.root.isEmpty(firstValue_);
                        boolean isSecondEmpty3 = this.root.isEmpty(secondValue_);
                        CodeRange firstCodeRange3 = this.root.getCodeRange(firstValue_);
                        CodeRange secondCodeRange3 = this.root.getCodeRange(secondValue_);
                        if (firstEncoding3 != secondEncoding3 && RubyGuards.isRubyString(firstValue_) && RubyGuards.isRubyString(secondValue_) && this.root.isEmpty(firstValue_) == isFirstEmpty3 && this.root.isEmpty(secondValue_) == isSecondEmpty3 && this.root.getCodeRange(firstValue_) == firstCodeRange3 && this.root.getCodeRange(secondValue_) == secondCodeRange3 && this.root.getEncoding(firstValue_) == firstEncoding3 && this.root.getEncoding(secondValue_) == secondEncoding3 && !this.root.excludeNegotiateStringStringCached_ && this.countSame(s3 = NegotiateStringStringCachedNode_.create(this.root, firstEncoding3, secondEncoding3, isFirstEmpty3, isSecondEmpty3, firstCodeRange3, secondCodeRange3, negotiatedEncoding3 = this.root.negotiateStringStringUncached(firstValue_, secondValue_))) < this.root.getCacheLimit()) {
                            return s3;
                        }
                        if (this.root.getEncoding(firstValue_) != this.root.getEncoding(secondValue_) && RubyGuards.isRubyString(firstValue_) && RubyGuards.isRubyString(secondValue_)) {
                            this.root.excludeNegotiateStringStringCached_ = true;
                            return NegotiateStringStringUncachedNode_.create(this.root);
                        }
                    }
                    Encoding firstEncoding5 = this.root.getEncoding(firstValue_);
                    Encoding secondEncoding5 = this.root.getEncoding(secondValue);
                    CodeRange codeRange5 = this.root.getCodeRange(firstValue_);
                    if (RubyGuards.isRubyString(firstValue_) && !RubyGuards.isRubyString(secondValue) && this.root.getCodeRange(firstValue_) == codeRange5 && this.root.getEncoding(firstValue_) == firstEncoding5 && this.root.getEncoding(secondValue) == secondEncoding5 && firstEncoding5 != secondEncoding5 && !this.root.excludeNegotiateStringObjectCached_ && this.countSame(s2 = NegotiateStringObjectCachedNode_.create(this.root, firstEncoding5, secondEncoding5, codeRange5, negotiatedEncoding5 = this.root.negotiateStringObjectUncached(firstValue_, secondValue))) < this.root.getCacheLimit()) {
                        return s2;
                    }
                    if (this.root.getEncoding(firstValue_) != this.root.getEncoding(secondValue) && RubyGuards.isRubyString(firstValue_) && !RubyGuards.isRubyString(secondValue)) {
                        this.root.excludeNegotiateStringObjectCached_ = true;
                        return NegotiateStringObjectUncachedNode_.create(this.root);
                    }
                }
                if (secondValue instanceof DynamicObject) {
                    DynamicObject secondValue_2 = (DynamicObject)secondValue;
                    if (this.root.getEncoding(firstValue) != this.root.getEncoding(secondValue_2) && !RubyGuards.isRubyString(firstValue) && RubyGuards.isRubyString(secondValue_2)) {
                        return NegotiateObjectStringNode_.create(this.root);
                    }
                }
                if (!((firstEncoding8 = this.root.getEncoding(firstValue)) == (secondEncoding8 = this.root.getEncoding(secondValue)) || RubyGuards.isRubyString(firstValue) || RubyGuards.isRubyString(secondValue) || firstEncoding8 == null || secondEncoding8 == null || this.root.getEncoding(firstValue) != firstEncoding8 || this.root.getEncoding(secondValue) != secondEncoding8 || this.root.excludeNegotiateObjectObjectCached_ || this.countSame(s = NegotiateObjectObjectCachedNode_.create(this.root, firstEncoding8, secondEncoding8, negotiatedEncoding8 = EncodingNodes.NegotiateCompatibleEncodingNode.areCompatible(firstEncoding8, secondEncoding8))) >= this.root.getCacheLimit())) {
                    return s;
                }
                if (this.root.getEncoding(firstValue) != this.root.getEncoding(secondValue) && !RubyGuards.isRubyString(firstValue) && !RubyGuards.isRubyString(secondValue)) {
                    this.root.excludeNegotiateObjectObjectCached_ = true;
                    return NegotiateObjectObjectUncachedNode_.create(this.root);
                }
                return null;
            }

            protected final SpecializationNode createPolymorphic() {
                return PolymorphicNode_.create(this.root);
            }

            protected final BaseNode_ getNext() {
                return (BaseNode_)this.next;
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.GetRubyEncodingNode.class)
    public static final class GetRubyEncodingNodeGen
    extends EncodingNodes.GetRubyEncodingNode
    implements SpecializedNode {
        @Node.Child
        private RubyNode encoding_;
        @CompilerDirectives.CompilationFinal
        private boolean excludeGetRubyEncodingCached_;
        @Node.Child
        private BaseNode_ specialization_;

        private GetRubyEncodingNodeGen(RubyNode encoding) {
            this.encoding_ = encoding;
            this.specialization_ = UninitializedNode_.create(this);
        }

        public NodeCost getCost() {
            return this.specialization_.getNodeCost();
        }

        @Override
        public DynamicObject executeGetRubyEncoding(Encoding encodingValue) {
            return this.specialization_.executeDynamicObject1(encodingValue);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.specialization_.execute(frameValue);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.specialization_.executeVoid(frameValue);
        }

        public SpecializationNode getSpecializationNode() {
            return this.specialization_;
        }

        public Node deepCopy() {
            return SpecializationNode.updateRoot((Node)super.deepCopy());
        }

        public static EncodingNodes.GetRubyEncodingNode create(RubyNode encoding) {
            return new GetRubyEncodingNodeGen(encoding);
        }

        @GeneratedBy(methodName="getRubyEncodingUncached(Encoding)", value=EncodingNodes.GetRubyEncodingNode.class)
        private static final class GetRubyEncodingUncachedNode_
        extends BaseNode_ {
            GetRubyEncodingUncachedNode_(GetRubyEncodingNodeGen root) {
                super(root, 2);
            }

            @Override
            public DynamicObject executeDynamicObject1(Encoding encodingValue) {
                return this.root.getRubyEncodingUncached(encodingValue);
            }

            @Override
            public DynamicObject executeDynamicObject_(Object encodingValue) {
                if (encodingValue instanceof Encoding) {
                    Encoding encodingValue_ = (Encoding)encodingValue;
                    return this.root.getRubyEncodingUncached(encodingValue_);
                }
                return this.getNext().executeDynamicObject_(encodingValue);
            }

            static BaseNode_ create(GetRubyEncodingNodeGen root) {
                return new GetRubyEncodingUncachedNode_(root);
            }
        }

        @GeneratedBy(methodName="getRubyEncodingCached(Encoding, DynamicObject)", value=EncodingNodes.GetRubyEncodingNode.class)
        private static final class GetRubyEncodingCachedNode_
        extends BaseNode_ {
            private final DynamicObject cachedRubyEncoding;

            GetRubyEncodingCachedNode_(GetRubyEncodingNodeGen root, DynamicObject cachedRubyEncoding) {
                super(root, 1);
                this.cachedRubyEncoding = cachedRubyEncoding;
            }

            public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object encodingValue) {
                if (newNode.getClass() == GetRubyEncodingUncachedNode_.class) {
                    this.removeSame("Contained by getRubyEncodingUncached(Encoding)");
                }
                return super.merge(newNode, frameValue, encodingValue);
            }

            public boolean isIdentical(SpecializationNode other, Frame frameValue, Object encodingValue) {
                Encoding encodingValue_;
                return encodingValue instanceof Encoding && this.root.isSameEncoding(encodingValue_ = (Encoding)encodingValue, this.cachedRubyEncoding);
            }

            @Override
            public DynamicObject executeDynamicObject1(Encoding encodingValue) {
                if (this.root.isSameEncoding(encodingValue, this.cachedRubyEncoding)) {
                    return this.root.getRubyEncodingCached(encodingValue, this.cachedRubyEncoding);
                }
                return this.getNext().executeDynamicObject1(encodingValue);
            }

            @Override
            public DynamicObject executeDynamicObject_(Object encodingValue) {
                Encoding encodingValue_;
                if (encodingValue instanceof Encoding && this.root.isSameEncoding(encodingValue_ = (Encoding)encodingValue, this.cachedRubyEncoding)) {
                    return this.root.getRubyEncodingCached(encodingValue_, this.cachedRubyEncoding);
                }
                return this.getNext().executeDynamicObject_(encodingValue);
            }

            static BaseNode_ create(GetRubyEncodingNodeGen root, DynamicObject cachedRubyEncoding) {
                return new GetRubyEncodingCachedNode_(root, cachedRubyEncoding);
            }
        }

        @GeneratedBy(value=EncodingNodes.GetRubyEncodingNode.class)
        private static final class PolymorphicNode_
        extends BaseNode_ {
            PolymorphicNode_(GetRubyEncodingNodeGen root) {
                super(root, 0);
            }

            public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object encodingValue) {
                return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, encodingValue));
            }

            @Override
            public DynamicObject executeDynamicObject_(Object encodingValue) {
                return this.getNext().executeDynamicObject_(encodingValue);
            }

            static BaseNode_ create(GetRubyEncodingNodeGen root) {
                return new PolymorphicNode_(root);
            }
        }

        @GeneratedBy(value=EncodingNodes.GetRubyEncodingNode.class)
        private static final class UninitializedNode_
        extends BaseNode_ {
            UninitializedNode_(GetRubyEncodingNodeGen root) {
                super(root, Integer.MAX_VALUE);
            }

            @Override
            public DynamicObject executeDynamicObject_(Object encodingValue) {
                return (DynamicObject)this.uninitialized(null, encodingValue);
            }

            static BaseNode_ create(GetRubyEncodingNodeGen root) {
                return new UninitializedNode_(root);
            }
        }

        @GeneratedBy(value=EncodingNodes.GetRubyEncodingNode.class)
        private static abstract class BaseNode_
        extends SpecializationNode {
            @CompilerDirectives.CompilationFinal
            protected GetRubyEncodingNodeGen root;

            BaseNode_(GetRubyEncodingNodeGen root, int index) {
                super(index);
                this.root = root;
            }

            protected final void setRoot(Node root) {
                this.root = (GetRubyEncodingNodeGen)root;
            }

            protected final Node[] getSuppliedChildren() {
                return new Node[]{this.root.encoding_};
            }

            public final Object acceptAndExecute(Frame frameValue, Object encodingValue) {
                return this.executeDynamicObject_(encodingValue);
            }

            public abstract DynamicObject executeDynamicObject_(Object var1);

            public DynamicObject executeDynamicObject1(Encoding encodingValue) {
                return this.executeDynamicObject_(encodingValue);
            }

            public Object execute(VirtualFrame frameValue) {
                Object encodingValue_ = this.root.encoding_.execute(frameValue);
                return this.executeDynamicObject_(encodingValue_);
            }

            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            protected final SpecializationNode createNext(Frame frameValue, Object encodingValue) {
                if (encodingValue instanceof Encoding) {
                    BaseNode_ s;
                    Encoding encodingValue_ = (Encoding)encodingValue;
                    DynamicObject cachedRubyEncoding1 = this.root.getRubyEncodingUncached(encodingValue_);
                    if (this.root.isSameEncoding(encodingValue_, cachedRubyEncoding1) && !this.root.excludeGetRubyEncodingCached_ && this.countSame(s = GetRubyEncodingCachedNode_.create(this.root, cachedRubyEncoding1)) < this.root.getCacheLimit()) {
                        return s;
                    }
                    this.root.excludeGetRubyEncodingCached_ = true;
                    return GetRubyEncodingUncachedNode_.create(this.root);
                }
                return null;
            }

            protected final SpecializationNode createPolymorphic() {
                return PolymorphicNode_.create(this.root);
            }

            protected final BaseNode_ getNext() {
                return (BaseNode_)this.next;
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.AsciiCompatibleNode.class)
    public static final class AsciiCompatibleNodeFactory
    implements NodeFactory<EncodingNodes.AsciiCompatibleNode> {
        private static AsciiCompatibleNodeFactory asciiCompatibleNodeFactoryInstance;

        private AsciiCompatibleNodeFactory() {
        }

        public Class<EncodingNodes.AsciiCompatibleNode> getNodeClass() {
            return EncodingNodes.AsciiCompatibleNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public EncodingNodes.AsciiCompatibleNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return AsciiCompatibleNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.AsciiCompatibleNode> getInstance() {
            if (asciiCompatibleNodeFactoryInstance == null) {
                asciiCompatibleNodeFactoryInstance = new AsciiCompatibleNodeFactory();
            }
            return asciiCompatibleNodeFactoryInstance;
        }

        public static EncodingNodes.AsciiCompatibleNode create(RubyNode[] arguments) {
            return new AsciiCompatibleNodeGen(arguments);
        }

        @GeneratedBy(value=EncodingNodes.AsciiCompatibleNode.class)
        @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
        public static final class AsciiCompatibleNodeGen
        extends EncodingNodes.AsciiCompatibleNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeIsAsciiCompatibleCached_;
            @Node.Child
            private BaseNode_ specialization_;

            private AsciiCompatibleNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.specialization_.executeBoolean(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="isAsciiCompatibleUncached(DynamicObject)", value=EncodingNodes.AsciiCompatibleNode.class)
            private static final class IsAsciiCompatibleUncachedNode_
            extends BaseNode_ {
                IsAsciiCompatibleUncachedNode_(AsciiCompatibleNodeGen root) {
                    super(root, 2);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    return this.root.isAsciiCompatibleUncached(arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        return this.root.isAsciiCompatibleUncached(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(AsciiCompatibleNodeGen root) {
                    return new IsAsciiCompatibleUncachedNode_(root);
                }
            }

            @GeneratedBy(methodName="isAsciiCompatibleCached(DynamicObject, DynamicObject, boolean)", value=EncodingNodes.AsciiCompatibleNode.class)
            private static final class IsAsciiCompatibleCachedNode_
            extends BaseNode_ {
                private final DynamicObject cachedEncoding;
                private final boolean isAsciiCompatible;

                IsAsciiCompatibleCachedNode_(AsciiCompatibleNodeGen root, DynamicObject cachedEncoding, boolean isAsciiCompatible) {
                    super(root, 1);
                    this.cachedEncoding = cachedEncoding;
                    this.isAsciiCompatible = isAsciiCompatible;
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    if (newNode.getClass() == IsAsciiCompatibleUncachedNode_.class) {
                        this.removeSame("Contained by isAsciiCompatibleUncached(DynamicObject)");
                    }
                    return super.merge(newNode, frameValue, arguments0Value);
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    return arguments0Value instanceof DynamicObject && (arguments0Value_ = (DynamicObject)arguments0Value) == this.cachedEncoding;
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    if (arguments0Value_ == this.cachedEncoding) {
                        return this.root.isAsciiCompatibleCached(arguments0Value_, this.cachedEncoding, this.isAsciiCompatible);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && (arguments0Value_ = (DynamicObject)arguments0Value) == this.cachedEncoding) {
                        return this.root.isAsciiCompatibleCached(arguments0Value_, this.cachedEncoding, this.isAsciiCompatible);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(AsciiCompatibleNodeGen root, DynamicObject cachedEncoding, boolean isAsciiCompatible) {
                    return new IsAsciiCompatibleCachedNode_(root, cachedEncoding, isAsciiCompatible);
                }
            }

            @GeneratedBy(value=EncodingNodes.AsciiCompatibleNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(AsciiCompatibleNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(AsciiCompatibleNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=EncodingNodes.AsciiCompatibleNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(AsciiCompatibleNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Boolean)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(AsciiCompatibleNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=EncodingNodes.AsciiCompatibleNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected AsciiCompatibleNodeGen root;

                BaseNode_(AsciiCompatibleNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (AsciiCompatibleNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeBoolean_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract boolean executeBoolean_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeBoolean_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) {
                    return (Boolean)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        boolean isAsciiCompatible1;
                        BaseNode_ s;
                        DynamicObject arguments0Value_;
                        DynamicObject cachedEncoding1 = arguments0Value_ = (DynamicObject)arguments0Value;
                        if (arguments0Value_ == cachedEncoding1 && !this.root.excludeIsAsciiCompatibleCached_ && this.countSame(s = IsAsciiCompatibleCachedNode_.create(this.root, cachedEncoding1, isAsciiCompatible1 = EncodingNodes.AsciiCompatibleNode.isAsciiCompatible(cachedEncoding1))) < this.root.getCacheLimit()) {
                            return s;
                        }
                        this.root.excludeIsAsciiCompatibleCached_ = true;
                        return IsAsciiCompatibleUncachedNode_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }
}

