/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.cast.BooleanCastNode;
import org.jruby.truffle.core.cast.BooleanCastNodeGen;
import org.jruby.truffle.language.yield.YieldNode;

public abstract class YieldingCoreMethodNode
extends CoreMethodArrayArgumentsNode {
    @Node.Child
    private YieldNode dispatchNode = new YieldNode();
    @Node.Child
    private BooleanCastNode booleanCastNode;

    public Object yield(VirtualFrame frame, DynamicObject block, Object ... arguments) {
        return this.dispatchNode.dispatch(frame, block, arguments);
    }

    public Object yieldWithBlock(VirtualFrame frame, DynamicObject block, DynamicObject blockArgument, Object ... arguments) {
        return this.dispatchNode.dispatchWithBlock(frame, block, blockArgument, arguments);
    }

    public boolean yieldIsTruthy(VirtualFrame frame, DynamicObject block, Object ... arguments) {
        return this.booleanCast(this.yield(frame, block, arguments));
    }

    private boolean booleanCast(Object value) {
        if (this.booleanCastNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.booleanCastNode = (BooleanCastNode)this.insert(BooleanCastNodeGen.create(null));
        }
        return this.booleanCastNode.executeToBoolean(value);
    }
}

