/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.stdlib.psych;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Set;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jcodings.unicode.UnicodeEncoding;
import org.jruby.RubyEncoding;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.adapaters.InputStreamAdapter;
import org.jruby.truffle.core.cast.ToStrNode;
import org.jruby.truffle.core.cast.ToStrNodeGen;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.SnippetNode;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DoesRespondDispatchHeadNode;
import org.jruby.truffle.language.objects.ReadObjectFieldNode;
import org.jruby.truffle.language.objects.ReadObjectFieldNodeGen;
import org.jruby.truffle.language.objects.TaintNode;
import org.jruby.truffle.language.objects.TaintNodeGen;
import org.jruby.truffle.stdlib.psych.YAMLEncoding;
import org.jruby.truffle.util.BoundaryUtils;
import org.jruby.util.ByteList;
import org.jruby.util.io.EncodingUtils;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.DocumentEndEvent;
import org.yaml.snakeyaml.events.DocumentStartEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;
import org.yaml.snakeyaml.parser.Parser;
import org.yaml.snakeyaml.parser.ParserException;
import org.yaml.snakeyaml.parser.ParserImpl;
import org.yaml.snakeyaml.reader.ReaderException;
import org.yaml.snakeyaml.reader.StreamReader;
import org.yaml.snakeyaml.scanner.ScannerException;

@CoreClass(value="Psych::Parser")
public abstract class PsychParserNodes {

    @CoreMethod(names={"parse"}, required=1, optional=1)
    public static abstract class ParseNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ToStrNode toStrNode = ToStrNodeGen.create(this.getContext(), null, null);
        private static final int STYLE_PLAIN = 1;
        private static final int STYLE_SINGLE_QUOTED = 2;
        private static final int STYLE_DOUBLE_QUOTED = 3;
        private static final int STYLE_LITERAL = 4;
        private static final int STYLE_FOLDED = 5;
        private static final int STYLE_ANY = 0;
        private static final int STYLE_FLOW = 2;
        private static final int STYLE_NOT_FLOW = 1;

        public ParseNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract Object executeParse(VirtualFrame var1, DynamicObject var2, DynamicObject var3, Object var4);

        @Specialization
        public Object parse(VirtualFrame frame, DynamicObject parserObject, DynamicObject yaml, NotProvided path) {
            return this.executeParse(frame, parserObject, yaml, this.nil());
        }

        @Specialization
        public Object parse(VirtualFrame frame, DynamicObject parserObject, DynamicObject yaml, DynamicObject path, @Cached(value="new()") SnippetNode taintedNode, @Cached(value="create()") DoesRespondDispatchHeadNode respondToReadNode, @Cached(value="create()") DoesRespondDispatchHeadNode respondToPathNode, @Cached(value="createMethodCall()") CallDispatchHeadNode callPathNode, @Cached(value="createReadHandlerNode()") ReadObjectFieldNode readHandlerNode, @Cached(value="createMethodCall()") CallDispatchHeadNode callStartStreamNode, @Cached(value="createMethodCall()") CallDispatchHeadNode callStartDocumentNode, @Cached(value="createMethodCall()") CallDispatchHeadNode callEndDocumentNode, @Cached(value="createMethodCall()") CallDispatchHeadNode callAliasNode, @Cached(value="createMethodCall()") CallDispatchHeadNode callScalarNode, @Cached(value="createMethodCall()") CallDispatchHeadNode callStartSequenceNode, @Cached(value="createMethodCall()") CallDispatchHeadNode callEndSequenceNode, @Cached(value="createMethodCall()") CallDispatchHeadNode callStartMappingNode, @Cached(value="createMethodCall()") CallDispatchHeadNode callEndMappingNode, @Cached(value="createMethodCall()") CallDispatchHeadNode callEndStreamNode, @Cached(value="new()") SnippetNode raiseSyntaxErrorSnippetNode, @Cached(value="new()") SnippetNode tagPushNode, @Cached(value="createTaintNode()") TaintNode taintNode, @Cached(value="create()") BranchProfile errorProfile) {
            StreamReader reader;
            boolean tainted = (Boolean)taintedNode.execute(frame, "yaml.tainted? || yaml.is_a?(IO)", "yaml", yaml);
            if (!RubyGuards.isRubyString(yaml) && respondToReadNode.doesRespondTo(frame, "read", yaml)) {
                reader = this.newStreamReader(yaml);
            } else {
                ByteList byteList = StringOperations.getByteListReadOnly(this.toStrNode.executeToStr(frame, yaml));
                reader = this.newStringReader(byteList);
            }
            ParserImpl parser = this.newParser(reader);
            try {
                if (this.isNil(path) && respondToPathNode.doesRespondTo(frame, "path", yaml)) {
                    path = (DynamicObject)callPathNode.call(frame, yaml, "path", new Object[0]);
                }
                Object handler = readHandlerNode.execute(parserObject);
                while (true) {
                    Integer style;
                    Boolean implicit;
                    Object tag;
                    Object anchor;
                    Event event;
                    if (this.isEvent(event = this.getParserEvent((Parser)parser), Event.ID.StreamStart)) {
                        callStartStreamNode.call(frame, handler, "start_stream", YAMLEncoding.YAML_ANY_ENCODING.ordinal());
                        continue;
                    }
                    if (this.isEvent(event, Event.ID.DocumentStart)) {
                        DocumentStartEvent startEvent = (DocumentStartEvent)event;
                        DumperOptions.Version versionOptions = startEvent.getVersion();
                        Integer[] versionInts = versionOptions == null ? null : versionOptions.getArray();
                        DynamicObject versionArray = versionInts == null ? this.createArray(null, 0) : this.createArray(new Object[]{versionInts[0], versionInts[1]}, 2);
                        Map tagsMap = startEvent.getTags();
                        DynamicObject tags = this.createArray(null, 0);
                        if (tagsMap != null && this.size(tagsMap) > 0) {
                            for (Map.Entry entry : BoundaryUtils.BoundaryIterable.wrap(this.entrySet(tagsMap))) {
                                Object key = this.stringFor(this.getKey(entry), tainted, taintNode);
                                Object value = this.stringFor(this.getValue(entry), tainted, taintNode);
                                tagPushNode.execute(frame, "tags.push [key, value]", "tags", tags, "key", key, "value", value);
                            }
                        }
                        Boolean notExplicit = !startEvent.getExplicit();
                        callStartDocumentNode.call(frame, handler, "start_document", versionArray, tags, notExplicit);
                        continue;
                    }
                    if (this.isEvent(event, Event.ID.DocumentEnd)) {
                        DocumentEndEvent endEvent = (DocumentEndEvent)event;
                        Boolean notExplicit = !endEvent.getExplicit();
                        callEndDocumentNode.call(frame, handler, "end_document", notExplicit);
                        continue;
                    }
                    if (this.isEvent(event, Event.ID.Alias)) {
                        AliasEvent aliasEvent = (AliasEvent)event;
                        Object alias = this.stringOrNilFor(aliasEvent.getAnchor(), tainted, taintNode);
                        callAliasNode.call(frame, handler, "alias", alias);
                        continue;
                    }
                    if (this.isEvent(event, Event.ID.Scalar)) {
                        ScalarEvent scalarEvent = (ScalarEvent)event;
                        anchor = this.stringOrNilFor(scalarEvent.getAnchor(), tainted, taintNode);
                        tag = this.stringOrNilFor(scalarEvent.getTag(), tainted, taintNode);
                        Boolean plain_implicit = scalarEvent.getImplicit().canOmitTagInPlainScalar();
                        Boolean quoted_implicit = scalarEvent.getImplicit().canOmitTagInNonPlainScalar();
                        Integer style2 = ParseNode.translateStyle(scalarEvent.getStyle());
                        Object val = this.stringFor(scalarEvent.getValue(), tainted, taintNode);
                        callScalarNode.call(frame, handler, "scalar", val, anchor, tag, plain_implicit, quoted_implicit, style2);
                        continue;
                    }
                    if (this.isEvent(event, Event.ID.SequenceStart)) {
                        SequenceStartEvent sequenceStartEvent = (SequenceStartEvent)event;
                        anchor = this.stringOrNilFor(sequenceStartEvent.getAnchor(), tainted, taintNode);
                        tag = this.stringOrNilFor(sequenceStartEvent.getTag(), tainted, taintNode);
                        implicit = sequenceStartEvent.getImplicit();
                        style = ParseNode.translateFlowStyle(sequenceStartEvent.getFlowStyle());
                        callStartSequenceNode.call(frame, handler, "start_sequence", anchor, tag, implicit, style);
                        continue;
                    }
                    if (this.isEvent(event, Event.ID.SequenceEnd)) {
                        callEndSequenceNode.call(frame, handler, "end_sequence", new Object[0]);
                        continue;
                    }
                    if (this.isEvent(event, Event.ID.MappingStart)) {
                        MappingStartEvent mappingStartEvent = (MappingStartEvent)event;
                        anchor = this.stringOrNilFor(mappingStartEvent.getAnchor(), tainted, taintNode);
                        tag = this.stringOrNilFor(mappingStartEvent.getTag(), tainted, taintNode);
                        implicit = mappingStartEvent.getImplicit();
                        style = ParseNode.translateFlowStyle(mappingStartEvent.getFlowStyle());
                        callStartMappingNode.call(frame, handler, "start_mapping", anchor, tag, implicit, style);
                        continue;
                    }
                    if (this.isEvent(event, Event.ID.MappingEnd)) {
                        callEndMappingNode.call(frame, handler, "end_mapping", new Object[0]);
                        continue;
                    }
                    if (this.isEvent(event, Event.ID.StreamEnd)) break;
                }
                callEndStreamNode.call(frame, handler, "end_stream", new Object[0]);
            }
            catch (ParserException | ScannerException pe) {
                errorProfile.enter();
                Mark mark = pe.getProblemMark();
                raiseSyntaxErrorSnippetNode.execute(frame, "raise Psych::SyntaxError.new(file, line, col, offset, problem, context)", "file", path, "line", mark.getLine(), "col", mark.getColumn(), "offset", mark.getIndex(), "problem", pe.getProblem() == null ? this.nil() : this.createUTF8String(pe.getProblem()), "context", pe.getContext() == null ? this.nil() : this.createUTF8String(pe.getContext()));
            }
            catch (ReaderException re) {
                errorProfile.enter();
                raiseSyntaxErrorSnippetNode.execute(frame, "raise Psych::SyntaxError.new(file, line, col, offset, problem, context)", "file", path, "line", 0, "col", 0, "offset", re.getPosition(), "problem", re.getName() == null ? this.nil() : this.createUTF8String(re.getName()), "context", this.toString(re) == null ? this.nil() : this.createUTF8String(this.toString(re)));
            }
            catch (Throwable t) {
                errorProfile.enter();
                Helpers.throwException((Throwable)t);
                return parserObject;
            }
            return parserObject;
        }

        @CompilerDirectives.TruffleBoundary
        private StreamReader newStreamReader(DynamicObject yaml) {
            UTF8Encoding enc = UTF8Encoding.INSTANCE;
            Charset charset = enc.getCharset();
            return new StreamReader((Reader)new InputStreamReader((InputStream)new InputStreamAdapter(this.getContext(), yaml), charset));
        }

        @CompilerDirectives.TruffleBoundary
        private StreamReader newStringReader(ByteList byteList) {
            Encoding encoding = byteList.getEncoding();
            if (!(encoding instanceof UnicodeEncoding)) {
                byteList = EncodingUtils.strConvEnc((ThreadContext)this.getContext().getJRubyRuntime().getCurrentContext(), (ByteList)byteList, (Encoding)encoding, (Encoding)UTF8Encoding.INSTANCE);
                encoding = UTF8Encoding.INSTANCE;
            }
            return new StreamReader((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(byteList.getUnsafeBytes(), byteList.getBegin(), byteList.getRealSize()), encoding.getCharset()));
        }

        @CompilerDirectives.TruffleBoundary
        private ParserImpl newParser(StreamReader reader) {
            return new ParserImpl(reader);
        }

        @CompilerDirectives.TruffleBoundary
        private Event getParserEvent(Parser parser) {
            return parser.getEvent();
        }

        @CompilerDirectives.TruffleBoundary
        private boolean isEvent(Event event, Event.ID id) {
            return event.is(id);
        }

        private DynamicObject createUTF8String(String value) {
            return this.createString(StringOperations.encodeRope(value, (Encoding)UTF8Encoding.INSTANCE));
        }

        @CompilerDirectives.TruffleBoundary
        private int size(Map<String, String> tagsMap) {
            return tagsMap.size();
        }

        @CompilerDirectives.TruffleBoundary
        private Set<Map.Entry<String, String>> entrySet(Map<String, String> tagsMap) {
            return tagsMap.entrySet();
        }

        @CompilerDirectives.TruffleBoundary
        private String getKey(Map.Entry<String, String> tag) {
            return tag.getKey();
        }

        @CompilerDirectives.TruffleBoundary
        private String getValue(Map.Entry<String, String> tag) {
            return tag.getValue();
        }

        @CompilerDirectives.TruffleBoundary
        private String toString(ReaderException re) {
            return re.toString();
        }

        protected ReadObjectFieldNode createReadHandlerNode() {
            return ReadObjectFieldNodeGen.create("@handler", this.nil());
        }

        protected TaintNode createTaintNode() {
            return TaintNodeGen.create(this.getContext(), null, null);
        }

        private static int translateStyle(Character style) {
            switch (style.charValue()) {
                case '\u0000': {
                    return 1;
                }
                case '\'': {
                    return 2;
                }
                case '\"': {
                    return 3;
                }
                case '|': {
                    return 4;
                }
                case '>': {
                    return 5;
                }
            }
            return 0;
        }

        private static int translateFlowStyle(Boolean flowStyle) {
            if (flowStyle == null) {
                return 0;
            }
            if (flowStyle.booleanValue()) {
                return 2;
            }
            return 1;
        }

        @CompilerDirectives.TruffleBoundary
        private Object stringOrNilFor(String value, boolean tainted, TaintNode taintNode) {
            if (value == null) {
                return this.nil();
            }
            return this.stringFor(value, tainted, taintNode);
        }

        @CompilerDirectives.TruffleBoundary
        private Object stringFor(String value, boolean tainted, TaintNode taintNode) {
            Encoding encoding = this.getContext().getJRubyRuntime().getDefaultInternalEncoding();
            if (encoding == null) {
                encoding = UTF8Encoding.INSTANCE;
            }
            Charset charset = RubyEncoding.UTF8;
            if (encoding.getCharset() != null) {
                charset = encoding.getCharset();
            }
            DynamicObject string = this.createString(value.getBytes(charset), encoding);
            if (tainted) {
                taintNode.executeTaint(string);
            }
            return string;
        }
    }
}

