/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.ast;

import java.util.List;
import org.jruby.truffle.parser.ast.BlockAcceptingParseNode;
import org.jruby.truffle.parser.ast.IArgumentNode;
import org.jruby.truffle.parser.ast.NodeType;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.types.INameNode;
import org.jruby.truffle.parser.ast.visitor.NodeVisitor;
import org.jruby.truffle.parser.lexer.ISourcePosition;

public class CallParseNode
extends ParseNode
implements INameNode,
IArgumentNode,
BlockAcceptingParseNode {
    private final ParseNode receiverNode;
    private ParseNode argsNode;
    protected ParseNode iterNode;
    private String name;
    private final boolean isLazy;

    public CallParseNode(ISourcePosition position, ParseNode receiverNode, String name, ParseNode argsNode, ParseNode iterNode) {
        this(position, receiverNode, name, argsNode, iterNode, false);
    }

    public CallParseNode(ISourcePosition position, ParseNode receiverNode, String name, ParseNode argsNode, ParseNode iterNode, boolean isLazy) {
        super(position, receiverNode.containsVariableAssignment() || argsNode != null && argsNode.containsVariableAssignment() || iterNode != null && iterNode.containsVariableAssignment());
        assert (receiverNode != null) : "receiverNode is not null";
        this.name = name;
        this.receiverNode = receiverNode;
        this.argsNode = argsNode;
        this.iterNode = iterNode;
        this.isLazy = isLazy;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.CALLNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitCallNode(this);
    }

    @Override
    public ParseNode getIterNode() {
        return this.iterNode;
    }

    @Override
    public ParseNode setIterNode(ParseNode iterNode) {
        this.iterNode = iterNode;
        return this;
    }

    @Override
    public ParseNode getArgsNode() {
        return this.argsNode;
    }

    @Override
    public ParseNode setArgsNode(ParseNode argsNode) {
        this.argsNode = argsNode;
        return argsNode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ParseNode getReceiverNode() {
        return this.receiverNode;
    }

    public boolean isLazy() {
        return this.isLazy;
    }

    @Override
    public List<ParseNode> childNodes() {
        return ParseNode.createList(this.receiverNode, this.argsNode, this.iterNode);
    }

    @Override
    protected String toStringInternal() {
        return this.isLazy ? "lazy" : null;
    }
}

