/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.HiddenKey;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.locals.ReadFrameSlotNode;
import org.jruby.truffle.language.locals.ReadFrameSlotNodeGen;

public class SelfNode
extends RubyNode {
    public static final HiddenKey SELF_IDENTIFIER = new HiddenKey("(self)");
    private final FrameSlot selfSlot;
    @Node.Child
    private ReadFrameSlotNode readSelfSlotNode;

    public SelfNode(FrameDescriptor frameDescriptor) {
        this.selfSlot = frameDescriptor.findOrAddFrameSlot((Object)SELF_IDENTIFIER);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        if (this.readSelfSlotNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.readSelfSlotNode = (ReadFrameSlotNode)this.insert(ReadFrameSlotNodeGen.create(this.selfSlot));
        }
        return this.readSelfSlotNode.executeRead((Frame)frame);
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        return this.coreStrings().SELF.createInstance();
    }
}

