/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import org.jruby.truffle.language.RubyTypes;

@GeneratedBy(value=RubyTypes.class)
public final class RubyTypesGen
extends RubyTypes {
    @Deprecated
    public static final RubyTypesGen RUBYTYPES = new RubyTypesGen();

    protected RubyTypesGen() {
    }

    public static long asImplicitLong(Object value) {
        if (value instanceof Short) {
            return RubyTypesGen.promoteToLong((Short)value);
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return RubyTypesGen.promoteToLong((Integer)value);
        }
        if (value instanceof Byte) {
            return RubyTypesGen.promoteToLong((Byte)value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new IllegalArgumentException("Illegal type ");
    }

    public static boolean isImplicitLong(Object value) {
        return value instanceof Short || value instanceof Long || value instanceof Integer || value instanceof Byte;
    }

    public static long asImplicitLong(Object value, Class<?> typeHint) {
        if (typeHint == Short.TYPE) {
            return RubyTypesGen.promoteToLong((Short)value);
        }
        if (typeHint == Long.TYPE) {
            return (Long)value;
        }
        if (typeHint == Integer.TYPE) {
            return RubyTypesGen.promoteToLong((Integer)value);
        }
        if (typeHint == Byte.TYPE) {
            return RubyTypesGen.promoteToLong((Byte)value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new IllegalArgumentException("Illegal type ");
    }

    public static long expectImplicitLong(Object value, Class<?> typeHint) throws UnexpectedResultException {
        if (typeHint == Short.TYPE && value instanceof Short) {
            return RubyTypesGen.promoteToLong((Short)value);
        }
        if (typeHint == Long.TYPE && value instanceof Long) {
            return (Long)value;
        }
        if (typeHint == Integer.TYPE && value instanceof Integer) {
            return RubyTypesGen.promoteToLong((Integer)value);
        }
        if (typeHint == Byte.TYPE && value instanceof Byte) {
            return RubyTypesGen.promoteToLong((Byte)value);
        }
        throw new UnexpectedResultException(value);
    }

    public static boolean isImplicitLong(Object value, Class<?> typeHint) {
        return typeHint == Short.TYPE && value instanceof Short || typeHint == Long.TYPE && value instanceof Long || typeHint == Integer.TYPE && value instanceof Integer || typeHint == Byte.TYPE && value instanceof Byte;
    }

    public static Class<?> getImplicitLongClass(Object value) {
        if (value instanceof Short) {
            return Short.TYPE;
        }
        if (value instanceof Long) {
            return Long.TYPE;
        }
        if (value instanceof Integer) {
            return Integer.TYPE;
        }
        if (value instanceof Byte) {
            return Byte.TYPE;
        }
        if (value == null) {
            return Object.class;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new IllegalArgumentException("Illegal type ");
    }

    public static int asImplicitInteger(Object value) {
        if (value instanceof Short) {
            return RubyTypesGen.promoteToInt((Short)value);
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Byte) {
            return RubyTypesGen.promoteToInt((Byte)value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new IllegalArgumentException("Illegal type ");
    }

    public static boolean isImplicitInteger(Object value) {
        return value instanceof Short || value instanceof Integer || value instanceof Byte;
    }

    public static int asImplicitInteger(Object value, Class<?> typeHint) {
        if (typeHint == Short.TYPE) {
            return RubyTypesGen.promoteToInt((Short)value);
        }
        if (typeHint == Integer.TYPE) {
            return (Integer)value;
        }
        if (typeHint == Byte.TYPE) {
            return RubyTypesGen.promoteToInt((Byte)value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new IllegalArgumentException("Illegal type ");
    }

    public static int expectImplicitInteger(Object value, Class<?> typeHint) throws UnexpectedResultException {
        if (typeHint == Short.TYPE && value instanceof Short) {
            return RubyTypesGen.promoteToInt((Short)value);
        }
        if (typeHint == Integer.TYPE && value instanceof Integer) {
            return (Integer)value;
        }
        if (typeHint == Byte.TYPE && value instanceof Byte) {
            return RubyTypesGen.promoteToInt((Byte)value);
        }
        throw new UnexpectedResultException(value);
    }

    public static boolean isImplicitInteger(Object value, Class<?> typeHint) {
        return typeHint == Short.TYPE && value instanceof Short || typeHint == Integer.TYPE && value instanceof Integer || typeHint == Byte.TYPE && value instanceof Byte;
    }

    public static Class<?> getImplicitIntegerClass(Object value) {
        if (value instanceof Short) {
            return Short.TYPE;
        }
        if (value instanceof Integer) {
            return Integer.TYPE;
        }
        if (value instanceof Byte) {
            return Byte.TYPE;
        }
        if (value == null) {
            return Object.class;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new IllegalArgumentException("Illegal type ");
    }

    public static double asImplicitDouble(Object value) {
        if (value instanceof Float) {
            return RubyTypesGen.promoteToDouble(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new IllegalArgumentException("Illegal type ");
    }

    public static boolean isImplicitDouble(Object value) {
        return value instanceof Float || value instanceof Double;
    }

    public static double asImplicitDouble(Object value, Class<?> typeHint) {
        if (typeHint == Float.TYPE) {
            return RubyTypesGen.promoteToDouble(((Float)value).floatValue());
        }
        if (typeHint == Double.TYPE) {
            return (Double)value;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new IllegalArgumentException("Illegal type ");
    }

    public static double expectImplicitDouble(Object value, Class<?> typeHint) throws UnexpectedResultException {
        if (typeHint == Float.TYPE && value instanceof Float) {
            return RubyTypesGen.promoteToDouble(((Float)value).floatValue());
        }
        if (typeHint == Double.TYPE && value instanceof Double) {
            return (Double)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static boolean isImplicitDouble(Object value, Class<?> typeHint) {
        return typeHint == Float.TYPE && value instanceof Float || typeHint == Double.TYPE && value instanceof Double;
    }

    public static Class<?> getImplicitDoubleClass(Object value) {
        if (value instanceof Float) {
            return Float.TYPE;
        }
        if (value instanceof Double) {
            return Double.TYPE;
        }
        if (value == null) {
            return Object.class;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new IllegalArgumentException("Illegal type ");
    }
}

