/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.RubyLanguage;
import org.jruby.truffle.language.RubyRootNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.backtrace.InternalRootNode;
import org.jruby.truffle.language.methods.DeclarationContext;
import org.jruby.truffle.language.methods.InternalMethod;
import org.jruby.truffle.parser.ParserContext;
import org.jruby.truffle.parser.TranslatorDriver;

public class LazyRubyRootNode
extends RootNode
implements InternalRootNode {
    private final Source source;
    private final String[] argumentNames;
    @CompilerDirectives.CompilationFinal
    private RubyContext cachedContext;
    @CompilerDirectives.CompilationFinal
    private DynamicObject mainObject;
    @CompilerDirectives.CompilationFinal
    private InternalMethod method;
    @Node.Child
    private Node findContextNode;
    @Node.Child
    private DirectCallNode callNode;

    public LazyRubyRootNode(SourceSection sourceSection, FrameDescriptor frameDescriptor, Source source, String[] argumentNames) {
        super(RubyLanguage.class, sourceSection, frameDescriptor);
        this.source = source;
        this.argumentNames = argumentNames;
        this.findContextNode = RubyLanguage.INSTANCE.unprotectedCreateFindContextNode();
    }

    public Object execute(VirtualFrame frame) {
        RubyContext context = RubyLanguage.INSTANCE.unprotectedFindContext(this.findContextNode);
        if (this.cachedContext == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.cachedContext = context;
        }
        if (this.callNode == null || context != this.cachedContext) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            TranslatorDriver translator = new TranslatorDriver(context);
            RubyRootNode rootNode = translator.parse(context, this.source, (Encoding)UTF8Encoding.INSTANCE, ParserContext.TOP_LEVEL, this.argumentNames, null, null, true, null);
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)rootNode);
            this.callNode = (DirectCallNode)this.insert((Node)Truffle.getRuntime().createDirectCallNode((CallTarget)callTarget));
            this.callNode.forceInlining();
            this.mainObject = context.getCoreLibrary().getMainObject();
            this.method = new InternalMethod(context, rootNode.getSharedMethodInfo(), rootNode.getSharedMethodInfo().getName(), context.getCoreLibrary().getObjectClass(), Visibility.PUBLIC, (CallTarget)callTarget);
        }
        Object[] arguments = RubyArguments.pack(null, null, this.method, DeclarationContext.TOP_LEVEL, null, this.mainObject, null, frame.getArguments());
        return this.callNode.call(frame, arguments);
    }
}

