/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.cast.NameToJavaStringNode;
import org.jruby.truffle.core.string.StringCachingGuards;
import org.jruby.truffle.interop.ForeignReadStringCachedHelperNode;
import org.jruby.truffle.interop.ForeignReadStringCachedHelperNodeGen;
import org.jruby.truffle.interop.IsStringLikeNode;
import org.jruby.truffle.language.RubyNode;

@ImportStatic(value={StringCachingGuards.class})
@NodeChildren(value={@NodeChild(value="receiver"), @NodeChild(value="name")})
abstract class ForeignReadStringCachingHelperNode
extends RubyNode {
    @Node.Child
    private IsStringLikeNode isStringLikeNode;

    public ForeignReadStringCachingHelperNode(RubyContext context) {
        super(context);
    }

    public abstract Object executeStringCachingHelper(VirtualFrame var1, DynamicObject var2, Object var3);

    @Specialization(guards={"isStringLike(name)"})
    public Object cacheStringLikeAndForward(VirtualFrame frame, DynamicObject receiver, Object name, @Cached(value="create()") NameToJavaStringNode toJavaStringNode, @Cached(value="createNextHelper()") ForeignReadStringCachedHelperNode nextHelper) {
        String nameAsJavaString = toJavaStringNode.executeToJavaString(frame, name);
        boolean isIVar = this.isIVar(nameAsJavaString);
        return nextHelper.executeStringCachedHelper(frame, receiver, name, nameAsJavaString, isIVar);
    }

    @Specialization(guards={"isRubyString(receiver)", "inRange(receiver, index)"})
    public int indexString(DynamicObject receiver, int index) {
        return Layouts.STRING.getRope(receiver).get(index);
    }

    @Specialization(guards={"isRubyString(receiver)", "!inRange(receiver, index)"})
    public int indexStringOutOfRange(DynamicObject receiver, int index) {
        return 0;
    }

    @Specialization(guards={"!isRubyString(receiver)", "!isStringLike(name)"})
    public Object indexObject(VirtualFrame frame, DynamicObject receiver, Object name, @Cached(value="createNextHelper()") ForeignReadStringCachedHelperNode nextHelper) {
        return nextHelper.executeStringCachedHelper(frame, receiver, name, null, false);
    }

    protected boolean inRange(DynamicObject string, int index) {
        return index >= 0 && index < Layouts.STRING.getRope(string).byteLength();
    }

    protected boolean isStringLike(Object value) {
        if (this.isStringLikeNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.isStringLikeNode = (IsStringLikeNode)this.insert(IsStringLikeNode.create());
        }
        return this.isStringLikeNode.executeIsStringLike(value);
    }

    protected boolean isIVar(String name) {
        return !name.isEmpty() && name.charAt(0) == '@';
    }

    protected ForeignReadStringCachedHelperNode createNextHelper() {
        return ForeignReadStringCachedHelperNodeGen.create(null, null, null, null);
    }
}

