/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.hash;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.dsl.internal.SuppressFBWarnings;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CoreMethodNode;
import org.jruby.truffle.core.array.ArrayBuilderNode;
import org.jruby.truffle.core.hash.HashGuards;
import org.jruby.truffle.core.hash.HashNodes;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.SnippetNode;

@GeneratedBy(value=HashNodes.class)
public final class HashNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(AllocateNodeFactory.getInstance(), ConstructNodeFactory.getInstance(), GetIndexNodeFactory.getInstance(), GetOrUndefinedNodeFactory.getInstance(), SetIndexNodeFactory.getInstance(), ClearNodeFactory.getInstance(), CompareByIdentityNodeFactory.getInstance(), IsCompareByIdentityNodeFactory.getInstance(), DefaultProcNodeFactory.getInstance(), DeleteNodeFactory.getInstance(), EachNodeFactory.getInstance(), EmptyNodeFactory.getInstance(), InitializeNodeFactory.getInstance(), InitializeCopyNodeFactory.getInstance(), MapNodeFactory.getInstance(), MergeNodeFactory.getInstance(), SetDefaultNodeFactory.getInstance(), ShiftNodeFactory.getInstance(), SizeNodeFactory.getInstance(), RehashNodeFactory.getInstance(), InternalDefaultValueNodeFactory.getInstance(), DefaultValueNodeFactory.getInstance(), SetDefaultValueNodeFactory.getInstance(), SetDefaultProcNodeFactory.getInstance());
    }

    @GeneratedBy(value=HashNodes.SetDefaultProcNode.class)
    public static final class SetDefaultProcNodeFactory
    implements NodeFactory<HashNodes.SetDefaultProcNode> {
        private static SetDefaultProcNodeFactory setDefaultProcNodeFactoryInstance;

        private SetDefaultProcNodeFactory() {
        }

        public Class<HashNodes.SetDefaultProcNode> getNodeClass() {
            return HashNodes.SetDefaultProcNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode.class, RubyNode.class));
        }

        public HashNodes.SetDefaultProcNode createNode(Object ... arguments) {
            if (arguments.length == 2 && (arguments[0] == null || arguments[0] instanceof RubyNode) && (arguments[1] == null || arguments[1] instanceof RubyNode)) {
                return SetDefaultProcNodeFactory.create((RubyNode)((Object)arguments[0]), (RubyNode)((Object)arguments[1]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.SetDefaultProcNode> getInstance() {
            if (setDefaultProcNodeFactoryInstance == null) {
                setDefaultProcNodeFactoryInstance = new SetDefaultProcNodeFactory();
            }
            return setDefaultProcNodeFactoryInstance;
        }

        public static HashNodes.SetDefaultProcNode create(RubyNode self, RubyNode defaultProc) {
            return new SetDefaultProcNodeGen(self, defaultProc);
        }

        @GeneratedBy(value=HashNodes.SetDefaultProcNode.class)
        public static final class SetDefaultProcNodeGen
        extends HashNodes.SetDefaultProcNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode self_;
            @Node.Child
            private RubyNode defaultProc_;
            @Node.Child
            private BaseNode_ specialization_;

            private SetDefaultProcNodeGen(RubyNode self, RubyNode defaultProc) {
                this.self_ = self;
                this.defaultProc_ = defaultProc;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="setDefaultProc(DynamicObject, Object)", value=HashNodes.SetDefaultProcNode.class)
            private static final class SetDefaultProc1Node_
            extends BaseNode_ {
                SetDefaultProc1Node_(SetDefaultProcNodeGen root) {
                    super(root, 2);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object selfValue, Object defaultProcValue) {
                    if (selfValue instanceof DynamicObject) {
                        DynamicObject selfValue_ = (DynamicObject)selfValue;
                        if (this.root.isNil(defaultProcValue)) {
                            return this.root.setDefaultProc(selfValue_, defaultProcValue);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, selfValue, defaultProcValue);
                }

                static BaseNode_ create(SetDefaultProcNodeGen root) {
                    return new SetDefaultProc1Node_(root);
                }
            }

            @GeneratedBy(methodName="setDefaultProc(DynamicObject, DynamicObject)", value=HashNodes.SetDefaultProcNode.class)
            private static final class SetDefaultProc0Node_
            extends BaseNode_ {
                SetDefaultProc0Node_(SetDefaultProcNodeGen root) {
                    super(root, 1);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object selfValue, Object defaultProcValue) {
                    if (selfValue instanceof DynamicObject && defaultProcValue instanceof DynamicObject) {
                        DynamicObject selfValue_ = (DynamicObject)selfValue;
                        DynamicObject defaultProcValue_ = (DynamicObject)defaultProcValue;
                        if (RubyGuards.isRubyProc(defaultProcValue_)) {
                            return this.root.setDefaultProc(selfValue_, defaultProcValue_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, selfValue, defaultProcValue);
                }

                static BaseNode_ create(SetDefaultProcNodeGen root) {
                    return new SetDefaultProc0Node_(root);
                }
            }

            @GeneratedBy(value=HashNodes.SetDefaultProcNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SetDefaultProcNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object selfValue, Object defaultProcValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, selfValue, defaultProcValue));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object selfValue, Object defaultProcValue) {
                    return this.getNext().executeDynamicObject_(frameValue, selfValue, defaultProcValue);
                }

                static BaseNode_ create(SetDefaultProcNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.SetDefaultProcNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SetDefaultProcNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object selfValue, Object defaultProcValue) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, selfValue, defaultProcValue);
                }

                static BaseNode_ create(SetDefaultProcNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.SetDefaultProcNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected SetDefaultProcNodeGen root;

                BaseNode_(SetDefaultProcNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (SetDefaultProcNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.self_, this.root.defaultProc_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object selfValue, Object defaultProcValue) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, selfValue, defaultProcValue);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object selfValue_ = this.root.self_.execute(frameValue);
                    Object defaultProcValue_ = this.root.defaultProc_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, selfValue_, defaultProcValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object selfValue, Object defaultProcValue) {
                    if (selfValue instanceof DynamicObject) {
                        DynamicObject defaultProcValue_;
                        if (defaultProcValue instanceof DynamicObject && RubyGuards.isRubyProc(defaultProcValue_ = (DynamicObject)defaultProcValue)) {
                            return SetDefaultProc0Node_.create(this.root);
                        }
                        if (this.root.isNil(defaultProcValue)) {
                            return SetDefaultProc1Node_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.SetDefaultValueNode.class)
    public static final class SetDefaultValueNodeFactory
    implements NodeFactory<HashNodes.SetDefaultValueNode> {
        private static SetDefaultValueNodeFactory setDefaultValueNodeFactoryInstance;

        private SetDefaultValueNodeFactory() {
        }

        public Class<HashNodes.SetDefaultValueNode> getNodeClass() {
            return HashNodes.SetDefaultValueNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode.class, RubyNode.class));
        }

        public HashNodes.SetDefaultValueNode createNode(Object ... arguments) {
            if (arguments.length == 2 && (arguments[0] == null || arguments[0] instanceof RubyNode) && (arguments[1] == null || arguments[1] instanceof RubyNode)) {
                return SetDefaultValueNodeFactory.create((RubyNode)((Object)arguments[0]), (RubyNode)((Object)arguments[1]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.SetDefaultValueNode> getInstance() {
            if (setDefaultValueNodeFactoryInstance == null) {
                setDefaultValueNodeFactoryInstance = new SetDefaultValueNodeFactory();
            }
            return setDefaultValueNodeFactoryInstance;
        }

        public static HashNodes.SetDefaultValueNode create(RubyNode self, RubyNode defaultValue) {
            return new SetDefaultValueNodeGen(self, defaultValue);
        }

        @GeneratedBy(value=HashNodes.SetDefaultValueNode.class)
        public static final class SetDefaultValueNodeGen
        extends HashNodes.SetDefaultValueNode {
            @Node.Child
            private RubyNode self_;
            @Node.Child
            private RubyNode defaultValue_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private SetDefaultValueNodeGen(RubyNode self, RubyNode defaultValue) {
                this.self_ = self;
                this.defaultValue_ = defaultValue;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject selfValue_;
                try {
                    selfValue_ = this.self_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object defaultValueValue = this.defaultValue_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), defaultValueValue);
                }
                Object defaultValueValue_ = this.defaultValue_.execute(frameValue);
                return this.setDefaultValue(selfValue_, defaultValueValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object selfValue, Object defaultValueValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.self_, this.defaultValue_}, new Object[]{selfValue, defaultValueValue});
            }
        }
    }

    @GeneratedBy(value=HashNodes.DefaultValueNode.class)
    public static final class DefaultValueNodeFactory
    implements NodeFactory<HashNodes.DefaultValueNode> {
        private static DefaultValueNodeFactory defaultValueNodeFactoryInstance;

        private DefaultValueNodeFactory() {
        }

        public Class<HashNodes.DefaultValueNode> getNodeClass() {
            return HashNodes.DefaultValueNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode.class));
        }

        public HashNodes.DefaultValueNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode)) {
                return DefaultValueNodeFactory.create((RubyNode)((Object)arguments[0]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.DefaultValueNode> getInstance() {
            if (defaultValueNodeFactoryInstance == null) {
                defaultValueNodeFactoryInstance = new DefaultValueNodeFactory();
            }
            return defaultValueNodeFactoryInstance;
        }

        public static HashNodes.DefaultValueNode create(RubyNode self) {
            return new DefaultValueNodeGen(self);
        }

        @GeneratedBy(value=HashNodes.DefaultValueNode.class)
        public static final class DefaultValueNodeGen
        extends HashNodes.DefaultValueNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode self_;
            @Node.Child
            private BaseNode_ specialization_;

            private DefaultValueNodeGen(RubyNode self) {
                this.self_ = self;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object executeDefaultValue(DynamicObject selfValue) {
                return this.specialization_.execute1(selfValue);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute0(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="defaultValue(DynamicObject, ConditionProfile)", value=HashNodes.DefaultValueNode.class)
            private static final class DefaultValueNode_
            extends BaseNode_ {
                private final ConditionProfile nullValueProfile;

                DefaultValueNode_(DefaultValueNodeGen root, ConditionProfile nullValueProfile) {
                    super(root, 1);
                    this.nullValueProfile = nullValueProfile;
                }

                @Override
                public Object execute1(DynamicObject selfValue) {
                    return this.root.defaultValue(selfValue, this.nullValueProfile);
                }

                @Override
                public Object execute_(Object selfValue) {
                    if (selfValue instanceof DynamicObject) {
                        DynamicObject selfValue_ = (DynamicObject)selfValue;
                        return this.root.defaultValue(selfValue_, this.nullValueProfile);
                    }
                    return this.getNext().execute_(selfValue);
                }

                static BaseNode_ create(DefaultValueNodeGen root, ConditionProfile nullValueProfile) {
                    return new DefaultValueNode_(root, nullValueProfile);
                }
            }

            @GeneratedBy(value=HashNodes.DefaultValueNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(DefaultValueNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(Object selfValue) {
                    return this.uninitialized(null, selfValue);
                }

                static BaseNode_ create(DefaultValueNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.DefaultValueNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected DefaultValueNodeGen root;

                BaseNode_(DefaultValueNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (DefaultValueNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.self_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object selfValue) {
                    return this.execute_(selfValue);
                }

                public abstract Object execute_(Object var1);

                public Object execute1(DynamicObject selfValue) {
                    return this.execute_(selfValue);
                }

                public Object execute0(VirtualFrame frameValue) {
                    Object selfValue_ = this.root.self_.execute(frameValue);
                    return this.execute_(selfValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute0(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object selfValue) {
                    if (selfValue instanceof DynamicObject) {
                        ConditionProfile nullValueProfile1 = ConditionProfile.createBinaryProfile();
                        return DefaultValueNode_.create(this.root, nullValueProfile1);
                    }
                    return null;
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.InternalDefaultValueNode.class)
    public static final class InternalDefaultValueNodeFactory
    implements NodeFactory<HashNodes.InternalDefaultValueNode> {
        private static InternalDefaultValueNodeFactory internalDefaultValueNodeFactoryInstance;

        private InternalDefaultValueNodeFactory() {
        }

        public Class<HashNodes.InternalDefaultValueNode> getNodeClass() {
            return HashNodes.InternalDefaultValueNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyContext.class, SourceSection.class, RubyNode[].class));
        }

        public HashNodes.InternalDefaultValueNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InternalDefaultValueNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.InternalDefaultValueNode> getInstance() {
            if (internalDefaultValueNodeFactoryInstance == null) {
                internalDefaultValueNodeFactoryInstance = new InternalDefaultValueNodeFactory();
            }
            return internalDefaultValueNodeFactoryInstance;
        }

        public static HashNodes.InternalDefaultValueNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new InternalDefaultValueNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=HashNodes.InternalDefaultValueNode.class)
        public static final class InternalDefaultValueNodeGen
        extends HashNodes.InternalDefaultValueNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private InternalDefaultValueNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.internalDefaultValue(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=HashNodes.RehashNode.class)
    public static final class RehashNodeFactory
    implements NodeFactory<HashNodes.RehashNode> {
        private static RehashNodeFactory rehashNodeFactoryInstance;

        private RehashNodeFactory() {
        }

        public Class<HashNodes.RehashNode> getNodeClass() {
            return HashNodes.RehashNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyContext.class, SourceSection.class, RubyNode[].class));
        }

        public HashNodes.RehashNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RehashNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.RehashNode> getInstance() {
            if (rehashNodeFactoryInstance == null) {
                rehashNodeFactoryInstance = new RehashNodeFactory();
            }
            return rehashNodeFactoryInstance;
        }

        public static HashNodes.RehashNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new RehashNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=HashNodes.RehashNode.class)
        public static final class RehashNodeGen
        extends HashNodes.RehashNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private RehashNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="rehashBuckets(DynamicObject)", value=HashNodes.RehashNode.class)
            private static final class RehashBucketsNode_
            extends BaseNode_ {
                RehashBucketsNode_(RehashNodeGen root) {
                    super(root, 3);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && HashGuards.isBucketHash(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.rehashBuckets(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(RehashNodeGen root) {
                    return new RehashBucketsNode_(root);
                }
            }

            @GeneratedBy(methodName="rehashPackedArray(VirtualFrame, DynamicObject)", value=HashNodes.RehashNode.class)
            private static final class RehashPackedArrayNode_
            extends BaseNode_ {
                RehashPackedArrayNode_(RehashNodeGen root) {
                    super(root, 2);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && HashGuards.isPackedHash(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.rehashPackedArray(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(RehashNodeGen root) {
                    return new RehashPackedArrayNode_(root);
                }
            }

            @GeneratedBy(methodName="rehashNull(DynamicObject)", value=HashNodes.RehashNode.class)
            private static final class RehashNullNode_
            extends BaseNode_ {
                RehashNullNode_(RehashNodeGen root) {
                    super(root, 1);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && HashGuards.isNullHash(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.rehashNull(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(RehashNodeGen root) {
                    return new RehashNullNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.RehashNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(RehashNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(RehashNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.RehashNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(RehashNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(RehashNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.RehashNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected RehashNodeGen root;

                BaseNode_(RehashNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (RehashNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (HashGuards.isNullHash(arguments0Value_)) {
                            return RehashNullNode_.create(this.root);
                        }
                        if (HashGuards.isPackedHash(arguments0Value_)) {
                            return RehashPackedArrayNode_.create(this.root);
                        }
                        if (HashGuards.isBucketHash(arguments0Value_)) {
                            return RehashBucketsNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.SizeNode.class)
    public static final class SizeNodeFactory
    implements NodeFactory<HashNodes.SizeNode> {
        private static SizeNodeFactory sizeNodeFactoryInstance;

        private SizeNodeFactory() {
        }

        public Class<HashNodes.SizeNode> getNodeClass() {
            return HashNodes.SizeNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public HashNodes.SizeNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return SizeNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.SizeNode> getInstance() {
            if (sizeNodeFactoryInstance == null) {
                sizeNodeFactoryInstance = new SizeNodeFactory();
            }
            return sizeNodeFactoryInstance;
        }

        public static HashNodes.SizeNode create(RubyNode[] arguments) {
            return new SizeNodeGen(arguments);
        }

        @GeneratedBy(value=HashNodes.SizeNode.class)
        public static final class SizeNodeGen
        extends HashNodes.SizeNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private SizeNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                return this.specialization_.executeInt(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="sizePackedArray(DynamicObject)", value=HashNodes.SizeNode.class)
            private static final class SizePackedArrayNode_
            extends BaseNode_ {
                SizePackedArrayNode_(SizeNodeGen root) {
                    super(root, 2);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, ex.getResult());
                    }
                    if (!HashGuards.isNullHash(arguments0Value_)) {
                        return this.root.sizePackedArray(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && !HashGuards.isNullHash(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.sizePackedArray(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SizeNodeGen root) {
                    return new SizePackedArrayNode_(root);
                }
            }

            @GeneratedBy(methodName="sizeNull(DynamicObject)", value=HashNodes.SizeNode.class)
            private static final class SizeNullNode_
            extends BaseNode_ {
                SizeNullNode_(SizeNodeGen root) {
                    super(root, 1);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, ex.getResult());
                    }
                    if (HashGuards.isNullHash(arguments0Value_)) {
                        return this.root.sizeNull(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && HashGuards.isNullHash(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.sizeNull(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SizeNodeGen root) {
                    return new SizeNullNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.SizeNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SizeNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.getNext().executeInt_(frameValue, arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SizeNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.SizeNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SizeNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Integer)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(SizeNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.SizeNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected SizeNodeGen root;

                BaseNode_(SizeNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (SizeNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeInt_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract int executeInt_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeInt_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) {
                    return (Integer)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (HashGuards.isNullHash(arguments0Value_)) {
                            return SizeNullNode_.create(this.root);
                        }
                        return SizePackedArrayNode_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.ShiftNode.class)
    public static final class ShiftNodeFactory
    implements NodeFactory<HashNodes.ShiftNode> {
        private static ShiftNodeFactory shiftNodeFactoryInstance;

        private ShiftNodeFactory() {
        }

        public Class<HashNodes.ShiftNode> getNodeClass() {
            return HashNodes.ShiftNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public HashNodes.ShiftNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ShiftNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.ShiftNode> getInstance() {
            if (shiftNodeFactoryInstance == null) {
                shiftNodeFactoryInstance = new ShiftNodeFactory();
            }
            return shiftNodeFactoryInstance;
        }

        public static HashNodes.ShiftNode create(RubyNode[] arguments) {
            return new ShiftNodeGen(arguments);
        }

        @GeneratedBy(value=HashNodes.ShiftNode.class)
        public static final class ShiftNodeGen
        extends HashNodes.ShiftNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private ShiftNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="shiftBuckets(DynamicObject)", value=HashNodes.ShiftNode.class)
            private static final class ShiftBucketsNode_
            extends BaseNode_ {
                ShiftBucketsNode_(ShiftNodeGen root) {
                    super(root, 5);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && !HashGuards.isEmptyHash(arguments0Value_ = (DynamicObject)arguments0Value) && HashGuards.isBucketHash(arguments0Value_)) {
                        return this.root.shiftBuckets(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new ShiftBucketsNode_(root);
                }
            }

            @GeneratedBy(methodName="shiftPackedArray(DynamicObject)", value=HashNodes.ShiftNode.class)
            private static final class ShiftPackedArrayNode_
            extends BaseNode_ {
                ShiftPackedArrayNode_(ShiftNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && !HashGuards.isEmptyHash(arguments0Value_ = (DynamicObject)arguments0Value) && HashGuards.isPackedHash(arguments0Value_)) {
                        return this.root.shiftPackedArray(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new ShiftPackedArrayNode_(root);
                }
            }

            @GeneratedBy(methodName="shiftEmptyDefaultProc(VirtualFrame, DynamicObject)", value=HashNodes.ShiftNode.class)
            private static final class ShiftEmptyDefaultProcNode_
            extends BaseNode_ {
                ShiftEmptyDefaultProcNode_(ShiftNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && HashGuards.isEmptyHash(arguments0Value_ = (DynamicObject)arguments0Value) && !HashGuards.hasDefaultValue(arguments0Value_) && HashGuards.hasDefaultBlock(arguments0Value_)) {
                        return this.root.shiftEmptyDefaultProc(frameValue, arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new ShiftEmptyDefaultProcNode_(root);
                }
            }

            @GeneratedBy(methodName="shiftEmpyDefaultValue(DynamicObject)", value=HashNodes.ShiftNode.class)
            private static final class ShiftEmpyDefaultValueNode_
            extends BaseNode_ {
                ShiftEmpyDefaultValueNode_(ShiftNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && HashGuards.isEmptyHash(arguments0Value_ = (DynamicObject)arguments0Value) && HashGuards.hasDefaultValue(arguments0Value_) && !HashGuards.hasDefaultBlock(arguments0Value_)) {
                        return this.root.shiftEmpyDefaultValue(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new ShiftEmpyDefaultValueNode_(root);
                }
            }

            @GeneratedBy(methodName="shiftEmpty(DynamicObject)", value=HashNodes.ShiftNode.class)
            private static final class ShiftEmptyNode_
            extends BaseNode_ {
                ShiftEmptyNode_(ShiftNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && HashGuards.isEmptyHash(arguments0Value_ = (DynamicObject)arguments0Value) && !HashGuards.hasDefaultValue(arguments0Value_) && !HashGuards.hasDefaultBlock(arguments0Value_)) {
                        return this.root.shiftEmpty(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new ShiftEmptyNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.ShiftNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ShiftNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.ShiftNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ShiftNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ShiftNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.ShiftNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ShiftNodeGen root;

                BaseNode_(ShiftNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (ShiftNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (HashGuards.isEmptyHash(arguments0Value_) && !HashGuards.hasDefaultValue(arguments0Value_) && !HashGuards.hasDefaultBlock(arguments0Value_)) {
                            return ShiftEmptyNode_.create(this.root);
                        }
                        if (HashGuards.isEmptyHash(arguments0Value_) && HashGuards.hasDefaultValue(arguments0Value_) && !HashGuards.hasDefaultBlock(arguments0Value_)) {
                            return ShiftEmpyDefaultValueNode_.create(this.root);
                        }
                        if (HashGuards.isEmptyHash(arguments0Value_) && !HashGuards.hasDefaultValue(arguments0Value_) && HashGuards.hasDefaultBlock(arguments0Value_)) {
                            return ShiftEmptyDefaultProcNode_.create(this.root);
                        }
                        if (!HashGuards.isEmptyHash(arguments0Value_) && HashGuards.isPackedHash(arguments0Value_)) {
                            return ShiftPackedArrayNode_.create(this.root);
                        }
                        if (!HashGuards.isEmptyHash(arguments0Value_) && HashGuards.isBucketHash(arguments0Value_)) {
                            return ShiftBucketsNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.SetDefaultNode.class)
    public static final class SetDefaultNodeFactory
    implements NodeFactory<HashNodes.SetDefaultNode> {
        private static SetDefaultNodeFactory setDefaultNodeFactoryInstance;

        private SetDefaultNodeFactory() {
        }

        public Class<HashNodes.SetDefaultNode> getNodeClass() {
            return HashNodes.SetDefaultNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public HashNodes.SetDefaultNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return SetDefaultNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.SetDefaultNode> getInstance() {
            if (setDefaultNodeFactoryInstance == null) {
                setDefaultNodeFactoryInstance = new SetDefaultNodeFactory();
            }
            return setDefaultNodeFactoryInstance;
        }

        public static HashNodes.SetDefaultNode create(RubyNode[] arguments) {
            return new SetDefaultNodeGen(arguments);
        }

        @GeneratedBy(value=HashNodes.SetDefaultNode.class)
        public static final class SetDefaultNodeGen
        extends HashNodes.SetDefaultNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private SetDefaultNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                return this.setDefault(arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
        }
    }

    @GeneratedBy(value=HashNodes.MergeNode.class)
    public static final class MergeNodeFactory
    implements NodeFactory<HashNodes.MergeNode> {
        private static MergeNodeFactory mergeNodeFactoryInstance;

        private MergeNodeFactory() {
        }

        public Class<HashNodes.MergeNode> getNodeClass() {
            return HashNodes.MergeNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyContext.class, SourceSection.class, RubyNode[].class));
        }

        public HashNodes.MergeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MergeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.MergeNode> getInstance() {
            if (mergeNodeFactoryInstance == null) {
                mergeNodeFactoryInstance = new MergeNodeFactory();
            }
            return mergeNodeFactoryInstance;
        }

        public static HashNodes.MergeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new MergeNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=HashNodes.MergeNode.class)
        public static final class MergeNodeGen
        extends HashNodes.MergeNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private BaseNode_ specialization_;

            private MergeNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="merge(VirtualFrame, DynamicObject, Object, Object)", value=HashNodes.MergeNode.class)
            private static final class Merge1Node_
            extends BaseNode_ {
                Merge1Node_(MergeNodeGen root) {
                    super(root, 11);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (!RubyGuards.isRubyHash(arguments1Value)) {
                            return this.root.merge(frameValue, arguments0Value_, arguments1Value, arguments2Value);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(MergeNodeGen root) {
                    return new Merge1Node_(root);
                }
            }

            @GeneratedBy(methodName="merge(VirtualFrame, DynamicObject, DynamicObject, DynamicObject)", value=HashNodes.MergeNode.class)
            private static final class Merge0Node_
            extends BaseNode_ {
                Merge0Node_(MergeNodeGen root) {
                    super(root, 10);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        DynamicObject arguments2Value_ = (DynamicObject)arguments2Value;
                        if (RubyGuards.isRubyHash(arguments1Value_) && !HashGuards.isCompareByIdentity(arguments0Value_)) {
                            return this.root.merge(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(MergeNodeGen root) {
                    return new Merge0Node_(root);
                }
            }

            @GeneratedBy(methodName="mergeBucketsPacked(VirtualFrame, DynamicObject, DynamicObject, NotProvided)", value=HashNodes.MergeNode.class)
            private static final class MergeBucketsPackedNode_
            extends BaseNode_ {
                MergeBucketsPackedNode_(MergeNodeGen root) {
                    super(root, 9);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (HashGuards.isBucketHash(arguments0Value_) && !HashGuards.isEmptyHash(arguments0Value_) && RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isPackedHash(arguments1Value_) && !HashGuards.isEmptyHash(arguments1Value_)) {
                            return this.root.mergeBucketsPacked(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(MergeNodeGen root) {
                    return new MergeBucketsPackedNode_(root);
                }
            }

            @GeneratedBy(methodName="mergePackedBuckets(VirtualFrame, DynamicObject, DynamicObject, NotProvided)", value=HashNodes.MergeNode.class)
            private static final class MergePackedBucketsNode_
            extends BaseNode_ {
                MergePackedBucketsNode_(MergeNodeGen root) {
                    super(root, 8);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (HashGuards.isPackedHash(arguments0Value_) && !HashGuards.isEmptyHash(arguments0Value_) && RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isBucketHash(arguments1Value_) && !HashGuards.isEmptyHash(arguments1Value_)) {
                            return this.root.mergePackedBuckets(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(MergeNodeGen root) {
                    return new MergePackedBucketsNode_(root);
                }
            }

            @GeneratedBy(methodName="mergeBucketsBuckets(VirtualFrame, DynamicObject, DynamicObject, NotProvided)", value=HashNodes.MergeNode.class)
            private static final class MergeBucketsBucketsNode_
            extends BaseNode_ {
                MergeBucketsBucketsNode_(MergeNodeGen root) {
                    super(root, 7);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (HashGuards.isBucketHash(arguments0Value_) && !HashGuards.isEmptyHash(arguments0Value_) && RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isBucketHash(arguments1Value_) && !HashGuards.isEmptyHash(arguments1Value_)) {
                            return this.root.mergeBucketsBuckets(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(MergeNodeGen root) {
                    return new MergeBucketsBucketsNode_(root);
                }
            }

            @GeneratedBy(methodName="mergePackedPacked(VirtualFrame, DynamicObject, DynamicObject, NotProvided)", value=HashNodes.MergeNode.class)
            private static final class MergePackedPackedNode_
            extends BaseNode_ {
                MergePackedPackedNode_(MergeNodeGen root) {
                    super(root, 6);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (HashGuards.isPackedHash(arguments0Value_) && !HashGuards.isEmptyHash(arguments0Value_) && RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isPackedHash(arguments1Value_) && !HashGuards.isEmptyHash(arguments1Value_) && !HashGuards.isCompareByIdentity(arguments0Value_)) {
                            return this.root.mergePackedPacked(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(MergeNodeGen root) {
                    return new MergePackedPackedNode_(root);
                }
            }

            @GeneratedBy(methodName="mergeBucketsEmpty(DynamicObject, DynamicObject, NotProvided)", value=HashNodes.MergeNode.class)
            private static final class MergeBucketsEmptyNode_
            extends BaseNode_ {
                MergeBucketsEmptyNode_(MergeNodeGen root) {
                    super(root, 5);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (HashGuards.isBucketHash(arguments0Value_) && RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isEmptyHash(arguments1Value_)) {
                            return this.root.mergeBucketsEmpty(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(MergeNodeGen root) {
                    return new MergeBucketsEmptyNode_(root);
                }
            }

            @GeneratedBy(methodName="mergeEmptyBuckets(DynamicObject, DynamicObject, NotProvided)", value=HashNodes.MergeNode.class)
            private static final class MergeEmptyBucketsNode_
            extends BaseNode_ {
                MergeEmptyBucketsNode_(MergeNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (HashGuards.isEmptyHash(arguments0Value_) && RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isBucketHash(arguments1Value_)) {
                            return this.root.mergeEmptyBuckets(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(MergeNodeGen root) {
                    return new MergeEmptyBucketsNode_(root);
                }
            }

            @GeneratedBy(methodName="mergePackedEmpty(DynamicObject, DynamicObject, NotProvided)", value=HashNodes.MergeNode.class)
            private static final class MergePackedEmptyNode_
            extends BaseNode_ {
                MergePackedEmptyNode_(MergeNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (HashGuards.isPackedHash(arguments0Value_) && RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isEmptyHash(arguments1Value_)) {
                            return this.root.mergePackedEmpty(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(MergeNodeGen root) {
                    return new MergePackedEmptyNode_(root);
                }
            }

            @GeneratedBy(methodName="mergeEmptyPacked(DynamicObject, DynamicObject, NotProvided)", value=HashNodes.MergeNode.class)
            private static final class MergeEmptyPackedNode_
            extends BaseNode_ {
                MergeEmptyPackedNode_(MergeNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (HashGuards.isEmptyHash(arguments0Value_) && RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isPackedHash(arguments1Value_)) {
                            return this.root.mergeEmptyPacked(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(MergeNodeGen root) {
                    return new MergeEmptyPackedNode_(root);
                }
            }

            @GeneratedBy(methodName="mergeEmptyEmpty(DynamicObject, DynamicObject, NotProvided)", value=HashNodes.MergeNode.class)
            private static final class MergeEmptyEmptyNode_
            extends BaseNode_ {
                MergeEmptyEmptyNode_(MergeNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (HashGuards.isNullHash(arguments0Value_) && RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isNullHash(arguments1Value_)) {
                            return this.root.mergeEmptyEmpty(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(MergeNodeGen root) {
                    return new MergeEmptyEmptyNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.MergeNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(MergeNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(MergeNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.MergeNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(MergeNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(MergeNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.MergeNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected MergeNodeGen root;

                BaseNode_(MergeNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (MergeNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (arguments1Value instanceof DynamicObject) {
                            DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                            if (arguments2Value instanceof NotProvided) {
                                if (HashGuards.isNullHash(arguments0Value_) && RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isNullHash(arguments1Value_)) {
                                    return MergeEmptyEmptyNode_.create(this.root);
                                }
                                if (HashGuards.isEmptyHash(arguments0Value_) && RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isPackedHash(arguments1Value_)) {
                                    return MergeEmptyPackedNode_.create(this.root);
                                }
                                if (HashGuards.isPackedHash(arguments0Value_) && RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isEmptyHash(arguments1Value_)) {
                                    return MergePackedEmptyNode_.create(this.root);
                                }
                                if (HashGuards.isEmptyHash(arguments0Value_) && RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isBucketHash(arguments1Value_)) {
                                    return MergeEmptyBucketsNode_.create(this.root);
                                }
                                if (HashGuards.isBucketHash(arguments0Value_) && RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isEmptyHash(arguments1Value_)) {
                                    return MergeBucketsEmptyNode_.create(this.root);
                                }
                                if (HashGuards.isPackedHash(arguments0Value_) && !HashGuards.isEmptyHash(arguments0Value_) && RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isPackedHash(arguments1Value_) && !HashGuards.isEmptyHash(arguments1Value_) && !HashGuards.isCompareByIdentity(arguments0Value_)) {
                                    return MergePackedPackedNode_.create(this.root);
                                }
                                if (HashGuards.isBucketHash(arguments0Value_) && !HashGuards.isEmptyHash(arguments0Value_) && RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isBucketHash(arguments1Value_) && !HashGuards.isEmptyHash(arguments1Value_)) {
                                    return MergeBucketsBucketsNode_.create(this.root);
                                }
                                if (HashGuards.isPackedHash(arguments0Value_) && !HashGuards.isEmptyHash(arguments0Value_) && RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isBucketHash(arguments1Value_) && !HashGuards.isEmptyHash(arguments1Value_)) {
                                    return MergePackedBucketsNode_.create(this.root);
                                }
                                if (HashGuards.isBucketHash(arguments0Value_) && !HashGuards.isEmptyHash(arguments0Value_) && RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isPackedHash(arguments1Value_) && !HashGuards.isEmptyHash(arguments1Value_)) {
                                    return MergeBucketsPackedNode_.create(this.root);
                                }
                            }
                            if (arguments2Value instanceof DynamicObject && RubyGuards.isRubyHash(arguments1Value_) && !HashGuards.isCompareByIdentity(arguments0Value_)) {
                                return Merge0Node_.create(this.root);
                            }
                        }
                        if (!RubyGuards.isRubyHash(arguments1Value)) {
                            return Merge1Node_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.MapNode.class)
    public static final class MapNodeFactory
    implements NodeFactory<HashNodes.MapNode> {
        private static MapNodeFactory mapNodeFactoryInstance;

        private MapNodeFactory() {
        }

        public Class<HashNodes.MapNode> getNodeClass() {
            return HashNodes.MapNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public HashNodes.MapNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return MapNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.MapNode> getInstance() {
            if (mapNodeFactoryInstance == null) {
                mapNodeFactoryInstance = new MapNodeFactory();
            }
            return mapNodeFactoryInstance;
        }

        public static HashNodes.MapNode create(RubyNode[] arguments) {
            return new MapNodeGen(arguments);
        }

        @GeneratedBy(value=HashNodes.MapNode.class)
        public static final class MapNodeGen
        extends HashNodes.MapNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private MapNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="mapBuckets(VirtualFrame, DynamicObject, DynamicObject, ArrayBuilderNode)", value=HashNodes.MapNode.class)
            private static final class MapBucketsNode_
            extends BaseNode_ {
                @Node.Child
                private ArrayBuilderNode arrayBuilderNode;

                MapBucketsNode_(MapNodeGen root, ArrayBuilderNode arrayBuilderNode) {
                    super(root, 3);
                    this.arrayBuilderNode = arrayBuilderNode;
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (HashGuards.isBucketHash(arguments0Value_)) {
                            return this.root.mapBuckets(frameValue, arguments0Value_, arguments1Value_, this.arrayBuilderNode);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MapNodeGen root, ArrayBuilderNode arrayBuilderNode) {
                    return new MapBucketsNode_(root, arrayBuilderNode);
                }
            }

            @GeneratedBy(methodName="mapPackedArray(VirtualFrame, DynamicObject, DynamicObject, ArrayBuilderNode)", value=HashNodes.MapNode.class)
            private static final class MapPackedArrayNode_
            extends BaseNode_ {
                @Node.Child
                private ArrayBuilderNode arrayBuilderNode;

                MapPackedArrayNode_(MapNodeGen root, ArrayBuilderNode arrayBuilderNode) {
                    super(root, 2);
                    this.arrayBuilderNode = arrayBuilderNode;
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (HashGuards.isPackedHash(arguments0Value_)) {
                            return this.root.mapPackedArray(frameValue, arguments0Value_, arguments1Value_, this.arrayBuilderNode);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MapNodeGen root, ArrayBuilderNode arrayBuilderNode) {
                    return new MapPackedArrayNode_(root, arrayBuilderNode);
                }
            }

            @GeneratedBy(methodName="mapNull(VirtualFrame, DynamicObject, DynamicObject)", value=HashNodes.MapNode.class)
            private static final class MapNullNode_
            extends BaseNode_ {
                MapNullNode_(MapNodeGen root) {
                    super(root, 1);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (HashGuards.isNullHash(arguments0Value_)) {
                            return this.root.mapNull(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MapNodeGen root) {
                    return new MapNullNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.MapNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(MapNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MapNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.MapNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(MapNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(MapNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.MapNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected MapNodeGen root;

                BaseNode_(MapNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (MapNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (HashGuards.isNullHash(arguments0Value_)) {
                            return MapNullNode_.create(this.root);
                        }
                        if (HashGuards.isPackedHash(arguments0Value_)) {
                            ArrayBuilderNode arrayBuilderNode2 = ArrayBuilderNode.create(this.root.getContext());
                            return MapPackedArrayNode_.create(this.root, arrayBuilderNode2);
                        }
                        if (HashGuards.isBucketHash(arguments0Value_)) {
                            ArrayBuilderNode arrayBuilderNode3 = ArrayBuilderNode.create(this.root.getContext());
                            return MapBucketsNode_.create(this.root, arrayBuilderNode3);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.InitializeCopyNode.class)
    public static final class InitializeCopyNodeFactory
    implements NodeFactory<HashNodes.InitializeCopyNode> {
        private static InitializeCopyNodeFactory initializeCopyNodeFactoryInstance;

        private InitializeCopyNodeFactory() {
        }

        public Class<HashNodes.InitializeCopyNode> getNodeClass() {
            return HashNodes.InitializeCopyNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public HashNodes.InitializeCopyNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return InitializeCopyNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.InitializeCopyNode> getInstance() {
            if (initializeCopyNodeFactoryInstance == null) {
                initializeCopyNodeFactoryInstance = new InitializeCopyNodeFactory();
            }
            return initializeCopyNodeFactoryInstance;
        }

        public static HashNodes.InitializeCopyNode create(RubyNode[] arguments) {
            return new InitializeCopyNodeGen(arguments);
        }

        @GeneratedBy(value=HashNodes.InitializeCopyNode.class)
        public static final class InitializeCopyNodeGen
        extends HashNodes.InitializeCopyNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private InitializeCopyNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="replaceBuckets(VirtualFrame, DynamicObject, Object, SnippetNode)", value=HashNodes.InitializeCopyNode.class)
            private static final class ReplaceBuckets1Node_
            extends BaseNode_ {
                @Node.Child
                private SnippetNode snippetNode;

                ReplaceBuckets1Node_(InitializeCopyNodeGen root, SnippetNode snippetNode) {
                    super(root, 4);
                    this.snippetNode = snippetNode;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (!RubyGuards.isRubyHash(arguments1Value)) {
                            return this.root.replaceBuckets(frameValue, arguments0Value_, arguments1Value, this.snippetNode);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InitializeCopyNodeGen root, SnippetNode snippetNode) {
                    return new ReplaceBuckets1Node_(root, snippetNode);
                }
            }

            @GeneratedBy(methodName="replaceBuckets(DynamicObject, DynamicObject)", value=HashNodes.InitializeCopyNode.class)
            private static final class ReplaceBuckets0Node_
            extends BaseNode_ {
                ReplaceBuckets0Node_(InitializeCopyNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isBucketHash(arguments1Value_)) {
                            return this.root.replaceBuckets(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InitializeCopyNodeGen root) {
                    return new ReplaceBuckets0Node_(root);
                }
            }

            @GeneratedBy(methodName="replacePackedArray(DynamicObject, DynamicObject)", value=HashNodes.InitializeCopyNode.class)
            private static final class ReplacePackedArrayNode_
            extends BaseNode_ {
                ReplacePackedArrayNode_(InitializeCopyNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isPackedHash(arguments1Value_)) {
                            return this.root.replacePackedArray(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InitializeCopyNodeGen root) {
                    return new ReplacePackedArrayNode_(root);
                }
            }

            @GeneratedBy(methodName="replaceNull(DynamicObject, DynamicObject)", value=HashNodes.InitializeCopyNode.class)
            private static final class ReplaceNullNode_
            extends BaseNode_ {
                ReplaceNullNode_(InitializeCopyNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isNullHash(arguments1Value_)) {
                            return this.root.replaceNull(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InitializeCopyNodeGen root) {
                    return new ReplaceNullNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.InitializeCopyNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(InitializeCopyNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InitializeCopyNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.InitializeCopyNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(InitializeCopyNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InitializeCopyNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.InitializeCopyNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected InitializeCopyNodeGen root;

                BaseNode_(InitializeCopyNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (InitializeCopyNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        if (arguments1Value instanceof DynamicObject) {
                            DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                            if (RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isNullHash(arguments1Value_)) {
                                return ReplaceNullNode_.create(this.root);
                            }
                            if (RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isPackedHash(arguments1Value_)) {
                                return ReplacePackedArrayNode_.create(this.root);
                            }
                            if (RubyGuards.isRubyHash(arguments1Value_) && HashGuards.isBucketHash(arguments1Value_)) {
                                return ReplaceBuckets0Node_.create(this.root);
                            }
                        }
                        if (!RubyGuards.isRubyHash(arguments1Value)) {
                            SnippetNode snippetNode4 = new SnippetNode();
                            return ReplaceBuckets1Node_.create(this.root, snippetNode4);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.InitializeNode.class)
    public static final class InitializeNodeFactory
    implements NodeFactory<HashNodes.InitializeNode> {
        private static InitializeNodeFactory initializeNodeFactoryInstance;

        private InitializeNodeFactory() {
        }

        public Class<HashNodes.InitializeNode> getNodeClass() {
            return HashNodes.InitializeNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public HashNodes.InitializeNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return InitializeNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.InitializeNode> getInstance() {
            if (initializeNodeFactoryInstance == null) {
                initializeNodeFactoryInstance = new InitializeNodeFactory();
            }
            return initializeNodeFactoryInstance;
        }

        public static HashNodes.InitializeNode create(RubyNode[] arguments) {
            return new InitializeNodeGen(arguments);
        }

        @GeneratedBy(value=HashNodes.InitializeNode.class)
        public static final class InitializeNodeGen
        extends HashNodes.InitializeNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private BaseNode_ specialization_;

            private InitializeNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="initialize(DynamicObject, Object, DynamicObject)", value=HashNodes.InitializeNode.class)
            private static final class Initialize3Node_
            extends BaseNode_ {
                Initialize3Node_(InitializeNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments2Value_ = (DynamicObject)arguments2Value;
                        if (RubyGuards.wasProvided(arguments1Value)) {
                            return this.root.initialize(arguments0Value_, arguments1Value, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new Initialize3Node_(root);
                }
            }

            @GeneratedBy(methodName="initialize(DynamicObject, Object, NotProvided)", value=HashNodes.InitializeNode.class)
            private static final class Initialize2Node_
            extends BaseNode_ {
                Initialize2Node_(InitializeNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (RubyGuards.wasProvided(arguments1Value)) {
                            return this.root.initialize(arguments0Value_, arguments1Value, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new Initialize2Node_(root);
                }
            }

            @GeneratedBy(methodName="initialize(DynamicObject, NotProvided, DynamicObject)", value=HashNodes.InitializeNode.class)
            private static final class Initialize1Node_
            extends BaseNode_ {
                Initialize1Node_(InitializeNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided && arguments2Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        DynamicObject arguments2Value_ = (DynamicObject)arguments2Value;
                        return this.root.initialize(arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new Initialize1Node_(root);
                }
            }

            @GeneratedBy(methodName="initialize(DynamicObject, NotProvided, NotProvided)", value=HashNodes.InitializeNode.class)
            private static final class Initialize0Node_
            extends BaseNode_ {
                Initialize0Node_(InitializeNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided && arguments2Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        return this.root.initialize(arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new Initialize0Node_(root);
                }
            }

            @GeneratedBy(value=HashNodes.InitializeNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(InitializeNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.InitializeNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(InitializeNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.InitializeNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected InitializeNodeGen root;

                BaseNode_(InitializeNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (InitializeNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        if (arguments1Value instanceof NotProvided) {
                            if (arguments2Value instanceof NotProvided) {
                                return Initialize0Node_.create(this.root);
                            }
                            if (arguments2Value instanceof DynamicObject) {
                                return Initialize1Node_.create(this.root);
                            }
                        }
                        if (arguments2Value instanceof NotProvided && RubyGuards.wasProvided(arguments1Value)) {
                            return Initialize2Node_.create(this.root);
                        }
                        if (arguments2Value instanceof DynamicObject && RubyGuards.wasProvided(arguments1Value)) {
                            return Initialize3Node_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.EmptyNode.class)
    public static final class EmptyNodeFactory
    implements NodeFactory<HashNodes.EmptyNode> {
        private static EmptyNodeFactory emptyNodeFactoryInstance;

        private EmptyNodeFactory() {
        }

        public Class<HashNodes.EmptyNode> getNodeClass() {
            return HashNodes.EmptyNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public HashNodes.EmptyNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return EmptyNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.EmptyNode> getInstance() {
            if (emptyNodeFactoryInstance == null) {
                emptyNodeFactoryInstance = new EmptyNodeFactory();
            }
            return emptyNodeFactoryInstance;
        }

        public static HashNodes.EmptyNode create(RubyNode[] arguments) {
            return new EmptyNodeGen(arguments);
        }

        @GeneratedBy(value=HashNodes.EmptyNode.class)
        public static final class EmptyNodeGen
        extends HashNodes.EmptyNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private EmptyNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.specialization_.executeBoolean(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="emptyPackedArray(DynamicObject)", value=HashNodes.EmptyNode.class)
            private static final class EmptyPackedArrayNode_
            extends BaseNode_ {
                EmptyPackedArrayNode_(EmptyNodeGen root) {
                    super(root, 2);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    if (!HashGuards.isNullHash(arguments0Value_)) {
                        return this.root.emptyPackedArray(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && !HashGuards.isNullHash(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.emptyPackedArray(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(EmptyNodeGen root) {
                    return new EmptyPackedArrayNode_(root);
                }
            }

            @GeneratedBy(methodName="emptyNull(DynamicObject)", value=HashNodes.EmptyNode.class)
            private static final class EmptyNullNode_
            extends BaseNode_ {
                EmptyNullNode_(EmptyNodeGen root) {
                    super(root, 1);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    if (HashGuards.isNullHash(arguments0Value_)) {
                        return this.root.emptyNull(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && HashGuards.isNullHash(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.emptyNull(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(EmptyNodeGen root) {
                    return new EmptyNullNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.EmptyNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(EmptyNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(EmptyNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.EmptyNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(EmptyNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Boolean)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(EmptyNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.EmptyNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected EmptyNodeGen root;

                BaseNode_(EmptyNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (EmptyNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeBoolean_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract boolean executeBoolean_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeBoolean_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) {
                    return (Boolean)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (HashGuards.isNullHash(arguments0Value_)) {
                            return EmptyNullNode_.create(this.root);
                        }
                        return EmptyPackedArrayNode_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.EachNode.class)
    public static final class EachNodeFactory
    implements NodeFactory<HashNodes.EachNode> {
        private static EachNodeFactory eachNodeFactoryInstance;

        private EachNodeFactory() {
        }

        public Class<HashNodes.EachNode> getNodeClass() {
            return HashNodes.EachNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyContext.class, SourceSection.class, RubyNode[].class));
        }

        public HashNodes.EachNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EachNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.EachNode> getInstance() {
            if (eachNodeFactoryInstance == null) {
                eachNodeFactoryInstance = new EachNodeFactory();
            }
            return eachNodeFactoryInstance;
        }

        public static HashNodes.EachNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new EachNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=HashNodes.EachNode.class)
        public static final class EachNodeGen
        extends HashNodes.EachNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private EachNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="each(VirtualFrame, DynamicObject, NotProvided)", value=HashNodes.EachNode.class)
            private static final class EachNode_
            extends BaseNode_ {
                EachNode_(EachNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        return this.root.each(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachNodeGen root) {
                    return new EachNode_(root);
                }
            }

            @GeneratedBy(methodName="eachBuckets(VirtualFrame, DynamicObject, DynamicObject)", value=HashNodes.EachNode.class)
            private static final class EachBucketsNode_
            extends BaseNode_ {
                EachBucketsNode_(EachNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (HashGuards.isBucketHash(arguments0Value_)) {
                            return this.root.eachBuckets(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachNodeGen root) {
                    return new EachBucketsNode_(root);
                }
            }

            @GeneratedBy(methodName="eachPackedArray(VirtualFrame, DynamicObject, DynamicObject)", value=HashNodes.EachNode.class)
            private static final class EachPackedArrayNode_
            extends BaseNode_ {
                EachPackedArrayNode_(EachNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (HashGuards.isPackedHash(arguments0Value_)) {
                            return this.root.eachPackedArray(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachNodeGen root) {
                    return new EachPackedArrayNode_(root);
                }
            }

            @GeneratedBy(methodName="eachNull(DynamicObject, DynamicObject)", value=HashNodes.EachNode.class)
            private static final class EachNullNode_
            extends BaseNode_ {
                EachNullNode_(EachNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (HashGuards.isNullHash(arguments0Value_)) {
                            return this.root.eachNull(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachNodeGen root) {
                    return new EachNullNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.EachNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(EachNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.EachNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(EachNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.EachNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected EachNodeGen root;

                BaseNode_(EachNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (EachNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (arguments1Value instanceof DynamicObject) {
                            if (HashGuards.isNullHash(arguments0Value_)) {
                                return EachNullNode_.create(this.root);
                            }
                            if (HashGuards.isPackedHash(arguments0Value_)) {
                                return EachPackedArrayNode_.create(this.root);
                            }
                            if (HashGuards.isBucketHash(arguments0Value_)) {
                                return EachBucketsNode_.create(this.root);
                            }
                        }
                        if (arguments1Value instanceof NotProvided) {
                            return EachNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.DeleteNode.class)
    public static final class DeleteNodeFactory
    implements NodeFactory<HashNodes.DeleteNode> {
        private static DeleteNodeFactory deleteNodeFactoryInstance;

        private DeleteNodeFactory() {
        }

        public Class<HashNodes.DeleteNode> getNodeClass() {
            return HashNodes.DeleteNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyContext.class, SourceSection.class, RubyNode[].class));
        }

        public HashNodes.DeleteNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DeleteNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.DeleteNode> getInstance() {
            if (deleteNodeFactoryInstance == null) {
                deleteNodeFactoryInstance = new DeleteNodeFactory();
            }
            return deleteNodeFactoryInstance;
        }

        public static HashNodes.DeleteNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new DeleteNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=HashNodes.DeleteNode.class)
        public static final class DeleteNodeGen
        extends HashNodes.DeleteNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private BaseNode_ specialization_;

            private DeleteNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="delete(VirtualFrame, DynamicObject, Object, Object)", value=HashNodes.DeleteNode.class)
            private static final class DeleteNode_
            extends BaseNode_ {
                DeleteNode_(DeleteNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && HashGuards.isBucketHash(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.delete(frameValue, arguments0Value_, arguments1Value, arguments2Value);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(DeleteNodeGen root) {
                    return new DeleteNode_(root);
                }
            }

            @GeneratedBy(methodName="deletePackedArray(VirtualFrame, DynamicObject, Object, Object)", value=HashNodes.DeleteNode.class)
            private static final class DeletePackedArrayNode_
            extends BaseNode_ {
                DeletePackedArrayNode_(DeleteNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && HashGuards.isPackedHash(arguments0Value_ = (DynamicObject)arguments0Value) && !HashGuards.isCompareByIdentity(arguments0Value_)) {
                        return this.root.deletePackedArray(frameValue, arguments0Value_, arguments1Value, arguments2Value);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(DeleteNodeGen root) {
                    return new DeletePackedArrayNode_(root);
                }
            }

            @GeneratedBy(methodName="deleteNull(VirtualFrame, DynamicObject, Object, DynamicObject)", value=HashNodes.DeleteNode.class)
            private static final class DeleteNull1Node_
            extends BaseNode_ {
                DeleteNull1Node_(DeleteNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments2Value_ = (DynamicObject)arguments2Value;
                        if (HashGuards.isNullHash(arguments0Value_)) {
                            return this.root.deleteNull(frameValue, arguments0Value_, arguments1Value, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(DeleteNodeGen root) {
                    return new DeleteNull1Node_(root);
                }
            }

            @GeneratedBy(methodName="deleteNull(VirtualFrame, DynamicObject, Object, NotProvided)", value=HashNodes.DeleteNode.class)
            private static final class DeleteNull0Node_
            extends BaseNode_ {
                DeleteNull0Node_(DeleteNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (HashGuards.isNullHash(arguments0Value_)) {
                            return this.root.deleteNull(frameValue, arguments0Value_, arguments1Value, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(DeleteNodeGen root) {
                    return new DeleteNull0Node_(root);
                }
            }

            @GeneratedBy(value=HashNodes.DeleteNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(DeleteNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(DeleteNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.DeleteNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(DeleteNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(DeleteNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.DeleteNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected DeleteNodeGen root;

                BaseNode_(DeleteNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (DeleteNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (arguments2Value instanceof NotProvided && HashGuards.isNullHash(arguments0Value_)) {
                            return DeleteNull0Node_.create(this.root);
                        }
                        if (arguments2Value instanceof DynamicObject && HashGuards.isNullHash(arguments0Value_)) {
                            return DeleteNull1Node_.create(this.root);
                        }
                        if (HashGuards.isPackedHash(arguments0Value_) && !HashGuards.isCompareByIdentity(arguments0Value_)) {
                            return DeletePackedArrayNode_.create(this.root);
                        }
                        if (HashGuards.isBucketHash(arguments0Value_)) {
                            return DeleteNode_.create(this.root);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.DefaultProcNode.class)
    public static final class DefaultProcNodeFactory
    implements NodeFactory<HashNodes.DefaultProcNode> {
        private static DefaultProcNodeFactory defaultProcNodeFactoryInstance;

        private DefaultProcNodeFactory() {
        }

        public Class<HashNodes.DefaultProcNode> getNodeClass() {
            return HashNodes.DefaultProcNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public HashNodes.DefaultProcNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return DefaultProcNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.DefaultProcNode> getInstance() {
            if (defaultProcNodeFactoryInstance == null) {
                defaultProcNodeFactoryInstance = new DefaultProcNodeFactory();
            }
            return defaultProcNodeFactoryInstance;
        }

        public static HashNodes.DefaultProcNode create(RubyNode[] arguments) {
            return new DefaultProcNodeGen(arguments);
        }

        @GeneratedBy(value=HashNodes.DefaultProcNode.class)
        public static final class DefaultProcNodeGen
        extends HashNodes.DefaultProcNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private DefaultProcNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="defaultProc(DynamicObject, ConditionProfile)", value=HashNodes.DefaultProcNode.class)
            private static final class DefaultProcNode_
            extends BaseNode_ {
                private final ConditionProfile defaultBlockNullProfile;

                DefaultProcNode_(DefaultProcNodeGen root, ConditionProfile defaultBlockNullProfile) {
                    super(root, 1);
                    this.defaultBlockNullProfile = defaultBlockNullProfile;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        return this.root.defaultProc(arguments0Value_, this.defaultBlockNullProfile);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(DefaultProcNodeGen root, ConditionProfile defaultBlockNullProfile) {
                    return new DefaultProcNode_(root, defaultBlockNullProfile);
                }
            }

            @GeneratedBy(value=HashNodes.DefaultProcNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(DefaultProcNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(DefaultProcNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.DefaultProcNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected DefaultProcNodeGen root;

                BaseNode_(DefaultProcNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (DefaultProcNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        ConditionProfile defaultBlockNullProfile1 = ConditionProfile.createBinaryProfile();
                        return DefaultProcNode_.create(this.root, defaultBlockNullProfile1);
                    }
                    return null;
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.IsCompareByIdentityNode.class)
    public static final class IsCompareByIdentityNodeFactory
    implements NodeFactory<HashNodes.IsCompareByIdentityNode> {
        private static IsCompareByIdentityNodeFactory isCompareByIdentityNodeFactoryInstance;

        private IsCompareByIdentityNodeFactory() {
        }

        public Class<HashNodes.IsCompareByIdentityNode> getNodeClass() {
            return HashNodes.IsCompareByIdentityNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyContext.class, SourceSection.class, RubyNode[].class));
        }

        public HashNodes.IsCompareByIdentityNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IsCompareByIdentityNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.IsCompareByIdentityNode> getInstance() {
            if (isCompareByIdentityNodeFactoryInstance == null) {
                isCompareByIdentityNodeFactoryInstance = new IsCompareByIdentityNodeFactory();
            }
            return isCompareByIdentityNodeFactoryInstance;
        }

        public static HashNodes.IsCompareByIdentityNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new IsCompareByIdentityNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=HashNodes.IsCompareByIdentityNode.class)
        public static final class IsCompareByIdentityNodeGen
        extends HashNodes.IsCompareByIdentityNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private IsCompareByIdentityNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.compareByIdentity(arguments0Value_);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=HashNodes.CompareByIdentityNode.class)
    public static final class CompareByIdentityNodeFactory
    implements NodeFactory<HashNodes.CompareByIdentityNode> {
        private static CompareByIdentityNodeFactory compareByIdentityNodeFactoryInstance;

        private CompareByIdentityNodeFactory() {
        }

        public Class<HashNodes.CompareByIdentityNode> getNodeClass() {
            return HashNodes.CompareByIdentityNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public HashNodes.CompareByIdentityNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return CompareByIdentityNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.CompareByIdentityNode> getInstance() {
            if (compareByIdentityNodeFactoryInstance == null) {
                compareByIdentityNodeFactoryInstance = new CompareByIdentityNodeFactory();
            }
            return compareByIdentityNodeFactoryInstance;
        }

        public static HashNodes.CompareByIdentityNode create(RubyNode[] arguments) {
            return new CompareByIdentityNodeGen(arguments);
        }

        @GeneratedBy(value=HashNodes.CompareByIdentityNode.class)
        public static final class CompareByIdentityNodeGen
        extends HashNodes.CompareByIdentityNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private CompareByIdentityNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.compareByIdentity(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=HashNodes.ClearNode.class)
    public static final class ClearNodeFactory
    implements NodeFactory<HashNodes.ClearNode> {
        private static ClearNodeFactory clearNodeFactoryInstance;

        private ClearNodeFactory() {
        }

        public Class<HashNodes.ClearNode> getNodeClass() {
            return HashNodes.ClearNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public HashNodes.ClearNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ClearNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.ClearNode> getInstance() {
            if (clearNodeFactoryInstance == null) {
                clearNodeFactoryInstance = new ClearNodeFactory();
            }
            return clearNodeFactoryInstance;
        }

        public static HashNodes.ClearNode create(RubyNode[] arguments) {
            return new ClearNodeGen(arguments);
        }

        @GeneratedBy(value=HashNodes.ClearNode.class)
        public static final class ClearNodeGen
        extends HashNodes.ClearNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private ClearNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="empty(DynamicObject)", value=HashNodes.ClearNode.class)
            private static final class EmptyNode_
            extends BaseNode_ {
                EmptyNode_(ClearNodeGen root) {
                    super(root, 2);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && !HashGuards.isNullHash(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.empty(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ClearNodeGen root) {
                    return new EmptyNode_(root);
                }
            }

            @GeneratedBy(methodName="emptyNull(DynamicObject)", value=HashNodes.ClearNode.class)
            private static final class EmptyNullNode_
            extends BaseNode_ {
                EmptyNullNode_(ClearNodeGen root) {
                    super(root, 1);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && HashGuards.isNullHash(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.emptyNull(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ClearNodeGen root) {
                    return new EmptyNullNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.ClearNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ClearNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ClearNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.ClearNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ClearNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ClearNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.ClearNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ClearNodeGen root;

                BaseNode_(ClearNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (ClearNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (HashGuards.isNullHash(arguments0Value_)) {
                            return EmptyNullNode_.create(this.root);
                        }
                        return EmptyNode_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.SetIndexNode.class)
    public static final class SetIndexNodeFactory
    implements NodeFactory<HashNodes.SetIndexNode> {
        private static SetIndexNodeFactory setIndexNodeFactoryInstance;

        private SetIndexNodeFactory() {
        }

        public Class<HashNodes.SetIndexNode> getNodeClass() {
            return HashNodes.SetIndexNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyContext.class, SourceSection.class, RubyNode[].class));
        }

        public HashNodes.SetIndexNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SetIndexNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.SetIndexNode> getInstance() {
            if (setIndexNodeFactoryInstance == null) {
                setIndexNodeFactoryInstance = new SetIndexNodeFactory();
            }
            return setIndexNodeFactoryInstance;
        }

        public static HashNodes.SetIndexNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SetIndexNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=HashNodes.SetIndexNode.class)
        public static final class SetIndexNodeGen
        extends HashNodes.SetIndexNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private SetIndexNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    Object arguments2Value = this.arguments2_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value, arguments2Value);
                }
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                Object arguments2Value_ = this.arguments2_.execute(frameValue);
                return this.set(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
            }
        }
    }

    @GeneratedBy(value=HashNodes.GetOrUndefinedNode.class)
    public static final class GetOrUndefinedNodeFactory
    implements NodeFactory<HashNodes.GetOrUndefinedNode> {
        private static GetOrUndefinedNodeFactory getOrUndefinedNodeFactoryInstance;

        private GetOrUndefinedNodeFactory() {
        }

        public Class<HashNodes.GetOrUndefinedNode> getNodeClass() {
            return HashNodes.GetOrUndefinedNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyContext.class, SourceSection.class, RubyNode[].class));
        }

        public HashNodes.GetOrUndefinedNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GetOrUndefinedNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.GetOrUndefinedNode> getInstance() {
            if (getOrUndefinedNodeFactoryInstance == null) {
                getOrUndefinedNodeFactoryInstance = new GetOrUndefinedNodeFactory();
            }
            return getOrUndefinedNodeFactoryInstance;
        }

        public static HashNodes.GetOrUndefinedNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new GetOrUndefinedNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=HashNodes.GetOrUndefinedNode.class)
        public static final class GetOrUndefinedNodeGen
        extends HashNodes.GetOrUndefinedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private GetOrUndefinedNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                return this.getOrUndefined(frameValue, arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
        }
    }

    @GeneratedBy(value=HashNodes.GetIndexNode.class)
    public static final class GetIndexNodeFactory
    implements NodeFactory<HashNodes.GetIndexNode> {
        private static GetIndexNodeFactory getIndexNodeFactoryInstance;

        private GetIndexNodeFactory() {
        }

        public Class<HashNodes.GetIndexNode> getNodeClass() {
            return HashNodes.GetIndexNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyContext.class, SourceSection.class, RubyNode[].class));
        }

        public HashNodes.GetIndexNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GetIndexNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.GetIndexNode> getInstance() {
            if (getIndexNodeFactoryInstance == null) {
                getIndexNodeFactoryInstance = new GetIndexNodeFactory();
            }
            return getIndexNodeFactoryInstance;
        }

        public static HashNodes.GetIndexNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new GetIndexNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=HashNodes.GetIndexNode.class)
        @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
        public static final class GetIndexNodeGen
        extends HashNodes.GetIndexNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeGetConstantIndexPackedArray_;
            @Node.Child
            private BaseNode_ specialization_;

            private GetIndexNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object executeGet(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                return this.specialization_.execute1(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute0(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="getBuckets(VirtualFrame, DynamicObject, Object, BranchProfile, BranchProfile)", value=HashNodes.GetIndexNode.class)
            private static final class GetBucketsNode_
            extends BaseNode_ {
                private final BranchProfile notInHashProfile;
                private final BranchProfile useDefaultProfile;

                GetBucketsNode_(GetIndexNodeGen root, BranchProfile notInHashProfile, BranchProfile useDefaultProfile) {
                    super(root, 6);
                    this.notInHashProfile = notInHashProfile;
                    this.useDefaultProfile = useDefaultProfile;
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                    if (HashGuards.isBucketHash(arguments0Value)) {
                        return this.root.getBuckets(frameValue, arguments0Value, arguments1Value, this.notInHashProfile, this.useDefaultProfile);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && HashGuards.isBucketHash(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.getBuckets(frameValue, arguments0Value_, arguments1Value, this.notInHashProfile, this.useDefaultProfile);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GetIndexNodeGen root, BranchProfile notInHashProfile, BranchProfile useDefaultProfile) {
                    return new GetBucketsNode_(root, notInHashProfile, useDefaultProfile);
                }
            }

            @GeneratedBy(methodName="getPackedArrayByIdentity(VirtualFrame, DynamicObject, Object, BranchProfile, BranchProfile)", value=HashNodes.GetIndexNode.class)
            private static final class GetPackedArrayByIdentityNode_
            extends BaseNode_ {
                private final BranchProfile notInHashProfile;
                private final BranchProfile useDefaultProfile;

                GetPackedArrayByIdentityNode_(GetIndexNodeGen root, BranchProfile notInHashProfile, BranchProfile useDefaultProfile) {
                    super(root, 5);
                    this.notInHashProfile = notInHashProfile;
                    this.useDefaultProfile = useDefaultProfile;
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                    if (HashGuards.isPackedHash(arguments0Value) && HashGuards.isCompareByIdentity(arguments0Value)) {
                        return this.root.getPackedArrayByIdentity(frameValue, arguments0Value, arguments1Value, this.notInHashProfile, this.useDefaultProfile);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && HashGuards.isPackedHash(arguments0Value_ = (DynamicObject)arguments0Value) && HashGuards.isCompareByIdentity(arguments0Value_)) {
                        return this.root.getPackedArrayByIdentity(frameValue, arguments0Value_, arguments1Value, this.notInHashProfile, this.useDefaultProfile);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GetIndexNodeGen root, BranchProfile notInHashProfile, BranchProfile useDefaultProfile) {
                    return new GetPackedArrayByIdentityNode_(root, notInHashProfile, useDefaultProfile);
                }
            }

            @GeneratedBy(methodName="getPackedArray(VirtualFrame, DynamicObject, Object, BranchProfile, BranchProfile)", value=HashNodes.GetIndexNode.class)
            private static final class GetPackedArrayNode_
            extends BaseNode_ {
                private final BranchProfile notInHashProfile;
                private final BranchProfile useDefaultProfile;

                GetPackedArrayNode_(GetIndexNodeGen root, BranchProfile notInHashProfile, BranchProfile useDefaultProfile) {
                    super(root, 4);
                    this.notInHashProfile = notInHashProfile;
                    this.useDefaultProfile = useDefaultProfile;
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                    if (HashGuards.isPackedHash(arguments0Value) && !HashGuards.isCompareByIdentity(arguments0Value)) {
                        return this.root.getPackedArray(frameValue, arguments0Value, arguments1Value, this.notInHashProfile, this.useDefaultProfile);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && HashGuards.isPackedHash(arguments0Value_ = (DynamicObject)arguments0Value) && !HashGuards.isCompareByIdentity(arguments0Value_)) {
                        return this.root.getPackedArray(frameValue, arguments0Value_, arguments1Value, this.notInHashProfile, this.useDefaultProfile);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GetIndexNodeGen root, BranchProfile notInHashProfile, BranchProfile useDefaultProfile) {
                    return new GetPackedArrayNode_(root, notInHashProfile, useDefaultProfile);
                }
            }

            @GeneratedBy(methodName="getConstantIndexPackedArrayByIdentity(VirtualFrame, DynamicObject, Object, int)", value=HashNodes.GetIndexNode.class)
            private static final class GetConstantIndexPackedArrayByIdentityNode_
            extends BaseNode_ {
                private final int cachedIndex;

                GetConstantIndexPackedArrayByIdentityNode_(GetIndexNodeGen root, int cachedIndex) {
                    super(root, 3);
                    this.cachedIndex = cachedIndex;
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && HashGuards.isPackedHash(arguments0Value_ = (DynamicObject)arguments0Value) && HashGuards.isCompareByIdentity(arguments0Value_) && this.cachedIndex < this.root.getSize(arguments0Value_) && this.root.equal(arguments1Value, this.root.getKeyAt(arguments0Value_, this.cachedIndex))) {
                        assert (this.cachedIndex >= 0);
                        return true;
                    }
                    return false;
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                    if (HashGuards.isPackedHash(arguments0Value) && HashGuards.isCompareByIdentity(arguments0Value) && this.cachedIndex < this.root.getSize(arguments0Value) && this.root.equal(arguments1Value, this.root.getKeyAt(arguments0Value, this.cachedIndex))) {
                        assert (this.cachedIndex >= 0);
                        return this.root.getConstantIndexPackedArrayByIdentity(frameValue, arguments0Value, arguments1Value, this.cachedIndex);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && HashGuards.isPackedHash(arguments0Value_ = (DynamicObject)arguments0Value) && HashGuards.isCompareByIdentity(arguments0Value_) && this.cachedIndex < this.root.getSize(arguments0Value_) && this.root.equal(arguments1Value, this.root.getKeyAt(arguments0Value_, this.cachedIndex))) {
                        assert (this.cachedIndex >= 0);
                        return this.root.getConstantIndexPackedArrayByIdentity(frameValue, arguments0Value_, arguments1Value, this.cachedIndex);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GetIndexNodeGen root, int cachedIndex) {
                    return new GetConstantIndexPackedArrayByIdentityNode_(root, cachedIndex);
                }
            }

            @GeneratedBy(methodName="getConstantIndexPackedArray(VirtualFrame, DynamicObject, Object, int)", value=HashNodes.GetIndexNode.class)
            private static final class GetConstantIndexPackedArrayNode_
            extends BaseNode_ {
                private final int cachedIndex;

                GetConstantIndexPackedArrayNode_(GetIndexNodeGen root, int cachedIndex) {
                    super(root, 2);
                    this.cachedIndex = cachedIndex;
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (newNode.getClass() == GetPackedArrayNode_.class) {
                        this.removeSame("Contained by getPackedArray(VirtualFrame, DynamicObject, Object, BranchProfile, BranchProfile)");
                    } else if (newNode.getClass() == GetPackedArrayByIdentityNode_.class) {
                        this.removeSame("Contained by getPackedArrayByIdentity(VirtualFrame, DynamicObject, Object, BranchProfile, BranchProfile)");
                    }
                    return super.merge(newNode, frameValue, arguments0Value, arguments1Value);
                }

                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && HashGuards.isPackedHash(arguments0Value_ = (DynamicObject)arguments0Value) && !HashGuards.isCompareByIdentity(arguments0Value_) && this.cachedIndex < this.root.getSize(arguments0Value_) && this.root.hash((VirtualFrame)frameValue, arguments1Value) == this.root.getHashedAt(arguments0Value_, this.cachedIndex) && this.root.eql((VirtualFrame)frameValue, arguments1Value, this.root.getKeyAt(arguments0Value_, this.cachedIndex))) {
                        assert (this.cachedIndex >= 0);
                        return true;
                    }
                    return false;
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                    if (HashGuards.isPackedHash(arguments0Value) && !HashGuards.isCompareByIdentity(arguments0Value) && this.cachedIndex < this.root.getSize(arguments0Value) && this.root.hash(frameValue, arguments1Value) == this.root.getHashedAt(arguments0Value, this.cachedIndex) && this.root.eql(frameValue, arguments1Value, this.root.getKeyAt(arguments0Value, this.cachedIndex))) {
                        assert (this.cachedIndex >= 0);
                        return this.root.getConstantIndexPackedArray(frameValue, arguments0Value, arguments1Value, this.cachedIndex);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && HashGuards.isPackedHash(arguments0Value_ = (DynamicObject)arguments0Value) && !HashGuards.isCompareByIdentity(arguments0Value_) && this.cachedIndex < this.root.getSize(arguments0Value_) && this.root.hash(frameValue, arguments1Value) == this.root.getHashedAt(arguments0Value_, this.cachedIndex) && this.root.eql(frameValue, arguments1Value, this.root.getKeyAt(arguments0Value_, this.cachedIndex))) {
                        assert (this.cachedIndex >= 0);
                        return this.root.getConstantIndexPackedArray(frameValue, arguments0Value_, arguments1Value, this.cachedIndex);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GetIndexNodeGen root, int cachedIndex) {
                    return new GetConstantIndexPackedArrayNode_(root, cachedIndex);
                }
            }

            @GeneratedBy(methodName="getNull(VirtualFrame, DynamicObject, Object)", value=HashNodes.GetIndexNode.class)
            private static final class GetNullNode_
            extends BaseNode_ {
                GetNullNode_(GetIndexNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                    if (HashGuards.isNullHash(arguments0Value)) {
                        return this.root.getNull(frameValue, arguments0Value, arguments1Value);
                    }
                    return this.getNext().execute1(frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && HashGuards.isNullHash(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.getNull(frameValue, arguments0Value_, arguments1Value);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GetIndexNodeGen root) {
                    return new GetNullNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.GetIndexNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(GetIndexNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GetIndexNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.GetIndexNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(GetIndexNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(GetIndexNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.GetIndexNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected GetIndexNodeGen root;

                BaseNode_(GetIndexNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (GetIndexNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute1(VirtualFrame frameValue, DynamicObject arguments0Value, Object arguments1Value) {
                    return this.execute_(frameValue, arguments0Value, arguments1Value);
                }

                public Object execute0(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute0(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (HashGuards.isNullHash(arguments0Value_)) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            return GetNullNode_.create(this.root);
                        }
                        int cachedIndex2 = this.root.index((VirtualFrame)frameValue, arguments0Value_, arguments1Value);
                        if (HashGuards.isPackedHash(arguments0Value_) && !HashGuards.isCompareByIdentity(arguments0Value_) && cachedIndex2 >= 0 && cachedIndex2 < this.root.getSize(arguments0Value_) && this.root.hash((VirtualFrame)frameValue, arguments1Value) == this.root.getHashedAt(arguments0Value_, cachedIndex2) && this.root.eql((VirtualFrame)frameValue, arguments1Value, this.root.getKeyAt(arguments0Value_, cachedIndex2)) && !this.root.excludeGetConstantIndexPackedArray_) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            BaseNode_ s = GetConstantIndexPackedArrayNode_.create(this.root, cachedIndex2);
                            if (this.countSame(s) < 1) {
                                return s;
                            }
                        }
                        int cachedIndex3 = this.root.index((VirtualFrame)frameValue, arguments0Value_, arguments1Value);
                        if (HashGuards.isPackedHash(arguments0Value_) && HashGuards.isCompareByIdentity(arguments0Value_) && cachedIndex3 >= 0 && cachedIndex3 < this.root.getSize(arguments0Value_) && this.root.equal(arguments1Value, this.root.getKeyAt(arguments0Value_, cachedIndex3))) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            BaseNode_ s = GetConstantIndexPackedArrayByIdentityNode_.create(this.root, cachedIndex3);
                            if (this.countSame(s) < 1) {
                                return s;
                            }
                        }
                        if (HashGuards.isPackedHash(arguments0Value_) && !HashGuards.isCompareByIdentity(arguments0Value_)) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            BranchProfile notInHashProfile4 = BranchProfile.create();
                            BranchProfile useDefaultProfile4 = BranchProfile.create();
                            this.root.excludeGetConstantIndexPackedArray_ = true;
                            return GetPackedArrayNode_.create(this.root, notInHashProfile4, useDefaultProfile4);
                        }
                        if (HashGuards.isPackedHash(arguments0Value_) && HashGuards.isCompareByIdentity(arguments0Value_)) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            BranchProfile notInHashProfile5 = BranchProfile.create();
                            BranchProfile useDefaultProfile5 = BranchProfile.create();
                            this.root.excludeGetConstantIndexPackedArray_ = true;
                            return GetPackedArrayByIdentityNode_.create(this.root, notInHashProfile5, useDefaultProfile5);
                        }
                        if (HashGuards.isBucketHash(arguments0Value_)) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            BranchProfile notInHashProfile6 = BranchProfile.create();
                            BranchProfile useDefaultProfile6 = BranchProfile.create();
                            return GetBucketsNode_.create(this.root, notInHashProfile6, useDefaultProfile6);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.ConstructNode.class)
    public static final class ConstructNodeFactory
    implements NodeFactory<HashNodes.ConstructNode> {
        private static ConstructNodeFactory constructNodeFactoryInstance;

        private ConstructNodeFactory() {
        }

        public Class<HashNodes.ConstructNode> getNodeClass() {
            return HashNodes.ConstructNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyContext.class, SourceSection.class, RubyNode[].class));
        }

        public HashNodes.ConstructNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ConstructNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.ConstructNode> getInstance() {
            if (constructNodeFactoryInstance == null) {
                constructNodeFactoryInstance = new ConstructNodeFactory();
            }
            return constructNodeFactoryInstance;
        }

        public static HashNodes.ConstructNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ConstructNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=HashNodes.ConstructNode.class)
        public static final class ConstructNodeGen
        extends HashNodes.ConstructNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private ConstructNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="constructFallback(VirtualFrame, DynamicObject, Object[], SnippetNode)", value=HashNodes.ConstructNode.class)
            private static final class ConstructFallbackNode_
            extends BaseNode_ {
                @Node.Child
                private SnippetNode snippetNode;

                ConstructFallbackNode_(ConstructNodeGen root, SnippetNode snippetNode) {
                    super(root, 2);
                    this.snippetNode = snippetNode;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Object[]) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        if (!this.root.isSmallArrayOfPairs(arguments1Value_)) {
                            return this.root.constructFallback(frameValue, arguments0Value_, arguments1Value_, this.snippetNode);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ConstructNodeGen root, SnippetNode snippetNode) {
                    return new ConstructFallbackNode_(root, snippetNode);
                }
            }

            @GeneratedBy(methodName="construct(VirtualFrame, DynamicObject, Object[], SnippetNode)", value=HashNodes.ConstructNode.class)
            private static final class ConstructNode_
            extends BaseNode_ {
                @Node.Child
                private SnippetNode snippetNode;

                ConstructNode_(ConstructNodeGen root, SnippetNode snippetNode) {
                    super(root, 1);
                    this.snippetNode = snippetNode;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Object[]) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        if (this.root.isSmallArrayOfPairs(arguments1Value_)) {
                            return this.root.construct(frameValue, arguments0Value_, arguments1Value_, this.snippetNode);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ConstructNodeGen root, SnippetNode snippetNode) {
                    return new ConstructNode_(root, snippetNode);
                }
            }

            @GeneratedBy(value=HashNodes.ConstructNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ConstructNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ConstructNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.ConstructNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ConstructNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ConstructNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=HashNodes.ConstructNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ConstructNodeGen root;

                BaseNode_(ConstructNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (ConstructNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Object[]) {
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        if (this.root.isSmallArrayOfPairs(arguments1Value_)) {
                            SnippetNode snippetNode1 = new SnippetNode();
                            return ConstructNode_.create(this.root, snippetNode1);
                        }
                        SnippetNode snippetNode2 = new SnippetNode();
                        return ConstructFallbackNode_.create(this.root, snippetNode2);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=HashNodes.AllocateNode.class)
    public static final class AllocateNodeFactory
    implements NodeFactory<HashNodes.AllocateNode> {
        private static AllocateNodeFactory allocateNodeFactoryInstance;

        private AllocateNodeFactory() {
        }

        public Class<HashNodes.AllocateNode> getNodeClass() {
            return HashNodes.AllocateNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyContext.class, SourceSection.class, RubyNode[].class));
        }

        public HashNodes.AllocateNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AllocateNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<HashNodes.AllocateNode> getInstance() {
            if (allocateNodeFactoryInstance == null) {
                allocateNodeFactoryInstance = new AllocateNodeFactory();
            }
            return allocateNodeFactoryInstance;
        }

        public static HashNodes.AllocateNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new AllocateNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=HashNodes.AllocateNode.class)
        public static final class AllocateNodeGen
        extends HashNodes.AllocateNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AllocateNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.allocate(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }
}

