/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle;

import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.vm.PolyglotEngine;
import org.jruby.JRubyTruffleInterface;
import org.jruby.Ruby;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.interop.JRubyContextWrapper;
import org.jruby.truffle.platform.graal.Graal;
import org.jruby.util.cli.Options;

public class JRubyTruffleImpl
implements JRubyTruffleInterface {
    private final PolyglotEngine engine;
    private final RubyContext context;

    public JRubyTruffleImpl(Ruby runtime) {
        this.engine = PolyglotEngine.newBuilder().globalSymbol("org.jruby.truffle.runtime", (Object)new JRubyContextWrapper(runtime)).build();
        this.context = (RubyContext)((Object)this.engine.eval(this.loadSource("Truffle::Boot.context", "context")).get());
    }

    public int execute(String path) {
        if (!Graal.isGraal() && ((Boolean)Options.TRUFFLE_GRAAL_WARNING_UNLESS.load()).booleanValue()) {
            System.err.println("WARNING: This JVM does not have the Graal compiler. JRuby+Truffle's performance without it will be limited. See https://github.com/jruby/jruby/wiki/Truffle-FAQ#how-do-i-get-jrubytruffle");
        }
        this.context.getJRubyInterop().setOriginalInputFile(path);
        return (Integer)this.engine.eval(this.loadSource("Truffle::Boot.run_jruby_root", "run_jruby_root")).as(Integer.class);
    }

    public void dispose() {
        this.engine.dispose();
    }

    private Source loadSource(String source, String name) {
        return Source.newBuilder((String)source).name(name).mimeType("application/x-ruby").build();
    }
}

