/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.stdlib.bigdecimal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.core.cast.IntegerCastNode;
import org.jruby.truffle.core.cast.ToIntNode;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.constants.GetConstantNode;
import org.jruby.truffle.language.constants.LookupConstantNode;
import org.jruby.truffle.stdlib.bigdecimal.GetIntegerConstantNode;

@GeneratedBy(value=GetIntegerConstantNode.class)
public final class GetIntegerConstantNodeGen
extends GetIntegerConstantNode
implements SpecializedNode {
    @Node.Child
    private RubyNode module_;
    @Node.Child
    private RubyNode name_;
    @Node.Child
    private BaseNode_ specialization_;

    private GetIntegerConstantNodeGen(RubyNode module, RubyNode name) {
        this.module_ = module;
        this.name_ = name;
        this.specialization_ = UninitializedNode_.create(this);
    }

    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public int executeGetIntegerConstant(VirtualFrame frameValue, DynamicObject moduleValue, String nameValue) {
        return this.specialization_.executeInt1(frameValue, moduleValue, nameValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public int executeInteger(VirtualFrame frameValue) {
        return this.specialization_.executeInt0(frameValue);
    }

    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    public Node deepCopy() {
        return SpecializationNode.updateRoot((Node)super.deepCopy());
    }

    private static String expectString(Object value) throws UnexpectedResultException {
        if (value instanceof String) {
            return (String)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static GetIntegerConstantNode create(RubyNode module, RubyNode name) {
        return new GetIntegerConstantNodeGen(module, name);
    }

    @GeneratedBy(methodName="doInteger(VirtualFrame, DynamicObject, String, LookupConstantNode, GetConstantNode, ToIntNode, IntegerCastNode)", value=GetIntegerConstantNode.class)
    private static final class IntegerNode_
    extends BaseNode_ {
        @Node.Child
        private LookupConstantNode lookupConstantNode;
        @Node.Child
        private GetConstantNode getConstantNode;
        @Node.Child
        private ToIntNode toIntNode;
        @Node.Child
        private IntegerCastNode integerCastNode;

        IntegerNode_(GetIntegerConstantNodeGen root, LookupConstantNode lookupConstantNode, GetConstantNode getConstantNode, ToIntNode toIntNode, IntegerCastNode integerCastNode) {
            super(root, 1);
            this.lookupConstantNode = lookupConstantNode;
            this.getConstantNode = getConstantNode;
            this.toIntNode = toIntNode;
            this.integerCastNode = integerCastNode;
        }

        @Override
        public int executeInt0(VirtualFrame frameValue) {
            String nameValue_;
            DynamicObject moduleValue_;
            try {
                moduleValue_ = this.root.module_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object nameValue = this.root.name_.execute(frameValue);
                return this.getNext().executeInt_(frameValue, ex.getResult(), nameValue);
            }
            try {
                nameValue_ = GetIntegerConstantNodeGen.expectString(this.root.name_.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeInt_(frameValue, moduleValue_, ex.getResult());
            }
            if (RubyGuards.isRubyModule(moduleValue_)) {
                return this.root.doInteger(frameValue, moduleValue_, nameValue_, this.lookupConstantNode, this.getConstantNode, this.toIntNode, this.integerCastNode);
            }
            return this.getNext().executeInt_(frameValue, moduleValue_, nameValue_);
        }

        @Override
        public int executeInt1(VirtualFrame frameValue, DynamicObject moduleValue, String nameValue) {
            if (RubyGuards.isRubyModule(moduleValue)) {
                return this.root.doInteger(frameValue, moduleValue, nameValue, this.lookupConstantNode, this.getConstantNode, this.toIntNode, this.integerCastNode);
            }
            return this.getNext().executeInt1(frameValue, moduleValue, nameValue);
        }

        @Override
        public int executeInt_(VirtualFrame frameValue, Object moduleValue, Object nameValue) {
            if (moduleValue instanceof DynamicObject && nameValue instanceof String) {
                DynamicObject moduleValue_ = (DynamicObject)moduleValue;
                String nameValue_ = (String)nameValue;
                if (RubyGuards.isRubyModule(moduleValue_)) {
                    return this.root.doInteger(frameValue, moduleValue_, nameValue_, this.lookupConstantNode, this.getConstantNode, this.toIntNode, this.integerCastNode);
                }
            }
            return this.getNext().executeInt_(frameValue, moduleValue, nameValue);
        }

        static BaseNode_ create(GetIntegerConstantNodeGen root, LookupConstantNode lookupConstantNode, GetConstantNode getConstantNode, ToIntNode toIntNode, IntegerCastNode integerCastNode) {
            return new IntegerNode_(root, lookupConstantNode, getConstantNode, toIntNode, integerCastNode);
        }
    }

    @GeneratedBy(value=GetIntegerConstantNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(GetIntegerConstantNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public int executeInt_(VirtualFrame frameValue, Object moduleValue, Object nameValue) {
            return (Integer)this.uninitialized((Frame)frameValue, moduleValue, nameValue);
        }

        static BaseNode_ create(GetIntegerConstantNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=GetIntegerConstantNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected GetIntegerConstantNodeGen root;

        BaseNode_(GetIntegerConstantNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        protected final void setRoot(Node root) {
            this.root = (GetIntegerConstantNodeGen)root;
        }

        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.module_, this.root.name_};
        }

        public final Object acceptAndExecute(Frame frameValue, Object moduleValue, Object nameValue) {
            return this.executeInt_((VirtualFrame)frameValue, moduleValue, nameValue);
        }

        public abstract int executeInt_(VirtualFrame var1, Object var2, Object var3);

        public int executeInt1(VirtualFrame frameValue, DynamicObject moduleValue, String nameValue) {
            return this.executeInt_(frameValue, moduleValue, nameValue);
        }

        public Object execute(VirtualFrame frameValue) {
            Object moduleValue_ = this.root.module_.execute(frameValue);
            Object nameValue_ = this.root.name_.execute(frameValue);
            return this.executeInt_(frameValue, moduleValue_, nameValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public int executeInt0(VirtualFrame frameValue) {
            return (Integer)this.execute(frameValue);
        }

        protected final SpecializationNode createNext(Frame frameValue, Object moduleValue, Object nameValue) {
            DynamicObject moduleValue_;
            if (moduleValue instanceof DynamicObject && nameValue instanceof String && RubyGuards.isRubyModule(moduleValue_ = (DynamicObject)moduleValue)) {
                LookupConstantNode lookupConstantNode1 = this.root.createLookupConstantNode();
                GetConstantNode getConstantNode1 = GetConstantNode.create();
                ToIntNode toIntNode1 = ToIntNode.create();
                IntegerCastNode integerCastNode1 = this.root.createIntegerCastNode();
                return IntegerNode_.create(this.root, lookupConstantNode1, getConstantNode1, toIntNode1, integerCastNode1);
            }
            return null;
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }
    }
}

