/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.parser.jruby;

import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.BlockArgNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.KeywordArgNode;
import org.jruby.ast.KeywordRestArgNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NilImplicitNode;
import org.jruby.ast.Node;
import org.jruby.ast.OptArgNode;
import org.jruby.ast.RequiredKeywordArgumentValueNode;
import org.jruby.ast.RestArgNode;
import org.jruby.ast.StarNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.IsNilNode;
import org.jruby.truffle.core.array.ArrayLiteralNode;
import org.jruby.truffle.core.array.ArraySliceNodeGen;
import org.jruby.truffle.core.array.PrimitiveArrayNodeFactory;
import org.jruby.truffle.core.cast.SplatCastNode;
import org.jruby.truffle.core.cast.SplatCastNodeGen;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.ArrayIsAtLeastAsLargeAsNode;
import org.jruby.truffle.language.arguments.MissingArgumentBehavior;
import org.jruby.truffle.language.arguments.MissingKeywordArgumentNode;
import org.jruby.truffle.language.arguments.ReadBlockNode;
import org.jruby.truffle.language.arguments.ReadKeywordArgumentNode;
import org.jruby.truffle.language.arguments.ReadKeywordRestArgumentNode;
import org.jruby.truffle.language.arguments.ReadOptionalArgumentNode;
import org.jruby.truffle.language.arguments.ReadPostArgumentNode;
import org.jruby.truffle.language.arguments.ReadPreArgumentNode;
import org.jruby.truffle.language.arguments.ReadRestArgumentNode;
import org.jruby.truffle.language.arguments.RunBlockKWArgsHelperNode;
import org.jruby.truffle.language.control.IfElseNode;
import org.jruby.truffle.language.control.IfNode;
import org.jruby.truffle.language.literal.NilLiteralNode;
import org.jruby.truffle.language.locals.LocalVariableType;
import org.jruby.truffle.language.locals.ReadLocalVariableNode;
import org.jruby.truffle.language.locals.WriteLocalVariableNode;
import org.jruby.truffle.language.parser.jruby.BodyTranslator;
import org.jruby.truffle.language.parser.jruby.ParameterCollector;
import org.jruby.truffle.language.parser.jruby.Translator;

public class LoadArgumentsTranslator
extends Translator {
    private final boolean isProc;
    private final BodyTranslator methodBodyTranslator;
    private final Deque<ArraySlot> arraySlotStack = new ArrayDeque<ArraySlot>();
    private int required;
    private int index;
    private int indexFromEnd = 1;
    private State state;
    private boolean hasKeywordArguments;
    private List<String> excludedKeywords = new ArrayList<String>();
    private boolean firstOpt = false;
    private ArgsNode argsNode;

    public LoadArgumentsTranslator(com.oracle.truffle.api.nodes.Node currentNode, RubyContext context, Source source, boolean isProc, BodyTranslator methodBodyTranslator) {
        super(currentNode, context, source);
        this.isProc = isProc;
        this.methodBodyTranslator = methodBodyTranslator;
    }

    public RubyNode visitArgsNode(ArgsNode node) {
        int preCount;
        boolean useHelper;
        this.argsNode = node;
        SourceSection sourceSection = this.translate(node.getPosition());
        ArrayList<RubyNode> sequence = new ArrayList<RubyNode>();
        Node[] args = node.getArgs();
        boolean bl = useHelper = this.useArray() && node.hasKeyRest();
        if (useHelper) {
            DynamicObject keyRestNameOrNil;
            sequence.add((RubyNode)((Object)node.getKeyRest().accept((NodeVisitor)this)));
            if (node.hasKeyRest()) {
                String name = node.getKeyRest().getName();
                this.methodBodyTranslator.getEnvironment().declareVar(name);
                keyRestNameOrNil = this.context.getSymbolTable().getSymbol(name);
            } else {
                keyRestNameOrNil = this.context.getCoreLibrary().getNilObject();
            }
            sequence.add(new IfNode(this.context, sourceSection, new ArrayIsAtLeastAsLargeAsNode(node.getPreCount() + node.getPostCount(), this.loadArray(sourceSection)), new RunBlockKWArgsHelperNode(this.arraySlotStack.peek().getArraySlot(), keyRestNameOrNil)));
        }
        if ((preCount = node.getPreCount()) > 0) {
            this.state = State.PRE;
            this.index = 0;
            for (int i = 0; i < preCount; ++i) {
                sequence.add((RubyNode)((Object)args[i].accept((NodeVisitor)this)));
                ++this.index;
                ++this.required;
            }
        }
        this.hasKeywordArguments = node.hasKwargs();
        int optArgCount = node.getOptionalArgsCount();
        if (optArgCount > 0) {
            this.state = State.OPT;
            this.index = this.argsNode.getPreCount();
            int optArgIndex = node.getOptArgIndex();
            for (int i = 0; i < optArgCount; ++i) {
                this.firstOpt = i == 0;
                sequence.add((RubyNode)((Object)args[optArgIndex + i].accept((NodeVisitor)this)));
                ++this.index;
            }
        }
        if (node.getRestArgNode() != null) {
            this.methodBodyTranslator.getEnvironment().hasRestParameter = true;
            sequence.add((RubyNode)((Object)node.getRestArgNode().accept((NodeVisitor)this)));
        }
        int postCount = node.getPostCount();
        ArrayList<RubyNode> notNilSmallerSequence = new ArrayList<RubyNode>();
        if (postCount > 0) {
            this.state = State.POST;
            Node[] children = node.getPost().children();
            this.index = node.getPreCount();
            for (int i = 0; i < children.length; ++i) {
                notNilSmallerSequence.add((RubyNode)((Object)children[i].accept((NodeVisitor)this)));
                ++this.index;
            }
        }
        RubyNode notNilSmaller = this.sequence(this.context, sourceSection, notNilSmallerSequence);
        ArrayList<RubyNode> noRestSequence = new ArrayList<RubyNode>();
        if (postCount > 0) {
            this.state = State.POST;
            Node[] children = node.getPost().children();
            this.index = node.getPreCount() + node.getOptionalArgsCount();
            for (int i = 0; i < children.length; ++i) {
                noRestSequence.add((RubyNode)((Object)children[i].accept((NodeVisitor)this)));
                ++this.index;
            }
        }
        RubyNode noRest = this.sequence(this.context, sourceSection, noRestSequence);
        ArrayList<RubyNode> notNilAtLeastAsLargeSequence = new ArrayList<RubyNode>();
        if (postCount > 0) {
            this.state = State.POST;
            this.index = -1;
            if (!this.useArray() && this.hasKeywordArguments) {
                --this.index;
            }
            int postIndex = node.getPostIndex();
            for (int i = postCount - 1; i >= 0; --i) {
                notNilAtLeastAsLargeSequence.add((RubyNode)((Object)args[postIndex + i].accept((NodeVisitor)this)));
                ++this.required;
                --this.index;
            }
        }
        RubyNode notNilAtLeastAsLarge = this.sequence(this.context, sourceSection, notNilAtLeastAsLargeSequence);
        if (this.useArray()) {
            if (node.getPreCount() == 0 || node.hasRestArg()) {
                sequence.add(new IfElseNode(this.context, sourceSection, new ArrayIsAtLeastAsLargeAsNode(node.getPreCount() + node.getPostCount(), this.loadArray(sourceSection)), notNilAtLeastAsLarge, notNilSmaller));
            } else {
                sequence.add(noRest);
            }
        } else {
            sequence.add(notNilAtLeastAsLarge);
        }
        if (this.hasKeywordArguments) {
            int keywordIndex = node.getKeywordsIndex();
            int keywordCount = node.getKeywordCount();
            for (int i = 0; i < keywordCount; ++i) {
                sequence.add((RubyNode)((Object)args[keywordIndex + i].accept((NodeVisitor)this)));
            }
        }
        if (node.getKeyRest() != null && !useHelper) {
            sequence.add((RubyNode)((Object)node.getKeyRest().accept((NodeVisitor)this)));
        }
        if (node.getBlock() != null) {
            sequence.add((RubyNode)((Object)node.getBlock().accept((NodeVisitor)this)));
        }
        return this.sequence(this.context, sourceSection, sequence);
    }

    public RubyNode visitKeywordRestArgNode(KeywordRestArgNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        ReadKeywordRestArgumentNode readNode = new ReadKeywordRestArgumentNode(this.context, sourceSection, this.required, this.excludedKeywords.toArray(new String[this.excludedKeywords.size()]));
        FrameSlot slot = this.methodBodyTranslator.getEnvironment().getFrameDescriptor().findOrAddFrameSlot((Object)node.getName());
        return WriteLocalVariableNode.createWriteLocalVariableNode(this.context, sourceSection, slot, readNode);
    }

    public RubyNode visitKeywordArgNode(KeywordArgNode node) {
        String name;
        LocalAsgnNode asgnNode;
        SourceSection sourceSection = this.translate(node.getPosition());
        Node firstChild = (Node)node.childNodes().get(0);
        if (firstChild instanceof LocalAsgnNode) {
            asgnNode = (LocalAsgnNode)firstChild;
            name = ((LocalAsgnNode)firstChild).getName();
        } else if (firstChild instanceof DAsgnNode) {
            asgnNode = (DAsgnNode)firstChild;
            name = ((DAsgnNode)firstChild).getName();
        } else {
            throw new UnsupportedOperationException("unsupported keyword arg " + node);
        }
        FrameSlot slot = this.methodBodyTranslator.getEnvironment().getFrameDescriptor().findOrAddFrameSlot((Object)name);
        RubyNode defaultValue = asgnNode.getValueNode() instanceof RequiredKeywordArgumentValueNode ? new MissingKeywordArgumentNode(name) : this.translateNodeOrNil(sourceSection, asgnNode.getValueNode());
        this.excludedKeywords.add(name);
        ReadKeywordArgumentNode readNode = new ReadKeywordArgumentNode(this.context, sourceSection, this.required, name, defaultValue);
        return WriteLocalVariableNode.createWriteLocalVariableNode(this.context, sourceSection, slot, readNode);
    }

    public RubyNode visitArgumentNode(ArgumentNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode readNode = this.readArgument(sourceSection);
        FrameSlot slot = this.methodBodyTranslator.getEnvironment().getFrameDescriptor().findFrameSlot((Object)node.getName());
        return WriteLocalVariableNode.createWriteLocalVariableNode(this.context, sourceSection, slot, readNode);
    }

    private RubyNode readArgument(SourceSection sourceSection) {
        if (this.useArray()) {
            return PrimitiveArrayNodeFactory.read(this.context, sourceSection, this.loadArray(sourceSection), this.index);
        }
        if (this.state == State.PRE) {
            return new ReadPreArgumentNode(this.index, this.isProc ? MissingArgumentBehavior.NIL : MissingArgumentBehavior.RUNTIME_ERROR);
        }
        if (this.state == State.POST) {
            return new ReadPostArgumentNode(-this.index);
        }
        throw new IllegalStateException();
    }

    public RubyNode visitRestArgNode(RestArgNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        if (this.argsNode == null) {
            throw new IllegalStateException("No arguments node visited");
        }
        int from = this.argsNode.getPreCount() + this.argsNode.getOptionalArgsCount();
        int to = -this.argsNode.getPostCount();
        RubyNode readNode = this.useArray() ? ArraySliceNodeGen.create(this.context, sourceSection, from, to, this.loadArray(sourceSection)) : new ReadRestArgumentNode(this.context, sourceSection, from, -to, this.hasKeywordArguments, this.required);
        FrameSlot slot = this.methodBodyTranslator.getEnvironment().getFrameDescriptor().findFrameSlot((Object)node.getName());
        return WriteLocalVariableNode.createWriteLocalVariableNode(this.context, sourceSection, slot, readNode);
    }

    public RubyNode visitBlockArgNode(BlockArgNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        ReadBlockNode readNode = new ReadBlockNode(this.context.getCoreLibrary().getNilObject());
        FrameSlot slot = this.methodBodyTranslator.getEnvironment().getFrameDescriptor().findFrameSlot((Object)node.getName());
        return WriteLocalVariableNode.createWriteLocalVariableNode(this.context, sourceSection, slot, readNode);
    }

    public RubyNode visitOptArgNode(OptArgNode node) {
        return (RubyNode)((Object)node.getValue().accept((NodeVisitor)this));
    }

    public RubyNode visitLocalAsgnNode(LocalAsgnNode node) {
        return this.translateLocalAssignment(node.getPosition(), node.getName(), node.getValueNode());
    }

    public RubyNode visitDAsgnNode(DAsgnNode node) {
        return this.translateLocalAssignment(node.getPosition(), node.getName(), node.getValueNode());
    }

    private RubyNode translateLocalAssignment(ISourcePosition sourcePosition, String name, Node valueNode) {
        RubyNode readNode;
        SourceSection sourceSection = this.translate(sourcePosition);
        FrameSlot slot = this.methodBodyTranslator.getEnvironment().getFrameDescriptor().findOrAddFrameSlot((Object)name);
        if (this.indexFromEnd == 1) {
            if (valueNode instanceof NilImplicitNode) {
                readNode = this.useArray() ? PrimitiveArrayNodeFactory.read(this.context, sourceSection, this.loadArray(sourceSection), this.index) : this.readArgument(sourceSection);
            } else {
                String calledName;
                RubyNode defaultValue = valueNode instanceof VCallNode ? ((calledName = ((VCallNode)valueNode).getName()).equals(name) ? new ReadLocalVariableNode(this.context, sourceSection, LocalVariableType.FRAME_LOCAL, slot) : (RubyNode)((Object)valueNode.accept((NodeVisitor)this))) : (RubyNode)((Object)valueNode.accept((NodeVisitor)this));
                if (this.argsNode == null) {
                    throw new IllegalStateException("No arguments node visited");
                }
                int minimum = this.index + 1 + this.argsNode.getPostCount();
                if (this.useArray()) {
                    readNode = new IfElseNode(this.context, sourceSection, new ArrayIsAtLeastAsLargeAsNode(minimum, this.loadArray(sourceSection)), PrimitiveArrayNodeFactory.read(this.context, sourceSection, this.loadArray(sourceSection), this.index), defaultValue);
                } else {
                    ReadRestArgumentNode readRest;
                    boolean considerRejectedKWArgs;
                    if (this.argsNode.hasKwargs()) {
                        ++minimum;
                    }
                    if (this.firstOpt && this.hasKeywordArguments) {
                        considerRejectedKWArgs = true;
                        int from = this.argsNode.getPreCount() + this.argsNode.getOptionalArgsCount();
                        int to = -this.argsNode.getPostCount();
                        readRest = new ReadRestArgumentNode(this.context, sourceSection, from, -to, this.hasKeywordArguments, this.required);
                    } else {
                        considerRejectedKWArgs = false;
                        readRest = null;
                    }
                    readNode = new ReadOptionalArgumentNode(this.context, sourceSection, this.index, minimum, considerRejectedKWArgs, this.argsNode.hasKwargs(), this.required, readRest, defaultValue);
                }
            }
        } else {
            readNode = ArraySliceNodeGen.create(this.context, sourceSection, this.index, this.indexFromEnd, this.loadArray(sourceSection));
        }
        return WriteLocalVariableNode.createWriteLocalVariableNode(this.context, sourceSection, slot, readNode);
    }

    public RubyNode visitArrayNode(ArrayNode node) {
        if (node.size() == 1 && node.get(0) instanceof MultipleAsgnNode) {
            return (RubyNode)((Object)node.children()[0].accept((NodeVisitor)this));
        }
        return this.defaultVisit((Node)node);
    }

    public RubyNode visitMultipleAsgnNode(MultipleAsgnNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        int arrayIndex = this.index;
        String arrayName = this.methodBodyTranslator.getEnvironment().allocateLocalTemp("destructure");
        FrameSlot arraySlot = this.methodBodyTranslator.getEnvironment().declareVar(arrayName);
        this.pushArraySlot(arraySlot);
        List childNodes = node.childNodes() == null || node.childNodes().get(0) == null ? Collections.emptyList() : ((Node)node.childNodes().get(0)).childNodes();
        ArrayList<RubyNode> notNilSmallerSequence = new ArrayList<RubyNode>();
        if (node.getPre() != null) {
            this.index = 0;
            for (Node child : node.getPre().children()) {
                notNilSmallerSequence.add((RubyNode)((Object)child.accept((NodeVisitor)this)));
                ++this.index;
            }
        }
        if (node.getRest() != null) {
            this.index = node.getPreCount();
            this.indexFromEnd = -node.getPostCount();
            notNilSmallerSequence.add((RubyNode)((Object)node.getRest().accept((NodeVisitor)this)));
            this.indexFromEnd = 1;
        }
        if (node.getPost() != null) {
            Node[] children = node.getPost().children();
            this.index = node.getPreCount();
            for (int i = 0; i < children.length; ++i) {
                notNilSmallerSequence.add((RubyNode)((Object)children[i].accept((NodeVisitor)this)));
                ++this.index;
            }
        }
        RubyNode notNilSmaller = this.sequence(this.context, sourceSection, notNilSmallerSequence);
        ArrayList<RubyNode> notNilAtLeastAsLargeSequence = new ArrayList<RubyNode>();
        if (node.getPre() != null) {
            this.index = 0;
            for (Node node2 : node.getPre().children()) {
                notNilAtLeastAsLargeSequence.add((RubyNode)((Object)node2.accept((NodeVisitor)this)));
                ++this.index;
            }
        }
        if (node.getRest() != null) {
            this.index = node.getPreCount();
            this.indexFromEnd = -node.getPostCount();
            notNilAtLeastAsLargeSequence.add((RubyNode)((Object)node.getRest().accept((NodeVisitor)this)));
            this.indexFromEnd = 1;
        }
        if (node.getPost() != null) {
            Node[] children = node.getPost().children();
            this.index = -1;
            for (int i = children.length - 1; i >= 0; --i) {
                notNilAtLeastAsLargeSequence.add((RubyNode)((Object)children[i].accept((NodeVisitor)this)));
                --this.index;
            }
        }
        RubyNode notNilAtLeastAsLarge = this.sequence(this.context, sourceSection, notNilAtLeastAsLargeSequence);
        this.popArraySlot(arraySlot);
        ArrayList<RubyNode> nilSequence = new ArrayList<RubyNode>();
        ParameterCollector parametersToClearCollector = new ParameterCollector();
        if (node.getPre() != null) {
            for (Node child : node.getPre().children()) {
                child.accept((NodeVisitor)parametersToClearCollector);
            }
        }
        if (node.getRest() != null) {
            if (node.getRest() instanceof INameNode) {
                String string = ((INameNode)node.getRest()).getName();
                if (node.getPreCount() == 0 && node.getPostCount() == 0) {
                    nilSequence.add(this.methodBodyTranslator.getEnvironment().findOrAddLocalVarNodeDangerous(string, sourceSection).makeWriteNode(ArrayLiteralNode.create(this.context, sourceSection, new RubyNode[]{new NilLiteralNode(this.context, sourceSection, true)})));
                } else {
                    nilSequence.add(this.methodBodyTranslator.getEnvironment().findOrAddLocalVarNodeDangerous(string, sourceSection).makeWriteNode(ArrayLiteralNode.create(this.context, sourceSection, new RubyNode[0])));
                }
            } else if (!(node.getRest() instanceof StarNode)) {
                throw new UnsupportedOperationException("unsupported rest node " + node.getRest());
            }
        }
        if (node.getPost() != null) {
            for (Node child : node.getPost().children()) {
                child.accept((NodeVisitor)parametersToClearCollector);
            }
        }
        for (String parameterToClear : parametersToClearCollector.getParameters()) {
            nilSequence.add(this.methodBodyTranslator.getEnvironment().findOrAddLocalVarNodeDangerous(parameterToClear, sourceSection).makeWriteNode(this.nilNode(sourceSection)));
        }
        if (!childNodes.isEmpty()) {
            this.index = arrayIndex;
            nilSequence.add((RubyNode)((Object)((Node)childNodes.get(0)).accept((NodeVisitor)this)));
        }
        RubyNode rubyNode = this.sequence(this.context, sourceSection, nilSequence);
        return this.sequence(this.context, sourceSection, Arrays.asList(new RubyNode[]{WriteLocalVariableNode.createWriteLocalVariableNode(this.context, sourceSection, arraySlot, SplatCastNodeGen.create(this.context, sourceSection, SplatCastNode.NilBehavior.ARRAY_WITH_NIL, true, this.readArgument(sourceSection))), new IfElseNode(this.context, sourceSection, new IsNilNode(this.context, sourceSection, new ReadLocalVariableNode(this.context, sourceSection, LocalVariableType.FRAME_LOCAL, arraySlot)), rubyNode, new IfElseNode(this.context, sourceSection, new ArrayIsAtLeastAsLargeAsNode(node.getPreCount() + node.getPostCount(), new ReadLocalVariableNode(this.context, sourceSection, LocalVariableType.FRAME_LOCAL, arraySlot)), notNilAtLeastAsLarge, notNilSmaller))}));
    }

    protected RubyNode defaultVisit(Node node) {
        return (RubyNode)((Object)node.accept((NodeVisitor)this.methodBodyTranslator));
    }

    public void pushArraySlot(FrameSlot slot) {
        this.arraySlotStack.push(new ArraySlot(slot, this.index));
    }

    public void popArraySlot(FrameSlot slot) {
        this.index = this.arraySlotStack.pop().getPreviousIndex();
    }

    protected boolean useArray() {
        return !this.arraySlotStack.isEmpty();
    }

    protected RubyNode loadArray(SourceSection sourceSection) {
        return new ReadLocalVariableNode(this.context, sourceSection, LocalVariableType.FRAME_LOCAL, this.arraySlotStack.peek().getArraySlot());
    }

    @Override
    protected String getIdentifier() {
        return this.methodBodyTranslator.getIdentifier();
    }

    private static enum State {
        PRE,
        OPT,
        POST;

    }

    private static class ArraySlot {
        private FrameSlot arraySlot;
        private int previousIndex;

        public ArraySlot(FrameSlot arraySlot, int previousIndex) {
            this.arraySlot = arraySlot;
            this.previousIndex = previousIndex;
        }

        public FrameSlot getArraySlot() {
            return this.arraySlot;
        }

        public int getPreviousIndex() {
            return this.previousIndex;
        }
    }
}

