/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.basicobject;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.builtins.UnaryCoreMethodNode;
import org.jruby.truffle.core.array.ArrayHelpers;
import org.jruby.truffle.core.basicobject.BasicObjectNodesFactory;
import org.jruby.truffle.core.cast.BooleanCastNodeGen;
import org.jruby.truffle.core.module.ModuleOperations;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyRootNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.language.dispatch.MissingBehavior;
import org.jruby.truffle.language.dispatch.RubyCallNode;
import org.jruby.truffle.language.loader.CodeLoader;
import org.jruby.truffle.language.methods.DeclarationContext;
import org.jruby.truffle.language.methods.InternalMethod;
import org.jruby.truffle.language.methods.UnsupportedOperationBehavior;
import org.jruby.truffle.language.objects.AllocateObjectNode;
import org.jruby.truffle.language.parser.ParserContext;
import org.jruby.truffle.language.supercall.SuperCallNode;
import org.jruby.truffle.language.yield.YieldNode;
import org.jruby.truffle.util.StringUtils;

@CoreClass(value="BasicObject")
public abstract class BasicObjectNodes {

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode = AllocateObjectNode.create();

        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return this.allocateObjectNode.allocate(rubyClass, new Object[0]);
        }
    }

    @CoreMethod(names={"__send__"}, needsBlock=true, rest=true, required=1)
    public static abstract class SendNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode dispatchNode;

        public SendNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.dispatchNode = new CallDispatchHeadNode(context, true, MissingBehavior.CALL_METHOD_MISSING);
        }

        @Specialization
        public Object send(VirtualFrame frame, Object self, Object name, Object[] args, NotProvided block) {
            return this.send(frame, self, name, args, (DynamicObject)null);
        }

        @Specialization
        public Object send(VirtualFrame frame, Object self, Object name, Object[] args, DynamicObject block) {
            return this.dispatchNode.callWithBlock(frame, self, name, block, args);
        }
    }

    @CoreMethod(names={"method_missing"}, needsBlock=true, rest=true, optional=1, visibility=Visibility.PRIVATE)
    public static abstract class MethodMissingNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public Object methodMissingNoName(Object self, NotProvided name, Object[] args, NotProvided block) {
            throw new RaiseException(this.coreExceptions().argumentError("no id given", this));
        }

        @Specialization
        public Object methodMissingNoBlock(Object self, DynamicObject name, Object[] args, NotProvided block) {
            return this.methodMissing(self, name, args, null);
        }

        @Specialization
        public Object methodMissingBlock(Object self, DynamicObject name, Object[] args, DynamicObject block) {
            return this.methodMissing(self, name, args, block);
        }

        private Object methodMissing(Object self, DynamicObject nameObject, Object[] args, DynamicObject block) {
            throw new RaiseException(this.buildMethodMissingException(self, nameObject, args, block));
        }

        @CompilerDirectives.TruffleBoundary
        private DynamicObject buildMethodMissingException(Object self, DynamicObject nameObject, Object[] args, DynamicObject block) {
            String name = nameObject.toString();
            FrameInstance relevantCallerFrame = this.getRelevantCallerFrame();
            if (this.lastCallWasSuper(relevantCallerFrame)) {
                return this.coreExceptions().noSuperMethodError(name, self, args, this);
            }
            if (this.lastCallWasCallingPrivateMethod(self, name)) {
                return this.coreExceptions().privateMethodError(name, self, args, this);
            }
            if (this.lastCallWasVCall(relevantCallerFrame)) {
                return this.coreExceptions().nameErrorUndefinedLocalVariableOrMethod(name, self, this);
            }
            return this.coreExceptions().noMethodErrorOnReceiver(name, self, args, this);
        }

        private FrameInstance getRelevantCallerFrame() {
            return (FrameInstance)Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<FrameInstance>(){

                public FrameInstance visitFrame(FrameInstance frameInstance) {
                    Node callNode = frameInstance.getCallNode();
                    if (callNode == null) {
                        return null;
                    }
                    SuperCallNode superCallNode = (SuperCallNode)((Object)NodeUtil.findParent((Node)callNode, SuperCallNode.class));
                    Frame frame = frameInstance.getFrame(FrameInstance.FrameAccess.READ_ONLY, true);
                    String superMethodName = RubyArguments.getMethod(frame).getName();
                    if (superCallNode != null && superMethodName.equals("method_missing")) {
                        return null;
                    }
                    return frameInstance;
                }
            });
        }

        private boolean lastCallWasSuper(FrameInstance callerFrame) {
            SuperCallNode superCallNode = (SuperCallNode)((Object)NodeUtil.findParent((Node)callerFrame.getCallNode(), SuperCallNode.class));
            return superCallNode != null;
        }

        private boolean lastCallWasCallingPrivateMethod(Object self, String name) {
            InternalMethod method = ModuleOperations.lookupMethod(this.coreLibrary().getMetaClass(self), name);
            return method != null && !method.isUndefined();
        }

        private boolean lastCallWasVCall(FrameInstance callerFrame) {
            RubyCallNode callNode = (RubyCallNode)((Object)NodeUtil.findParent((Node)callerFrame.getCallNode(), RubyCallNode.class));
            return callNode != null && callNode.isVCall();
        }
    }

    @CoreMethod(names={"__instance_variables__"})
    public static abstract class InstanceVariablesNode
    extends CoreMethodArrayArgumentsNode {
        public abstract DynamicObject execute(Object var1);

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isNil(self)", "!isRubySymbol(self)"})
        public DynamicObject instanceVariables(DynamicObject self) {
            List keys = self.getShape().getKeyList();
            Object[] instanceVariableNames = keys.toArray(new Object[keys.size()]);
            Arrays.sort(instanceVariableNames);
            ArrayList<DynamicObject> names = new ArrayList<DynamicObject>();
            for (Object name : instanceVariableNames) {
                if (!(name instanceof String)) continue;
                names.add(this.getSymbol((String)name));
            }
            int size = names.size();
            return ArrayHelpers.createArray(this.getContext(), names.toArray(new Object[size]), size);
        }

        @Specialization
        public DynamicObject instanceVariables(int self) {
            return ArrayHelpers.createArray(this.getContext(), null, 0);
        }

        @Specialization
        public DynamicObject instanceVariables(long self) {
            return ArrayHelpers.createArray(this.getContext(), null, 0);
        }

        @Specialization
        public DynamicObject instanceVariables(boolean self) {
            return ArrayHelpers.createArray(this.getContext(), null, 0);
        }

        @Specialization(guards={"isNil(object)"})
        public DynamicObject instanceVariablesNil(DynamicObject object) {
            return ArrayHelpers.createArray(this.getContext(), null, 0);
        }

        @Specialization(guards={"isRubySymbol(object)"})
        public DynamicObject instanceVariablesSymbol(DynamicObject object) {
            return ArrayHelpers.createArray(this.getContext(), null, 0);
        }
    }

    @CoreMethod(names={"instance_exec"}, needsBlock=true, rest=true)
    public static abstract class InstanceExecNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private YieldNode yield;

        public InstanceExecNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.yield = new YieldNode(context, DeclarationContext.INSTANCE_EVAL);
        }

        @Specialization
        public Object instanceExec(VirtualFrame frame, Object receiver, Object[] arguments, DynamicObject block) {
            return this.yield.dispatchWithModifiedSelf(frame, block, receiver, arguments);
        }

        @Specialization
        public Object instanceExec(Object receiver, Object[] arguments, NotProvided block) {
            throw new RaiseException(this.coreExceptions().localJumpError("no block given", this));
        }
    }

    @CoreMethod(names={"instance_eval"}, needsBlock=true, optional=3, unsupportedOperationBehavior=UnsupportedOperationBehavior.ARGUMENT_ERROR)
    public static abstract class InstanceEvalNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private YieldNode yield;

        public InstanceEvalNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.yield = new YieldNode(context, DeclarationContext.INSTANCE_EVAL);
        }

        @Specialization(guards={"isRubyString(string)", "isRubyString(fileName)"})
        public Object instanceEval(VirtualFrame frame, Object receiver, DynamicObject string, DynamicObject fileName, int line, NotProvided block, @Cached(value="create()") IndirectCallNode callNode) {
            Rope code = StringOperations.rope(string);
            String space = this.getSpace(line);
            Source source = this.loadFragment(space + code.toString(), StringOperations.rope(fileName).toString());
            RubyRootNode rootNode = this.getContext().getCodeLoader().parse(source, code.getEncoding(), ParserContext.EVAL, null, true, this);
            CodeLoader.DeferredCall deferredCall = this.getContext().getCodeLoader().prepareExecute(ParserContext.EVAL, DeclarationContext.INSTANCE_EVAL, rootNode, null, receiver);
            return deferredCall.call(frame, callNode);
        }

        @Specialization(guards={"isRubyString(string)", "isRubyString(fileName)"})
        public Object instanceEval(VirtualFrame frame, Object receiver, DynamicObject string, DynamicObject fileName, NotProvided line, NotProvided block, @Cached(value="create()") IndirectCallNode callNode) {
            return this.instanceEval(frame, receiver, string, fileName, 1, block, callNode);
        }

        @Specialization(guards={"isRubyString(string)"})
        public Object instanceEval(VirtualFrame frame, Object receiver, DynamicObject string, NotProvided fileName, NotProvided line, NotProvided block, @Cached(value="create()") IndirectCallNode callNode) {
            DynamicObject eval = StringOperations.createString(this.getContext(), StringOperations.encodeRope("(eval)", (Encoding)ASCIIEncoding.INSTANCE));
            return this.instanceEval(frame, receiver, string, eval, 1, block, callNode);
        }

        @Specialization
        public Object instanceEval(VirtualFrame frame, Object receiver, NotProvided string, NotProvided fileName, NotProvided line, DynamicObject block) {
            return this.yield.dispatchWithModifiedSelf(frame, block, receiver, receiver);
        }

        @CompilerDirectives.TruffleBoundary
        private String getSpace(int line) {
            String s = new String(new char[Math.max(line - 1, 0)]);
            return StringUtils.replace(s, "\u0000", "\n");
        }

        @CompilerDirectives.TruffleBoundary
        private Source loadFragment(String fragment, String name) {
            return this.getContext().getSourceLoader().loadFragment(fragment, name);
        }
    }

    @CoreMethod(names={"initialize"}, needsSelf=false)
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject initialize() {
            return this.nil();
        }
    }

    @CoreMethod(names={"equal?", "=="}, required=1)
    public static abstract class ReferenceEqualNode
    extends CoreMethodArrayArgumentsNode {
        public static ReferenceEqualNode create() {
            return BasicObjectNodesFactory.ReferenceEqualNodeFactory.create(null);
        }

        public abstract boolean executeReferenceEqual(Object var1, Object var2);

        @Specialization
        public boolean equal(boolean a, boolean b) {
            return a == b;
        }

        @Specialization
        public boolean equal(int a, int b) {
            return a == b;
        }

        @Specialization
        public boolean equal(long a, long b) {
            return a == b;
        }

        @Specialization
        public boolean equal(double a, double b) {
            return Double.doubleToRawLongBits(a) == Double.doubleToRawLongBits(b);
        }

        @Specialization
        public boolean equal(DynamicObject a, DynamicObject b) {
            return a == b;
        }

        @Specialization(guards={"isNotDynamicObject(a)", "isNotDynamicObject(b)", "notSameClass(a, b)"})
        public boolean equal(Object a, Object b) {
            return false;
        }

        @Specialization(guards={"isNotDynamicObject(a)"})
        public boolean equal(Object a, DynamicObject b) {
            return false;
        }

        @Specialization(guards={"isNotDynamicObject(b)"})
        public boolean equal(DynamicObject a, Object b) {
            return false;
        }

        protected boolean isNotDynamicObject(Object value) {
            return !(value instanceof DynamicObject);
        }

        protected boolean notSameClass(Object a, Object b) {
            return a.getClass() != b.getClass();
        }
    }

    @CoreMethod(names={"!="}, required=1)
    public static abstract class NotEqualNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode equalNode;

        public NotEqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.equalNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization
        public boolean equal(VirtualFrame frame, Object a, Object b) {
            return !this.equalNode.callBoolean(frame, a, "==", null, b);
        }
    }

    @CoreMethod(names={"!"})
    public static abstract class NotNode
    extends UnaryCoreMethodNode {
        @CreateCast(value={"operand"})
        public RubyNode createCast(RubyNode operand) {
            return BooleanCastNodeGen.create(operand);
        }

        @Specialization
        public boolean not(boolean value) {
            return !value;
        }
    }
}

