/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.builtins;

import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.List;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CallPrimitiveNode;
import org.jruby.truffle.builtins.CoreMethodNodeManager;
import org.jruby.truffle.builtins.InvokePrimitiveNode;
import org.jruby.truffle.builtins.Primitive;
import org.jruby.truffle.builtins.PrimitiveConstructor;
import org.jruby.truffle.builtins.UnsafeNode;
import org.jruby.truffle.core.array.ArrayUtils;
import org.jruby.truffle.core.numeric.FixnumLowerNodeGen;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.MissingArgumentBehavior;
import org.jruby.truffle.language.arguments.ReadPreArgumentNode;
import org.jruby.truffle.language.control.ReturnID;
import org.jruby.truffle.language.objects.SelfNode;

public class PrimitiveNodeConstructor
implements PrimitiveConstructor {
    private final Primitive annotation;
    private final NodeFactory<? extends RubyNode> factory;

    public PrimitiveNodeConstructor(Primitive annotation, NodeFactory<? extends RubyNode> factory) {
        this.annotation = annotation;
        this.factory = factory;
    }

    @Override
    public int getPrimitiveArity() {
        return this.factory.getExecutionSignature().size();
    }

    @Override
    public RubyNode createCallPrimitiveNode(RubyContext context, SourceSection sourceSection, ReturnID returnID) {
        int argumentsCount = this.getPrimitiveArity();
        ArrayList<RubyNode> arguments = new ArrayList<RubyNode>(argumentsCount);
        List signatures = this.factory.getNodeSignatures();
        assert (signatures.size() == 1);
        List signature = (List)signatures.get(0);
        if (this.annotation.needsSelf()) {
            arguments.add(new SelfNode(context, sourceSection));
            --argumentsCount;
        }
        for (int n = 0; n < argumentsCount; ++n) {
            ReadPreArgumentNode readArgumentNode = new ReadPreArgumentNode(n, MissingArgumentBehavior.UNDEFINED);
            arguments.add(this.transformArgument(readArgumentNode, n));
        }
        if (!CoreMethodNodeManager.isSafe(context, this.annotation.unsafe())) {
            return new UnsafeNode(context, sourceSection);
        }
        if (signature.size() >= 3 && signature.get(2) == RubyNode[].class) {
            return new CallPrimitiveNode(context, sourceSection, (RubyNode)((Object)this.factory.createNode(new Object[]{context, sourceSection, arguments.toArray(new RubyNode[arguments.size()])})), returnID);
        }
        if (signature.size() == 1 && signature.get(0) == RubyNode[].class) {
            return new CallPrimitiveNode(context, sourceSection, (RubyNode)((Object)this.factory.createNode(new Object[]{arguments.toArray(new RubyNode[arguments.size()])})), returnID);
        }
        if (signature.size() == 0) {
            return new CallPrimitiveNode(context, sourceSection, (RubyNode)((Object)this.factory.createNode(new Object[0])), returnID);
        }
        if (signature.get(0) != RubyContext.class) {
            Object[] varargs = new Object[arguments.size()];
            System.arraycopy(arguments.toArray(new RubyNode[arguments.size()]), 0, varargs, 0, arguments.size());
            return new CallPrimitiveNode(context, sourceSection, (RubyNode)((Object)this.factory.createNode(varargs)), returnID);
        }
        Object[] varargs = new Object[2 + arguments.size()];
        varargs[0] = context;
        varargs[1] = sourceSection;
        System.arraycopy(arguments.toArray(new RubyNode[arguments.size()]), 0, varargs, 2, arguments.size());
        return new CallPrimitiveNode(context, sourceSection, (RubyNode)((Object)this.factory.createNode(varargs)), returnID);
    }

    @Override
    public RubyNode createInvokePrimitiveNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
        if (!CoreMethodNodeManager.isSafe(context, this.annotation.unsafe())) {
            return new UnsafeNode(context, sourceSection);
        }
        for (int n = 1; n < arguments.length; ++n) {
            arguments[n] = this.transformArgument(arguments[n], n);
        }
        List signatures = this.factory.getNodeSignatures();
        assert (signatures.size() == 1);
        List signature = (List)signatures.get(0);
        if (signature.get(0) == RubyContext.class) {
            return new InvokePrimitiveNode(context, sourceSection, (RubyNode)((Object)this.factory.createNode(new Object[]{context, sourceSection, arguments})));
        }
        return new InvokePrimitiveNode(context, sourceSection, (RubyNode)((Object)this.factory.createNode(new Object[]{arguments})));
    }

    private RubyNode transformArgument(RubyNode argument, int n) {
        if (ArrayUtils.contains(this.annotation.lowerFixnumParameters(), n)) {
            return FixnumLowerNodeGen.create(null, null, argument);
        }
        return argument;
    }
}

