/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.stdlib;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyFixnum;
import org.jruby.RubyRational;
import org.jruby.ext.bigdecimal.RubyBigDecimal;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.CoreClass;
import org.jruby.truffle.core.CoreMethod;
import org.jruby.truffle.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.CoreMethodNode;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.cast.BooleanCastNode;
import org.jruby.truffle.core.cast.BooleanCastNodeGen;
import org.jruby.truffle.core.cast.IntegerCastNode;
import org.jruby.truffle.core.cast.IntegerCastNodeGen;
import org.jruby.truffle.core.cast.ToIntNode;
import org.jruby.truffle.core.numeric.FixnumOrBignumNode;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.SnippetNode;
import org.jruby.truffle.language.constants.ReadConstantNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.stdlib.BigDecimalNodesFactory;

@CoreClass(name="Truffle::BigDecimal")
public abstract class BigDecimalNodes {
    public static BigDecimal getBigDecimalValue(long v) {
        return BigDecimal.valueOf(v);
    }

    public static BigDecimal getBigDecimalValue(double v) {
        return BigDecimal.valueOf(v);
    }

    public static BigDecimal getBignumBigDecimalValue(DynamicObject v) {
        return new BigDecimal(Layouts.BIGNUM.getValue(v));
    }

    public static RoundingMode toRoundingMode(int constValue) {
        switch (constValue) {
            case 1: {
                return RoundingMode.UP;
            }
            case 2: {
                return RoundingMode.DOWN;
            }
            case 3: {
                return RoundingMode.HALF_UP;
            }
            case 4: {
                return RoundingMode.HALF_DOWN;
            }
            case 5: {
                return RoundingMode.CEILING;
            }
            case 6: {
                return RoundingMode.FLOOR;
            }
            case 7: {
                return RoundingMode.HALF_EVEN;
            }
        }
        throw new UnsupportedOperationException("unknown value: " + constValue);
    }

    private static int nearestBiggerMultipleOf4(int value) {
        return (value / 4 + 1) * 4;
    }

    public static int defaultDivisionPrecision(int precisionA, int precisionB, int limit) {
        int combination = BigDecimalNodes.nearestBiggerMultipleOf4(precisionA + precisionB) * 4;
        return limit > 0 && limit < combination ? limit : combination;
    }

    public static int defaultDivisionPrecision(BigDecimal a, BigDecimal b, int limit) {
        return BigDecimalNodes.defaultDivisionPrecision(a.precision(), b.precision(), limit);
    }

    public static abstract class RoundModeNode
    extends BigDecimalCoreMethodNode {
        @Specialization
        public RoundingMode doGetRoundMode(VirtualFrame frame) {
            return this.getRoundMode(frame);
        }
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return Layouts.BIG_DECIMAL.createBigDecimal(Layouts.CLASS.getInstanceFactory(rubyClass), BigDecimal.ZERO, Type.NORMAL);
        }
    }

    @NodeChildren(value={@NodeChild(value="value", type=RubyNode.class), @NodeChild(value="roundingMode", type=RoundModeNode.class), @NodeChild(value="cast", type=BigDecimalCastNode.class, executeWith={"value", "roundingMode"})})
    public static abstract class BigDecimalCoerceNode
    extends RubyNode {
        @Node.Child
        private CreateBigDecimalNode createBigDecimal;

        public static BigDecimalCoerceNode create(RubyContext context, SourceSection sourceSection, RubyNode value) {
            return BigDecimalNodesFactory.BigDecimalCoerceNodeGen.create(value, BigDecimalNodesFactory.RoundModeNodeFactory.create(), BigDecimalNodesFactory.BigDecimalCastNodeGen.create(context, sourceSection, null, null));
        }

        private void setupCreateBigDecimal() {
            if (this.createBigDecimal == null) {
                CompilerDirectives.transferToInterpreter();
                this.createBigDecimal = (CreateBigDecimalNode)this.insert(BigDecimalNodesFactory.CreateBigDecimalNodeFactory.create(this.getContext(), this.getSourceSection(), null, null, null));
            }
        }

        protected DynamicObject createBigDecimal(VirtualFrame frame, Object value) {
            this.setupCreateBigDecimal();
            return this.createBigDecimal.executeCreate(frame, value);
        }

        public abstract DynamicObject executeBigDecimal(VirtualFrame var1, RoundingMode var2, Object var3);

        @Specialization
        public DynamicObject doBigDecimal(VirtualFrame frame, Object value, RoundingMode roundingMode, BigDecimal cast) {
            return this.createBigDecimal(frame, cast);
        }

        @Specialization(guards={"isRubyBigDecimal(value)", "isNil(cast)"})
        public Object doBigDecimal(DynamicObject value, RoundingMode roundingMode, DynamicObject cast) {
            return value;
        }
    }

    @ImportStatic(value={BigDecimalCoreMethodNode.class})
    @NodeChildren(value={@NodeChild(value="value", type=RubyNode.class), @NodeChild(value="roundingMode", type=RubyNode.class)})
    public static abstract class BigDecimalCastNode
    extends RubyNode {
        public BigDecimalCastNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract BigDecimal executeBigDecimal(VirtualFrame var1, Object var2, RoundingMode var3);

        public abstract Object executeObject(VirtualFrame var1, Object var2, RoundingMode var3);

        @Specialization
        public BigDecimal doInt(long value, Object roundingMode) {
            return BigDecimal.valueOf(value);
        }

        @Specialization
        public BigDecimal doDouble(double value, Object roundingMode) {
            return BigDecimal.valueOf(value);
        }

        @Specialization(guards={"isRubyBignum(value)"})
        public BigDecimal doBignum(DynamicObject value, Object roundingMode) {
            return new BigDecimal(Layouts.BIGNUM.getValue(value));
        }

        @Specialization(guards={"isNormalRubyBigDecimal(value)"})
        public BigDecimal doBigDecimal(DynamicObject value, Object roundingMode) {
            return Layouts.BIG_DECIMAL.getValue(value);
        }

        @Specialization(guards={"!isRubyBignum(value)", "!isRubyBigDecimal(value)"})
        public Object doOther(VirtualFrame frame, DynamicObject value, Object roundingMode, @Cached(value="new()") SnippetNode isRationalSnippet, @Cached(value="createMethodCall()") CallDispatchHeadNode numeratorCallNode, @Cached(value="createMethodCall()") CallDispatchHeadNode denominatorCallNode, @Cached(value="createMethodCall()") CallDispatchHeadNode toFCallNode) {
            if (roundingMode instanceof RoundingMode && ((Boolean)isRationalSnippet.execute(frame, "value.is_a?(Rational)", "value", value)).booleanValue()) {
                RubyBigDecimal rubyBigDecimalValue;
                RubyFixnum denominatorValue;
                RubyFixnum numeratorValue;
                Object numerator = numeratorCallNode.call(frame, value, "numerator", null, new Object[0]);
                if (numerator instanceof Integer) {
                    numeratorValue = RubyFixnum.newFixnum((Ruby)this.getContext().getJRubyRuntime(), (long)((Integer)numerator).intValue());
                } else if (numerator instanceof Long) {
                    numeratorValue = RubyFixnum.newFixnum((Ruby)this.getContext().getJRubyRuntime(), (long)((Long)numerator));
                } else if (RubyGuards.isRubyBignum(numerator)) {
                    numeratorValue = RubyBignum.newBignum((Ruby)this.getContext().getJRubyRuntime(), (BigInteger)Layouts.BIGNUM.getValue((DynamicObject)numerator));
                } else {
                    throw new UnsupportedOperationException(numerator.toString());
                }
                Object denominator = denominatorCallNode.call(frame, value, "denominator", null, new Object[0]);
                if (denominator instanceof Integer) {
                    denominatorValue = RubyFixnum.newFixnum((Ruby)this.getContext().getJRubyRuntime(), (long)((Integer)denominator).intValue());
                } else if (denominator instanceof Long) {
                    denominatorValue = RubyFixnum.newFixnum((Ruby)this.getContext().getJRubyRuntime(), (long)((Long)denominator));
                } else if (RubyGuards.isRubyBignum(denominator)) {
                    denominatorValue = RubyBignum.newBignum((Ruby)this.getContext().getJRubyRuntime(), (BigInteger)Layouts.BIGNUM.getValue((DynamicObject)denominator));
                } else {
                    throw new UnsupportedOperationException(denominator.toString());
                }
                RubyRational rubyRationalValue = RubyRational.newRationalRaw((Ruby)this.getContext().getJRubyRuntime(), (IRubyObject)numeratorValue, (IRubyObject)denominatorValue);
                try {
                    rubyBigDecimalValue = RubyBigDecimal.getVpRubyObjectWithPrec19Inner((ThreadContext)this.getContext().getJRubyRuntime().getCurrentContext(), (RubyRational)rubyRationalValue, (RoundingMode)((RoundingMode)((Object)roundingMode)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
                return rubyBigDecimalValue.getBigDecimalValue();
            }
            Object result = toFCallNode.call(frame, value, "to_f", null, new Object[0]);
            if (result != this.nil()) {
                return new BigDecimal((Double)result);
            }
            return result;
        }

        @Fallback
        public Object doBigDecimalFallback(Object value, Object roundingMode) {
            return this.nil();
        }
    }

    @CoreMethod(names={"to_i", "to_int"})
    public static abstract class ToINode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        @Node.Child
        private FixnumOrBignumNode fixnumOrBignum;

        public ToINode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.fixnumOrBignum = new FixnumOrBignumNode(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isNormal(value)"})
        public Object toINormal(DynamicObject value) {
            return this.fixnumOrBignum.fixnumOrBignum(Layouts.BIG_DECIMAL.getValue(value).toBigInteger());
        }

        @Specialization(guards={"!isNormal(value)"})
        public int toISpecial(DynamicObject value) {
            Type type = Layouts.BIG_DECIMAL.getType(value);
            switch (type) {
                case NEGATIVE_INFINITY: {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.coreExceptions().floatDomainError(type.getRepresentation(), this));
                }
                case POSITIVE_INFINITY: {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.coreExceptions().floatDomainError(type.getRepresentation(), this));
                }
                case NAN: {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.coreExceptions().floatDomainError(type.getRepresentation(), this));
                }
                case NEGATIVE_ZERO: {
                    return 0;
                }
            }
            throw new UnsupportedOperationException("unreachable code branch for value: " + (Object)((Object)Layouts.BIG_DECIMAL.getType(value)));
        }
    }

    @CoreMethod(names={"unscaled"}, visibility=Visibility.PRIVATE)
    public static abstract class UnscaledNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isNormal(value)"})
        public Object unscaled(DynamicObject value) {
            return this.createString(StringOperations.encodeRope(Layouts.BIG_DECIMAL.getValue(value).abs().stripTrailingZeros().unscaledValue().toString(), (Encoding)UTF8Encoding.INSTANCE));
        }

        @Specialization(guards={"!isNormal(value)"})
        public Object unscaledSpecial(DynamicObject value) {
            String type = Layouts.BIG_DECIMAL.getType(value).getRepresentation();
            String string = type.startsWith("-") ? type.substring(1) : type;
            return this.createString(StringOperations.encodeRope(string, (Encoding)UTF8Encoding.INSTANCE));
        }
    }

    @CoreMethod(names={"to_f"})
    public static abstract class ToFNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isNormal(value)"})
        public double toFNormal(DynamicObject value) {
            return Layouts.BIG_DECIMAL.getValue(value).doubleValue();
        }

        @Specialization(guards={"!isNormal(value)"})
        public double toFSpecial(DynamicObject value) {
            switch (Layouts.BIG_DECIMAL.getType(value)) {
                case NEGATIVE_INFINITY: {
                    return Double.NEGATIVE_INFINITY;
                }
                case POSITIVE_INFINITY: {
                    return Double.POSITIVE_INFINITY;
                }
                case NEGATIVE_ZERO: {
                    return 0.0;
                }
                case NAN: {
                    return Double.NaN;
                }
            }
            throw new UnsupportedOperationException("unreachable code branch for value: " + (Object)((Object)Layouts.BIG_DECIMAL.getType(value)));
        }
    }

    @CoreMethod(names={"precs"})
    public static abstract class PrecsNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isNormal(value)"})
        public Object precsNormal(DynamicObject value) {
            BigDecimal bigDecimalValue = Layouts.BIG_DECIMAL.getValue(value).abs();
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), new int[]{bigDecimalValue.stripTrailingZeros().unscaledValue().toString().length(), BigDecimalNodes.nearestBiggerMultipleOf4(bigDecimalValue.unscaledValue().toString().length())}, 2);
        }

        @Specialization(guards={"!isNormal(value)"})
        public Object precsSpecial(DynamicObject value) {
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), new int[]{1, 1}, 2);
        }
    }

    @CoreMethod(names={"infinite?"})
    public static abstract class InfiniteNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        @Specialization(guards={"isNormal(value)"})
        public Object infiniteNormal(DynamicObject value) {
            return this.nil();
        }

        @Specialization(guards={"!isNormal(value)"})
        public Object infiniteSpecial(DynamicObject value) {
            switch (Layouts.BIG_DECIMAL.getType(value)) {
                case POSITIVE_INFINITY: {
                    return 1;
                }
                case NEGATIVE_INFINITY: {
                    return -1;
                }
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"finite?"})
    public static abstract class FiniteNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        @Specialization(guards={"isNormal(value)"})
        public boolean finiteNormal(DynamicObject value) {
            return true;
        }

        @Specialization(guards={"!isNormal(value)"})
        public boolean finiteSpecial(DynamicObject value) {
            switch (Layouts.BIG_DECIMAL.getType(value)) {
                case POSITIVE_INFINITY: 
                case NEGATIVE_INFINITY: 
                case NAN: {
                    return false;
                }
            }
            return true;
        }
    }

    @CoreMethod(names={"round"}, optional=2)
    public static abstract class RoundNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        @Node.Child
        private FixnumOrBignumNode fixnumOrBignumNode;

        @CompilerDirectives.TruffleBoundary
        private BigDecimal round(DynamicObject value, int digit, RoundingMode roundingMode) {
            BigDecimal valueBigDecimal = Layouts.BIG_DECIMAL.getValue(value);
            if (digit <= valueBigDecimal.scale()) {
                return valueBigDecimal.movePointRight(digit).setScale(0, roundingMode).movePointLeft(digit);
            }
            return valueBigDecimal;
        }

        @Specialization(guards={"isNormal(value)"})
        public Object round(VirtualFrame frame, DynamicObject value, NotProvided digit, NotProvided roundingMode) {
            if (this.fixnumOrBignumNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.fixnumOrBignumNode = (FixnumOrBignumNode)this.insert(FixnumOrBignumNode.create(this.getContext(), this.getSourceSection()));
            }
            return this.fixnumOrBignumNode.fixnumOrBignum(this.round(value, 0, this.getRoundMode(frame)));
        }

        @Specialization(guards={"isNormal(value)"})
        public Object round(VirtualFrame frame, DynamicObject value, int digit, NotProvided roundingMode) {
            return this.createBigDecimal(frame, this.round(value, digit, this.getRoundMode(frame)));
        }

        @Specialization(guards={"isNormal(value)"})
        public Object round(VirtualFrame frame, DynamicObject value, int digit, int roundingMode) {
            return this.createBigDecimal(frame, this.round(value, digit, BigDecimalNodes.toRoundingMode(roundingMode)));
        }

        @Specialization(guards={"!isNormal(value)"})
        public Object roundSpecial(VirtualFrame frame, DynamicObject value, NotProvided precision, Object unusedRoundingMode) {
            if (this.fixnumOrBignumNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.fixnumOrBignumNode = (FixnumOrBignumNode)this.insert(FixnumOrBignumNode.create(this.getContext(), this.getSourceSection()));
            }
            switch (Layouts.BIG_DECIMAL.getType(value)) {
                case NEGATIVE_INFINITY: {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.coreExceptions().floatDomainError("Computation results to '-Infinity'", this));
                }
                case POSITIVE_INFINITY: {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.coreExceptions().floatDomainError("Computation results to 'Infinity'", this));
                }
                case NEGATIVE_ZERO: {
                    return this.fixnumOrBignumNode.fixnumOrBignum(Layouts.BIG_DECIMAL.getValue(value));
                }
                case NAN: {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.coreExceptions().floatDomainError("Computation results to 'NaN'(Not a Number)", this));
                }
            }
            throw new UnsupportedOperationException("unreachable code branch for value: " + (Object)((Object)Layouts.BIG_DECIMAL.getType(value)));
        }

        @Specialization(guards={"!isNormal(value)", "wasProvided(precision)"})
        public Object roundSpecial(VirtualFrame frame, DynamicObject value, Object precision, Object unusedRoundingMode) {
            return value;
        }
    }

    @CoreMethod(names={"abs"})
    public static abstract class AbsNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        private BigDecimal abs(DynamicObject value) {
            return Layouts.BIG_DECIMAL.getValue(value).abs();
        }

        @Specialization(guards={"isNormal(value)"})
        public Object abs(VirtualFrame frame, DynamicObject value) {
            return this.createBigDecimal(frame, this.abs(value));
        }

        @Specialization(guards={"!isNormal(value)"})
        public Object absSpecial(VirtualFrame frame, DynamicObject value) {
            Type type = Layouts.BIG_DECIMAL.getType(value);
            switch (type) {
                case NEGATIVE_INFINITY: {
                    return this.createBigDecimal(frame, (Object)Type.POSITIVE_INFINITY);
                }
                case NEGATIVE_ZERO: {
                    return this.createBigDecimal(frame, BigDecimal.ZERO);
                }
                case POSITIVE_INFINITY: 
                case NAN: {
                    return this.createBigDecimal(frame, (Object)type);
                }
            }
            throw new UnsupportedOperationException("unreachable code branch for value: " + (Object)((Object)type));
        }
    }

    @CoreMethod(names={"exponent"})
    public static abstract class ExponentNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isNormal(value)", "!isNormalZero(value)"})
        public long exponent(DynamicObject value) {
            BigDecimal val = Layouts.BIG_DECIMAL.getValue(value).abs().stripTrailingZeros();
            return val.precision() - val.scale();
        }

        @Specialization(guards={"isNormal(value)", "isNormalZero(value)"})
        public int exponentZero(DynamicObject value) {
            return 0;
        }

        @Specialization(guards={"!isNormal(value)"})
        public int exponentSpecial(DynamicObject value) {
            return 0;
        }
    }

    @CoreMethod(names={"nan?"})
    public static abstract class NanNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        @Specialization(guards={"isNormal(value)"})
        public boolean nanNormal(DynamicObject value) {
            return false;
        }

        @Specialization(guards={"!isNormal(value)"})
        public boolean nanSpecial(DynamicObject value) {
            return Layouts.BIG_DECIMAL.getType(value) == Type.NAN;
        }
    }

    @CoreMethod(names={"sign"})
    public static abstract class SignNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        private final ConditionProfile positive = ConditionProfile.createBinaryProfile();
        @Node.Child
        private GetIntegerConstantNode sign;

        public SignNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.sign = BigDecimalNodesFactory.GetIntegerConstantNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization(guards={"isNormal(value)", "isNormalZero(value)"})
        public int signNormalZero(VirtualFrame frame, DynamicObject value) {
            return this.sign.executeGetIntegerConstant(frame, this.getBigDecimalClass(), "SIGN_POSITIVE_ZERO");
        }

        @Specialization(guards={"isNormal(value)", "!isNormalZero(value)"})
        public int signNormal(VirtualFrame frame, DynamicObject value) {
            if (this.positive.profile(Layouts.BIG_DECIMAL.getValue(value).signum() > 0)) {
                return this.sign.executeGetIntegerConstant(frame, this.getBigDecimalClass(), "SIGN_POSITIVE_FINITE");
            }
            return this.sign.executeGetIntegerConstant(frame, this.getBigDecimalClass(), "SIGN_NEGATIVE_FINITE");
        }

        @Specialization(guards={"!isNormal(value)"})
        public int signSpecial(VirtualFrame frame, DynamicObject value) {
            switch (Layouts.BIG_DECIMAL.getType(value)) {
                case NEGATIVE_INFINITY: {
                    return this.sign.executeGetIntegerConstant(frame, this.getBigDecimalClass(), "SIGN_NEGATIVE_INFINITE");
                }
                case POSITIVE_INFINITY: {
                    return this.sign.executeGetIntegerConstant(frame, this.getBigDecimalClass(), "SIGN_POSITIVE_INFINITE");
                }
                case NEGATIVE_ZERO: {
                    return this.sign.executeGetIntegerConstant(frame, this.getBigDecimalClass(), "SIGN_NEGATIVE_ZERO");
                }
                case NAN: {
                    return this.sign.executeGetIntegerConstant(frame, this.getBigDecimalClass(), "SIGN_NaN");
                }
            }
            throw new UnsupportedOperationException("unreachable code branch for value: " + (Object)((Object)Layouts.BIG_DECIMAL.getType(value)));
        }
    }

    @NodeChildren(value={@NodeChild(value="module"), @NodeChild(value="name")})
    public static abstract class GetIntegerConstantNode
    extends RubyNode {
        @Node.Child
        ReadConstantNode readConstantNode;
        @Node.Child
        ToIntNode toIntNode;
        @Node.Child
        IntegerCastNode integerCastNode;

        public GetIntegerConstantNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.readConstantNode = new ReadConstantNode(context, sourceSection, false, false, null, null);
            this.toIntNode = ToIntNode.create();
            this.integerCastNode = IntegerCastNodeGen.create(context, sourceSection, null);
        }

        public abstract int executeGetIntegerConstant(VirtualFrame var1, DynamicObject var2, String var3);

        @Specialization(guards={"isRubyModule(module)"})
        public int doInteger(VirtualFrame frame, DynamicObject module, String name) {
            Object value = this.readConstantNode.readConstant(frame, module, name);
            return this.integerCastNode.executeCastInt(this.toIntNode.executeIntOrLong(frame, value));
        }
    }

    @CoreMethod(names={"zero?"})
    public static abstract class ZeroNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        @Specialization(guards={"isNormal(value)"})
        public boolean zeroNormal(DynamicObject value) {
            return Layouts.BIG_DECIMAL.getValue(value).compareTo(BigDecimal.ZERO) == 0;
        }

        @Specialization(guards={"!isNormal(value)"})
        public boolean zeroSpecial(DynamicObject value) {
            switch (Layouts.BIG_DECIMAL.getType(value)) {
                case NEGATIVE_ZERO: {
                    return true;
                }
            }
            return false;
        }
    }

    @CoreMethod(names={"<=>"}, required=1)
    public static abstract class CompareNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        private int compareBigDecimal(DynamicObject a, BigDecimal b) {
            return Layouts.BIG_DECIMAL.getValue(a).compareTo(b);
        }

        @Specialization(guards={"isNormal(a)"})
        public int compare(DynamicObject a, long b) {
            return this.compareBigDecimal(a, BigDecimalNodes.getBigDecimalValue(b));
        }

        @Specialization(guards={"isNormal(a)"})
        public int compare(DynamicObject a, double b) {
            return this.compareBigDecimal(a, BigDecimalNodes.getBigDecimalValue(b));
        }

        @Specialization(guards={"isNormal(a)", "isRubyBignum(b)"})
        public int compare(DynamicObject a, DynamicObject b) {
            return this.compareBigDecimal(a, BigDecimalNodes.getBignumBigDecimalValue(b));
        }

        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public int compareNormal(DynamicObject a, DynamicObject b) {
            return this.compareBigDecimal(a, Layouts.BIG_DECIMAL.getValue(b));
        }

        @Specialization(guards={"!isNormal(a)"})
        public Object compareSpecial(VirtualFrame frame, DynamicObject a, long b) {
            return this.compareSpecial(a, this.createBigDecimal(frame, BigDecimalNodes.getBigDecimalValue(b)));
        }

        @Specialization(guards={"!isNormal(a)"})
        public Object compareSpecial(VirtualFrame frame, DynamicObject a, double b) {
            return this.compareSpecial(a, this.createBigDecimal(frame, BigDecimalNodes.getBigDecimalValue(b)));
        }

        @Specialization(guards={"!isNormal(a)", "isRubyBignum(b)"})
        public Object compareSpecialBignum(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            return this.compareSpecial(a, this.createBigDecimal(frame, BigDecimalNodes.getBignumBigDecimalValue(b)));
        }

        @Specialization(guards={"!isNormal(a)", "isNan(a)"})
        public Object compareSpecialNan(DynamicObject a, DynamicObject b) {
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyBigDecimal(b)", "!isNormal(a) || !isNormal(b)", "isNormal(a) || !isNan(a)"})
        public Object compareSpecial(DynamicObject a, DynamicObject b) {
            Type aType = Layouts.BIG_DECIMAL.getType(a);
            Type bType = Layouts.BIG_DECIMAL.getType(b);
            if (aType == Type.NAN || bType == Type.NAN) {
                return this.nil();
            }
            if (aType == bType) {
                return 0;
            }
            if (aType == Type.POSITIVE_INFINITY || bType == Type.NEGATIVE_INFINITY) {
                return 1;
            }
            if (aType == Type.NEGATIVE_INFINITY || bType == Type.POSITIVE_INFINITY) {
                return -1;
            }
            BigDecimal aCompare = aType == Type.NEGATIVE_ZERO ? BigDecimal.ZERO : Layouts.BIG_DECIMAL.getValue(a);
            BigDecimal bCompare = bType == Type.NEGATIVE_ZERO ? BigDecimal.ZERO : Layouts.BIG_DECIMAL.getValue(b);
            return aCompare.compareTo(bCompare);
        }

        @Specialization(guards={"isNil(b)"})
        public Object compareNil(DynamicObject a, DynamicObject b) {
            return this.nil();
        }

        @Specialization(guards={"!isRubyBigDecimal(b)", "!isNil(b)"})
        public Object compareCoerced(VirtualFrame frame, DynamicObject a, DynamicObject b, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "redo_coerced :<=>, b", "b", b);
        }
    }

    @CoreMethod(names={"sqrt"}, required=1)
    @NodeChildren(value={@NodeChild(value="self", type=RubyNode.class), @NodeChild(value="precision", type=RubyNode.class)})
    public static abstract class SqrtNode
    extends BigDecimalCoreMethodNode {
        private final ConditionProfile positiveValueProfile = ConditionProfile.createBinaryProfile();

        public abstract Object executeSqrt(VirtualFrame var1, DynamicObject var2, int var3);

        @CompilerDirectives.TruffleBoundary
        private BigDecimal sqrt(BigDecimal value, MathContext mathContext) {
            return RubyBigDecimal.bigSqrt((BigDecimal)value, (MathContext)mathContext);
        }

        @Specialization(guards={"precision < 0"})
        public Object sqrtNegativePrecision(VirtualFrame frame, DynamicObject a, int precision) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.coreExceptions().argumentError("precision must be positive", this));
        }

        @Specialization(guards={"precision == 0"})
        public Object sqrtZeroPrecision(VirtualFrame frame, DynamicObject a, int precision) {
            return this.executeSqrt(frame, a, 1);
        }

        @Specialization(guards={"isNormal(a)", "precision > 0"})
        public Object sqrt(VirtualFrame frame, DynamicObject a, int precision) {
            BigDecimal valueBigDecimal = Layouts.BIG_DECIMAL.getValue(a);
            if (this.positiveValueProfile.profile(valueBigDecimal.signum() >= 0)) {
                return this.createBigDecimal(frame, this.sqrt(valueBigDecimal, new MathContext(precision, this.getRoundMode(frame))));
            }
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.coreExceptions().floatDomainError("(VpSqrt) SQRT(negative value)", this));
        }

        @Specialization(guards={"!isNormal(a)", "precision > 0"})
        public Object sqrtSpecial(VirtualFrame frame, DynamicObject a, int precision) {
            switch (Layouts.BIG_DECIMAL.getType(a)) {
                case NAN: {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.coreExceptions().floatDomainError("(VpSqrt) SQRT(NaN value)", this));
                }
                case POSITIVE_INFINITY: {
                    return this.createBigDecimal(frame, (Object)Type.POSITIVE_INFINITY);
                }
                case NEGATIVE_INFINITY: {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.coreExceptions().floatDomainError("(VpSqrt) SQRT(negative value)", this));
                }
                case NEGATIVE_ZERO: {
                    return this.createBigDecimal(frame, this.sqrt(BigDecimal.ZERO, new MathContext(precision, this.getRoundMode(frame))));
                }
            }
            throw new UnsupportedOperationException("unreachable code branch for value: " + (Object)((Object)Layouts.BIG_DECIMAL.getType(a)));
        }
    }

    @CoreMethod(names={"**", "power"}, required=1, optional=1)
    @NodeChildren(value={@NodeChild(value="self", type=RubyNode.class), @NodeChild(value="exponent", type=RubyNode.class), @NodeChild(value="precision", type=RubyNode.class)})
    public static abstract class PowerNode
    extends BigDecimalCoreMethodNode {
        private final ConditionProfile positiveExponentProfile = ConditionProfile.createBinaryProfile();
        private final ConditionProfile zeroExponentProfile = ConditionProfile.createBinaryProfile();
        private final ConditionProfile zeroProfile = ConditionProfile.createBinaryProfile();

        @CompilerDirectives.TruffleBoundary
        private BigDecimal power(BigDecimal value, int exponent, MathContext mathContext) {
            return value.pow(exponent, mathContext);
        }

        @Specialization(guards={"isNormal(a)"})
        public Object power(VirtualFrame frame, DynamicObject a, int exponent, NotProvided precision) {
            return this.power(frame, a, exponent, this.getLimit(frame));
        }

        @Specialization(guards={"isNormal(a)"})
        public Object power(VirtualFrame frame, DynamicObject a, int exponent, int precision) {
            BigDecimal aBigDecimal = Layouts.BIG_DECIMAL.getValue(a);
            boolean positiveExponent = this.positiveExponentProfile.profile(exponent >= 0);
            if (this.zeroProfile.profile(aBigDecimal.compareTo(BigDecimal.ZERO) == 0)) {
                if (positiveExponent) {
                    if (this.zeroExponentProfile.profile(exponent == 0)) {
                        return this.createBigDecimal(frame, BigDecimal.ONE);
                    }
                    return this.createBigDecimal(frame, BigDecimal.ZERO);
                }
                return this.createBigDecimal(frame, (Object)Type.POSITIVE_INFINITY);
            }
            int newPrecision = positiveExponent ? precision : (-exponent + 4) * (this.getDigits(aBigDecimal) + 4);
            return this.createBigDecimal(frame, this.power(Layouts.BIG_DECIMAL.getValue(a), exponent, new MathContext(newPrecision, this.getRoundMode(frame))));
        }

        @CompilerDirectives.TruffleBoundary
        private int getDigits(BigDecimal value) {
            return value.abs().unscaledValue().toString().length();
        }

        @Specialization(guards={"!isNormal(a)"})
        public Object power(VirtualFrame frame, DynamicObject a, int exponent, Object unusedPrecision) {
            switch (Layouts.BIG_DECIMAL.getType(a)) {
                case NAN: {
                    return this.createBigDecimal(frame, (Object)Type.NAN);
                }
                case POSITIVE_INFINITY: {
                    return this.createBigDecimal(frame, exponent >= 0 ? Type.POSITIVE_INFINITY : BigDecimal.ZERO);
                }
                case NEGATIVE_INFINITY: {
                    return this.createBigDecimal(frame, Integer.signum(exponent) == 1 ? (exponent % 2 == 0 ? Type.POSITIVE_INFINITY : Type.NEGATIVE_INFINITY) : BigDecimal.ZERO);
                }
                case NEGATIVE_ZERO: {
                    return this.createBigDecimal(frame, Integer.signum(exponent) == 1 ? BigDecimal.ZERO : Type.NAN);
                }
            }
            throw new UnsupportedOperationException("unreachable code branch for value: " + (Object)((Object)Layouts.BIG_DECIMAL.getType(a)));
        }
    }

    @CoreMethod(names={"modulo", "%"}, required=1)
    public static abstract class ModuloNode
    extends OpNode {
        @CompilerDirectives.TruffleBoundary
        public static BigDecimal moduloBigDecimal(BigDecimal a, BigDecimal b) {
            BigDecimal modulo = a.remainder(b);
            if (modulo.signum() * b.signum() < 0) {
                return modulo.add(b);
            }
            return modulo;
        }

        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)", "!isNormalZero(b)"})
        public Object modulo(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            return this.createBigDecimal(frame, ModuloNode.moduloBigDecimal(Layouts.BIG_DECIMAL.getValue(a), Layouts.BIG_DECIMAL.getValue(b)));
        }

        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)", "isNormalZero(b)"})
        public Object moduloZero(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.coreExceptions().zeroDivisionError(this));
        }

        @Specialization(guards={"isRubyBigDecimal(b)", "!isNormal(a) || !isNormal(b)"})
        public Object moduloSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            Type aType = Layouts.BIG_DECIMAL.getType(a);
            Type bType = Layouts.BIG_DECIMAL.getType(b);
            if (aType == Type.NAN || bType == Type.NAN) {
                return this.createBigDecimal(frame, (Object)Type.NAN);
            }
            if (bType == Type.NEGATIVE_ZERO || bType == Type.NORMAL && ModuloNode.isNormalZero(b)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().zeroDivisionError(this));
            }
            if (aType == Type.NEGATIVE_ZERO || aType == Type.NORMAL && ModuloNode.isNormalZero(a)) {
                return this.createBigDecimal(frame, BigDecimal.ZERO);
            }
            if (aType == Type.POSITIVE_INFINITY || aType == Type.NEGATIVE_INFINITY) {
                return this.createBigDecimal(frame, (Object)Type.NAN);
            }
            if (bType == Type.POSITIVE_INFINITY || bType == Type.NEGATIVE_INFINITY) {
                return this.createBigDecimal(frame, a);
            }
            throw new UnsupportedOperationException("unreachable code branch");
        }
    }

    @CoreMethod(names={"remainder"}, required=1)
    public static abstract class RemainderNode
    extends OpNode {
        @CompilerDirectives.TruffleBoundary
        public static BigDecimal remainderBigDecimal(BigDecimal a, BigDecimal b) {
            return a.remainder(b);
        }

        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)", "!isNormalZero(b)"})
        public Object remainder(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            return this.createBigDecimal(frame, RemainderNode.remainderBigDecimal(Layouts.BIG_DECIMAL.getValue(a), Layouts.BIG_DECIMAL.getValue(b)));
        }

        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)", "isNormalZero(b)"})
        public Object remainderZero(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            return this.createBigDecimal(frame, (Object)Type.NAN);
        }

        @Specialization(guards={"isRubyBigDecimal(b)", "!isNormal(a) || !isNormal(b)"})
        public Object remainderSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            Type aType = Layouts.BIG_DECIMAL.getType(a);
            Type bType = Layouts.BIG_DECIMAL.getType(b);
            if (aType == Type.NEGATIVE_ZERO && bType == Type.NORMAL) {
                return this.createBigDecimal(frame, BigDecimal.ZERO);
            }
            return this.createBigDecimal(frame, (Object)Type.NAN);
        }
    }

    @CoreMethod(names={"divmod"}, required=1)
    public static abstract class DivModNode
    extends OpNode {
        @Node.Child
        private CallDispatchHeadNode signCall;
        @Node.Child
        private IntegerCastNode signIntegerCast;

        @CompilerDirectives.TruffleBoundary
        private BigDecimal[] divmodBigDecimal(BigDecimal a, BigDecimal b) {
            BigDecimal[] result = a.divideAndRemainder(b);
            if (result[1].signum() * b.signum() < 0) {
                result[0] = result[0].subtract(BigDecimal.ONE);
                result[1] = result[1].add(b);
            }
            return result;
        }

        private void setupSignCall() {
            if (this.signCall == null) {
                CompilerDirectives.transferToInterpreter();
                this.signCall = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
        }

        private void setupLimitIntegerCast() {
            if (this.signIntegerCast == null) {
                CompilerDirectives.transferToInterpreter();
                this.signIntegerCast = (IntegerCastNode)this.insert(IntegerCastNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
        }

        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)", "!isNormalZero(a)", "!isNormalZero(b)"})
        public Object divmod(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            BigDecimal[] result = this.divmodBigDecimal(Layouts.BIG_DECIMAL.getValue(a), Layouts.BIG_DECIMAL.getValue(b));
            Object[] store = new Object[]{this.createBigDecimal(frame, result[0]), this.createBigDecimal(frame, result[1])};
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), store, store.length);
        }

        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)", "isNormalZero(a)", "!isNormalZero(b)"})
        public Object divmodZeroDividend(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            Object[] store = new Object[]{this.createBigDecimal(frame, BigDecimal.ZERO), this.createBigDecimal(frame, BigDecimal.ZERO)};
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), store, store.length);
        }

        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)", "isNormalZero(b)"})
        public Object divmodZeroDivisor(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.coreExceptions().zeroDivisionError(this));
        }

        @Specialization(guards={"isRubyBigDecimal(b)", "!isNormal(a) || !isNormal(b)"})
        public Object divmodSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            Type aType = Layouts.BIG_DECIMAL.getType(a);
            Type bType = Layouts.BIG_DECIMAL.getType(b);
            if (aType == Type.NAN || bType == Type.NAN) {
                Object[] store = new Object[]{this.createBigDecimal(frame, (Object)Type.NAN), this.createBigDecimal(frame, (Object)Type.NAN)};
                return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), store, store.length);
            }
            if (bType == Type.NEGATIVE_ZERO || bType == Type.NORMAL && DivModNode.isNormalZero(b)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().zeroDivisionError(this));
            }
            if (aType == Type.NEGATIVE_ZERO || aType == Type.NORMAL && DivModNode.isNormalZero(a)) {
                Object[] store = new Object[]{this.createBigDecimal(frame, BigDecimal.ZERO), this.createBigDecimal(frame, BigDecimal.ZERO)};
                return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), store, store.length);
            }
            if (aType == Type.POSITIVE_INFINITY || aType == Type.NEGATIVE_INFINITY) {
                this.setupSignCall();
                this.setupLimitIntegerCast();
                int signA = aType == Type.POSITIVE_INFINITY ? 1 : -1;
                int signB = Integer.signum(this.signIntegerCast.executeCastInt(this.signCall.call(frame, b, "sign", null, new Object[0])));
                int sign = signA * signB;
                Type type = (new Type[]{Type.NEGATIVE_INFINITY, Type.NAN, Type.POSITIVE_INFINITY})[sign + 1];
                Object[] store = new Object[]{this.createBigDecimal(frame, (Object)type), this.createBigDecimal(frame, (Object)Type.NAN)};
                return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), store, store.length);
            }
            if (bType == Type.POSITIVE_INFINITY || bType == Type.NEGATIVE_INFINITY) {
                Object[] store = new Object[]{this.createBigDecimal(frame, BigDecimal.ZERO), this.createBigDecimal(frame, a)};
                return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), store, store.length);
            }
            throw new UnsupportedOperationException("unreachable code branch");
        }
    }

    @CoreMethod(names={"div"}, required=1, optional=1)
    @NodeChild(value="precision", type=RubyNode.class)
    public static abstract class DivNode
    extends AbstractDivNode {
        private final ConditionProfile zeroPrecisionProfile = ConditionProfile.createBinaryProfile();
        private final ConditionProfile bZeroProfile = ConditionProfile.createBinaryProfile();
        @Node.Child
        private CallDispatchHeadNode floorCall;

        private void setupFloorCall() {
            if (this.floorCall == null) {
                CompilerDirectives.transferToInterpreter();
                this.floorCall = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
        }

        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public Object div(VirtualFrame frame, DynamicObject a, DynamicObject b, NotProvided precision) {
            this.setupFloorCall();
            if (this.bZeroProfile.profile(DivNode.isNormalZero(b))) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().zeroDivisionError(this));
            }
            Object result = this.div(frame, a, b, 0);
            return this.floorCall.call(frame, result, "floor", null, new Object[0]);
        }

        @Override
        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public Object div(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
            int newPrecision = this.zeroPrecisionProfile.profile(precision == 0) ? BigDecimalNodes.defaultDivisionPrecision(Layouts.BIG_DECIMAL.getValue(a), Layouts.BIG_DECIMAL.getValue(b), this.getLimit(frame)) : precision;
            return super.div(frame, a, b, newPrecision);
        }

        @Specialization(guards={"isNormal(a)", "isSpecialRubyBigDecimal(b)"})
        public Object divNormalSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b, NotProvided precision) {
            if (Layouts.BIG_DECIMAL.getType(b) == Type.NEGATIVE_ZERO) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().zeroDivisionError(this));
            }
            if (Layouts.BIG_DECIMAL.getType(b) == Type.NAN) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().floatDomainError("Computation results to 'NaN'(Not a Number)", this));
            }
            return this.divNormalSpecial(frame, a, b, 0);
        }

        @Override
        @Specialization(guards={"isNormal(a)", "isSpecialRubyBigDecimal(b)"})
        public Object divNormalSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
            return super.divNormalSpecial(frame, a, b, precision);
        }

        @Specialization(guards={"!isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public Object divSpecialNormal(VirtualFrame frame, DynamicObject a, DynamicObject b, NotProvided precision) {
            if (DivNode.isNormalZero(b)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().zeroDivisionError(this));
            }
            if (Layouts.BIG_DECIMAL.getType(a) == Type.NAN) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().floatDomainError("Computation results to 'NaN'(Not a Number)", this));
            }
            if (Layouts.BIG_DECIMAL.getType(a) == Type.POSITIVE_INFINITY || Layouts.BIG_DECIMAL.getType(a) == Type.NEGATIVE_INFINITY) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().floatDomainError("Computation results to 'Infinity'", this));
            }
            return this.divSpecialNormal(frame, a, b, 0);
        }

        @Override
        @Specialization(guards={"!isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public Object divSpecialNormal(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
            return super.divSpecialNormal(frame, a, b, precision);
        }

        @Specialization(guards={"!isNormal(a)", "isSpecialRubyBigDecimal(b)"})
        public Object divSpecialSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b, NotProvided precision) {
            if (Layouts.BIG_DECIMAL.getType(b) == Type.NEGATIVE_ZERO) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().zeroDivisionError(this));
            }
            if (Layouts.BIG_DECIMAL.getType(a) == Type.NAN || Layouts.BIG_DECIMAL.getType(b) == Type.NAN) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().floatDomainError("Computation results to 'NaN'(Not a Number)", this));
            }
            return this.divSpecialSpecial(frame, a, b, 0);
        }

        @Override
        @Specialization(guards={"!isNormal(a)", "isSpecialRubyBigDecimal(b)"})
        public Object divSpecialSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
            return super.divSpecialSpecial(frame, a, b, precision);
        }
    }

    @CoreMethod(names={"/", "quo"}, required=1)
    public static abstract class DivOpNode
    extends AbstractDivNode {
        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public Object div(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            int precision = BigDecimalNodes.defaultDivisionPrecision(Layouts.BIG_DECIMAL.getValue(a), Layouts.BIG_DECIMAL.getValue(b), this.getLimit(frame));
            return this.div(frame, a, b, precision);
        }

        @Specialization(guards={"isNormal(a)", "isSpecialRubyBigDecimal(b)"})
        public Object divNormalSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            return this.divNormalSpecial(frame, a, b, 0);
        }

        @Specialization(guards={"!isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public Object divSpecialNormal(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            return this.divSpecialNormal(frame, a, b, 0);
        }

        @Specialization(guards={"!isNormal(a)", "isSpecialRubyBigDecimal(b)"})
        public Object divSpecialSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            return this.divSpecialSpecial(frame, a, b, 0);
        }
    }

    public static abstract class AbstractDivNode
    extends OpNode {
        private final ConditionProfile normalZero = ConditionProfile.createBinaryProfile();

        private Object divBigDecimalWithProfile(DynamicObject a, DynamicObject b, MathContext mathContext) {
            BigDecimal aBigDecimal = Layouts.BIG_DECIMAL.getValue(a);
            BigDecimal bBigDecimal = Layouts.BIG_DECIMAL.getValue(b);
            if (this.normalZero.profile(bBigDecimal.signum() == 0)) {
                switch (aBigDecimal.signum()) {
                    case 1: {
                        return Type.POSITIVE_INFINITY;
                    }
                    case 0: {
                        return Type.NAN;
                    }
                    case -1: {
                        return Type.NEGATIVE_INFINITY;
                    }
                }
                throw new UnsupportedOperationException("unreachable code branch for value: " + aBigDecimal.signum());
            }
            return this.divBigDecimal(aBigDecimal, bBigDecimal, mathContext);
        }

        @CompilerDirectives.TruffleBoundary
        private BigDecimal divBigDecimal(BigDecimal a, BigDecimal b, MathContext mathContext) {
            return a.divide(b, mathContext);
        }

        protected Object div(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
            return this.createBigDecimal(frame, this.divBigDecimalWithProfile(a, b, new MathContext(precision, this.getRoundMode(frame))));
        }

        protected Object divNormalSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
            switch (Layouts.BIG_DECIMAL.getType(b)) {
                case NAN: {
                    return this.createBigDecimal(frame, (Object)Type.NAN);
                }
                case NEGATIVE_ZERO: {
                    switch (Layouts.BIG_DECIMAL.getValue(a).signum()) {
                        case 1: {
                            return this.createBigDecimal(frame, (Object)Type.NEGATIVE_INFINITY);
                        }
                        case 0: {
                            return this.createBigDecimal(frame, (Object)Type.NAN);
                        }
                        case -1: {
                            return this.createBigDecimal(frame, (Object)Type.POSITIVE_INFINITY);
                        }
                    }
                }
                case POSITIVE_INFINITY: {
                    switch (Layouts.BIG_DECIMAL.getValue(a).signum()) {
                        case 0: 
                        case 1: {
                            return this.createBigDecimal(frame, BigDecimal.ZERO);
                        }
                        case -1: {
                            return this.createBigDecimal(frame, (Object)Type.NEGATIVE_ZERO);
                        }
                    }
                }
                case NEGATIVE_INFINITY: {
                    switch (Layouts.BIG_DECIMAL.getValue(b).signum()) {
                        case 1: {
                            return this.createBigDecimal(frame, (Object)Type.NEGATIVE_ZERO);
                        }
                        case -1: 
                        case 0: {
                            return this.createBigDecimal(frame, BigDecimal.ZERO);
                        }
                    }
                }
            }
            throw new UnsupportedOperationException("unreachable code branch for value: " + (Object)((Object)Layouts.BIG_DECIMAL.getType(b)));
        }

        protected Object divSpecialNormal(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
            switch (Layouts.BIG_DECIMAL.getType(a)) {
                case NAN: {
                    return this.createBigDecimal(frame, (Object)Type.NAN);
                }
                case NEGATIVE_ZERO: {
                    switch (Layouts.BIG_DECIMAL.getValue(b).signum()) {
                        case 1: {
                            return this.createBigDecimal(frame, (Object)Type.NEGATIVE_ZERO);
                        }
                        case 0: {
                            return this.createBigDecimal(frame, (Object)Type.NAN);
                        }
                        case -1: {
                            return this.createBigDecimal(frame, BigDecimal.ZERO);
                        }
                    }
                }
                case POSITIVE_INFINITY: {
                    switch (Layouts.BIG_DECIMAL.getValue(b).signum()) {
                        case 0: 
                        case 1: {
                            return this.createBigDecimal(frame, (Object)Type.POSITIVE_INFINITY);
                        }
                        case -1: {
                            return this.createBigDecimal(frame, (Object)Type.NEGATIVE_INFINITY);
                        }
                    }
                }
                case NEGATIVE_INFINITY: {
                    switch (Layouts.BIG_DECIMAL.getValue(b).signum()) {
                        case 0: 
                        case 1: {
                            return this.createBigDecimal(frame, (Object)Type.NEGATIVE_INFINITY);
                        }
                        case -1: {
                            return this.createBigDecimal(frame, (Object)Type.POSITIVE_INFINITY);
                        }
                    }
                }
            }
            throw new UnsupportedOperationException("unreachable code branch for value: " + (Object)((Object)Layouts.BIG_DECIMAL.getType(a)));
        }

        protected Object divSpecialSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
            Type aType = Layouts.BIG_DECIMAL.getType(a);
            Type bType = Layouts.BIG_DECIMAL.getType(b);
            if (aType == Type.NAN || bType == Type.NAN || aType == Type.NEGATIVE_ZERO && bType == Type.NEGATIVE_ZERO) {
                return this.createBigDecimal(frame, (Object)Type.NAN);
            }
            if (aType == Type.NEGATIVE_ZERO) {
                if (bType == Type.POSITIVE_INFINITY) {
                    return this.createBigDecimal(frame, (Object)Type.NEGATIVE_ZERO);
                }
                return this.createBigDecimal(frame, (Object)Type.POSITIVE_INFINITY);
            }
            if (bType == Type.NEGATIVE_ZERO) {
                if (aType == Type.POSITIVE_INFINITY) {
                    return this.createBigDecimal(frame, (Object)Type.NEGATIVE_INFINITY);
                }
                return this.createBigDecimal(frame, (Object)Type.POSITIVE_INFINITY);
            }
            return this.createBigDecimal(frame, (Object)Type.NAN);
        }
    }

    @CoreMethod(names={"mult"}, required=2)
    @NodeChild(value="precision", type=RubyNode.class)
    public static abstract class MultNode
    extends AbstractMultNode {
        @Override
        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public Object mult(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
            return super.mult(frame, a, b, precision);
        }

        @Override
        @Specialization(guards={"isNormal(a)", "isSpecialRubyBigDecimal(b)"})
        public Object multNormalSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
            return super.multNormalSpecial(frame, a, b, precision);
        }

        @Override
        @Specialization(guards={"!isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public Object multSpecialNormal(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
            return super.multSpecialNormal(frame, a, b, precision);
        }

        @Override
        @Specialization(guards={"!isNormal(a)", "isSpecialRubyBigDecimal(b)"})
        public Object multSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
            return super.multSpecial(frame, a, b, precision);
        }
    }

    @CoreMethod(names={"*"}, required=1)
    public static abstract class MultOpNode
    extends AbstractMultNode {
        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public Object mult(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            return this.mult(frame, a, b, this.getLimit(frame));
        }

        @Specialization(guards={"isNormal(a)", "isSpecialRubyBigDecimal(b)"})
        public Object multNormalSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            return this.multSpecialNormal(frame, b, a, 0);
        }

        @Specialization(guards={"!isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public Object multSpecialNormal(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            return this.multSpecialNormal(frame, a, b, 0);
        }

        @Specialization(guards={"!isNormal(a)", "isSpecialRubyBigDecimal(b)"})
        public Object multSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            return this.multSpecial(frame, a, b, 0);
        }
    }

    public static abstract class AbstractMultNode
    extends OpNode {
        private final ConditionProfile zeroNormal = ConditionProfile.createBinaryProfile();

        private Object multBigDecimalWithProfile(DynamicObject a, DynamicObject b, MathContext mathContext) {
            BigDecimal bBigDecimal = Layouts.BIG_DECIMAL.getValue(b);
            if (this.zeroNormal.profile(AbstractMultNode.isNormalZero(a) && bBigDecimal.signum() == -1)) {
                return Type.NEGATIVE_ZERO;
            }
            return this.multBigDecimal(Layouts.BIG_DECIMAL.getValue(a), bBigDecimal, mathContext);
        }

        @CompilerDirectives.TruffleBoundary
        private Object multBigDecimal(BigDecimal a, BigDecimal b, MathContext mathContext) {
            return a.multiply(b, mathContext);
        }

        protected Object mult(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
            return this.createBigDecimal(frame, this.multBigDecimalWithProfile(a, b, new MathContext(precision, this.getRoundMode(frame))));
        }

        protected Object multNormalSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
            return this.multSpecialNormal(frame, b, a, precision);
        }

        protected Object multSpecialNormal(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
            switch (Layouts.BIG_DECIMAL.getType(a)) {
                case NAN: {
                    return this.createBigDecimal(frame, (Object)Type.NAN);
                }
                case NEGATIVE_ZERO: {
                    switch (Layouts.BIG_DECIMAL.getValue(b).signum()) {
                        case 0: 
                        case 1: {
                            return this.createBigDecimal(frame, (Object)Type.NEGATIVE_ZERO);
                        }
                        case -1: {
                            return this.createBigDecimal(frame, BigDecimal.ZERO);
                        }
                    }
                }
                case POSITIVE_INFINITY: {
                    switch (Layouts.BIG_DECIMAL.getValue(b).signum()) {
                        case 1: {
                            return this.createBigDecimal(frame, (Object)Type.POSITIVE_INFINITY);
                        }
                        case 0: {
                            return this.createBigDecimal(frame, (Object)Type.NAN);
                        }
                        case -1: {
                            return this.createBigDecimal(frame, (Object)Type.NEGATIVE_INFINITY);
                        }
                    }
                }
                case NEGATIVE_INFINITY: {
                    switch (Layouts.BIG_DECIMAL.getValue(b).signum()) {
                        case 1: {
                            return this.createBigDecimal(frame, (Object)Type.NEGATIVE_INFINITY);
                        }
                        case 0: {
                            return this.createBigDecimal(frame, (Object)Type.NAN);
                        }
                        case -1: {
                            return this.createBigDecimal(frame, (Object)Type.POSITIVE_INFINITY);
                        }
                    }
                }
            }
            throw new UnsupportedOperationException("unreachable code branch");
        }

        protected Object multSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
            Type aType = Layouts.BIG_DECIMAL.getType(a);
            Type bType = Layouts.BIG_DECIMAL.getType(b);
            if (aType == Type.NAN || bType == Type.NAN) {
                return this.createBigDecimal(frame, (Object)Type.NAN);
            }
            if (aType == Type.NEGATIVE_ZERO && bType == Type.NEGATIVE_ZERO) {
                return this.createBigDecimal(frame, BigDecimal.ZERO);
            }
            if (aType == Type.NEGATIVE_ZERO || bType == Type.NEGATIVE_ZERO) {
                return this.createBigDecimal(frame, (Object)Type.NAN);
            }
            if (aType == Type.POSITIVE_INFINITY) {
                return bType == Type.POSITIVE_INFINITY ? a : this.createBigDecimal(frame, (Object)Type.NEGATIVE_INFINITY);
            }
            if (aType == Type.NEGATIVE_INFINITY) {
                return bType == Type.POSITIVE_INFINITY ? a : this.createBigDecimal(frame, (Object)Type.POSITIVE_INFINITY);
            }
            throw new UnsupportedOperationException("unreachable code branch");
        }
    }

    @CoreMethod(names={"-@"})
    public static abstract class NegNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        @Specialization(guards={"isNormal(value)", "!isNormalZero(value)"})
        public Object negNormal(VirtualFrame frame, DynamicObject value) {
            return this.createBigDecimal(frame, Layouts.BIG_DECIMAL.getValue(value).negate());
        }

        @Specialization(guards={"isNormal(value)", "isNormalZero(value)"})
        public Object negNormalZero(VirtualFrame frame, DynamicObject value) {
            return this.createBigDecimal(frame, (Object)Type.NEGATIVE_ZERO);
        }

        @Specialization(guards={"!isNormal(value)"})
        public Object negSpecial(VirtualFrame frame, DynamicObject value) {
            switch (Layouts.BIG_DECIMAL.getType(value)) {
                case POSITIVE_INFINITY: {
                    return this.createBigDecimal(frame, (Object)Type.NEGATIVE_INFINITY);
                }
                case NEGATIVE_INFINITY: {
                    return this.createBigDecimal(frame, (Object)Type.POSITIVE_INFINITY);
                }
                case NEGATIVE_ZERO: {
                    return this.createBigDecimal(frame, BigDecimal.ZERO);
                }
                case NAN: {
                    return value;
                }
            }
            throw new UnsupportedOperationException("unreachable code branch for value: " + value);
        }
    }

    @CoreMethod(names={"sub"}, required=2)
    @NodeChild(value="precision", type=RubyNode.class)
    public static abstract class SubNode
    extends AbstractSubNode {
        @Override
        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public Object subNormal(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
            return super.subNormal(frame, a, b, precision);
        }

        @Override
        @Specialization(guards={"isRubyBigDecimal(b)", "!isNormal(a) || !isNormal(b)"})
        public Object subSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
            return super.subSpecial(frame, a, b, precision);
        }
    }

    @CoreMethod(names={"-"}, required=1)
    public static abstract class SubOpNode
    extends AbstractSubNode {
        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public Object subNormal(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            return this.subNormal(frame, a, b, this.getLimit(frame));
        }

        @Specialization(guards={"isRubyBigDecimal(b)", "!isNormal(a) || !isNormal(b)"})
        public Object subSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            return this.subSpecial(frame, a, b, 0);
        }
    }

    public static abstract class AbstractSubNode
    extends OpNode {
        @CompilerDirectives.TruffleBoundary
        private BigDecimal subBigDecimal(DynamicObject a, DynamicObject b, MathContext mathContext) {
            return Layouts.BIG_DECIMAL.getValue(a).subtract(Layouts.BIG_DECIMAL.getValue(b), mathContext);
        }

        protected Object subNormal(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
            return this.createBigDecimal(frame, this.subBigDecimal(a, b, new MathContext(precision, this.getRoundMode(frame))));
        }

        protected Object subSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
            Type aType = Layouts.BIG_DECIMAL.getType(a);
            Type bType = Layouts.BIG_DECIMAL.getType(b);
            if (aType == Type.NAN || bType == Type.NAN || aType == Type.POSITIVE_INFINITY && bType == Type.POSITIVE_INFINITY || aType == Type.NEGATIVE_INFINITY && bType == Type.NEGATIVE_INFINITY) {
                return this.createBigDecimal(frame, (Object)Type.NAN);
            }
            if (aType == Type.POSITIVE_INFINITY || bType == Type.NEGATIVE_INFINITY) {
                return this.createBigDecimal(frame, (Object)Type.POSITIVE_INFINITY);
            }
            if (aType == Type.NEGATIVE_INFINITY || bType == Type.POSITIVE_INFINITY) {
                return this.createBigDecimal(frame, (Object)Type.NEGATIVE_INFINITY);
            }
            if (AbstractSubNode.isNormal(a)) {
                return a;
            }
            return this.createBigDecimal(frame, Layouts.BIG_DECIMAL.getValue(b).negate());
        }
    }

    @CoreMethod(names={"add"}, required=2)
    @NodeChild(value="precision", type=RubyNode.class)
    public static abstract class AddNode
    extends AbstractAddNode {
        @Override
        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)"})
        protected Object add(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
            return super.add(frame, a, b, precision);
        }

        @Override
        @Specialization(guards={"isRubyBigDecimal(b)", "!isNormal(a) || !isNormal(b)"})
        protected Object addSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
            return super.addSpecial(frame, a, b, precision);
        }
    }

    @CoreMethod(names={"+"}, required=1)
    public static abstract class AddOpNode
    extends AbstractAddNode {
        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public Object add(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            return this.add(frame, a, b, this.getLimit(frame));
        }

        @Specialization(guards={"isRubyBigDecimal(b)", "!isNormal(a) || !isNormal(b)"})
        public Object addSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            return this.addSpecial(frame, a, b, 0);
        }
    }

    public static abstract class AbstractAddNode
    extends OpNode {
        @CompilerDirectives.TruffleBoundary
        private BigDecimal addBigDecimal(DynamicObject a, DynamicObject b, MathContext mathContext) {
            return Layouts.BIG_DECIMAL.getValue(a).add(Layouts.BIG_DECIMAL.getValue(b), mathContext);
        }

        protected Object add(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
            return this.createBigDecimal(frame, this.addBigDecimal(a, b, new MathContext(precision, this.getRoundMode(frame))));
        }

        protected Object addSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
            Type aType = Layouts.BIG_DECIMAL.getType(a);
            Type bType = Layouts.BIG_DECIMAL.getType(b);
            if (aType == Type.NAN || bType == Type.NAN || aType == Type.POSITIVE_INFINITY && bType == Type.NEGATIVE_INFINITY || aType == Type.NEGATIVE_INFINITY && bType == Type.POSITIVE_INFINITY) {
                return this.createBigDecimal(frame, (Object)Type.NAN);
            }
            if (aType == Type.POSITIVE_INFINITY || bType == Type.POSITIVE_INFINITY) {
                return this.createBigDecimal(frame, (Object)Type.POSITIVE_INFINITY);
            }
            if (aType == Type.NEGATIVE_INFINITY || bType == Type.NEGATIVE_INFINITY) {
                return this.createBigDecimal(frame, (Object)Type.NEGATIVE_INFINITY);
            }
            if (AbstractAddNode.isNormal(a)) {
                return a;
            }
            return b;
        }
    }

    @NodeChildren(value={@NodeChild(value="a", type=RubyNode.class), @NodeChild(value="b", type=RubyNode.class)})
    public static abstract class OpNode
    extends BigDecimalCoreMethodNode {
        @CreateCast(value={"b"})
        protected RubyNode castB(RubyNode b) {
            return BigDecimalNodesFactory.BigDecimalCoerceNodeGen.create(null, null, b);
        }
    }

    @CoreMethod(names={"initialize"}, required=1, optional=1)
    public static abstract class InitializeNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        @Specialization
        public Object initialize(VirtualFrame frame, DynamicObject self, Object value, NotProvided digits) {
            return this.initializeBigDecimal(frame, value, self, digits);
        }

        @Specialization
        public Object initialize(VirtualFrame frame, DynamicObject self, Object value, int digits) {
            return this.initializeBigDecimal(frame, value, self, digits);
        }
    }

    @ImportStatic(value={Type.class})
    @NodeChildren(value={@NodeChild(value="value", type=RubyNode.class), @NodeChild(value="self", type=RubyNode.class), @NodeChild(value="digits", type=RubyNode.class)})
    public static abstract class CreateBigDecimalNode
    extends BigDecimalCoreMethodNode {
        private static final Pattern NUMBER_PATTERN;
        private static final Pattern ZERO_PATTERN;
        @Node.Child
        private BigDecimalCastNode bigDecimalCast;
        @Node.Child
        private CallDispatchHeadNode modeCall;
        @Node.Child
        private GetIntegerConstantNode getIntegerConstant;
        @Node.Child
        private BooleanCastNode booleanCast;
        @Node.Child
        private CallDispatchHeadNode allocateNode;

        public CreateBigDecimalNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.bigDecimalCast = BigDecimalNodesFactory.BigDecimalCastNodeGen.create(context, sourceSection, null, null);
        }

        private void setBigDecimalValue(DynamicObject bigdecimal, BigDecimal value) {
            Layouts.BIG_DECIMAL.setValue(bigdecimal, value);
        }

        private void setBigDecimalValue(DynamicObject bigdecimal, Type type) {
            Layouts.BIG_DECIMAL.setType(bigdecimal, type);
        }

        public abstract DynamicObject executeInitialize(VirtualFrame var1, Object var2, DynamicObject var3, Object var4);

        public final DynamicObject executeCreate(VirtualFrame frame, Object value) {
            if (this.allocateNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.allocateNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), true));
            }
            DynamicObject rubyClass = this.getBigDecimalClass();
            return this.executeInitialize(frame, value, (DynamicObject)this.allocateNode.call(frame, rubyClass, "allocate", null, new Object[0]), NotProvided.INSTANCE);
        }

        @Specialization
        public DynamicObject create(VirtualFrame frame, long value, DynamicObject self, NotProvided digits) {
            return this.create(frame, value, self, 0);
        }

        @Specialization
        public DynamicObject create(VirtualFrame frame, long value, DynamicObject self, int digits) {
            this.setBigDecimalValue(self, this.bigDecimalCast.executeBigDecimal(frame, value, this.getRoundMode(frame)).round(new MathContext(digits, this.getRoundMode(frame))));
            return self;
        }

        @Specialization
        public DynamicObject create(VirtualFrame frame, double value, DynamicObject self, NotProvided digits) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.coreExceptions().argumentError("can't omit precision for a Float.", this));
        }

        @Specialization
        public DynamicObject create(VirtualFrame frame, double value, DynamicObject self, int digits) {
            this.setBigDecimalValue(self, this.bigDecimalCast.executeBigDecimal(frame, value, this.getRoundMode(frame)).round(new MathContext(digits, this.getRoundMode(frame))));
            return self;
        }

        @Specialization(guards={"value == NEGATIVE_INFINITY || value == POSITIVE_INFINITY"})
        public DynamicObject createInfinity(VirtualFrame frame, Type value, DynamicObject self, Object digits) {
            return this.createWithMode(frame, value, self, "EXCEPTION_INFINITY", "Computation results to 'Infinity'");
        }

        @Specialization(guards={"value == NAN"})
        public DynamicObject createNaN(VirtualFrame frame, Type value, DynamicObject self, Object digits) {
            return this.createWithMode(frame, value, self, "EXCEPTION_NaN", "Computation results to 'NaN'(Not a Number)");
        }

        @Specialization(guards={"value == NEGATIVE_ZERO"})
        public DynamicObject createNegativeZero(VirtualFrame frame, Type value, DynamicObject self, Object digits) {
            this.setBigDecimalValue(self, value);
            return self;
        }

        @Specialization
        public DynamicObject create(VirtualFrame frame, BigDecimal value, DynamicObject self, NotProvided digits) {
            return this.create(frame, value, self, 0);
        }

        @Specialization
        public DynamicObject create(VirtualFrame frame, BigDecimal value, DynamicObject self, int digits) {
            this.setBigDecimalValue(self, value.round(new MathContext(digits, this.getRoundMode(frame))));
            return self;
        }

        @Specialization(guards={"isRubyBignum(value)"})
        public DynamicObject createBignum(VirtualFrame frame, DynamicObject value, DynamicObject self, NotProvided digits) {
            return this.createBignum(frame, value, self, 0);
        }

        @Specialization(guards={"isRubyBignum(value)"})
        public DynamicObject createBignum(VirtualFrame frame, DynamicObject value, DynamicObject self, int digits) {
            this.setBigDecimalValue(self, BigDecimalNodes.getBignumBigDecimalValue(value).round(new MathContext(digits, this.getRoundMode(frame))));
            return self;
        }

        @Specialization(guards={"isRubyBigDecimal(value)"})
        public DynamicObject createBigDecimal(VirtualFrame frame, DynamicObject value, DynamicObject self, NotProvided digits) {
            return this.createBigDecimal(frame, value, self, 0);
        }

        @Specialization(guards={"isRubyBigDecimal(value)"})
        public DynamicObject createBigDecimal(VirtualFrame frame, DynamicObject value, DynamicObject self, int digits) {
            this.setBigDecimalValue(self, Layouts.BIG_DECIMAL.getValue(value).round(new MathContext(digits, this.getRoundMode(frame))));
            return self;
        }

        @Specialization(guards={"isRubyString(value)"})
        public DynamicObject createString(VirtualFrame frame, DynamicObject value, DynamicObject self, NotProvided digits) {
            return this.createString(frame, value, self, 0);
        }

        @Specialization(guards={"isRubyString(value)"})
        public DynamicObject createString(VirtualFrame frame, DynamicObject value, DynamicObject self, int digits) {
            return this.executeInitialize(frame, this.getValueFromString(value.toString(), digits), self, digits);
        }

        @Specialization(guards={"!isRubyBignum(value)", "!isRubyBigDecimal(value)", "!isRubyString(value)"})
        public DynamicObject create(VirtualFrame frame, DynamicObject value, DynamicObject self, int digits) {
            Object castedValue = this.bigDecimalCast.executeObject(frame, value, this.getRoundMode(frame));
            if (castedValue == this.nil()) {
                throw new RaiseException(this.coreExceptions().typeError("could not be casted to BigDecimal", this));
            }
            this.setBigDecimalValue(self, ((BigDecimal)castedValue).round(new MathContext(digits, this.getRoundMode(frame))));
            return self;
        }

        private DynamicObject createWithMode(VirtualFrame frame, Type value, DynamicObject self, String constantName, String errorMessage) {
            this.setupModeCall();
            this.setupGetIntegerConstant();
            this.setupBooleanCast();
            int exceptionConstant = this.getIntegerConstant.executeGetIntegerConstant(frame, this.getBigDecimalClass(), constantName);
            boolean raise = this.booleanCast.executeBoolean(frame, this.modeCall.call(frame, this.getBigDecimalClass(), "boolean_mode", null, exceptionConstant));
            if (raise) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().floatDomainError(errorMessage, this));
            }
            this.setBigDecimalValue(self, value);
            return self;
        }

        private void setupBooleanCast() {
            if (this.booleanCast == null) {
                CompilerDirectives.transferToInterpreter();
                this.booleanCast = (BooleanCastNode)this.insert(BooleanCastNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
        }

        private void setupGetIntegerConstant() {
            if (this.getIntegerConstant == null) {
                CompilerDirectives.transferToInterpreter();
                this.getIntegerConstant = (GetIntegerConstantNode)this.insert(BigDecimalNodesFactory.GetIntegerConstantNodeGen.create(this.getContext(), this.getSourceSection(), null, null));
            }
        }

        private void setupModeCall() {
            if (this.modeCall == null) {
                CompilerDirectives.transferToInterpreter();
                this.modeCall = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), true));
            }
        }

        @CompilerDirectives.TruffleBoundary
        private Object getValueFromString(String string, int digits) {
            String strValue;
            switch (strValue = string.trim()) {
                case "NaN": {
                    return Type.NAN;
                }
                case "Infinity": 
                case "+Infinity": {
                    return Type.POSITIVE_INFINITY;
                }
                case "-Infinity": {
                    return Type.NEGATIVE_INFINITY;
                }
                case "-0": {
                    return Type.NEGATIVE_ZERO;
                }
            }
            strValue = strValue.replaceFirst("[dD]", "E");
            strValue = strValue.replaceAll("_", "");
            Matcher matcher = NUMBER_PATTERN.matcher(strValue);
            strValue = matcher.replaceFirst("$1");
            MatchResult result = matcher.toMatchResult();
            try {
                BigDecimal value = new BigDecimal(strValue, new MathContext(digits));
                if (value.compareTo(BigDecimal.ZERO) == 0 && strValue.startsWith("-")) {
                    return Type.NEGATIVE_ZERO;
                }
                return value;
            }
            catch (NumberFormatException e) {
                if (ZERO_PATTERN.matcher(strValue).matches()) {
                    return BigDecimal.ZERO;
                }
                BigInteger exponent = new BigInteger(result.group(3));
                if (exponent.signum() == 1) {
                    return Type.POSITIVE_INFINITY;
                }
                if (exponent.signum() == -1) {
                    return BigDecimal.ZERO;
                }
                throw e;
            }
        }

        static {
            String exponent = "([eE][+-]?)?(\\d*)";
            NUMBER_PATTERN = Pattern.compile("^([+-]?\\d*\\.?\\d*([eE][+-]?)?(\\d*)).*");
            ZERO_PATTERN = Pattern.compile("^[+-]?0*\\.?0*([eE][+-]?)?(\\d*)");
        }
    }

    @NodeChild(value="arguments", type=RubyNode[].class)
    public static abstract class BigDecimalCoreMethodArrayArgumentsNode
    extends BigDecimalCoreMethodNode {
        public BigDecimalCoreMethodArrayArgumentsNode() {
        }

        public BigDecimalCoreMethodArrayArgumentsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }
    }

    public static abstract class BigDecimalCoreMethodNode
    extends CoreMethodNode {
        @Node.Child
        private CreateBigDecimalNode createBigDecimal;
        @Node.Child
        private CallDispatchHeadNode limitCall;
        @Node.Child
        private IntegerCastNode limitIntegerCast;
        @Node.Child
        private CallDispatchHeadNode roundModeCall;
        @Node.Child
        private IntegerCastNode roundModeIntegerCast;

        public BigDecimalCoreMethodNode() {
        }

        public BigDecimalCoreMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public static boolean isNormal(DynamicObject value) {
            return Layouts.BIG_DECIMAL.getType(value) == Type.NORMAL;
        }

        public static boolean isNormalRubyBigDecimal(DynamicObject value) {
            return RubyGuards.isRubyBigDecimal(value) && Layouts.BIG_DECIMAL.getType(value) == Type.NORMAL;
        }

        public static boolean isSpecialRubyBigDecimal(DynamicObject value) {
            return RubyGuards.isRubyBigDecimal(value) && Layouts.BIG_DECIMAL.getType(value) != Type.NORMAL;
        }

        public static boolean isNormalZero(DynamicObject value) {
            return Layouts.BIG_DECIMAL.getValue(value).compareTo(BigDecimal.ZERO) == 0;
        }

        public static boolean isNan(DynamicObject value) {
            return Layouts.BIG_DECIMAL.getType(value) == Type.NAN;
        }

        private void setupCreateBigDecimal() {
            if (this.createBigDecimal == null) {
                CompilerDirectives.transferToInterpreter();
                this.createBigDecimal = (CreateBigDecimalNode)this.insert(BigDecimalNodesFactory.CreateBigDecimalNodeFactory.create(this.getContext(), this.getSourceSection(), null, null, null));
            }
        }

        protected DynamicObject createBigDecimal(VirtualFrame frame, Object value) {
            this.setupCreateBigDecimal();
            return this.createBigDecimal.executeCreate(frame, value);
        }

        protected DynamicObject initializeBigDecimal(VirtualFrame frame, Object value, DynamicObject self, Object digits) {
            this.setupCreateBigDecimal();
            return this.createBigDecimal.executeInitialize(frame, value, self, digits);
        }

        private void setupLimitCall() {
            if (this.limitCall == null) {
                CompilerDirectives.transferToInterpreter();
                this.limitCall = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
        }

        private void setupLimitIntegerCast() {
            if (this.limitIntegerCast == null) {
                CompilerDirectives.transferToInterpreter();
                this.limitIntegerCast = (IntegerCastNode)this.insert(IntegerCastNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
        }

        protected int getLimit(VirtualFrame frame) {
            this.setupLimitCall();
            this.setupLimitIntegerCast();
            return this.limitIntegerCast.executeCastInt(this.limitCall.call(frame, this.getBigDecimalClass(), "limit", null, new Object[0]));
        }

        private void setupRoundModeCall() {
            if (this.roundModeCall == null) {
                CompilerDirectives.transferToInterpreter();
                this.roundModeCall = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
        }

        private void setupRoundModeIntegerCast() {
            if (this.roundModeIntegerCast == null) {
                CompilerDirectives.transferToInterpreter();
                this.roundModeIntegerCast = (IntegerCastNode)this.insert(IntegerCastNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
        }

        protected RoundingMode getRoundMode(VirtualFrame frame) {
            this.setupRoundModeCall();
            this.setupRoundModeIntegerCast();
            return BigDecimalNodes.toRoundingMode(this.roundModeIntegerCast.executeCastInt(this.roundModeCall.call(frame, this.getBigDecimalClass(), "mode", null, 256)));
        }

        protected DynamicObject getBigDecimalClass() {
            return this.coreLibrary().getBigDecimalClass();
        }
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type NEGATIVE_INFINITY = new Type("-Infinity");
        public static final /* enum */ Type POSITIVE_INFINITY = new Type("Infinity");
        public static final /* enum */ Type NAN = new Type("NaN");
        public static final /* enum */ Type NEGATIVE_ZERO = new Type("-0");
        public static final /* enum */ Type NORMAL = new Type(null);
        private final String representation;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(String representation) {
            this.representation = representation;
        }

        public String getRepresentation() {
            assert (this.representation != null);
            return this.representation;
        }

        static {
            $VALUES = new Type[]{NEGATIVE_INFINITY, POSITIVE_INFINITY, NAN, NEGATIVE_ZERO, NORMAL};
        }
    }
}

