/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.yield;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.array.ArrayOperations;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.yield.YieldNode;

public class YieldExpressionNode
extends RubyNode {
    private final boolean unsplat;
    @Node.Children
    private final RubyNode[] arguments;
    @Node.Child
    private YieldNode yieldNode;
    private final BranchProfile useCapturedBlock = BranchProfile.create();
    private final BranchProfile noCapturedBlock = BranchProfile.create();

    public YieldExpressionNode(RubyContext context, SourceSection sourceSection, boolean unsplat, RubyNode[] arguments) {
        super(context, sourceSection);
        this.unsplat = unsplat;
        this.arguments = arguments;
    }

    @Override
    @ExplodeLoop
    public final Object execute(VirtualFrame frame) {
        Object[] argumentsObjects = new Object[this.arguments.length];
        for (int i = 0; i < this.arguments.length; ++i) {
            argumentsObjects[i] = this.arguments[i].execute(frame);
        }
        DynamicObject block = RubyArguments.getBlock((Frame)frame);
        if (block == null) {
            this.useCapturedBlock.enter();
            block = RubyArguments.getMethod((Frame)frame).getCapturedBlock();
            if (block == null) {
                this.noCapturedBlock.enter();
                throw new RaiseException(this.coreExceptions().noBlockToYieldTo(this));
            }
        }
        if (this.unsplat) {
            argumentsObjects = this.unsplat(argumentsObjects);
        }
        return this.getYieldNode().dispatch(frame, block, argumentsObjects);
    }

    @CompilerDirectives.TruffleBoundary
    private Object[] unsplat(Object[] argumentsObjects) {
        assert (argumentsObjects.length == 1);
        assert (RubyGuards.isRubyArray(argumentsObjects[0]));
        return ArrayOperations.toObjectArray((DynamicObject)argumentsObjects[0]);
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        if (RubyArguments.getBlock((Frame)frame) == null) {
            return this.nil();
        }
        return this.coreStrings().YIELD.createInstance();
    }

    private YieldNode getYieldNode() {
        if (this.yieldNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.yieldNode = (YieldNode)this.insert(new YieldNode(this.getContext()));
        }
        return this.yieldNode;
    }
}

