/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import jnr.posix.FileStat;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.rubinius.RubiniusPrimitive;
import org.jruby.truffle.core.rubinius.RubiniusPrimitiveArrayArgumentsNode;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.SnippetNode;
import org.jruby.truffle.platform.UnsafeGroup;

public abstract class StatPrimitiveNodes {
    static FileStat getStat(DynamicObject rubyStat) {
        return Layouts.STAT.getStat(rubyStat);
    }

    @RubiniusPrimitive(name="stat_uid", unsafe={UnsafeGroup.IO})
    public static abstract class StatUIDPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization
        public int uid(DynamicObject rubyStat) {
            return StatPrimitiveNodes.getStat(rubyStat).uid();
        }
    }

    @RubiniusPrimitive(name="stat_gid", unsafe={UnsafeGroup.IO})
    public static abstract class StatGIDPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization
        public int gid(DynamicObject rubyStat) {
            return StatPrimitiveNodes.getStat(rubyStat).gid();
        }
    }

    @RubiniusPrimitive(name="stat_mode", unsafe={UnsafeGroup.IO})
    public static abstract class StatModePrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization
        public int mode(DynamicObject rubyStat) {
            return StatPrimitiveNodes.getStat(rubyStat).mode();
        }
    }

    @RubiniusPrimitive(name="stat_size", unsafe={UnsafeGroup.IO})
    public static abstract class StatSizePrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization
        public long size(DynamicObject rubyStat) {
            return StatPrimitiveNodes.getStat(rubyStat).st_size();
        }
    }

    @RubiniusPrimitive(name="stat_lstat", unsafe={UnsafeGroup.IO})
    public static abstract class StatLStatPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        public StatLStatPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(path)"})
        public int lstat(DynamicObject rubyStat, DynamicObject path) {
            FileStat stat = this.posix().allocateStat();
            int code = this.posix().lstat(path.toString(), stat);
            if (code == 0) {
                Layouts.STAT.setStat(rubyStat, stat);
            }
            return code;
        }

        @Specialization(guards={"!isRubyString(path)"})
        public Object stat(DynamicObject rubyStat, Object path) {
            return null;
        }
    }

    @RubiniusPrimitive(name="stat_fstat", unsafe={UnsafeGroup.IO})
    public static abstract class StatFStatPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        public StatFStatPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int fstat(DynamicObject rubyStat, int fd) {
            FileStat stat = this.posix().allocateStat();
            int code = this.posix().fstat(fd, stat);
            if (code == 0) {
                Layouts.STAT.setStat(rubyStat, stat);
            }
            return code;
        }
    }

    @RubiniusPrimitive(name="stat_stat", unsafe={UnsafeGroup.IO})
    public static abstract class StatStatPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        public StatStatPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(path)"})
        public int stat(DynamicObject rubyStat, DynamicObject path) {
            FileStat stat = this.posix().allocateStat();
            int code = this.posix().stat(StringOperations.decodeUTF8(path), stat);
            if (code == 0) {
                Layouts.STAT.setStat(rubyStat, stat);
            }
            return code;
        }

        @Specialization(guards={"!isRubyString(path)"})
        public Object stat(DynamicObject rubyStat, Object path) {
            return null;
        }
    }

    @RubiniusPrimitive(name="stat_ino", unsafe={UnsafeGroup.IO})
    public static abstract class StatInoPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization
        public long ino(DynamicObject rubyStat) {
            return StatPrimitiveNodes.getStat(rubyStat).ino();
        }
    }

    @RubiniusPrimitive(name="stat_dev", unsafe={UnsafeGroup.IO})
    public static abstract class StatDevPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization
        public long dev(DynamicObject rubyStat) {
            return StatPrimitiveNodes.getStat(rubyStat).dev();
        }
    }

    @RubiniusPrimitive(name="stat_blocks", unsafe={UnsafeGroup.IO})
    public static abstract class StatBlocksPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization
        public long blocks(DynamicObject rubyStat) {
            return StatPrimitiveNodes.getStat(rubyStat).blocks();
        }
    }

    @RubiniusPrimitive(name="stat_blksize", unsafe={UnsafeGroup.IO})
    public static abstract class StatBlksizePrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization
        public long blksize(DynamicObject rubyStat) {
            return StatPrimitiveNodes.getStat(rubyStat).blockSize();
        }
    }

    @RubiniusPrimitive(name="stat_rdev", unsafe={UnsafeGroup.IO})
    public static abstract class RdevPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization
        public long rdev(DynamicObject rubyStat) {
            return StatPrimitiveNodes.getStat(rubyStat).rdev();
        }
    }

    @RubiniusPrimitive(name="stat_nlink", unsafe={UnsafeGroup.IO})
    public static abstract class NlinkPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization
        public int nlink(DynamicObject rubyStat) {
            return StatPrimitiveNodes.getStat(rubyStat).nlink();
        }
    }

    @RubiniusPrimitive(name="stat_mtime", unsafe={UnsafeGroup.IO})
    public static abstract class StatMtimePrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization
        public Object mtime(VirtualFrame frame, DynamicObject rubyStat, @Cached(value="new()") SnippetNode snippetNode) {
            long time = StatPrimitiveNodes.getStat(rubyStat).mtime();
            return snippetNode.execute(frame, "Time.at(time)", "time", time);
        }
    }

    @RubiniusPrimitive(name="stat_ctime", unsafe={UnsafeGroup.IO})
    public static abstract class StatCtimePrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization
        public Object ctime(VirtualFrame frame, DynamicObject rubyStat, @Cached(value="new()") SnippetNode snippetNode) {
            long time = StatPrimitiveNodes.getStat(rubyStat).ctime();
            return snippetNode.execute(frame, "Time.at(time)", "time", time);
        }
    }

    @RubiniusPrimitive(name="stat_atime", unsafe={UnsafeGroup.IO})
    public static abstract class StatAtimePrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization
        public Object atime(VirtualFrame frame, DynamicObject rubyStat, @Cached(value="new()") SnippetNode snippetNode) {
            long time = StatPrimitiveNodes.getStat(rubyStat).atime();
            return snippetNode.execute(frame, "Time.at(time)", "time", time);
        }
    }

    @RubiniusPrimitive(name="stat_allocate", unsafe={UnsafeGroup.IO})
    public static abstract class StatAllocatePrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization
        public DynamicObject allocate(DynamicObject classToAllocate) {
            return Layouts.STAT.createStat(this.coreLibrary().getStatFactory(), null);
        }
    }
}

