/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rubinius;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.method.MethodNodesFactory;
import org.jruby.truffle.core.rubinius.CallRubiniusPrimitiveNode;
import org.jruby.truffle.core.rubinius.RubiniusPrimitiveConstructor;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.ObjectArrayNode;
import org.jruby.truffle.language.arguments.ReadAllArgumentsNode;
import org.jruby.truffle.language.arguments.ReadBlockNode;
import org.jruby.truffle.language.control.ReturnID;
import org.jruby.truffle.language.literal.ObjectLiteralNode;

public class RubiniusPrimitiveCallConstructor
implements RubiniusPrimitiveConstructor {
    private final DynamicObject method;

    public RubiniusPrimitiveCallConstructor(DynamicObject method) {
        assert (RubyGuards.isRubyMethod(method));
        this.method = method;
    }

    @Override
    public int getPrimitiveArity() {
        return Layouts.METHOD.getMethod(this.method).getSharedMethodInfo().getArity().getPreRequired();
    }

    @Override
    public RubyNode createCallPrimitiveNode(RubyContext context, SourceSection sourceSection, ReturnID returnID) {
        return new CallRubiniusPrimitiveNode(context, sourceSection, MethodNodesFactory.CallNodeFactory.create(context, sourceSection, new RubyNode[]{new ObjectLiteralNode(context, sourceSection, this.method), new ReadAllArgumentsNode(), new ReadBlockNode(NotProvided.INSTANCE)}), returnID);
    }

    @Override
    public RubyNode createInvokePrimitiveNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
        return MethodNodesFactory.CallNodeFactory.create(context, sourceSection, new RubyNode[]{new ObjectLiteralNode(context, sourceSection, this.method), new ObjectArrayNode(arguments), new ReadBlockNode(NotProvided.INSTANCE)});
    }
}

