/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.method;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.CoreClass;
import org.jruby.truffle.core.CoreMethod;
import org.jruby.truffle.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.UnaryCoreMethodNode;
import org.jruby.truffle.core.basicobject.BasicObjectNodes;
import org.jruby.truffle.core.basicobject.BasicObjectNodesFactory;
import org.jruby.truffle.core.cast.ProcOrNullNode;
import org.jruby.truffle.core.cast.ProcOrNullNodeGen;
import org.jruby.truffle.core.proc.ProcOperations;
import org.jruby.truffle.core.proc.ProcType;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyRootNode;
import org.jruby.truffle.language.arguments.ArgumentDescriptorUtils;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.methods.CallBoundMethodNode;
import org.jruby.truffle.language.methods.CallBoundMethodNodeGen;
import org.jruby.truffle.language.methods.InternalMethod;
import org.jruby.truffle.language.objects.LogicalClassNode;
import org.jruby.truffle.language.objects.LogicalClassNodeGen;

@CoreClass(name="Method")
public abstract class MethodNodes {

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends UnaryCoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            throw new RaiseException(this.coreExceptions().typeErrorAllocatorUndefinedFor(rubyClass, this));
        }
    }

    private static class SetReceiverNode
    extends RubyNode {
        private final Object receiver;
        @Node.Child
        private DirectCallNode methodCallNode;

        public SetReceiverNode(RubyContext context, SourceSection sourceSection, Object receiver, CallTarget methodCallTarget) {
            super(context, sourceSection);
            this.receiver = receiver;
            this.methodCallNode = DirectCallNode.create((CallTarget)methodCallTarget);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            RubyArguments.setSelf(frame.getArguments(), this.receiver);
            return this.methodCallNode.call(frame, frame.getArguments());
        }
    }

    @CoreMethod(names={"to_proc"})
    public static abstract class ToProcNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"methodObject == cachedMethodObject"}, limit="getCacheLimit()")
        public DynamicObject toProcCached(DynamicObject methodObject, @Cached(value="methodObject") DynamicObject cachedMethodObject, @Cached(value="toProcUncached(cachedMethodObject)") DynamicObject proc) {
            return proc;
        }

        @Specialization
        public DynamicObject toProcUncached(DynamicObject methodObject) {
            CallTarget callTarget = this.method2proc(methodObject);
            InternalMethod method = Layouts.METHOD.getMethod(methodObject);
            return ProcOperations.createRubyProc(this.coreLibrary().getProcFactory(), ProcType.LAMBDA, method.getSharedMethodInfo(), callTarget, callTarget, null, method, Layouts.METHOD.getReceiver(methodObject), null);
        }

        @CompilerDirectives.TruffleBoundary
        protected CallTarget method2proc(DynamicObject methodObject) {
            InternalMethod method = Layouts.METHOD.getMethod(methodObject);
            SourceSection sourceSection = method.getSharedMethodInfo().getSourceSection();
            RootNode oldRootNode = ((RootCallTarget)method.getCallTarget()).getRootNode();
            SetReceiverNode setReceiverNode = new SetReceiverNode(this.getContext(), sourceSection, Layouts.METHOD.getReceiver(methodObject), method.getCallTarget());
            RubyRootNode newRootNode = new RubyRootNode(this.getContext(), sourceSection, oldRootNode.getFrameDescriptor(), method.getSharedMethodInfo(), setReceiverNode, false);
            return Truffle.getRuntime().createCallTarget((RootNode)newRootNode);
        }

        protected int getCacheLimit() {
            return this.getContext().getOptions().METHOD_TO_PROC_CACHE;
        }
    }

    @CoreMethod(names={"unbind"})
    public static abstract class UnbindNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private LogicalClassNode classNode;

        public UnbindNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.classNode = LogicalClassNodeGen.create(context, sourceSection, null);
        }

        @Specialization
        public DynamicObject unbind(VirtualFrame frame, DynamicObject method) {
            DynamicObject receiverClass = this.classNode.executeLogicalClass(Layouts.METHOD.getReceiver(method));
            return Layouts.UNBOUND_METHOD.createUnboundMethod(this.coreLibrary().getUnboundMethodFactory(), receiverClass, Layouts.METHOD.getMethod(method));
        }
    }

    @CoreMethod(names={"source_location"})
    public static abstract class SourceLocationNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public Object sourceLocation(DynamicObject method) {
            CompilerDirectives.transferToInterpreter();
            SourceSection sourceSection = Layouts.METHOD.getMethod(method).getSharedMethodInfo().getSourceSection();
            if (sourceSection.getSource() == null) {
                return this.nil();
            }
            DynamicObject file = this.createString(StringOperations.encodeRope(sourceSection.getSource().getName(), (Encoding)UTF8Encoding.INSTANCE));
            Object[] objects = new Object[]{file, sourceSection.getStartLine()};
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), objects, objects.length);
        }
    }

    @CoreMethod(names={"receiver"})
    public static abstract class ReceiverNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public Object receiver(DynamicObject method) {
            return Layouts.METHOD.getReceiver(method);
        }
    }

    @CoreMethod(names={"parameters"})
    public static abstract class ParametersNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject parameters(DynamicObject method) {
            ArgumentDescriptor[] argsDesc = Layouts.METHOD.getMethod(method).getSharedMethodInfo().getArgumentDescriptors();
            return ArgumentDescriptorUtils.argumentDescriptorsToParameters(this.getContext(), argsDesc, true);
        }
    }

    @CoreMethod(names={"owner"})
    public static abstract class OwnerNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject owner(DynamicObject method) {
            return Layouts.METHOD.getMethod(method).getDeclaringModule();
        }
    }

    @CoreMethod(names={"name"})
    public static abstract class NameNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject name(DynamicObject method) {
            CompilerDirectives.transferToInterpreter();
            return this.getSymbol(Layouts.METHOD.getMethod(method).getName());
        }
    }

    @CoreMethod(names={"call", "[]"}, needsBlock=true, rest=true)
    public static abstract class CallNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        CallBoundMethodNode callBoundMethodNode;
        @Node.Child
        ProcOrNullNode procOrNullNode;

        public CallNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.callBoundMethodNode = CallBoundMethodNodeGen.create(context, sourceSection, null, null, null);
            this.procOrNullNode = ProcOrNullNodeGen.create(context, sourceSection, null);
        }

        @Specialization
        protected Object call(VirtualFrame frame, DynamicObject method, Object[] arguments, Object block) {
            return this.callBoundMethodNode.executeCallBoundMethod(frame, method, arguments, this.procOrNullNode.executeProcOrNull(block));
        }
    }

    @CoreMethod(names={"arity"})
    public static abstract class ArityNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int arity(DynamicObject method) {
            return Layouts.METHOD.getMethod(method).getSharedMethodInfo().getArity().getArityNumber();
        }
    }

    @CoreMethod(names={"==", "eql?"}, required=1)
    public static abstract class EqualNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        protected BasicObjectNodes.ReferenceEqualNode referenceEqualNode;

        protected boolean areSame(VirtualFrame frame, Object left, Object right) {
            if (this.referenceEqualNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.referenceEqualNode = (BasicObjectNodes.ReferenceEqualNode)this.insert(BasicObjectNodesFactory.ReferenceEqualNodeFactory.create(null, null));
            }
            return this.referenceEqualNode.executeReferenceEqual(frame, left, right);
        }

        @Specialization(guards={"isRubyMethod(b)"})
        public boolean equal(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            return this.areSame(frame, Layouts.METHOD.getReceiver(a), Layouts.METHOD.getReceiver(b)) && Layouts.METHOD.getMethod(a) == Layouts.METHOD.getMethod(b);
        }

        @Specialization(guards={"!isRubyMethod(b)"})
        public boolean equal(DynamicObject a, Object b) {
            return false;
        }
    }
}

