/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.read.bytes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.exceptions.InvalidFormatException;
import org.jruby.truffle.core.format.read.SourceNode;
import org.jruby.truffle.core.rope.AsciiOnlyLeafRope;
import org.jruby.util.Pack;

@NodeChildren(value={@NodeChild(value="value", type=SourceNode.class)})
public abstract class ReadBase64StringNode
extends FormatNode {
    public ReadBase64StringNode(RubyContext context) {
        super(context);
    }

    @Specialization
    public Object read(VirtualFrame frame, byte[] source) {
        int position = this.getSourcePosition(frame);
        int length = this.getSourceLength(frame);
        ByteBuffer encode = ByteBuffer.wrap(source, position, length - position);
        byte[] result = this.read(encode);
        this.setSourcePosition(frame, encode.position());
        return Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), new AsciiOnlyLeafRope(result, (Encoding)ASCIIEncoding.INSTANCE));
    }

    @CompilerDirectives.TruffleBoundary
    private byte[] read(ByteBuffer encode) {
        int occurrences = encode.remaining();
        int length = encode.remaining() * 3 / 4;
        byte[] lElem = new byte[length];
        int a = -1;
        int b = -1;
        int c = 0;
        int index = 0;
        int s = -1;
        if (occurrences == 0) {
            if (encode.remaining() % 4 != 0) {
                throw new InvalidFormatException("invalid base64");
            }
            while (encode.hasRemaining()) {
                s = Pack.safeGet((ByteBuffer)encode);
                a = Pack.b64_xtable[s];
                if (a == -1) {
                    throw new InvalidFormatException("invalid base64");
                }
                s = Pack.safeGet((ByteBuffer)encode);
                b = Pack.b64_xtable[s];
                if (b == -1) {
                    throw new InvalidFormatException("invalid base64");
                }
                s = Pack.safeGet((ByteBuffer)encode);
                c = Pack.b64_xtable[s];
                if (s == 61) {
                    if (Pack.safeGet((ByteBuffer)encode) == 61) break;
                    throw new InvalidFormatException("invalid base64");
                }
                if (c == -1) {
                    throw new InvalidFormatException("invalid base64");
                }
                s = Pack.safeGet((ByteBuffer)encode);
                int d = Pack.b64_xtable[s];
                if (s == 61) break;
                if (d == -1) {
                    throw new InvalidFormatException("invalid base64");
                }
                lElem[index++] = (byte)((a << 2 | b >> 4) & 0xFF);
                lElem[index++] = (byte)((b << 4 | c >> 2) & 0xFF);
                lElem[index++] = (byte)((c << 6 | d) & 0xFF);
            }
            if (encode.hasRemaining()) {
                throw new InvalidFormatException("invalid base64");
            }
            if (a != -1) {
                if (c == -1) {
                    if ((b & 0xF) != 0) {
                        throw new InvalidFormatException("invalid base64");
                    }
                    lElem[index++] = (byte)((a << 2 | b >> 4) & 0xFF);
                } else if (s == 61) {
                    if ((c & 3) != 0) {
                        throw new InvalidFormatException("invalid base64");
                    }
                    lElem[index++] = (byte)((a << 2 | b >> 4) & 0xFF);
                    lElem[index++] = (byte)((b << 4 | c >> 2) & 0xFF);
                }
            }
        } else {
            while (encode.hasRemaining()) {
                int d;
                c = -1;
                b = -1;
                s = Pack.safeGet((ByteBuffer)encode);
                while ((a = Pack.b64_xtable[s]) == -1 && encode.hasRemaining()) {
                    s = Pack.safeGet((ByteBuffer)encode);
                }
                if (a == -1) break;
                s = Pack.safeGet((ByteBuffer)encode);
                while ((b = Pack.b64_xtable[s]) == -1 && encode.hasRemaining()) {
                    s = Pack.safeGet((ByteBuffer)encode);
                }
                if (b == -1) break;
                s = Pack.safeGet((ByteBuffer)encode);
                while ((c = Pack.b64_xtable[s]) == -1 && encode.hasRemaining() && s != 61) {
                    s = Pack.safeGet((ByteBuffer)encode);
                }
                if (s == 61 || c == -1) {
                    if (s != 61) break;
                    encode.position(encode.position() - 1);
                    break;
                }
                s = Pack.safeGet((ByteBuffer)encode);
                while ((d = Pack.b64_xtable[s]) == -1 && encode.hasRemaining() && s != 61) {
                    s = Pack.safeGet((ByteBuffer)encode);
                }
                if (s == 61 || d == -1) {
                    if (s != 61) break;
                    encode.position(encode.position() - 1);
                    break;
                }
                lElem[index++] = (byte)((a << 2 | b >> 4) & 0xFF);
                lElem[index++] = (byte)((b << 4 | c >> 2) & 0xFF);
                lElem[index++] = (byte)((c << 6 | d) & 0xFF);
            }
            if (a != -1 && b != -1) {
                if (c == -1 && s == 61) {
                    lElem[index++] = (byte)((a << 2 | b >> 4) & 0xFF);
                } else if (c != -1 && s == 61) {
                    lElem[index++] = (byte)((a << 2 | b >> 4) & 0xFF);
                    lElem[index++] = (byte)((b << 4 | c >> 2) & 0xFF);
                }
            }
        }
        return Arrays.copyOfRange(lElem, 0, index);
    }
}

