/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.array.ArrayGuards;
import org.jruby.truffle.core.array.ArrayStrategy;
import org.jruby.truffle.language.RubyNode;

@ImportStatic(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array")})
public abstract class ArrayPopOneNode
extends RubyNode {
    public ArrayPopOneNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract Object executePopOne(DynamicObject var1);

    @Specialization(guards={"isEmptyArray(array)"})
    public DynamicObject popOneEmpty(DynamicObject array) {
        return this.nil();
    }

    @Specialization(guards={"strategy.matches(array)", "!isEmptyArray(array)"}, limit="ARRAY_STRATEGIES")
    public Object popOne(DynamicObject array, @Cached(value="of(array)") ArrayStrategy strategy) {
        int size = Layouts.ARRAY.getSize(array);
        Object value = strategy.newMirror(array).get(size - 1);
        Layouts.ARRAY.setSize(array, size - 1);
        return value;
    }
}

