/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.language.RubyGuards;

public class ArrayGuards {
    public static final int ARRAY_STRATEGIES = 25;

    public static boolean isNullArray(DynamicObject array) {
        assert (RubyGuards.isRubyArray(array));
        return Layouts.ARRAY.getStore(array) == null;
    }

    public static boolean isIntArray(DynamicObject array) {
        assert (RubyGuards.isRubyArray(array));
        return Layouts.ARRAY.getStore(array) instanceof int[];
    }

    public static boolean isLongArray(DynamicObject array) {
        assert (RubyGuards.isRubyArray(array));
        return Layouts.ARRAY.getStore(array) instanceof long[];
    }

    public static boolean isDoubleArray(DynamicObject array) {
        assert (RubyGuards.isRubyArray(array));
        return Layouts.ARRAY.getStore(array) instanceof double[];
    }

    public static boolean isObjectArray(DynamicObject array) {
        assert (RubyGuards.isRubyArray(array));
        Object store = Layouts.ARRAY.getStore(array);
        return store != null && store.getClass() == Object[].class;
    }

    public static boolean isEmptyArray(DynamicObject array) {
        assert (RubyGuards.isRubyArray(array));
        return Layouts.ARRAY.getSize(array) == 0;
    }
}

