/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.cast.BooleanCastNode;
import org.jruby.truffle.core.cast.BooleanCastNodeGen;
import org.jruby.truffle.language.yield.YieldNode;

public abstract class YieldingCoreMethodNode
extends CoreMethodArrayArgumentsNode {
    @Node.Child
    private YieldNode dispatchNode;
    @Node.Child
    private BooleanCastNode booleanCastNode;

    public YieldingCoreMethodNode() {
        this(null, null);
    }

    public YieldingCoreMethodNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.dispatchNode = new YieldNode(context);
    }

    private boolean booleanCast(VirtualFrame frame, Object value) {
        if (this.booleanCastNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.booleanCastNode = (BooleanCastNode)this.insert(BooleanCastNodeGen.create(this.getContext(), this.getSourceSection(), null));
        }
        return this.booleanCastNode.executeBoolean(frame, value);
    }

    public Object yield(VirtualFrame frame, DynamicObject block, Object ... arguments) {
        return this.dispatchNode.dispatch(frame, block, arguments);
    }

    public Object yieldWithModifiedBlock(VirtualFrame frame, DynamicObject block, DynamicObject modifiedBlock, Object ... arguments) {
        return this.dispatchNode.dispatchWithModifiedBlock(frame, block, modifiedBlock, arguments);
    }

    public boolean yieldIsTruthy(VirtualFrame frame, DynamicObject block, Object ... arguments) {
        return this.booleanCast(frame, this.yield(frame, block, arguments));
    }
}

