/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.layouts;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.jruby.truffle.runtime.core.ModuleFields;
import org.jruby.truffle.runtime.layouts.ClassLayout;
import org.jruby.truffle.runtime.layouts.ModuleLayoutImpl;

public class ClassLayoutImpl
extends ModuleLayoutImpl
implements ClassLayout {
    public static final ClassLayout INSTANCE = new ClassLayoutImpl();
    protected static final Shape.Allocator CLASS_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey IS_SINGLETON_IDENTIFIER;
    protected static final Property IS_SINGLETON_PROPERTY;
    protected static final HiddenKey ATTACHED_IDENTIFIER;
    protected static final Property ATTACHED_PROPERTY;
    protected static final HiddenKey INSTANCE_FACTORY_IDENTIFIER;
    protected static final Property INSTANCE_FACTORY_PROPERTY;

    protected ClassLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createClassShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape((ObjectType)new ClassType(logicalClass, metaClass)).addProperty(FIELDS_PROPERTY).addProperty(IS_SINGLETON_PROPERTY).addProperty(ATTACHED_PROPERTY).addProperty(INSTANCE_FACTORY_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createClass(DynamicObjectFactory factory, ModuleFields fields, boolean isSingleton, DynamicObject attached, DynamicObjectFactory instanceFactory) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant((Object)factory);
        assert (this.createsClass(factory));
        assert (factory.getShape().hasProperty((Object)FIELDS_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)IS_SINGLETON_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)ATTACHED_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)INSTANCE_FACTORY_IDENTIFIER));
        assert (fields != null);
        return factory.newInstance(new Object[]{fields, isSingleton, attached, instanceFactory});
    }

    @Override
    public boolean isClass(Object object) {
        return object instanceof DynamicObject && this.isClass((DynamicObject)object);
    }

    @Override
    public boolean isClass(DynamicObject object) {
        return this.isClass(object.getShape().getObjectType());
    }

    private boolean isClass(ObjectType objectType) {
        return objectType instanceof ClassType;
    }

    private boolean createsClass(DynamicObjectFactory factory) {
        return this.isClass(factory.getShape().getObjectType());
    }

    @Override
    public boolean getIsSingleton(DynamicObject object) {
        assert (this.isClass(object));
        assert (object.getShape().hasProperty((Object)IS_SINGLETON_IDENTIFIER));
        return (Boolean)IS_SINGLETON_PROPERTY.get(object, true);
    }

    @Override
    public DynamicObject getAttached(DynamicObject object) {
        assert (this.isClass(object));
        assert (object.getShape().hasProperty((Object)ATTACHED_IDENTIFIER));
        return (DynamicObject)ATTACHED_PROPERTY.get(object, true);
    }

    @Override
    public DynamicObjectFactory getInstanceFactory(DynamicObject object) {
        assert (this.isClass(object));
        assert (object.getShape().hasProperty((Object)INSTANCE_FACTORY_IDENTIFIER));
        return (DynamicObjectFactory)INSTANCE_FACTORY_PROPERTY.get(object, true);
    }

    @Override
    public void setInstanceFactoryUnsafe(DynamicObject object, DynamicObjectFactory value) {
        assert (this.isClass(object));
        assert (object.getShape().hasProperty((Object)INSTANCE_FACTORY_IDENTIFIER));
        INSTANCE_FACTORY_PROPERTY.setInternal(object, (Object)value);
    }

    static {
        CLASS_ALLOCATOR.locationForType(ModuleFields.class, EnumSet.of(LocationModifier.NonNull));
        IS_SINGLETON_IDENTIFIER = new HiddenKey("isSingleton");
        IS_SINGLETON_PROPERTY = Property.create((Object)IS_SINGLETON_IDENTIFIER, (Location)CLASS_ALLOCATOR.locationForType(Boolean.TYPE, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), (int)0);
        ATTACHED_IDENTIFIER = new HiddenKey("attached");
        ATTACHED_PROPERTY = Property.create((Object)ATTACHED_IDENTIFIER, (Location)CLASS_ALLOCATOR.locationForType(DynamicObject.class, EnumSet.of(LocationModifier.Final)), (int)0);
        INSTANCE_FACTORY_IDENTIFIER = new HiddenKey("instanceFactory");
        INSTANCE_FACTORY_PROPERTY = Property.create((Object)INSTANCE_FACTORY_IDENTIFIER, (Location)CLASS_ALLOCATOR.locationForType(DynamicObjectFactory.class, EnumSet.of(LocationModifier.Final)), (int)0);
    }

    protected static class ClassType
    extends ModuleLayoutImpl.ModuleType {
        public ClassType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public ClassType setLogicalClass(DynamicObject logicalClass) {
            return new ClassType(logicalClass, this.metaClass);
        }

        @Override
        public ClassType setMetaClass(DynamicObject metaClass) {
            return new ClassType(this.logicalClass, metaClass);
        }
    }
}

