/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerOptions;
import com.oracle.truffle.api.ExecutionContext;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrument.ASTProber;
import com.oracle.truffle.api.instrument.Instrumenter;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.tools.CoverageTracker;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import jnr.ffi.LibraryLoader;
import jnr.posix.POSIX;
import jnr.posix.POSIXFactory;
import jnr.posix.POSIXHandler;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyString;
import org.jruby.ext.ffi.Platform;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.truffle.callgraph.CallGraph;
import org.jruby.truffle.callgraph.SimpleWriter;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyRootNode;
import org.jruby.truffle.nodes.control.SequenceNode;
import org.jruby.truffle.nodes.core.BindingNodes;
import org.jruby.truffle.nodes.core.LoadRequiredLibrariesNode;
import org.jruby.truffle.nodes.core.SetTopLevelBindingNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.exceptions.TopLevelRaiseHandler;
import org.jruby.truffle.nodes.instrument.RubyDefaultASTProber;
import org.jruby.truffle.nodes.methods.DeclarationContext;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveManager;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.Options;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.ArrayOperations;
import org.jruby.truffle.runtime.core.CoreLibrary;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.core.SymbolTable;
import org.jruby.truffle.runtime.ffi.LibCClockGetTime;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.loader.FeatureLoader;
import org.jruby.truffle.runtime.loader.SourceCache;
import org.jruby.truffle.runtime.loader.SourceLoader;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.platform.CrtExterns;
import org.jruby.truffle.runtime.rubinius.RubiniusConfiguration;
import org.jruby.truffle.runtime.sockets.NativeSockets;
import org.jruby.truffle.runtime.subsystems.AtExitManager;
import org.jruby.truffle.runtime.subsystems.AttachmentsManager;
import org.jruby.truffle.runtime.subsystems.InstrumentationServerManager;
import org.jruby.truffle.runtime.subsystems.ObjectSpaceManager;
import org.jruby.truffle.runtime.subsystems.SafepointManager;
import org.jruby.truffle.runtime.subsystems.ThreadManager;
import org.jruby.truffle.runtime.subsystems.TraceManager;
import org.jruby.truffle.runtime.subsystems.TrufflePOSIXHandler;
import org.jruby.truffle.runtime.subsystems.Warnings;
import org.jruby.truffle.translator.TranslatorDriver;
import org.jruby.util.ByteList;
import org.jruby.util.IdUtil;

public class RubyContext
extends ExecutionContext {
    private static volatile RubyContext latestInstance;
    private final Ruby runtime;
    private final Options options;
    private final POSIX posix;
    private final NativeSockets nativeSockets;
    private final LibCClockGetTime libCClockGetTime;
    private CrtExterns crtExterns;
    private final CoreLibrary coreLibrary;
    private final FeatureLoader featureLoader;
    private final TraceManager traceManager;
    private final ObjectSpaceManager objectSpaceManager;
    private final ThreadManager threadManager;
    private final AtExitManager atExitManager;
    private final SymbolTable symbolTable = new SymbolTable(this);
    private final Warnings warnings;
    private final SafepointManager safepointManager;
    private final LexicalScope rootLexicalScope;
    private final CompilerOptions compilerOptions;
    private final RubiniusPrimitiveManager rubiniusPrimitiveManager;
    private final CoverageTracker coverageTracker;
    private final InstrumentationServerManager instrumentationServerManager;
    private final AttachmentsManager attachmentsManager;
    private final SourceCache sourceCache;
    private final RubiniusConfiguration rubiniusConfiguration;
    private final CallGraph callGraph;
    private final AtomicLong nextObjectID = new AtomicLong(6L);
    private final boolean runningOnWindows;
    private final PrintStream debugStandardOut;
    private final Map<String, TruffleObject> exported = new HashMap<String, TruffleObject>();
    private final TruffleLanguage.Env env;
    private org.jruby.ast.RootNode initialJRubyRootNode;

    public RubyContext(Ruby runtime, TruffleLanguage.Env env) {
        this.options = new Options();
        this.callGraph = this.options.CALL_GRAPH ? new CallGraph() : null;
        latestInstance = this;
        assert (runtime != null);
        this.env = env;
        this.compilerOptions = Truffle.getRuntime().createCompilerOptions();
        if (!this.onGraal() && this.options.GRAAL_WARNING_UNLESS) {
            System.err.println("WARNING: JRuby+Truffle is designed to be used with a JVM that has the Graal compiler. Without the Graal compiler, performance will be drastically reduced. See https://github.com/jruby/jruby/wiki/Truffle-FAQ#how-do-i-get-jrubytruffle");
        }
        if (this.compilerOptions.supportsOption("MinTimeThreshold")) {
            this.compilerOptions.setOption("MinTimeThreshold", (Object)100000000);
        }
        if (this.compilerOptions.supportsOption("MinInliningMaxCallerSize")) {
            this.compilerOptions.setOption("MinInliningMaxCallerSize", (Object)5000);
        }
        env.instrumenter().registerASTProber((ASTProber)new RubyDefaultASTProber(env.instrumenter()));
        if (this.options.COVERAGE || this.options.COVERAGE_GLOBAL) {
            this.coverageTracker = new CoverageTracker();
            if (this.options.COVERAGE_GLOBAL) {
                env.instrumenter().install((Instrumenter.Tool)this.coverageTracker);
            }
        } else {
            this.coverageTracker = null;
        }
        this.safepointManager = new SafepointManager(this);
        this.runtime = runtime;
        this.posix = POSIXFactory.getNativePOSIX((POSIXHandler)new TrufflePOSIXHandler(this));
        this.nativeSockets = (NativeSockets)LibraryLoader.create(NativeSockets.class).library("c").load();
        try {
            this.crtExterns = (CrtExterns)LibraryLoader.create(CrtExterns.class).failImmediately().library("libSystem.B.dylib").load();
        }
        catch (UnsatisfiedLinkError e) {
            this.crtExterns = null;
        }
        this.libCClockGetTime = Platform.getPlatform().getOS() == Platform.OS_TYPE.LINUX ? (LibCClockGetTime)LibraryLoader.create(LibCClockGetTime.class).library("c").load() : null;
        this.warnings = new Warnings(this);
        this.objectSpaceManager = new ObjectSpaceManager(this);
        this.coreLibrary = new CoreLibrary(this);
        this.rootLexicalScope = new LexicalScope(null, this.coreLibrary.getObjectClass());
        this.coreLibrary.initialize();
        this.featureLoader = new FeatureLoader(this);
        this.traceManager = new TraceManager(this);
        this.atExitManager = new AtExitManager(this);
        this.threadManager = new ThreadManager(this);
        this.threadManager.initialize();
        this.rubiniusPrimitiveManager = new RubiniusPrimitiveManager();
        this.rubiniusPrimitiveManager.addAnnotatedPrimitives();
        if (this.options.INSTRUMENTATION_SERVER_PORT != 0) {
            this.instrumentationServerManager = new InstrumentationServerManager(this, this.options.INSTRUMENTATION_SERVER_PORT);
            this.instrumentationServerManager.start();
        } else {
            this.instrumentationServerManager = null;
        }
        this.runningOnWindows = Platform.getPlatform().getOS() == Platform.OS_TYPE.WINDOWS;
        this.attachmentsManager = new AttachmentsManager(this);
        this.sourceCache = new SourceCache(new SourceLoader(this));
        this.rubiniusConfiguration = RubiniusConfiguration.create(this);
        PrintStream configStandardOut = runtime.getInstanceConfig().getOutput();
        this.debugStandardOut = configStandardOut == System.out ? null : configStandardOut;
        this.initialize();
    }

    public boolean onGraal() {
        return Truffle.getRuntime().getName().toLowerCase(Locale.ENGLISH).contains("graal");
    }

    public Object send(Object object, String methodName, DynamicObject block, Object ... arguments) {
        CompilerAsserts.neverPartOfCompilation();
        assert (block == null || RubyGuards.isRubyProc(block));
        InternalMethod method = ModuleOperations.lookupMethod(this.coreLibrary.getMetaClass(object), methodName);
        if (method == null || method.isUndefined()) {
            return null;
        }
        return method.getCallTarget().call(RubyArguments.pack(null, null, method, DeclarationContext.METHOD, null, object, block, arguments));
    }

    public static Object debugEval(String code) {
        CompilerAsserts.neverPartOfCompilation();
        FrameInstance currentFrameInstance = Truffle.getRuntime().getCurrentFrame();
        Frame currentFrame = currentFrameInstance.getFrame(FrameInstance.FrameAccess.MATERIALIZE, true);
        return RubyContext.getLatestInstance().inlineRubyHelper(null, currentFrame, code, new Object[0]);
    }

    @CompilerDirectives.TruffleBoundary
    public Object inlineRubyHelper(Node currentNode, String expression, Object ... arguments) {
        return this.inlineRubyHelper(currentNode, Truffle.getRuntime().getCurrentFrame().getFrame(FrameInstance.FrameAccess.MATERIALIZE, true), expression, arguments);
    }

    public Object inlineRubyHelper(Node currentNode, Frame frame, String expression, Object ... arguments) {
        MaterializedFrame evalFrame = this.setupInlineRubyFrame(frame, arguments);
        DynamicObject binding = BindingNodes.createBinding(this, evalFrame);
        return this.eval(TranslatorDriver.ParserContext.INLINE, StringOperations.createByteList(expression), binding, true, "inline-ruby", currentNode);
    }

    private MaterializedFrame setupInlineRubyFrame(Frame frame, Object ... arguments) {
        CompilerDirectives.transferToInterpreter();
        MaterializedFrame evalFrame = Truffle.getRuntime().createMaterializedFrame(RubyArguments.pack(null, null, RubyArguments.getMethod(frame.getArguments()), DeclarationContext.INSTANCE_EVAL, null, RubyArguments.getSelf(frame.getArguments()), null, new Object[0]), new FrameDescriptor(frame.getFrameDescriptor().getDefaultValue()));
        if (arguments.length % 2 == 1) {
            throw new UnsupportedOperationException("odd number of name-value pairs for arguments");
        }
        for (int n = 0; n < arguments.length; n += 2) {
            evalFrame.setObject(evalFrame.getFrameDescriptor().findOrAddFrameSlot(arguments[n]), arguments[n + 1]);
        }
        return evalFrame;
    }

    private void initialize() {
        this.coreLibrary.initializeAfterMethodsAdded();
        for (IRubyObject arg : ((RubyArray)this.runtime.getObject().getConstant("ARGV")).toJavaArray()) {
            assert (arg != null);
            ArrayOperations.append(this.coreLibrary.getArgv(), StringOperations.createString(this, StringOperations.encodeByteList(arg.toString(), (Encoding)UTF8Encoding.INSTANCE)));
        }
        DynamicObject receiver = this.coreLibrary.getGlobalVariablesObject();
        DynamicObject loadPath = (DynamicObject)receiver.get((Object)"$:", (Object)this.coreLibrary.getNilObject());
        for (IRubyObject path : ((RubyArray)this.runtime.getLoadService().getLoadPath()).toJavaArray()) {
            String pathString = path.toString();
            if (pathString.endsWith("lib/ruby/2.2/site_ruby") || pathString.endsWith("lib/ruby/shared") || pathString.endsWith("lib/ruby/stdlib")) continue;
            if (pathString.startsWith("uri:classloader:")) {
                pathString = "jruby:" + pathString.substring("uri:classloader:".length());
            }
            ArrayOperations.append(loadPath, StringOperations.createString(this, StringOperations.encodeByteList(pathString, (Encoding)UTF8Encoding.INSTANCE)));
        }
        String home = this.runtime.getInstanceConfig().getJRubyHome();
        if (home.startsWith("uri:classloader:")) {
            home = home.substring("uri:classloader:".length());
            while (home.startsWith("/")) {
                home = home.substring(1);
            }
            home = "jruby:/" + home;
        }
        home = home + "/";
        ArrayOperations.append(loadPath, StringOperations.createString(this, StringOperations.encodeByteList(home + "lib/ruby/truffle/mri", (Encoding)UTF8Encoding.INSTANCE)));
        ArrayOperations.append(loadPath, StringOperations.createString(this, StringOperations.encodeByteList(home + "lib/ruby/truffle/truffle", (Encoding)UTF8Encoding.INSTANCE)));
        for (String lib : Arrays.asList("rubysl-strscan", "rubysl-stringio", "rubysl-complex", "rubysl-date", "rubysl-pathname", "rubysl-tempfile", "rubysl-socket", "rubysl-securerandom", "rubysl-timeout", "rubysl-webrick")) {
            ArrayOperations.append(loadPath, StringOperations.createString(this, StringOperations.encodeByteList(home + "lib/ruby/truffle/rubysl/" + lib + "/lib", (Encoding)UTF8Encoding.INSTANCE)));
        }
        ArrayOperations.append(loadPath, StringOperations.createString(this, StringOperations.encodeByteList(home + "lib/ruby/truffle/shims", (Encoding)UTF8Encoding.INSTANCE)));
    }

    public static String checkInstanceVariableName(RubyContext context, String name, Node currentNode) {
        if (!name.startsWith("@") || name.length() <= 1 || !IdUtil.isInitialCharacter((int)name.charAt(1))) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(context.getCoreLibrary().nameErrorInstanceNameNotAllowable(name, currentNode));
        }
        return name;
    }

    public static String checkClassVariableName(RubyContext context, String name, Node currentNode) {
        if (!IdUtil.isValidClassVariableName((String)name)) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(context.getCoreLibrary().nameErrorInstanceNameNotAllowable(name, currentNode));
        }
        return name;
    }

    public boolean isRunningOnWindows() {
        return this.runningOnWindows;
    }

    public void loadFile(String fileName, Node currentNode) throws IOException {
        this.loadFileAbsolute(fileName, currentNode);
    }

    private void loadFileAbsolute(String fileName, Node currentNode) throws IOException {
        Source source = this.sourceCache.getSource(fileName);
        this.load(source, currentNode);
    }

    public void load(Source source, Node currentNode) {
        this.parseAndExecute(source, (Encoding)UTF8Encoding.INSTANCE, TranslatorDriver.ParserContext.TOP_LEVEL, this.coreLibrary.getMainObject(), null, true, DeclarationContext.TOP_LEVEL, currentNode);
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public DynamicObject getSymbol(String name) {
        return this.symbolTable.getSymbol(name);
    }

    public DynamicObject getSymbol(ByteList name) {
        return this.symbolTable.getSymbol(name);
    }

    @CompilerDirectives.TruffleBoundary
    public Object instanceEval(ByteList code, Object self, String filename, Node currentNode) {
        Source source = Source.fromText((CharSequence)code, (String)filename);
        return this.parseAndExecute(source, code.getEncoding(), TranslatorDriver.ParserContext.EVAL, self, null, true, DeclarationContext.INSTANCE_EVAL, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public Object eval(TranslatorDriver.ParserContext parserContext, ByteList code, DynamicObject binding, boolean ownScopeForAssignments, String filename, Node currentNode) {
        assert (RubyGuards.isRubyBinding(binding));
        Source source = Source.fromText((CharSequence)code, (String)filename);
        MaterializedFrame frame = Layouts.BINDING.getFrame(binding);
        DeclarationContext declarationContext = RubyArguments.getDeclarationContext(frame.getArguments());
        return this.parseAndExecute(source, code.getEncoding(), parserContext, RubyArguments.getSelf(frame.getArguments()), frame, ownScopeForAssignments, declarationContext, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public Object parseAndExecute(Source source, Encoding defaultEncoding, TranslatorDriver.ParserContext parserContext, Object self, MaterializedFrame parentFrame, boolean ownScopeForAssignments, DeclarationContext declarationContext, Node currentNode) {
        RubyRootNode rootNode = this.parse(source, defaultEncoding, parserContext, parentFrame, ownScopeForAssignments, currentNode);
        return this.execute(parserContext, declarationContext, rootNode, parentFrame, self);
    }

    @CompilerDirectives.TruffleBoundary
    private RubyRootNode parse(Source source, Encoding defaultEncoding, TranslatorDriver.ParserContext parserContext, MaterializedFrame parentFrame, boolean ownScopeForAssignments, Node currentNode) {
        TranslatorDriver translator = new TranslatorDriver(this);
        return translator.parse(this, source, defaultEncoding, parserContext, null, parentFrame, ownScopeForAssignments, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    private Object execute(TranslatorDriver.ParserContext parserContext, DeclarationContext declarationContext, RubyRootNode rootNode, MaterializedFrame parentFrame, Object self) {
        DynamicObject declaringModule;
        RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)rootNode);
        if (parserContext == TranslatorDriver.ParserContext.EVAL && parentFrame != null) {
            declaringModule = RubyArguments.getMethod(parentFrame.getArguments()).getDeclaringModule();
        } else if (parserContext == TranslatorDriver.ParserContext.MODULE) {
            assert (RubyGuards.isRubyModule(self));
            declaringModule = (DynamicObject)self;
        } else {
            declaringModule = this.getCoreLibrary().getObjectClass();
        }
        InternalMethod method = new InternalMethod(rootNode.getSharedMethodInfo(), rootNode.getSharedMethodInfo().getName(), declaringModule, Visibility.PUBLIC, (CallTarget)callTarget);
        return callTarget.call(RubyArguments.pack(parentFrame, null, method, declarationContext, null, self, null, new Object[0]));
    }

    public long getNextObjectID() {
        long id = this.nextObjectID.getAndAdd(2L);
        if (id < 0L) {
            CompilerDirectives.transferToInterpreter();
            this.nextObjectID.set(Long.MIN_VALUE);
            throw new RuntimeException("Object IDs exhausted");
        }
        return id;
    }

    public Object makeTuple(VirtualFrame frame, CallDispatchHeadNode newTupleNode, Object ... values) {
        return newTupleNode.call(frame, this.getCoreLibrary().getTupleClass(), "create", null, values);
    }

    @CompilerDirectives.TruffleBoundary
    public IRubyObject toJRuby(Object object) {
        if (object == this.getCoreLibrary().getNilObject()) {
            return this.runtime.getNil();
        }
        if (object instanceof Boolean) {
            return this.runtime.newBoolean(((Boolean)object).booleanValue());
        }
        if (RubyGuards.isRubyString(object)) {
            return this.toJRubyString((DynamicObject)object);
        }
        if (RubyGuards.isRubyEncoding(object)) {
            return this.runtime.getEncodingService().rubyEncodingFromObject((IRubyObject)this.runtime.newString(Layouts.ENCODING.getName((DynamicObject)object)));
        }
        throw new UnsupportedOperationException();
    }

    @CompilerDirectives.TruffleBoundary
    public RubyString toJRubyString(DynamicObject string) {
        assert (RubyGuards.isRubyString(string));
        return this.runtime.newString(StringOperations.getByteList(string).dup());
    }

    @CompilerDirectives.TruffleBoundary
    public Object toTruffle(IRubyObject object) {
        if (object instanceof RubyFixnum) {
            long value = ((RubyFixnum)object).getLongValue();
            if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
                return value;
            }
            return (int)value;
        }
        if (object instanceof RubyBignum) {
            BigInteger value = ((RubyBignum)object).getBigIntegerValue();
            return Layouts.BIGNUM.createBignum(this.coreLibrary.getBignumFactory(), value);
        }
        if (object instanceof RubyString) {
            return StringOperations.createString(this, ((RubyString)object).getByteList().dup());
        }
        throw new UnsupportedOperationException();
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject toTruffle(RubyException jrubyException, RubyNode currentNode) {
        switch (jrubyException.getMetaClass().getName()) {
            case "ArgumentError": {
                return this.getCoreLibrary().argumentError(jrubyException.getMessage().toString(), currentNode);
            }
            case "Encoding::CompatibilityError": {
                return this.getCoreLibrary().encodingCompatibilityError(jrubyException.getMessage().toString(), currentNode);
            }
            case "RegexpError": {
                return this.getCoreLibrary().regexpError(jrubyException.getMessage().toString(), currentNode);
            }
        }
        throw new UnsupportedOperationException();
    }

    public Ruby getRuntime() {
        return this.runtime;
    }

    public CoreLibrary getCoreLibrary() {
        return this.coreLibrary;
    }

    public FeatureLoader getFeatureLoader() {
        return this.featureLoader;
    }

    public ObjectSpaceManager getObjectSpaceManager() {
        return this.objectSpaceManager;
    }

    public ThreadManager getThreadManager() {
        return this.threadManager;
    }

    public AtExitManager getAtExitManager() {
        return this.atExitManager;
    }

    public TraceManager getTraceManager() {
        return this.traceManager;
    }

    public Warnings getWarnings() {
        return this.warnings;
    }

    public SafepointManager getSafepointManager() {
        return this.safepointManager;
    }

    public ThreadLocalRandom getRandom() {
        return ThreadLocalRandom.current();
    }

    public LexicalScope getRootLexicalScope() {
        return this.rootLexicalScope;
    }

    public CompilerOptions getCompilerOptions() {
        return this.compilerOptions;
    }

    public RubiniusPrimitiveManager getRubiniusPrimitiveManager() {
        return this.rubiniusPrimitiveManager;
    }

    public CoverageTracker getCoverageTracker() {
        return this.coverageTracker;
    }

    public static RubyContext getLatestInstance() {
        return latestInstance;
    }

    public AttachmentsManager getAttachmentsManager() {
        return this.attachmentsManager;
    }

    public SourceCache getSourceCache() {
        return this.sourceCache;
    }

    public RubiniusConfiguration getRubiniusConfiguration() {
        return this.rubiniusConfiguration;
    }

    public POSIX getPosix() {
        return this.posix;
    }

    public NativeSockets getNativeSockets() {
        return this.nativeSockets;
    }

    public LibCClockGetTime getLibCClockGetTime() {
        return this.libCClockGetTime;
    }

    public Object execute(org.jruby.ast.RootNode rootNode) {
        Source source;
        this.coreLibrary.getGlobalVariablesObject().define((Object)"$0", this.toTruffle(this.runtime.getGlobalVariables().get("$0")), 0);
        String inputFile = rootNode.getPosition().getFile();
        try {
            if (!inputFile.equals("-e")) {
                inputFile = new File(inputFile).getCanonicalPath();
            }
            source = this.sourceCache.getSource(inputFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.featureLoader.setMainScriptSource(source);
        RubyRootNode originalRootNode = this.parse(source, (Encoding)UTF8Encoding.INSTANCE, TranslatorDriver.ParserContext.TOP_LEVEL, null, true, null);
        SourceSection sourceSection = originalRootNode.getSourceSection();
        TopLevelRaiseHandler wrappedBody = new TopLevelRaiseHandler(this, sourceSection, SequenceNode.sequence(this, sourceSection, new SetTopLevelBindingNode(this, sourceSection), new LoadRequiredLibrariesNode(this, sourceSection), originalRootNode.getBody()));
        RubyRootNode newRootNode = originalRootNode.withBody(wrappedBody);
        if (rootNode.hasEndPosition()) {
            Object data = this.inlineRubyHelper(null, "Truffle::Primitive.get_data(file, offset)", "file", StringOperations.createString(this, ByteList.create((CharSequence)inputFile)), "offset", rootNode.getEndPosition());
            Layouts.MODULE.getFields(this.coreLibrary.getObjectClass()).setConstant(this, null, "DATA", data);
        }
        return this.execute(TranslatorDriver.ParserContext.TOP_LEVEL, DeclarationContext.TOP_LEVEL, newRootNode, null, this.coreLibrary.getMainObject());
    }

    public DynamicObject runAtExitHooks() {
        return this.atExitManager.runAtExitHooks();
    }

    public void shutdown() {
        this.atExitManager.runSystemExitHooks();
        if (this.instrumentationServerManager != null) {
            this.instrumentationServerManager.shutdown();
        }
        this.threadManager.shutdown();
        if (this.options.COVERAGE_GLOBAL) {
            this.coverageTracker.print(System.out);
        }
        if (this.callGraph != null) {
            this.callGraph.resolve();
            if (this.options.CALL_GRAPH_WRITE != null) {
                try (PrintStream stream = new PrintStream(this.options.CALL_GRAPH_WRITE, StandardCharsets.UTF_8.name());){
                    new SimpleWriter(this.callGraph, stream).write();
                }
                catch (FileNotFoundException | UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public PrintStream getDebugStandardOut() {
        return this.debugStandardOut;
    }

    public void exportObject(DynamicObject name, TruffleObject object) {
        assert (RubyGuards.isRubyString(name));
        this.exported.put(name.toString(), object);
    }

    public Object findExportedObject(String name) {
        return this.exported.get(name);
    }

    public Object importObject(DynamicObject name) {
        assert (RubyGuards.isRubyString(name));
        return this.env.importSymbol(name.toString());
    }

    public Options getOptions() {
        return this.options;
    }

    public TruffleLanguage.Env getEnv() {
        return this.env;
    }

    public void setInitialJRubyRootNode(org.jruby.ast.RootNode initialJRubyRootNode) {
        this.initialJRubyRootNode = initialJRubyRootNode;
    }

    public org.jruby.ast.RootNode getInitialJRubyRootNode() {
        return this.initialJRubyRootNode;
    }

    public DynamicObject createHandle(Object object) {
        return Layouts.HANDLE.createHandle(this.coreLibrary.getHandleFactory(), object);
    }

    public CrtExterns getCrtExterns() {
        return this.crtExterns;
    }

    public static void appendToFile(String fileName, String message) {
        try (PrintStream stream = new PrintStream((OutputStream)new FileOutputStream(fileName, true), true, StandardCharsets.UTF_8.name());){
            stream.println(message);
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public CallGraph getCallGraph() {
        return this.callGraph;
    }
}

