/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.supercall;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.core.ArrayOperations;

public class ReadZSuperArgumentsNode
extends RubyNode {
    private final boolean hasRestParameter;
    @Node.Children
    private final RubyNode[] reloadNodes;

    public ReadZSuperArgumentsNode(RubyContext context, SourceSection sourceSection, boolean hasRestParameter, RubyNode[] reloadNodes) {
        super(context, sourceSection);
        this.hasRestParameter = hasRestParameter;
        this.reloadNodes = reloadNodes;
    }

    @Override
    @ExplodeLoop
    public final Object execute(VirtualFrame frame) {
        CompilerAsserts.compilationConstant((Object)this.reloadNodes.length);
        Object[] superArguments = new Object[this.reloadNodes.length];
        for (int n = 0; n < superArguments.length; ++n) {
            superArguments[n] = this.reloadNodes[n].execute(frame);
        }
        if (this.hasRestParameter) {
            CompilerDirectives.transferToInterpreter();
            Object restArg = superArguments[superArguments.length - 1];
            assert (RubyGuards.isRubyArray(restArg));
            Object[] restArgs = ArrayOperations.toObjectArray((DynamicObject)restArg);
            int restArgIndex = this.reloadNodes.length - 1;
            superArguments = Arrays.copyOf(superArguments, restArgIndex + restArgs.length);
            ArrayUtils.arraycopy(restArgs, 0, superArguments, restArgIndex, restArgs.length);
        }
        return superArguments;
    }
}

