/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.lang.ref.WeakReference;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;

public abstract class WeakRefPrimitiveNodes {

    @RubiniusPrimitive(name="weakref_object")
    public static abstract class WeakRefObjectPrimitiveNode
    extends RubiniusPrimitiveNode {
        public WeakRefObjectPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object weakRefObject(DynamicObject weakRef) {
            return Layouts.WEAK_REF_LAYOUT.getReference(weakRef).get();
        }
    }

    @RubiniusPrimitive(name="weakref_set_object")
    public static abstract class WeakRefSetObjectPrimitiveNode
    extends RubiniusPrimitiveNode {
        public WeakRefSetObjectPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object weakRefSetObject(DynamicObject weakRef, Object object) {
            Layouts.WEAK_REF_LAYOUT.setReference(weakRef, new WeakReference<Object>(object));
            return object;
        }
    }

    @RubiniusPrimitive(name="weakref_new", needsSelf=false)
    public static abstract class WeakRefNewPrimitiveNode
    extends RubiniusPrimitiveNode {
        public WeakRefNewPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject weakRefNew(Object object) {
            return Layouts.WEAK_REF_LAYOUT.createWeakRef(this.getContext().getCoreLibrary().getWeakRefFactory(), new WeakReference<Object>(object));
        }
    }
}

