/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypes;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.objects.ClassNode;
import org.jruby.truffle.runtime.RubyContext;

@GeneratedBy(value=ClassNode.class)
public final class ClassNodeGen
extends ClassNode
implements SpecializedNode {
    @Node.Child
    private RubyNode object_;
    @CompilerDirectives.CompilationFinal
    private Class<?> objectType_;
    @Node.Child
    private BaseNode_ specialization_;

    private ClassNodeGen(RubyContext context, SourceSection sourceSection, RubyNode object) {
        super(context, sourceSection);
        this.object_ = object;
        this.specialization_ = UninitializedNode_.create(this);
    }

    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public DynamicObject executeGetClass(VirtualFrame frameValue, Object objectValue) {
        return this.specialization_.executeDynamicObject1(frameValue, objectValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
        return this.specialization_.executeDynamicObject0(frameValue);
    }

    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    public Node deepCopy() {
        return SpecializationNode.updateRoot((Node)super.deepCopy());
    }

    public static ClassNode create(RubyContext context, SourceSection sourceSection, RubyNode object) {
        return new ClassNodeGen(context, sourceSection, object);
    }

    @GeneratedBy(methodName="getClass(DynamicObject)", value=ClassNode.class)
    private static final class GetClass3Node_
    extends BaseNode_ {
        GetClass3Node_(ClassNodeGen root) {
            super(root, 6);
        }

        @Override
        public DynamicObject executeDynamicObject1(VirtualFrame frameValue, Object objectValue) {
            if (objectValue instanceof DynamicObject) {
                DynamicObject objectValue_ = (DynamicObject)objectValue;
                return this.root.getClass(objectValue_);
            }
            return this.getNext().executeDynamicObject1(frameValue, objectValue);
        }

        static BaseNode_ create(ClassNodeGen root) {
            return new GetClass3Node_(root);
        }
    }

    @GeneratedBy(methodName="getClass(double)", value=ClassNode.class)
    private static final class GetClass2Node_
    extends BaseNode_ {
        private final Class<?> objectImplicitType;

        GetClass2Node_(ClassNodeGen root, Object objectValue) {
            super(root, 5);
            this.objectImplicitType = RubyTypesGen.getImplicitDoubleClass(objectValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.objectImplicitType == ((GetClass2Node_)other).objectImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            double objectValue_;
            try {
                if (this.objectImplicitType == Double.TYPE) {
                    objectValue_ = this.root.object_.executeDouble(frameValue);
                } else {
                    Object objectValue__ = this.executeObject_((Frame)frameValue);
                    objectValue_ = RubyTypesGen.expectImplicitDouble(objectValue__, this.objectImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject1(frameValue, ex.getResult());
            }
            return this.root.getClass(objectValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(VirtualFrame frameValue, Object objectValue) {
            if (RubyTypesGen.isImplicitDouble(objectValue, this.objectImplicitType)) {
                double objectValue_ = RubyTypesGen.asImplicitDouble(objectValue, this.objectImplicitType);
                return this.root.getClass(objectValue_);
            }
            return this.getNext().executeDynamicObject1(frameValue, objectValue);
        }

        static BaseNode_ create(ClassNodeGen root, Object objectValue) {
            return new GetClass2Node_(root, objectValue);
        }
    }

    @GeneratedBy(methodName="getClass(long)", value=ClassNode.class)
    private static final class GetClass1Node_
    extends BaseNode_ {
        private final Class<?> objectImplicitType;

        GetClass1Node_(ClassNodeGen root, Object objectValue) {
            super(root, 4);
            this.objectImplicitType = RubyTypesGen.getImplicitLongClass(objectValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.objectImplicitType == ((GetClass1Node_)other).objectImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            long objectValue_;
            try {
                if (this.objectImplicitType == Long.TYPE) {
                    objectValue_ = this.root.object_.executeLong(frameValue);
                } else if (this.objectImplicitType == Integer.TYPE) {
                    objectValue_ = RubyTypes.promoteToLong(this.root.object_.executeInteger(frameValue));
                } else {
                    Object objectValue__ = this.executeObject_((Frame)frameValue);
                    objectValue_ = RubyTypesGen.expectImplicitLong(objectValue__, this.objectImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject1(frameValue, ex.getResult());
            }
            return this.root.getClass(objectValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(VirtualFrame frameValue, Object objectValue) {
            if (RubyTypesGen.isImplicitLong(objectValue, this.objectImplicitType)) {
                long objectValue_ = RubyTypesGen.asImplicitLong(objectValue, this.objectImplicitType);
                return this.root.getClass(objectValue_);
            }
            return this.getNext().executeDynamicObject1(frameValue, objectValue);
        }

        static BaseNode_ create(ClassNodeGen root, Object objectValue) {
            return new GetClass1Node_(root, objectValue);
        }
    }

    @GeneratedBy(methodName="getClass(int)", value=ClassNode.class)
    private static final class GetClass0Node_
    extends BaseNode_ {
        private final Class<?> objectImplicitType;

        GetClass0Node_(ClassNodeGen root, Object objectValue) {
            super(root, 3);
            this.objectImplicitType = RubyTypesGen.getImplicitIntegerClass(objectValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.objectImplicitType == ((GetClass0Node_)other).objectImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            int objectValue_;
            try {
                if (this.objectImplicitType == Integer.TYPE) {
                    objectValue_ = this.root.object_.executeInteger(frameValue);
                } else {
                    Object objectValue__ = this.executeObject_((Frame)frameValue);
                    objectValue_ = RubyTypesGen.expectImplicitInteger(objectValue__, this.objectImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject1(frameValue, ex.getResult());
            }
            return this.root.getClass(objectValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(VirtualFrame frameValue, Object objectValue) {
            if (RubyTypesGen.isImplicitInteger(objectValue, this.objectImplicitType)) {
                int objectValue_ = RubyTypesGen.asImplicitInteger(objectValue, this.objectImplicitType);
                return this.root.getClass(objectValue_);
            }
            return this.getNext().executeDynamicObject1(frameValue, objectValue);
        }

        static BaseNode_ create(ClassNodeGen root, Object objectValue) {
            return new GetClass0Node_(root, objectValue);
        }
    }

    @GeneratedBy(methodName="getClassFalse(boolean)", value=ClassNode.class)
    private static final class GetClassFalseNode_
    extends BaseNode_ {
        GetClassFalseNode_(ClassNodeGen root) {
            super(root, 2);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            boolean objectValue_;
            try {
                objectValue_ = this.root.object_.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject1(frameValue, ex.getResult());
            }
            if (!objectValue_) {
                return this.root.getClassFalse(objectValue_);
            }
            return this.getNext().executeDynamicObject1(frameValue, objectValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(VirtualFrame frameValue, Object objectValue) {
            boolean objectValue_;
            if (objectValue instanceof Boolean && !(objectValue_ = ((Boolean)objectValue).booleanValue())) {
                return this.root.getClassFalse(objectValue_);
            }
            return this.getNext().executeDynamicObject1(frameValue, objectValue);
        }

        static BaseNode_ create(ClassNodeGen root) {
            return new GetClassFalseNode_(root);
        }
    }

    @GeneratedBy(methodName="getClassTrue(boolean)", value=ClassNode.class)
    private static final class GetClassTrueNode_
    extends BaseNode_ {
        GetClassTrueNode_(ClassNodeGen root) {
            super(root, 1);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            boolean objectValue_;
            try {
                objectValue_ = this.root.object_.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject1(frameValue, ex.getResult());
            }
            if (objectValue_) {
                return this.root.getClassTrue(objectValue_);
            }
            return this.getNext().executeDynamicObject1(frameValue, objectValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(VirtualFrame frameValue, Object objectValue) {
            boolean objectValue_;
            if (objectValue instanceof Boolean && (objectValue_ = ((Boolean)objectValue).booleanValue())) {
                return this.root.getClassTrue(objectValue_);
            }
            return this.getNext().executeDynamicObject1(frameValue, objectValue);
        }

        static BaseNode_ create(ClassNodeGen root) {
            return new GetClassTrueNode_(root);
        }
    }

    @GeneratedBy(value=ClassNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(ClassNodeGen root) {
            super(root, 0);
        }

        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object objectValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, objectValue));
        }

        @Override
        public DynamicObject executeDynamicObject1(VirtualFrame frameValue, Object objectValue) {
            return this.getNext().executeDynamicObject1(frameValue, objectValue);
        }

        static BaseNode_ create(ClassNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=ClassNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(ClassNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public DynamicObject executeDynamicObject1(VirtualFrame frameValue, Object objectValue) {
            return (DynamicObject)this.uninitialized((Frame)frameValue, objectValue);
        }

        static BaseNode_ create(ClassNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=ClassNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected ClassNodeGen root;

        BaseNode_(ClassNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        protected final void setRoot(Node root) {
            this.root = (ClassNodeGen)root;
        }

        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.object_};
        }

        public final Object acceptAndExecute(Frame frameValue, Object objectValue) {
            return this.executeDynamicObject1((VirtualFrame)frameValue, objectValue);
        }

        public abstract DynamicObject executeDynamicObject1(VirtualFrame var1, Object var2);

        public Object execute(VirtualFrame frameValue) {
            Object objectValue_ = this.executeObject_((Frame)frameValue);
            return this.executeDynamicObject1(frameValue, objectValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            return (DynamicObject)this.execute(frameValue);
        }

        protected final SpecializationNode createNext(Frame frameValue, Object objectValue) {
            if (objectValue instanceof Boolean) {
                boolean objectValue_ = (Boolean)objectValue;
                if (objectValue_) {
                    return GetClassTrueNode_.create(this.root);
                }
                return GetClassFalseNode_.create(this.root);
            }
            if (RubyTypesGen.isImplicitInteger(objectValue)) {
                return GetClass0Node_.create(this.root, objectValue);
            }
            if (RubyTypesGen.isImplicitLong(objectValue)) {
                return GetClass1Node_.create(this.root, objectValue);
            }
            if (RubyTypesGen.isImplicitDouble(objectValue)) {
                return GetClass2Node_.create(this.root, objectValue);
            }
            if (objectValue instanceof DynamicObject) {
                return GetClass3Node_.create(this.root);
            }
            return null;
        }

        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeObject_(Frame frameValue) {
            Object object;
            Class objectType_ = this.root.objectType_;
            if (objectType_ == Boolean.TYPE) {
                return this.root.object_.executeBoolean((VirtualFrame)frameValue);
            }
            if (objectType_ == Double.TYPE) {
                return this.root.object_.executeDouble((VirtualFrame)frameValue);
            }
            if (objectType_ == Integer.TYPE) {
                return this.root.object_.executeInteger((VirtualFrame)frameValue);
            }
            if (objectType_ == Long.TYPE) {
                return this.root.object_.executeLong((VirtualFrame)frameValue);
            }
            if (objectType_ != null) return this.root.object_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.object_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Boolean ? Boolean.TYPE : (_value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class)));
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.objectType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.objectType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.objectType_ = _type;
            return object;
        }
    }
}

