/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.dsl.internal.SuppressFBWarnings;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypes;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.nodes.core.array.ArrayWriteNormalizedNode;
import org.jruby.truffle.runtime.RubyContext;

@GeneratedBy(value=ArrayWriteNormalizedNode.class)
@SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
public final class ArrayWriteNormalizedNodeGen
extends ArrayWriteNormalizedNode
implements SpecializedNode {
    @Node.Child
    private RubyNode array_;
    @Node.Child
    private RubyNode index_;
    @Node.Child
    private RubyNode value_;
    @CompilerDirectives.CompilationFinal
    private Class<?> indexType_;
    @CompilerDirectives.CompilationFinal
    private Class<?> valueType_;
    @Node.Child
    private BaseNode_ specialization_;

    private ArrayWriteNormalizedNodeGen(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index, RubyNode value) {
        super(context, sourceSection);
        this.array_ = array;
        this.index_ = index;
        this.value_ = value;
        this.specialization_ = UninitializedNode_.create(this);
    }

    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public Object executeWrite(DynamicObject arrayValue, int indexValue, Object valueValue) {
        return this.specialization_.execute1(arrayValue, indexValue, valueValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute0(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
        return this.specialization_.executeDynamicObject(frameValue);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
        return this.specialization_.executeBoolean(frameValue);
    }

    @Override
    public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
        return this.specialization_.executeDouble(frameValue);
    }

    @Override
    public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
        return this.specialization_.executeInt(frameValue);
    }

    @Override
    public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
        return this.specialization_.executeLong(frameValue);
    }

    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    public Node deepCopy() {
        return SpecializationNode.updateRoot((Node)super.deepCopy());
    }

    private static DynamicObject expectDynamicObject(Object value) throws UnexpectedResultException {
        if (value instanceof DynamicObject) {
            return (DynamicObject)value;
        }
        throw new UnexpectedResultException(value);
    }

    private static boolean expectBoolean(Object value) throws UnexpectedResultException {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new UnexpectedResultException(value);
    }

    private static double expectDouble(Object value) throws UnexpectedResultException {
        if (value instanceof Double) {
            return (Double)value;
        }
        throw new UnexpectedResultException(value);
    }

    private static int expectInteger(Object value) throws UnexpectedResultException {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw new UnexpectedResultException(value);
    }

    private static long expectLong(Object value) throws UnexpectedResultException {
        if (value instanceof Long) {
            return (Long)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static ArrayWriteNormalizedNode create(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index, RubyNode value) {
        return new ArrayWriteNormalizedNodeGen(context, sourceSection, array, index, value);
    }

    @GeneratedBy(methodName="writeBeyondObject(DynamicObject, int, Object)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteBeyondObjectNode_
    extends BaseNode_ {
        private final Class<?> indexImplicitType;

        WriteBeyondObjectNode_(ArrayWriteNormalizedNodeGen root, Object indexValue) {
            super(root, 20);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((WriteBeyondObjectNode_)other).indexImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return this.getNext().execute_(ex.getResult(), indexValue, valueValue);
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_((Frame)frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return this.getNext().execute_(arrayValue_, ex.getResult(), valueValue);
            }
            Object valueValue_ = this.executeValue_((Frame)frameValue);
            if (ArrayGuards.isObjectArray(arrayValue_) && !ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && !ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                return this.root.writeBeyondObject(arrayValue_, indexValue_, valueValue_);
            }
            return this.getNext().execute_(arrayValue_, indexValue_, valueValue_);
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int indexValue, Object valueValue) {
            if (ArrayGuards.isObjectArray(arrayValue) && !ArrayWriteNormalizedNode.isInBounds(arrayValue, indexValue) && !ArrayWriteNormalizedNode.isExtendingByOne(arrayValue, indexValue)) {
                return this.root.writeBeyondObject(arrayValue, indexValue, valueValue);
            }
            return this.getNext().execute1(arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                if (ArrayGuards.isObjectArray(arrayValue_) && !ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && !ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                    return this.root.writeBeyondObject(arrayValue_, indexValue_, valueValue);
                }
            }
            return this.getNext().execute_(arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root, Object indexValue) {
            return new WriteBeyondObjectNode_(root, indexValue);
        }
    }

    @GeneratedBy(methodName="writeBeyondPrimitive(DynamicObject, int, Object)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteBeyondPrimitiveNode_
    extends BaseNode_ {
        private final Class<?> indexImplicitType;

        WriteBeyondPrimitiveNode_(ArrayWriteNormalizedNodeGen root, Object indexValue) {
            super(root, 19);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((WriteBeyondPrimitiveNode_)other).indexImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return this.getNext().execute_(ex.getResult(), indexValue, valueValue);
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_((Frame)frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return this.getNext().execute_(arrayValue_, ex.getResult(), valueValue);
            }
            Object valueValue_ = this.executeValue_((Frame)frameValue);
            if (!(ArrayGuards.isObjectArray(arrayValue_) || ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) || ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_))) {
                return this.root.writeBeyondPrimitive(arrayValue_, indexValue_, valueValue_);
            }
            return this.getNext().execute_(arrayValue_, indexValue_, valueValue_);
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int indexValue, Object valueValue) {
            if (!(ArrayGuards.isObjectArray(arrayValue) || ArrayWriteNormalizedNode.isInBounds(arrayValue, indexValue) || ArrayWriteNormalizedNode.isExtendingByOne(arrayValue, indexValue))) {
                return this.root.writeBeyondPrimitive(arrayValue, indexValue, valueValue);
            }
            return this.getNext().execute1(arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                if (!(ArrayGuards.isObjectArray(arrayValue_) || ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) || ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_))) {
                    return this.root.writeBeyondPrimitive(arrayValue_, indexValue_, valueValue);
                }
            }
            return this.getNext().execute_(arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root, Object indexValue) {
            return new WriteBeyondPrimitiveNode_(root, indexValue);
        }
    }

    @GeneratedBy(methodName="writeExtendByOne(DynamicObject, int, Object)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteExtendByOne3Node_
    extends BaseNode_ {
        private final Class<?> indexImplicitType;

        WriteExtendByOne3Node_(ArrayWriteNormalizedNodeGen root, Object indexValue) {
            super(root, 18);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((WriteExtendByOne3Node_)other).indexImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return this.getNext().execute_(ex.getResult(), indexValue, valueValue);
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_((Frame)frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return this.getNext().execute_(arrayValue_, ex.getResult(), valueValue);
            }
            Object valueValue_ = this.executeValue_((Frame)frameValue);
            if (ArrayGuards.isObjectArray(arrayValue_) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                return this.root.writeExtendByOne(arrayValue_, indexValue_, valueValue_);
            }
            return this.getNext().execute_(arrayValue_, indexValue_, valueValue_);
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int indexValue, Object valueValue) {
            if (ArrayGuards.isObjectArray(arrayValue) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue, indexValue)) {
                return this.root.writeExtendByOne(arrayValue, indexValue, valueValue);
            }
            return this.getNext().execute1(arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                if (ArrayGuards.isObjectArray(arrayValue_) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                    return this.root.writeExtendByOne(arrayValue_, indexValue_, valueValue);
                }
            }
            return this.getNext().execute_(arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root, Object indexValue) {
            return new WriteExtendByOne3Node_(root, indexValue);
        }
    }

    @GeneratedBy(methodName="writeExtendByOne(DynamicObject, int, double)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteExtendByOne2Node_
    extends BaseNode_ {
        private final Class<?> indexImplicitType;
        private final Class<?> valueImplicitType;

        WriteExtendByOne2Node_(ArrayWriteNormalizedNodeGen root, Object indexValue, Object valueValue) {
            super(root, 17);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
            this.valueImplicitType = RubyTypesGen.getImplicitDoubleClass(valueValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((WriteExtendByOne2Node_)other).indexImplicitType && this.valueImplicitType == ((WriteExtendByOne2Node_)other).valueImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            double valueValue_;
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectDouble(this.getNext().execute_(ex.getResult(), indexValue, valueValue));
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_((Frame)frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectDouble(this.getNext().execute_(arrayValue_, ex.getResult(), valueValue));
            }
            try {
                if (this.valueImplicitType == Double.TYPE) {
                    valueValue_ = this.root.value_.executeDouble(frameValue);
                } else {
                    Object valueValue__ = this.executeValue_((Frame)frameValue);
                    valueValue_ = RubyTypesGen.expectImplicitDouble(valueValue__, this.valueImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return ArrayWriteNormalizedNodeGen.expectDouble(this.getNext().execute_(arrayValue_, indexValue_, ex.getResult()));
            }
            if (ArrayGuards.isDoubleArray(arrayValue_) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                return this.root.writeExtendByOne(arrayValue_, indexValue_, valueValue_);
            }
            return ArrayWriteNormalizedNodeGen.expectDouble(this.getNext().execute_(arrayValue_, indexValue_, valueValue_));
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int indexValue, Object valueValue) {
            if (RubyTypesGen.isImplicitDouble(valueValue, this.valueImplicitType)) {
                double valueValue_ = RubyTypesGen.asImplicitDouble(valueValue, this.valueImplicitType);
                if (ArrayGuards.isDoubleArray(arrayValue) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue, indexValue)) {
                    return this.root.writeExtendByOne(arrayValue, indexValue, valueValue_);
                }
            }
            return this.getNext().execute1(arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && RubyTypesGen.isImplicitDouble(valueValue, this.valueImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                double valueValue_ = RubyTypesGen.asImplicitDouble(valueValue, this.valueImplicitType);
                if (ArrayGuards.isDoubleArray(arrayValue_) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                    return this.root.writeExtendByOne(arrayValue_, indexValue_, valueValue_);
                }
            }
            return this.getNext().execute_(arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root, Object indexValue, Object valueValue) {
            return new WriteExtendByOne2Node_(root, indexValue, valueValue);
        }
    }

    @GeneratedBy(methodName="writeExtendByOne(DynamicObject, int, long)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteExtendByOne1Node_
    extends BaseNode_ {
        private final Class<?> indexImplicitType;
        private final Class<?> valueImplicitType;

        WriteExtendByOne1Node_(ArrayWriteNormalizedNodeGen root, Object indexValue, Object valueValue) {
            super(root, 16);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
            this.valueImplicitType = RubyTypesGen.getImplicitLongClass(valueValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((WriteExtendByOne1Node_)other).indexImplicitType && this.valueImplicitType == ((WriteExtendByOne1Node_)other).valueImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeLong(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
            long valueValue_;
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectLong(this.getNext().execute_(ex.getResult(), indexValue, valueValue));
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_((Frame)frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectLong(this.getNext().execute_(arrayValue_, ex.getResult(), valueValue));
            }
            try {
                valueValue_ = this.executeValueLong_((Frame)frameValue, this.valueImplicitType);
            }
            catch (UnexpectedResultException ex) {
                return ArrayWriteNormalizedNodeGen.expectLong(this.getNext().execute_(arrayValue_, indexValue_, ex.getResult()));
            }
            if (ArrayGuards.isLongArray(arrayValue_) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                return this.root.writeExtendByOne(arrayValue_, indexValue_, valueValue_);
            }
            return ArrayWriteNormalizedNodeGen.expectLong(this.getNext().execute_(arrayValue_, indexValue_, valueValue_));
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int indexValue, Object valueValue) {
            if (RubyTypesGen.isImplicitLong(valueValue, this.valueImplicitType)) {
                long valueValue_ = RubyTypesGen.asImplicitLong(valueValue, this.valueImplicitType);
                if (ArrayGuards.isLongArray(arrayValue) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue, indexValue)) {
                    return this.root.writeExtendByOne(arrayValue, indexValue, valueValue_);
                }
            }
            return this.getNext().execute1(arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && RubyTypesGen.isImplicitLong(valueValue, this.valueImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                long valueValue_ = RubyTypesGen.asImplicitLong(valueValue, this.valueImplicitType);
                if (ArrayGuards.isLongArray(arrayValue_) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                    return this.root.writeExtendByOne(arrayValue_, indexValue_, valueValue_);
                }
            }
            return this.getNext().execute_(arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root, Object indexValue, Object valueValue) {
            return new WriteExtendByOne1Node_(root, indexValue, valueValue);
        }
    }

    @GeneratedBy(methodName="writeExtendByOne(DynamicObject, int, int)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteExtendByOne0Node_
    extends BaseNode_ {
        private final Class<?> indexImplicitType;
        private final Class<?> valueImplicitType;

        WriteExtendByOne0Node_(ArrayWriteNormalizedNodeGen root, Object indexValue, Object valueValue) {
            super(root, 15);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
            this.valueImplicitType = RubyTypesGen.getImplicitIntegerClass(valueValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((WriteExtendByOne0Node_)other).indexImplicitType && this.valueImplicitType == ((WriteExtendByOne0Node_)other).valueImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            int valueValue_;
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectInteger(this.getNext().execute_(ex.getResult(), indexValue, valueValue));
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_((Frame)frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectInteger(this.getNext().execute_(arrayValue_, ex.getResult(), valueValue));
            }
            try {
                if (this.valueImplicitType == Integer.TYPE) {
                    valueValue_ = this.root.value_.executeInteger(frameValue);
                } else {
                    Object valueValue__ = this.executeValue_((Frame)frameValue);
                    valueValue_ = RubyTypesGen.expectImplicitInteger(valueValue__, this.valueImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return ArrayWriteNormalizedNodeGen.expectInteger(this.getNext().execute_(arrayValue_, indexValue_, ex.getResult()));
            }
            if (ArrayGuards.isIntArray(arrayValue_) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                return this.root.writeExtendByOne(arrayValue_, indexValue_, valueValue_);
            }
            return ArrayWriteNormalizedNodeGen.expectInteger(this.getNext().execute_(arrayValue_, indexValue_, valueValue_));
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int indexValue, Object valueValue) {
            if (RubyTypesGen.isImplicitInteger(valueValue, this.valueImplicitType)) {
                int valueValue_ = RubyTypesGen.asImplicitInteger(valueValue, this.valueImplicitType);
                if (ArrayGuards.isIntArray(arrayValue) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue, indexValue)) {
                    return this.root.writeExtendByOne(arrayValue, indexValue, valueValue_);
                }
            }
            return this.getNext().execute1(arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && RubyTypesGen.isImplicitInteger(valueValue, this.valueImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                int valueValue_ = RubyTypesGen.asImplicitInteger(valueValue, this.valueImplicitType);
                if (ArrayGuards.isIntArray(arrayValue_) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                    return this.root.writeExtendByOne(arrayValue_, indexValue_, valueValue_);
                }
            }
            return this.getNext().execute_(arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root, Object indexValue, Object valueValue) {
            return new WriteExtendByOne0Node_(root, indexValue, valueValue);
        }
    }

    @GeneratedBy(methodName="writeWithinDouble(DynamicObject, int, Object)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteWithinDoubleNode_
    extends BaseNode_ {
        private final Class<?> indexImplicitType;

        WriteWithinDoubleNode_(ArrayWriteNormalizedNodeGen root, Object indexValue) {
            super(root, 14);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((WriteWithinDoubleNode_)other).indexImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return this.getNext().execute_(ex.getResult(), indexValue, valueValue);
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_((Frame)frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return this.getNext().execute_(arrayValue_, ex.getResult(), valueValue);
            }
            Object valueValue_ = this.executeValue_((Frame)frameValue);
            if (ArrayGuards.isDoubleArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && !RubyGuards.isDouble(valueValue_)) {
                return this.root.writeWithinDouble(arrayValue_, indexValue_, valueValue_);
            }
            return this.getNext().execute_(arrayValue_, indexValue_, valueValue_);
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int indexValue, Object valueValue) {
            if (ArrayGuards.isDoubleArray(arrayValue) && ArrayWriteNormalizedNode.isInBounds(arrayValue, indexValue) && !RubyGuards.isDouble(valueValue)) {
                return this.root.writeWithinDouble(arrayValue, indexValue, valueValue);
            }
            return this.getNext().execute1(arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                if (ArrayGuards.isDoubleArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && !RubyGuards.isDouble(valueValue)) {
                    return this.root.writeWithinDouble(arrayValue_, indexValue_, valueValue);
                }
            }
            return this.getNext().execute_(arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root, Object indexValue) {
            return new WriteWithinDoubleNode_(root, indexValue);
        }
    }

    @GeneratedBy(methodName="writeWithinLong(DynamicObject, int, Object)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteWithinLongNode_
    extends BaseNode_ {
        private final Class<?> indexImplicitType;

        WriteWithinLongNode_(ArrayWriteNormalizedNodeGen root, Object indexValue) {
            super(root, 13);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((WriteWithinLongNode_)other).indexImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return this.getNext().execute_(ex.getResult(), indexValue, valueValue);
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_((Frame)frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return this.getNext().execute_(arrayValue_, ex.getResult(), valueValue);
            }
            Object valueValue_ = this.executeValue_((Frame)frameValue);
            if (ArrayGuards.isLongArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && !RubyGuards.isInteger(valueValue_) && !RubyGuards.isLong(valueValue_)) {
                return this.root.writeWithinLong(arrayValue_, indexValue_, valueValue_);
            }
            return this.getNext().execute_(arrayValue_, indexValue_, valueValue_);
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int indexValue, Object valueValue) {
            if (ArrayGuards.isLongArray(arrayValue) && ArrayWriteNormalizedNode.isInBounds(arrayValue, indexValue) && !RubyGuards.isInteger(valueValue) && !RubyGuards.isLong(valueValue)) {
                return this.root.writeWithinLong(arrayValue, indexValue, valueValue);
            }
            return this.getNext().execute1(arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                if (ArrayGuards.isLongArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && !RubyGuards.isInteger(valueValue) && !RubyGuards.isLong(valueValue)) {
                    return this.root.writeWithinLong(arrayValue_, indexValue_, valueValue);
                }
            }
            return this.getNext().execute_(arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root, Object indexValue) {
            return new WriteWithinLongNode_(root, indexValue);
        }
    }

    @GeneratedBy(methodName="writeWithinInt(DynamicObject, int, Object)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteWithinInt1Node_
    extends BaseNode_ {
        private final Class<?> indexImplicitType;

        WriteWithinInt1Node_(ArrayWriteNormalizedNodeGen root, Object indexValue) {
            super(root, 12);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((WriteWithinInt1Node_)other).indexImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return this.getNext().execute_(ex.getResult(), indexValue, valueValue);
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_((Frame)frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return this.getNext().execute_(arrayValue_, ex.getResult(), valueValue);
            }
            Object valueValue_ = this.executeValue_((Frame)frameValue);
            if (ArrayGuards.isIntArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && !RubyGuards.isInteger(valueValue_) && !RubyGuards.isLong(valueValue_)) {
                return this.root.writeWithinInt(arrayValue_, indexValue_, valueValue_);
            }
            return this.getNext().execute_(arrayValue_, indexValue_, valueValue_);
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int indexValue, Object valueValue) {
            if (ArrayGuards.isIntArray(arrayValue) && ArrayWriteNormalizedNode.isInBounds(arrayValue, indexValue) && !RubyGuards.isInteger(valueValue) && !RubyGuards.isLong(valueValue)) {
                return this.root.writeWithinInt(arrayValue, indexValue, valueValue);
            }
            return this.getNext().execute1(arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                if (ArrayGuards.isIntArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && !RubyGuards.isInteger(valueValue) && !RubyGuards.isLong(valueValue)) {
                    return this.root.writeWithinInt(arrayValue_, indexValue_, valueValue);
                }
            }
            return this.getNext().execute_(arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root, Object indexValue) {
            return new WriteWithinInt1Node_(root, indexValue);
        }
    }

    @GeneratedBy(methodName="writeWithinInt(DynamicObject, int, long)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteWithinInt0Node_
    extends BaseNode_ {
        private final Class<?> indexImplicitType;
        private final Class<?> valueImplicitType;

        WriteWithinInt0Node_(ArrayWriteNormalizedNodeGen root, Object indexValue, Object valueValue) {
            super(root, 11);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
            this.valueImplicitType = RubyTypesGen.getImplicitLongClass(valueValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((WriteWithinInt0Node_)other).indexImplicitType && this.valueImplicitType == ((WriteWithinInt0Node_)other).valueImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeLong(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
            long valueValue_;
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectLong(this.getNext().execute_(ex.getResult(), indexValue, valueValue));
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_((Frame)frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectLong(this.getNext().execute_(arrayValue_, ex.getResult(), valueValue));
            }
            try {
                valueValue_ = this.executeValueLong_((Frame)frameValue, this.valueImplicitType);
            }
            catch (UnexpectedResultException ex) {
                return ArrayWriteNormalizedNodeGen.expectLong(this.getNext().execute_(arrayValue_, indexValue_, ex.getResult()));
            }
            if (ArrayGuards.isIntArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_)) {
                return this.root.writeWithinInt(arrayValue_, indexValue_, valueValue_);
            }
            return ArrayWriteNormalizedNodeGen.expectLong(this.getNext().execute_(arrayValue_, indexValue_, valueValue_));
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int indexValue, Object valueValue) {
            if (RubyTypesGen.isImplicitLong(valueValue, this.valueImplicitType)) {
                long valueValue_ = RubyTypesGen.asImplicitLong(valueValue, this.valueImplicitType);
                if (ArrayGuards.isIntArray(arrayValue) && ArrayWriteNormalizedNode.isInBounds(arrayValue, indexValue)) {
                    return this.root.writeWithinInt(arrayValue, indexValue, valueValue_);
                }
            }
            return this.getNext().execute1(arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && RubyTypesGen.isImplicitLong(valueValue, this.valueImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                long valueValue_ = RubyTypesGen.asImplicitLong(valueValue, this.valueImplicitType);
                if (ArrayGuards.isIntArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_)) {
                    return this.root.writeWithinInt(arrayValue_, indexValue_, valueValue_);
                }
            }
            return this.getNext().execute_(arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root, Object indexValue, Object valueValue) {
            return new WriteWithinInt0Node_(root, indexValue, valueValue);
        }
    }

    @GeneratedBy(methodName="writeWithin(DynamicObject, int, Object)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteWithin3Node_
    extends BaseNode_ {
        private final Class<?> indexImplicitType;

        WriteWithin3Node_(ArrayWriteNormalizedNodeGen root, Object indexValue) {
            super(root, 10);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((WriteWithin3Node_)other).indexImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return this.getNext().execute_(ex.getResult(), indexValue, valueValue);
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_((Frame)frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return this.getNext().execute_(arrayValue_, ex.getResult(), valueValue);
            }
            Object valueValue_ = this.executeValue_((Frame)frameValue);
            if (ArrayGuards.isObjectArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_)) {
                return this.root.writeWithin(arrayValue_, indexValue_, valueValue_);
            }
            return this.getNext().execute_(arrayValue_, indexValue_, valueValue_);
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int indexValue, Object valueValue) {
            if (ArrayGuards.isObjectArray(arrayValue) && ArrayWriteNormalizedNode.isInBounds(arrayValue, indexValue)) {
                return this.root.writeWithin(arrayValue, indexValue, valueValue);
            }
            return this.getNext().execute1(arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                if (ArrayGuards.isObjectArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_)) {
                    return this.root.writeWithin(arrayValue_, indexValue_, valueValue);
                }
            }
            return this.getNext().execute_(arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root, Object indexValue) {
            return new WriteWithin3Node_(root, indexValue);
        }
    }

    @GeneratedBy(methodName="writeWithin(DynamicObject, int, double)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteWithin2Node_
    extends BaseNode_ {
        private final Class<?> indexImplicitType;
        private final Class<?> valueImplicitType;

        WriteWithin2Node_(ArrayWriteNormalizedNodeGen root, Object indexValue, Object valueValue) {
            super(root, 9);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
            this.valueImplicitType = RubyTypesGen.getImplicitDoubleClass(valueValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((WriteWithin2Node_)other).indexImplicitType && this.valueImplicitType == ((WriteWithin2Node_)other).valueImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            double valueValue_;
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectDouble(this.getNext().execute_(ex.getResult(), indexValue, valueValue));
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_((Frame)frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectDouble(this.getNext().execute_(arrayValue_, ex.getResult(), valueValue));
            }
            try {
                if (this.valueImplicitType == Double.TYPE) {
                    valueValue_ = this.root.value_.executeDouble(frameValue);
                } else {
                    Object valueValue__ = this.executeValue_((Frame)frameValue);
                    valueValue_ = RubyTypesGen.expectImplicitDouble(valueValue__, this.valueImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return ArrayWriteNormalizedNodeGen.expectDouble(this.getNext().execute_(arrayValue_, indexValue_, ex.getResult()));
            }
            if (ArrayGuards.isDoubleArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_)) {
                return this.root.writeWithin(arrayValue_, indexValue_, valueValue_);
            }
            return ArrayWriteNormalizedNodeGen.expectDouble(this.getNext().execute_(arrayValue_, indexValue_, valueValue_));
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int indexValue, Object valueValue) {
            if (RubyTypesGen.isImplicitDouble(valueValue, this.valueImplicitType)) {
                double valueValue_ = RubyTypesGen.asImplicitDouble(valueValue, this.valueImplicitType);
                if (ArrayGuards.isDoubleArray(arrayValue) && ArrayWriteNormalizedNode.isInBounds(arrayValue, indexValue)) {
                    return this.root.writeWithin(arrayValue, indexValue, valueValue_);
                }
            }
            return this.getNext().execute1(arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && RubyTypesGen.isImplicitDouble(valueValue, this.valueImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                double valueValue_ = RubyTypesGen.asImplicitDouble(valueValue, this.valueImplicitType);
                if (ArrayGuards.isDoubleArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_)) {
                    return this.root.writeWithin(arrayValue_, indexValue_, valueValue_);
                }
            }
            return this.getNext().execute_(arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root, Object indexValue, Object valueValue) {
            return new WriteWithin2Node_(root, indexValue, valueValue);
        }
    }

    @GeneratedBy(methodName="writeWithin(DynamicObject, int, long)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteWithin1Node_
    extends BaseNode_ {
        private final Class<?> indexImplicitType;
        private final Class<?> valueImplicitType;

        WriteWithin1Node_(ArrayWriteNormalizedNodeGen root, Object indexValue, Object valueValue) {
            super(root, 8);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
            this.valueImplicitType = RubyTypesGen.getImplicitLongClass(valueValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((WriteWithin1Node_)other).indexImplicitType && this.valueImplicitType == ((WriteWithin1Node_)other).valueImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeLong(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
            long valueValue_;
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectLong(this.getNext().execute_(ex.getResult(), indexValue, valueValue));
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_((Frame)frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectLong(this.getNext().execute_(arrayValue_, ex.getResult(), valueValue));
            }
            try {
                valueValue_ = this.executeValueLong_((Frame)frameValue, this.valueImplicitType);
            }
            catch (UnexpectedResultException ex) {
                return ArrayWriteNormalizedNodeGen.expectLong(this.getNext().execute_(arrayValue_, indexValue_, ex.getResult()));
            }
            if (ArrayGuards.isLongArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_)) {
                return this.root.writeWithin(arrayValue_, indexValue_, valueValue_);
            }
            return ArrayWriteNormalizedNodeGen.expectLong(this.getNext().execute_(arrayValue_, indexValue_, valueValue_));
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int indexValue, Object valueValue) {
            if (RubyTypesGen.isImplicitLong(valueValue, this.valueImplicitType)) {
                long valueValue_ = RubyTypesGen.asImplicitLong(valueValue, this.valueImplicitType);
                if (ArrayGuards.isLongArray(arrayValue) && ArrayWriteNormalizedNode.isInBounds(arrayValue, indexValue)) {
                    return this.root.writeWithin(arrayValue, indexValue, valueValue_);
                }
            }
            return this.getNext().execute1(arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && RubyTypesGen.isImplicitLong(valueValue, this.valueImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                long valueValue_ = RubyTypesGen.asImplicitLong(valueValue, this.valueImplicitType);
                if (ArrayGuards.isLongArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_)) {
                    return this.root.writeWithin(arrayValue_, indexValue_, valueValue_);
                }
            }
            return this.getNext().execute_(arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root, Object indexValue, Object valueValue) {
            return new WriteWithin1Node_(root, indexValue, valueValue);
        }
    }

    @GeneratedBy(methodName="writeWithin(DynamicObject, int, int)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteWithin0Node_
    extends BaseNode_ {
        private final Class<?> indexImplicitType;
        private final Class<?> valueImplicitType;

        WriteWithin0Node_(ArrayWriteNormalizedNodeGen root, Object indexValue, Object valueValue) {
            super(root, 7);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
            this.valueImplicitType = RubyTypesGen.getImplicitIntegerClass(valueValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((WriteWithin0Node_)other).indexImplicitType && this.valueImplicitType == ((WriteWithin0Node_)other).valueImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            int valueValue_;
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectInteger(this.getNext().execute_(ex.getResult(), indexValue, valueValue));
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_((Frame)frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectInteger(this.getNext().execute_(arrayValue_, ex.getResult(), valueValue));
            }
            try {
                if (this.valueImplicitType == Integer.TYPE) {
                    valueValue_ = this.root.value_.executeInteger(frameValue);
                } else {
                    Object valueValue__ = this.executeValue_((Frame)frameValue);
                    valueValue_ = RubyTypesGen.expectImplicitInteger(valueValue__, this.valueImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return ArrayWriteNormalizedNodeGen.expectInteger(this.getNext().execute_(arrayValue_, indexValue_, ex.getResult()));
            }
            if (ArrayGuards.isIntArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_)) {
                return this.root.writeWithin(arrayValue_, indexValue_, valueValue_);
            }
            return ArrayWriteNormalizedNodeGen.expectInteger(this.getNext().execute_(arrayValue_, indexValue_, valueValue_));
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int indexValue, Object valueValue) {
            if (RubyTypesGen.isImplicitInteger(valueValue, this.valueImplicitType)) {
                int valueValue_ = RubyTypesGen.asImplicitInteger(valueValue, this.valueImplicitType);
                if (ArrayGuards.isIntArray(arrayValue) && ArrayWriteNormalizedNode.isInBounds(arrayValue, indexValue)) {
                    return this.root.writeWithin(arrayValue, indexValue, valueValue_);
                }
            }
            return this.getNext().execute1(arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && RubyTypesGen.isImplicitInteger(valueValue, this.valueImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                int valueValue_ = RubyTypesGen.asImplicitInteger(valueValue, this.valueImplicitType);
                if (ArrayGuards.isIntArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_)) {
                    return this.root.writeWithin(arrayValue_, indexValue_, valueValue_);
                }
            }
            return this.getNext().execute_(arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root, Object indexValue, Object valueValue) {
            return new WriteWithin0Node_(root, indexValue, valueValue);
        }
    }

    @GeneratedBy(methodName="writeNullBeyond(DynamicObject, int, Object)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteNullBeyondNode_
    extends BaseNode_ {
        private final Class<?> indexImplicitType;

        WriteNullBeyondNode_(ArrayWriteNormalizedNodeGen root, Object indexValue) {
            super(root, 6);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((WriteNullBeyondNode_)other).indexImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return this.getNext().execute_(ex.getResult(), indexValue, valueValue);
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_((Frame)frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return this.getNext().execute_(arrayValue_, ex.getResult(), valueValue);
            }
            Object valueValue_ = this.executeValue_((Frame)frameValue);
            if (ArrayGuards.isNullArray(arrayValue_) && indexValue_ != 0) {
                return this.root.writeNullBeyond(arrayValue_, indexValue_, valueValue_);
            }
            return this.getNext().execute_(arrayValue_, indexValue_, valueValue_);
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int indexValue, Object valueValue) {
            if (ArrayGuards.isNullArray(arrayValue) && indexValue != 0) {
                return this.root.writeNullBeyond(arrayValue, indexValue, valueValue);
            }
            return this.getNext().execute1(arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                if (ArrayGuards.isNullArray(arrayValue_) && indexValue_ != 0) {
                    return this.root.writeNullBeyond(arrayValue_, indexValue_, valueValue);
                }
            }
            return this.getNext().execute_(arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root, Object indexValue) {
            return new WriteNullBeyondNode_(root, indexValue);
        }
    }

    @GeneratedBy(methodName="writeNull0(DynamicObject, int, DynamicObject)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteNull04Node_
    extends BaseNode_ {
        private final Class<?> indexImplicitType;

        WriteNull04Node_(ArrayWriteNormalizedNodeGen root, Object indexValue) {
            super(root, 5);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((WriteNull04Node_)other).indexImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
            DynamicObject valueValue_;
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectDynamicObject(this.getNext().execute_(ex.getResult(), indexValue, valueValue));
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_((Frame)frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectDynamicObject(this.getNext().execute_(arrayValue_, ex.getResult(), valueValue));
            }
            try {
                valueValue_ = this.root.value_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ArrayWriteNormalizedNodeGen.expectDynamicObject(this.getNext().execute_(arrayValue_, indexValue_, ex.getResult()));
            }
            if (ArrayGuards.isNullArray(arrayValue_) && indexValue_ == 0) {
                return this.root.writeNull0(arrayValue_, indexValue_, valueValue_);
            }
            return ArrayWriteNormalizedNodeGen.expectDynamicObject(this.getNext().execute_(arrayValue_, indexValue_, valueValue_));
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int indexValue, Object valueValue) {
            if (valueValue instanceof DynamicObject) {
                DynamicObject valueValue_ = (DynamicObject)valueValue;
                if (ArrayGuards.isNullArray(arrayValue) && indexValue == 0) {
                    return this.root.writeNull0(arrayValue, indexValue, valueValue_);
                }
            }
            return this.getNext().execute1(arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && valueValue instanceof DynamicObject) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                DynamicObject valueValue_ = (DynamicObject)valueValue;
                if (ArrayGuards.isNullArray(arrayValue_) && indexValue_ == 0) {
                    return this.root.writeNull0(arrayValue_, indexValue_, valueValue_);
                }
            }
            return this.getNext().execute_(arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root, Object indexValue) {
            return new WriteNull04Node_(root, indexValue);
        }
    }

    @GeneratedBy(methodName="writeNull0(DynamicObject, int, double)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteNull03Node_
    extends BaseNode_ {
        private final Class<?> indexImplicitType;
        private final Class<?> valueImplicitType;

        WriteNull03Node_(ArrayWriteNormalizedNodeGen root, Object indexValue, Object valueValue) {
            super(root, 4);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
            this.valueImplicitType = RubyTypesGen.getImplicitDoubleClass(valueValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((WriteNull03Node_)other).indexImplicitType && this.valueImplicitType == ((WriteNull03Node_)other).valueImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            double valueValue_;
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectDouble(this.getNext().execute_(ex.getResult(), indexValue, valueValue));
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_((Frame)frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectDouble(this.getNext().execute_(arrayValue_, ex.getResult(), valueValue));
            }
            try {
                if (this.valueImplicitType == Double.TYPE) {
                    valueValue_ = this.root.value_.executeDouble(frameValue);
                } else {
                    Object valueValue__ = this.executeValue_((Frame)frameValue);
                    valueValue_ = RubyTypesGen.expectImplicitDouble(valueValue__, this.valueImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return ArrayWriteNormalizedNodeGen.expectDouble(this.getNext().execute_(arrayValue_, indexValue_, ex.getResult()));
            }
            if (ArrayGuards.isNullArray(arrayValue_) && indexValue_ == 0) {
                return this.root.writeNull0(arrayValue_, indexValue_, valueValue_);
            }
            return ArrayWriteNormalizedNodeGen.expectDouble(this.getNext().execute_(arrayValue_, indexValue_, valueValue_));
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int indexValue, Object valueValue) {
            if (RubyTypesGen.isImplicitDouble(valueValue, this.valueImplicitType)) {
                double valueValue_ = RubyTypesGen.asImplicitDouble(valueValue, this.valueImplicitType);
                if (ArrayGuards.isNullArray(arrayValue) && indexValue == 0) {
                    return this.root.writeNull0(arrayValue, indexValue, valueValue_);
                }
            }
            return this.getNext().execute1(arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && RubyTypesGen.isImplicitDouble(valueValue, this.valueImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                double valueValue_ = RubyTypesGen.asImplicitDouble(valueValue, this.valueImplicitType);
                if (ArrayGuards.isNullArray(arrayValue_) && indexValue_ == 0) {
                    return this.root.writeNull0(arrayValue_, indexValue_, valueValue_);
                }
            }
            return this.getNext().execute_(arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root, Object indexValue, Object valueValue) {
            return new WriteNull03Node_(root, indexValue, valueValue);
        }
    }

    @GeneratedBy(methodName="writeNull0(DynamicObject, int, long)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteNull02Node_
    extends BaseNode_ {
        private final Class<?> indexImplicitType;
        private final Class<?> valueImplicitType;

        WriteNull02Node_(ArrayWriteNormalizedNodeGen root, Object indexValue, Object valueValue) {
            super(root, 3);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
            this.valueImplicitType = RubyTypesGen.getImplicitLongClass(valueValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((WriteNull02Node_)other).indexImplicitType && this.valueImplicitType == ((WriteNull02Node_)other).valueImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeLong(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
            long valueValue_;
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectLong(this.getNext().execute_(ex.getResult(), indexValue, valueValue));
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_((Frame)frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectLong(this.getNext().execute_(arrayValue_, ex.getResult(), valueValue));
            }
            try {
                valueValue_ = this.executeValueLong_((Frame)frameValue, this.valueImplicitType);
            }
            catch (UnexpectedResultException ex) {
                return ArrayWriteNormalizedNodeGen.expectLong(this.getNext().execute_(arrayValue_, indexValue_, ex.getResult()));
            }
            if (ArrayGuards.isNullArray(arrayValue_) && indexValue_ == 0) {
                return this.root.writeNull0(arrayValue_, indexValue_, valueValue_);
            }
            return ArrayWriteNormalizedNodeGen.expectLong(this.getNext().execute_(arrayValue_, indexValue_, valueValue_));
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int indexValue, Object valueValue) {
            if (RubyTypesGen.isImplicitLong(valueValue, this.valueImplicitType)) {
                long valueValue_ = RubyTypesGen.asImplicitLong(valueValue, this.valueImplicitType);
                if (ArrayGuards.isNullArray(arrayValue) && indexValue == 0) {
                    return this.root.writeNull0(arrayValue, indexValue, valueValue_);
                }
            }
            return this.getNext().execute1(arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && RubyTypesGen.isImplicitLong(valueValue, this.valueImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                long valueValue_ = RubyTypesGen.asImplicitLong(valueValue, this.valueImplicitType);
                if (ArrayGuards.isNullArray(arrayValue_) && indexValue_ == 0) {
                    return this.root.writeNull0(arrayValue_, indexValue_, valueValue_);
                }
            }
            return this.getNext().execute_(arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root, Object indexValue, Object valueValue) {
            return new WriteNull02Node_(root, indexValue, valueValue);
        }
    }

    @GeneratedBy(methodName="writeNull0(DynamicObject, int, int)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteNull01Node_
    extends BaseNode_ {
        private final Class<?> indexImplicitType;
        private final Class<?> valueImplicitType;

        WriteNull01Node_(ArrayWriteNormalizedNodeGen root, Object indexValue, Object valueValue) {
            super(root, 2);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
            this.valueImplicitType = RubyTypesGen.getImplicitIntegerClass(valueValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((WriteNull01Node_)other).indexImplicitType && this.valueImplicitType == ((WriteNull01Node_)other).valueImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            int valueValue_;
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectInteger(this.getNext().execute_(ex.getResult(), indexValue, valueValue));
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_((Frame)frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectInteger(this.getNext().execute_(arrayValue_, ex.getResult(), valueValue));
            }
            try {
                if (this.valueImplicitType == Integer.TYPE) {
                    valueValue_ = this.root.value_.executeInteger(frameValue);
                } else {
                    Object valueValue__ = this.executeValue_((Frame)frameValue);
                    valueValue_ = RubyTypesGen.expectImplicitInteger(valueValue__, this.valueImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return ArrayWriteNormalizedNodeGen.expectInteger(this.getNext().execute_(arrayValue_, indexValue_, ex.getResult()));
            }
            if (ArrayGuards.isNullArray(arrayValue_) && indexValue_ == 0) {
                return this.root.writeNull0(arrayValue_, indexValue_, valueValue_);
            }
            return ArrayWriteNormalizedNodeGen.expectInteger(this.getNext().execute_(arrayValue_, indexValue_, valueValue_));
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int indexValue, Object valueValue) {
            if (RubyTypesGen.isImplicitInteger(valueValue, this.valueImplicitType)) {
                int valueValue_ = RubyTypesGen.asImplicitInteger(valueValue, this.valueImplicitType);
                if (ArrayGuards.isNullArray(arrayValue) && indexValue == 0) {
                    return this.root.writeNull0(arrayValue, indexValue, valueValue_);
                }
            }
            return this.getNext().execute1(arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && RubyTypesGen.isImplicitInteger(valueValue, this.valueImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                int valueValue_ = RubyTypesGen.asImplicitInteger(valueValue, this.valueImplicitType);
                if (ArrayGuards.isNullArray(arrayValue_) && indexValue_ == 0) {
                    return this.root.writeNull0(arrayValue_, indexValue_, valueValue_);
                }
            }
            return this.getNext().execute_(arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root, Object indexValue, Object valueValue) {
            return new WriteNull01Node_(root, indexValue, valueValue);
        }
    }

    @GeneratedBy(methodName="writeNull0(DynamicObject, int, boolean)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteNull00Node_
    extends BaseNode_ {
        private final Class<?> indexImplicitType;

        WriteNull00Node_(ArrayWriteNormalizedNodeGen root, Object indexValue) {
            super(root, 1);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((WriteNull00Node_)other).indexImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
            boolean valueValue_;
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectBoolean(this.getNext().execute_(ex.getResult(), indexValue, valueValue));
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_((Frame)frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.executeValue_((Frame)frameValue);
                return ArrayWriteNormalizedNodeGen.expectBoolean(this.getNext().execute_(arrayValue_, ex.getResult(), valueValue));
            }
            try {
                valueValue_ = this.root.value_.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ArrayWriteNormalizedNodeGen.expectBoolean(this.getNext().execute_(arrayValue_, indexValue_, ex.getResult()));
            }
            if (ArrayGuards.isNullArray(arrayValue_) && indexValue_ == 0) {
                return this.root.writeNull0(arrayValue_, indexValue_, valueValue_);
            }
            return ArrayWriteNormalizedNodeGen.expectBoolean(this.getNext().execute_(arrayValue_, indexValue_, valueValue_));
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int indexValue, Object valueValue) {
            if (valueValue instanceof Boolean) {
                boolean valueValue_ = (Boolean)valueValue;
                if (ArrayGuards.isNullArray(arrayValue) && indexValue == 0) {
                    return this.root.writeNull0(arrayValue, indexValue, valueValue_);
                }
            }
            return this.getNext().execute1(arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && valueValue instanceof Boolean) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                boolean valueValue_ = (Boolean)valueValue;
                if (ArrayGuards.isNullArray(arrayValue_) && indexValue_ == 0) {
                    return this.root.writeNull0(arrayValue_, indexValue_, valueValue_);
                }
            }
            return this.getNext().execute_(arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root, Object indexValue) {
            return new WriteNull00Node_(root, indexValue);
        }
    }

    @GeneratedBy(value=ArrayWriteNormalizedNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(ArrayWriteNormalizedNodeGen root) {
            super(root, 0);
        }

        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arrayValue, indexValue, valueValue));
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue, Object valueValue) {
            return this.getNext().execute_(arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=ArrayWriteNormalizedNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(ArrayWriteNormalizedNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue, Object valueValue) {
            return this.uninitialized(null, arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=ArrayWriteNormalizedNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected ArrayWriteNormalizedNodeGen root;

        BaseNode_(ArrayWriteNormalizedNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        protected final void setRoot(Node root) {
            this.root = (ArrayWriteNormalizedNodeGen)root;
        }

        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.array_, this.root.index_, this.root.value_};
        }

        public final Object acceptAndExecute(Frame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            return this.execute_(arrayValue, indexValue, valueValue);
        }

        public abstract Object execute_(Object var1, Object var2, Object var3);

        public Object execute1(DynamicObject arrayValue, int indexValue, Object valueValue) {
            return this.execute_(arrayValue, indexValue, valueValue);
        }

        public Object execute0(VirtualFrame frameValue) {
            Object arrayValue_ = this.root.array_.execute(frameValue);
            Object indexValue_ = this.executeIndex_((Frame)frameValue);
            Object valueValue_ = this.executeValue_((Frame)frameValue);
            return this.execute_(arrayValue_, indexValue_, valueValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute0(frameValue);
        }

        public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
            return ArrayWriteNormalizedNodeGen.expectDynamicObject(this.execute0(frameValue));
        }

        public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
            return ArrayWriteNormalizedNodeGen.expectBoolean(this.execute0(frameValue));
        }

        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            return ArrayWriteNormalizedNodeGen.expectDouble(this.execute0(frameValue));
        }

        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            return ArrayWriteNormalizedNodeGen.expectInteger(this.execute0(frameValue));
        }

        public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
            return ArrayWriteNormalizedNodeGen.expectLong(this.execute0(frameValue));
        }

        protected final SpecializationNode createNext(Frame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue);
                if (valueValue instanceof Boolean && ArrayGuards.isNullArray(arrayValue_) && indexValue_ == 0) {
                    return WriteNull00Node_.create(this.root, indexValue);
                }
                if (RubyTypesGen.isImplicitInteger(valueValue) && ArrayGuards.isNullArray(arrayValue_) && indexValue_ == 0) {
                    return WriteNull01Node_.create(this.root, indexValue, valueValue);
                }
                if (RubyTypesGen.isImplicitLong(valueValue) && ArrayGuards.isNullArray(arrayValue_) && indexValue_ == 0) {
                    return WriteNull02Node_.create(this.root, indexValue, valueValue);
                }
                if (RubyTypesGen.isImplicitDouble(valueValue) && ArrayGuards.isNullArray(arrayValue_) && indexValue_ == 0) {
                    return WriteNull03Node_.create(this.root, indexValue, valueValue);
                }
                if (valueValue instanceof DynamicObject && ArrayGuards.isNullArray(arrayValue_) && indexValue_ == 0) {
                    return WriteNull04Node_.create(this.root, indexValue);
                }
                if (ArrayGuards.isNullArray(arrayValue_) && indexValue_ != 0) {
                    return WriteNullBeyondNode_.create(this.root, indexValue);
                }
                if (RubyTypesGen.isImplicitInteger(valueValue) && ArrayGuards.isIntArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_)) {
                    return WriteWithin0Node_.create(this.root, indexValue, valueValue);
                }
                if (RubyTypesGen.isImplicitLong(valueValue) && ArrayGuards.isLongArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_)) {
                    return WriteWithin1Node_.create(this.root, indexValue, valueValue);
                }
                if (RubyTypesGen.isImplicitDouble(valueValue) && ArrayGuards.isDoubleArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_)) {
                    return WriteWithin2Node_.create(this.root, indexValue, valueValue);
                }
                if (ArrayGuards.isObjectArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_)) {
                    return WriteWithin3Node_.create(this.root, indexValue);
                }
                if (RubyTypesGen.isImplicitLong(valueValue) && ArrayGuards.isIntArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_)) {
                    return WriteWithinInt0Node_.create(this.root, indexValue, valueValue);
                }
                if (ArrayGuards.isIntArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && !RubyGuards.isInteger(valueValue) && !RubyGuards.isLong(valueValue)) {
                    return WriteWithinInt1Node_.create(this.root, indexValue);
                }
                if (ArrayGuards.isLongArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && !RubyGuards.isInteger(valueValue) && !RubyGuards.isLong(valueValue)) {
                    return WriteWithinLongNode_.create(this.root, indexValue);
                }
                if (ArrayGuards.isDoubleArray(arrayValue_) && ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && !RubyGuards.isDouble(valueValue)) {
                    return WriteWithinDoubleNode_.create(this.root, indexValue);
                }
                if (RubyTypesGen.isImplicitInteger(valueValue) && ArrayGuards.isIntArray(arrayValue_) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                    return WriteExtendByOne0Node_.create(this.root, indexValue, valueValue);
                }
                if (RubyTypesGen.isImplicitLong(valueValue) && ArrayGuards.isLongArray(arrayValue_) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                    return WriteExtendByOne1Node_.create(this.root, indexValue, valueValue);
                }
                if (RubyTypesGen.isImplicitDouble(valueValue) && ArrayGuards.isDoubleArray(arrayValue_) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                    return WriteExtendByOne2Node_.create(this.root, indexValue, valueValue);
                }
                if (ArrayGuards.isObjectArray(arrayValue_) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                    return WriteExtendByOne3Node_.create(this.root, indexValue);
                }
                if (!(ArrayGuards.isObjectArray(arrayValue_) || ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) || ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_))) {
                    return WriteBeyondPrimitiveNode_.create(this.root, indexValue);
                }
                if (ArrayGuards.isObjectArray(arrayValue_) && !ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && !ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                    return WriteBeyondObjectNode_.create(this.root, indexValue);
                }
            }
            return null;
        }

        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeIndex_(Frame frameValue) {
            Object object;
            Class indexType_ = this.root.indexType_;
            if (indexType_ == Integer.TYPE) {
                return this.root.index_.executeInteger((VirtualFrame)frameValue);
            }
            if (indexType_ != null) return this.root.index_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.index_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.indexType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.indexType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.indexType_ = _type;
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeValue_(Frame frameValue) {
            Object object;
            Class valueType_ = this.root.valueType_;
            if (valueType_ == Boolean.TYPE) {
                return this.root.value_.executeBoolean((VirtualFrame)frameValue);
            }
            if (valueType_ == Double.TYPE) {
                return this.root.value_.executeDouble((VirtualFrame)frameValue);
            }
            if (valueType_ == Integer.TYPE) {
                return this.root.value_.executeInteger((VirtualFrame)frameValue);
            }
            if (valueType_ == Long.TYPE) {
                return this.root.value_.executeLong((VirtualFrame)frameValue);
            }
            if (valueType_ != null) return this.root.value_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.value_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Boolean ? Boolean.TYPE : (_value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class)));
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.valueType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.valueType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.valueType_ = _type;
            return object;
        }

        protected final long executeValueLong_(Frame frameValue, Class<?> valueImplicitType) throws UnexpectedResultException {
            if (valueImplicitType == Long.TYPE) {
                return this.root.value_.executeLong((VirtualFrame)frameValue);
            }
            if (valueImplicitType == Integer.TYPE) {
                return RubyTypes.promoteToLong(this.root.value_.executeInteger((VirtualFrame)frameValue));
            }
            Object valueValue_ = this.executeValue_(frameValue);
            return RubyTypesGen.expectImplicitLong(valueValue_, valueImplicitType);
        }
    }
}

