/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.nodes.core.array.ArrayPopOneNode;
import org.jruby.truffle.runtime.RubyContext;

@GeneratedBy(value=ArrayPopOneNode.class)
public final class ArrayPopOneNodeGen
extends ArrayPopOneNode
implements SpecializedNode {
    @Node.Child
    private RubyNode array_;
    @Node.Child
    private BaseNode_ specialization_;

    private ArrayPopOneNodeGen(RubyContext context, SourceSection sourceSection, RubyNode array) {
        super(context, sourceSection);
        this.array_ = array;
        this.specialization_ = UninitializedNode_.create(this);
    }

    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public Object executePopOne(DynamicObject arrayValue) {
        return this.specialization_.execute1(arrayValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute0(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    public Node deepCopy() {
        return SpecializationNode.updateRoot((Node)super.deepCopy());
    }

    public static ArrayPopOneNode create(RubyContext context, SourceSection sourceSection, RubyNode array) {
        return new ArrayPopOneNodeGen(context, sourceSection, array);
    }

    @GeneratedBy(methodName="popOneObject(DynamicObject)", value=ArrayPopOneNode.class)
    private static final class PopOneObjectNode_
    extends BaseNode_ {
        PopOneObjectNode_(ArrayPopOneNodeGen root) {
            super(root, 5);
        }

        @Override
        public Object execute1(DynamicObject arrayValue) {
            if (!ArrayGuards.isEmptyArray(arrayValue) && ArrayGuards.isObjectArray(arrayValue)) {
                return this.root.popOneObject(arrayValue);
            }
            return this.getNext().execute1(arrayValue);
        }

        @Override
        public Object execute_(Object arrayValue) {
            DynamicObject arrayValue_;
            if (arrayValue instanceof DynamicObject && !ArrayGuards.isEmptyArray(arrayValue_ = (DynamicObject)arrayValue) && ArrayGuards.isObjectArray(arrayValue_)) {
                return this.root.popOneObject(arrayValue_);
            }
            return this.getNext().execute_(arrayValue);
        }

        static BaseNode_ create(ArrayPopOneNodeGen root) {
            return new PopOneObjectNode_(root);
        }
    }

    @GeneratedBy(methodName="popOneDouble(DynamicObject)", value=ArrayPopOneNode.class)
    private static final class PopOneDoubleNode_
    extends BaseNode_ {
        PopOneDoubleNode_(ArrayPopOneNodeGen root) {
            super(root, 4);
        }

        @Override
        public Object execute1(DynamicObject arrayValue) {
            if (!ArrayGuards.isEmptyArray(arrayValue) && ArrayGuards.isDoubleArray(arrayValue)) {
                return this.root.popOneDouble(arrayValue);
            }
            return this.getNext().execute1(arrayValue);
        }

        @Override
        public Object execute_(Object arrayValue) {
            DynamicObject arrayValue_;
            if (arrayValue instanceof DynamicObject && !ArrayGuards.isEmptyArray(arrayValue_ = (DynamicObject)arrayValue) && ArrayGuards.isDoubleArray(arrayValue_)) {
                return this.root.popOneDouble(arrayValue_);
            }
            return this.getNext().execute_(arrayValue);
        }

        static BaseNode_ create(ArrayPopOneNodeGen root) {
            return new PopOneDoubleNode_(root);
        }
    }

    @GeneratedBy(methodName="popOneLong(DynamicObject)", value=ArrayPopOneNode.class)
    private static final class PopOneLongNode_
    extends BaseNode_ {
        PopOneLongNode_(ArrayPopOneNodeGen root) {
            super(root, 3);
        }

        @Override
        public Object execute1(DynamicObject arrayValue) {
            if (!ArrayGuards.isEmptyArray(arrayValue) && ArrayGuards.isLongArray(arrayValue)) {
                return this.root.popOneLong(arrayValue);
            }
            return this.getNext().execute1(arrayValue);
        }

        @Override
        public Object execute_(Object arrayValue) {
            DynamicObject arrayValue_;
            if (arrayValue instanceof DynamicObject && !ArrayGuards.isEmptyArray(arrayValue_ = (DynamicObject)arrayValue) && ArrayGuards.isLongArray(arrayValue_)) {
                return this.root.popOneLong(arrayValue_);
            }
            return this.getNext().execute_(arrayValue);
        }

        static BaseNode_ create(ArrayPopOneNodeGen root) {
            return new PopOneLongNode_(root);
        }
    }

    @GeneratedBy(methodName="popOneInteger(DynamicObject)", value=ArrayPopOneNode.class)
    private static final class PopOneIntegerNode_
    extends BaseNode_ {
        PopOneIntegerNode_(ArrayPopOneNodeGen root) {
            super(root, 2);
        }

        @Override
        public Object execute1(DynamicObject arrayValue) {
            if (!ArrayGuards.isEmptyArray(arrayValue) && ArrayGuards.isIntArray(arrayValue)) {
                return this.root.popOneInteger(arrayValue);
            }
            return this.getNext().execute1(arrayValue);
        }

        @Override
        public Object execute_(Object arrayValue) {
            DynamicObject arrayValue_;
            if (arrayValue instanceof DynamicObject && !ArrayGuards.isEmptyArray(arrayValue_ = (DynamicObject)arrayValue) && ArrayGuards.isIntArray(arrayValue_)) {
                return this.root.popOneInteger(arrayValue_);
            }
            return this.getNext().execute_(arrayValue);
        }

        static BaseNode_ create(ArrayPopOneNodeGen root) {
            return new PopOneIntegerNode_(root);
        }
    }

    @GeneratedBy(methodName="popOneEmpty(DynamicObject)", value=ArrayPopOneNode.class)
    private static final class PopOneEmptyNode_
    extends BaseNode_ {
        PopOneEmptyNode_(ArrayPopOneNodeGen root) {
            super(root, 1);
        }

        @Override
        public Object execute1(DynamicObject arrayValue) {
            if (ArrayGuards.isEmptyArray(arrayValue)) {
                return this.root.popOneEmpty(arrayValue);
            }
            return this.getNext().execute1(arrayValue);
        }

        @Override
        public Object execute_(Object arrayValue) {
            DynamicObject arrayValue_;
            if (arrayValue instanceof DynamicObject && ArrayGuards.isEmptyArray(arrayValue_ = (DynamicObject)arrayValue)) {
                return this.root.popOneEmpty(arrayValue_);
            }
            return this.getNext().execute_(arrayValue);
        }

        static BaseNode_ create(ArrayPopOneNodeGen root) {
            return new PopOneEmptyNode_(root);
        }
    }

    @GeneratedBy(value=ArrayPopOneNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(ArrayPopOneNodeGen root) {
            super(root, 0);
        }

        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arrayValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arrayValue));
        }

        @Override
        public Object execute_(Object arrayValue) {
            return this.getNext().execute_(arrayValue);
        }

        static BaseNode_ create(ArrayPopOneNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=ArrayPopOneNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(ArrayPopOneNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public Object execute_(Object arrayValue) {
            return this.uninitialized(null, arrayValue);
        }

        static BaseNode_ create(ArrayPopOneNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=ArrayPopOneNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected ArrayPopOneNodeGen root;

        BaseNode_(ArrayPopOneNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        protected final void setRoot(Node root) {
            this.root = (ArrayPopOneNodeGen)root;
        }

        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.array_};
        }

        public final Object acceptAndExecute(Frame frameValue, Object arrayValue) {
            return this.execute_(arrayValue);
        }

        public abstract Object execute_(Object var1);

        public Object execute1(DynamicObject arrayValue) {
            return this.execute_(arrayValue);
        }

        public Object execute0(VirtualFrame frameValue) {
            Object arrayValue_ = this.root.array_.execute(frameValue);
            return this.execute_(arrayValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute0(frameValue);
        }

        protected final SpecializationNode createNext(Frame frameValue, Object arrayValue) {
            if (arrayValue instanceof DynamicObject) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                if (ArrayGuards.isEmptyArray(arrayValue_)) {
                    return PopOneEmptyNode_.create(this.root);
                }
                if (ArrayGuards.isIntArray(arrayValue_)) {
                    return PopOneIntegerNode_.create(this.root);
                }
                if (!ArrayGuards.isEmptyArray(arrayValue_) && ArrayGuards.isLongArray(arrayValue_)) {
                    return PopOneLongNode_.create(this.root);
                }
                if (!ArrayGuards.isEmptyArray(arrayValue_) && ArrayGuards.isDoubleArray(arrayValue_)) {
                    return PopOneDoubleNode_.create(this.root);
                }
                if (!ArrayGuards.isEmptyArray(arrayValue_) && ArrayGuards.isObjectArray(arrayValue_)) {
                    return PopOneObjectNode_.create(this.root);
                }
            }
            return null;
        }

        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }
    }
}

