/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.array.ArrayAppendManyNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.runtime.RubyContext;

@GeneratedBy(value=ArrayAppendManyNode.class)
public final class ArrayAppendManyNodeGen
extends ArrayAppendManyNode
implements SpecializedNode {
    @Node.Child
    private RubyNode array_;
    @Node.Child
    private RubyNode otherSize_;
    @Node.Child
    private RubyNode other_;
    @CompilerDirectives.CompilationFinal
    private Class<?> otherSizeType_;
    @Node.Child
    private BaseNode_ specialization_;

    private ArrayAppendManyNodeGen(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode otherSize, RubyNode other) {
        super(context, sourceSection);
        this.array_ = array;
        this.otherSize_ = otherSize;
        this.other_ = other;
        this.specialization_ = UninitializedNode_.create(this);
    }

    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public DynamicObject executeAppendMany(DynamicObject arrayValue, int otherSizeValue, Object otherValue) {
        return this.specialization_.executeDynamicObject1(arrayValue, otherSizeValue, otherValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
        return this.specialization_.executeDynamicObject0(frameValue);
    }

    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    public Node deepCopy() {
        return SpecializationNode.updateRoot((Node)super.deepCopy());
    }

    private static double[] expectDoubleArray(Object value) throws UnexpectedResultException {
        if (value instanceof double[]) {
            return (double[])value;
        }
        throw new UnexpectedResultException(value);
    }

    private static int[] expectIntArray(Object value) throws UnexpectedResultException {
        if (value instanceof int[]) {
            return (int[])value;
        }
        throw new UnexpectedResultException(value);
    }

    private static long[] expectLongArray(Object value) throws UnexpectedResultException {
        if (value instanceof long[]) {
            return (long[])value;
        }
        throw new UnexpectedResultException(value);
    }

    public static ArrayAppendManyNode create(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode otherSize, RubyNode other) {
        return new ArrayAppendManyNodeGen(context, sourceSection, array, otherSize, other);
    }

    @GeneratedBy(methodName="appendManyGeneralizeDoubleObject(DynamicObject, int, Object[])", value=ArrayAppendManyNode.class)
    private static final class AppendManyGeneralizeDoubleObjectNode_
    extends BaseNode_ {
        private final Class<?> otherSizeImplicitType;

        AppendManyGeneralizeDoubleObjectNode_(ArrayAppendManyNodeGen root, Object otherSizeValue) {
            super(root, 19);
            this.otherSizeImplicitType = RubyTypesGen.getImplicitIntegerClass(otherSizeValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.otherSizeImplicitType == ((AppendManyGeneralizeDoubleObjectNode_)other).otherSizeImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            Object[] otherValue_;
            int otherSizeValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherSizeValue = this.executeOtherSize_((Frame)frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), otherSizeValue, otherValue);
            }
            try {
                if (this.otherSizeImplicitType == Integer.TYPE) {
                    otherSizeValue_ = this.root.otherSize_.executeInteger(frameValue);
                } else {
                    Object otherSizeValue__ = this.executeOtherSize_((Frame)frameValue);
                    otherSizeValue_ = RubyTypesGen.expectImplicitInteger(otherSizeValue__, this.otherSizeImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult(), otherValue);
            }
            try {
                otherValue_ = this.root.other_.executeObjectArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, otherSizeValue_, ex.getResult());
            }
            if (ArrayGuards.isDoubleArray(arrayValue_)) {
                return this.root.appendManyGeneralizeDoubleObject(arrayValue_, otherSizeValue_, otherValue_);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, otherSizeValue_, otherValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, int otherSizeValue, Object otherValue) {
            if (otherValue instanceof Object[]) {
                Object[] otherValue_ = (Object[])otherValue;
                if (ArrayGuards.isDoubleArray(arrayValue)) {
                    return this.root.appendManyGeneralizeDoubleObject(arrayValue, otherSizeValue, otherValue_);
                }
            }
            return this.getNext().executeDynamicObject1(arrayValue, otherSizeValue, otherValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(otherSizeValue, this.otherSizeImplicitType) && otherValue instanceof Object[]) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int otherSizeValue_ = RubyTypesGen.asImplicitInteger(otherSizeValue, this.otherSizeImplicitType);
                Object[] otherValue_ = (Object[])otherValue;
                if (ArrayGuards.isDoubleArray(arrayValue_)) {
                    return this.root.appendManyGeneralizeDoubleObject(arrayValue_, otherSizeValue_, otherValue_);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(ArrayAppendManyNodeGen root, Object otherSizeValue) {
            return new AppendManyGeneralizeDoubleObjectNode_(root, otherSizeValue);
        }
    }

    @GeneratedBy(methodName="appendManyGeneralizeDoubleLong(DynamicObject, int, long[])", value=ArrayAppendManyNode.class)
    private static final class AppendManyGeneralizeDoubleLongNode_
    extends BaseNode_ {
        private final Class<?> otherSizeImplicitType;

        AppendManyGeneralizeDoubleLongNode_(ArrayAppendManyNodeGen root, Object otherSizeValue) {
            super(root, 18);
            this.otherSizeImplicitType = RubyTypesGen.getImplicitIntegerClass(otherSizeValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.otherSizeImplicitType == ((AppendManyGeneralizeDoubleLongNode_)other).otherSizeImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            long[] otherValue_;
            int otherSizeValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherSizeValue = this.executeOtherSize_((Frame)frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), otherSizeValue, otherValue);
            }
            try {
                if (this.otherSizeImplicitType == Integer.TYPE) {
                    otherSizeValue_ = this.root.otherSize_.executeInteger(frameValue);
                } else {
                    Object otherSizeValue__ = this.executeOtherSize_((Frame)frameValue);
                    otherSizeValue_ = RubyTypesGen.expectImplicitInteger(otherSizeValue__, this.otherSizeImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult(), otherValue);
            }
            try {
                otherValue_ = ArrayAppendManyNodeGen.expectLongArray(this.root.other_.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, otherSizeValue_, ex.getResult());
            }
            if (ArrayGuards.isDoubleArray(arrayValue_)) {
                return this.root.appendManyGeneralizeDoubleLong(arrayValue_, otherSizeValue_, otherValue_);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, otherSizeValue_, otherValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, int otherSizeValue, Object otherValue) {
            if (otherValue instanceof long[]) {
                long[] otherValue_ = (long[])otherValue;
                if (ArrayGuards.isDoubleArray(arrayValue)) {
                    return this.root.appendManyGeneralizeDoubleLong(arrayValue, otherSizeValue, otherValue_);
                }
            }
            return this.getNext().executeDynamicObject1(arrayValue, otherSizeValue, otherValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(otherSizeValue, this.otherSizeImplicitType) && otherValue instanceof long[]) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int otherSizeValue_ = RubyTypesGen.asImplicitInteger(otherSizeValue, this.otherSizeImplicitType);
                long[] otherValue_ = (long[])otherValue;
                if (ArrayGuards.isDoubleArray(arrayValue_)) {
                    return this.root.appendManyGeneralizeDoubleLong(arrayValue_, otherSizeValue_, otherValue_);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(ArrayAppendManyNodeGen root, Object otherSizeValue) {
            return new AppendManyGeneralizeDoubleLongNode_(root, otherSizeValue);
        }
    }

    @GeneratedBy(methodName="appendManyGeneralizeDoubleInteger(DynamicObject, int, int[])", value=ArrayAppendManyNode.class)
    private static final class AppendManyGeneralizeDoubleIntegerNode_
    extends BaseNode_ {
        private final Class<?> otherSizeImplicitType;

        AppendManyGeneralizeDoubleIntegerNode_(ArrayAppendManyNodeGen root, Object otherSizeValue) {
            super(root, 17);
            this.otherSizeImplicitType = RubyTypesGen.getImplicitIntegerClass(otherSizeValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.otherSizeImplicitType == ((AppendManyGeneralizeDoubleIntegerNode_)other).otherSizeImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            int[] otherValue_;
            int otherSizeValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherSizeValue = this.executeOtherSize_((Frame)frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), otherSizeValue, otherValue);
            }
            try {
                if (this.otherSizeImplicitType == Integer.TYPE) {
                    otherSizeValue_ = this.root.otherSize_.executeInteger(frameValue);
                } else {
                    Object otherSizeValue__ = this.executeOtherSize_((Frame)frameValue);
                    otherSizeValue_ = RubyTypesGen.expectImplicitInteger(otherSizeValue__, this.otherSizeImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult(), otherValue);
            }
            try {
                otherValue_ = ArrayAppendManyNodeGen.expectIntArray(this.root.other_.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, otherSizeValue_, ex.getResult());
            }
            if (ArrayGuards.isDoubleArray(arrayValue_)) {
                return this.root.appendManyGeneralizeDoubleInteger(arrayValue_, otherSizeValue_, otherValue_);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, otherSizeValue_, otherValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, int otherSizeValue, Object otherValue) {
            if (otherValue instanceof int[]) {
                int[] otherValue_ = (int[])otherValue;
                if (ArrayGuards.isDoubleArray(arrayValue)) {
                    return this.root.appendManyGeneralizeDoubleInteger(arrayValue, otherSizeValue, otherValue_);
                }
            }
            return this.getNext().executeDynamicObject1(arrayValue, otherSizeValue, otherValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(otherSizeValue, this.otherSizeImplicitType) && otherValue instanceof int[]) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int otherSizeValue_ = RubyTypesGen.asImplicitInteger(otherSizeValue, this.otherSizeImplicitType);
                int[] otherValue_ = (int[])otherValue;
                if (ArrayGuards.isDoubleArray(arrayValue_)) {
                    return this.root.appendManyGeneralizeDoubleInteger(arrayValue_, otherSizeValue_, otherValue_);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(ArrayAppendManyNodeGen root, Object otherSizeValue) {
            return new AppendManyGeneralizeDoubleIntegerNode_(root, otherSizeValue);
        }
    }

    @GeneratedBy(methodName="appendManyGeneralizeLongDouble(DynamicObject, int, Object[])", value=ArrayAppendManyNode.class)
    private static final class AppendManyGeneralizeLongDouble1Node_
    extends BaseNode_ {
        private final Class<?> otherSizeImplicitType;

        AppendManyGeneralizeLongDouble1Node_(ArrayAppendManyNodeGen root, Object otherSizeValue) {
            super(root, 16);
            this.otherSizeImplicitType = RubyTypesGen.getImplicitIntegerClass(otherSizeValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.otherSizeImplicitType == ((AppendManyGeneralizeLongDouble1Node_)other).otherSizeImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            Object[] otherValue_;
            int otherSizeValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherSizeValue = this.executeOtherSize_((Frame)frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), otherSizeValue, otherValue);
            }
            try {
                if (this.otherSizeImplicitType == Integer.TYPE) {
                    otherSizeValue_ = this.root.otherSize_.executeInteger(frameValue);
                } else {
                    Object otherSizeValue__ = this.executeOtherSize_((Frame)frameValue);
                    otherSizeValue_ = RubyTypesGen.expectImplicitInteger(otherSizeValue__, this.otherSizeImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult(), otherValue);
            }
            try {
                otherValue_ = this.root.other_.executeObjectArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, otherSizeValue_, ex.getResult());
            }
            if (ArrayGuards.isLongArray(arrayValue_)) {
                return this.root.appendManyGeneralizeLongDouble(arrayValue_, otherSizeValue_, otherValue_);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, otherSizeValue_, otherValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, int otherSizeValue, Object otherValue) {
            if (otherValue instanceof Object[]) {
                Object[] otherValue_ = (Object[])otherValue;
                if (ArrayGuards.isLongArray(arrayValue)) {
                    return this.root.appendManyGeneralizeLongDouble(arrayValue, otherSizeValue, otherValue_);
                }
            }
            return this.getNext().executeDynamicObject1(arrayValue, otherSizeValue, otherValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(otherSizeValue, this.otherSizeImplicitType) && otherValue instanceof Object[]) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int otherSizeValue_ = RubyTypesGen.asImplicitInteger(otherSizeValue, this.otherSizeImplicitType);
                Object[] otherValue_ = (Object[])otherValue;
                if (ArrayGuards.isLongArray(arrayValue_)) {
                    return this.root.appendManyGeneralizeLongDouble(arrayValue_, otherSizeValue_, otherValue_);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(ArrayAppendManyNodeGen root, Object otherSizeValue) {
            return new AppendManyGeneralizeLongDouble1Node_(root, otherSizeValue);
        }
    }

    @GeneratedBy(methodName="appendManyGeneralizeLongDouble(DynamicObject, int, double[])", value=ArrayAppendManyNode.class)
    private static final class AppendManyGeneralizeLongDouble0Node_
    extends BaseNode_ {
        private final Class<?> otherSizeImplicitType;

        AppendManyGeneralizeLongDouble0Node_(ArrayAppendManyNodeGen root, Object otherSizeValue) {
            super(root, 15);
            this.otherSizeImplicitType = RubyTypesGen.getImplicitIntegerClass(otherSizeValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.otherSizeImplicitType == ((AppendManyGeneralizeLongDouble0Node_)other).otherSizeImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            double[] otherValue_;
            int otherSizeValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherSizeValue = this.executeOtherSize_((Frame)frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), otherSizeValue, otherValue);
            }
            try {
                if (this.otherSizeImplicitType == Integer.TYPE) {
                    otherSizeValue_ = this.root.otherSize_.executeInteger(frameValue);
                } else {
                    Object otherSizeValue__ = this.executeOtherSize_((Frame)frameValue);
                    otherSizeValue_ = RubyTypesGen.expectImplicitInteger(otherSizeValue__, this.otherSizeImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult(), otherValue);
            }
            try {
                otherValue_ = ArrayAppendManyNodeGen.expectDoubleArray(this.root.other_.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, otherSizeValue_, ex.getResult());
            }
            if (ArrayGuards.isLongArray(arrayValue_)) {
                return this.root.appendManyGeneralizeLongDouble(arrayValue_, otherSizeValue_, otherValue_);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, otherSizeValue_, otherValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, int otherSizeValue, Object otherValue) {
            if (otherValue instanceof double[]) {
                double[] otherValue_ = (double[])otherValue;
                if (ArrayGuards.isLongArray(arrayValue)) {
                    return this.root.appendManyGeneralizeLongDouble(arrayValue, otherSizeValue, otherValue_);
                }
            }
            return this.getNext().executeDynamicObject1(arrayValue, otherSizeValue, otherValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(otherSizeValue, this.otherSizeImplicitType) && otherValue instanceof double[]) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int otherSizeValue_ = RubyTypesGen.asImplicitInteger(otherSizeValue, this.otherSizeImplicitType);
                double[] otherValue_ = (double[])otherValue;
                if (ArrayGuards.isLongArray(arrayValue_)) {
                    return this.root.appendManyGeneralizeLongDouble(arrayValue_, otherSizeValue_, otherValue_);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(ArrayAppendManyNodeGen root, Object otherSizeValue) {
            return new AppendManyGeneralizeLongDouble0Node_(root, otherSizeValue);
        }
    }

    @GeneratedBy(methodName="appendManyGeneralizeIntegerDouble(DynamicObject, int, Object[])", value=ArrayAppendManyNode.class)
    private static final class AppendManyGeneralizeIntegerDouble1Node_
    extends BaseNode_ {
        private final Class<?> otherSizeImplicitType;

        AppendManyGeneralizeIntegerDouble1Node_(ArrayAppendManyNodeGen root, Object otherSizeValue) {
            super(root, 14);
            this.otherSizeImplicitType = RubyTypesGen.getImplicitIntegerClass(otherSizeValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.otherSizeImplicitType == ((AppendManyGeneralizeIntegerDouble1Node_)other).otherSizeImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            Object[] otherValue_;
            int otherSizeValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherSizeValue = this.executeOtherSize_((Frame)frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), otherSizeValue, otherValue);
            }
            try {
                if (this.otherSizeImplicitType == Integer.TYPE) {
                    otherSizeValue_ = this.root.otherSize_.executeInteger(frameValue);
                } else {
                    Object otherSizeValue__ = this.executeOtherSize_((Frame)frameValue);
                    otherSizeValue_ = RubyTypesGen.expectImplicitInteger(otherSizeValue__, this.otherSizeImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult(), otherValue);
            }
            try {
                otherValue_ = this.root.other_.executeObjectArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, otherSizeValue_, ex.getResult());
            }
            if (ArrayGuards.isIntArray(arrayValue_)) {
                return this.root.appendManyGeneralizeIntegerDouble(arrayValue_, otherSizeValue_, otherValue_);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, otherSizeValue_, otherValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, int otherSizeValue, Object otherValue) {
            if (otherValue instanceof Object[]) {
                Object[] otherValue_ = (Object[])otherValue;
                if (ArrayGuards.isIntArray(arrayValue)) {
                    return this.root.appendManyGeneralizeIntegerDouble(arrayValue, otherSizeValue, otherValue_);
                }
            }
            return this.getNext().executeDynamicObject1(arrayValue, otherSizeValue, otherValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(otherSizeValue, this.otherSizeImplicitType) && otherValue instanceof Object[]) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int otherSizeValue_ = RubyTypesGen.asImplicitInteger(otherSizeValue, this.otherSizeImplicitType);
                Object[] otherValue_ = (Object[])otherValue;
                if (ArrayGuards.isIntArray(arrayValue_)) {
                    return this.root.appendManyGeneralizeIntegerDouble(arrayValue_, otherSizeValue_, otherValue_);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(ArrayAppendManyNodeGen root, Object otherSizeValue) {
            return new AppendManyGeneralizeIntegerDouble1Node_(root, otherSizeValue);
        }
    }

    @GeneratedBy(methodName="appendManyGeneralizeIntegerDouble(DynamicObject, int, double[])", value=ArrayAppendManyNode.class)
    private static final class AppendManyGeneralizeIntegerDouble0Node_
    extends BaseNode_ {
        private final Class<?> otherSizeImplicitType;

        AppendManyGeneralizeIntegerDouble0Node_(ArrayAppendManyNodeGen root, Object otherSizeValue) {
            super(root, 13);
            this.otherSizeImplicitType = RubyTypesGen.getImplicitIntegerClass(otherSizeValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.otherSizeImplicitType == ((AppendManyGeneralizeIntegerDouble0Node_)other).otherSizeImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            double[] otherValue_;
            int otherSizeValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherSizeValue = this.executeOtherSize_((Frame)frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), otherSizeValue, otherValue);
            }
            try {
                if (this.otherSizeImplicitType == Integer.TYPE) {
                    otherSizeValue_ = this.root.otherSize_.executeInteger(frameValue);
                } else {
                    Object otherSizeValue__ = this.executeOtherSize_((Frame)frameValue);
                    otherSizeValue_ = RubyTypesGen.expectImplicitInteger(otherSizeValue__, this.otherSizeImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult(), otherValue);
            }
            try {
                otherValue_ = ArrayAppendManyNodeGen.expectDoubleArray(this.root.other_.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, otherSizeValue_, ex.getResult());
            }
            if (ArrayGuards.isIntArray(arrayValue_)) {
                return this.root.appendManyGeneralizeIntegerDouble(arrayValue_, otherSizeValue_, otherValue_);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, otherSizeValue_, otherValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, int otherSizeValue, Object otherValue) {
            if (otherValue instanceof double[]) {
                double[] otherValue_ = (double[])otherValue;
                if (ArrayGuards.isIntArray(arrayValue)) {
                    return this.root.appendManyGeneralizeIntegerDouble(arrayValue, otherSizeValue, otherValue_);
                }
            }
            return this.getNext().executeDynamicObject1(arrayValue, otherSizeValue, otherValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(otherSizeValue, this.otherSizeImplicitType) && otherValue instanceof double[]) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int otherSizeValue_ = RubyTypesGen.asImplicitInteger(otherSizeValue, this.otherSizeImplicitType);
                double[] otherValue_ = (double[])otherValue;
                if (ArrayGuards.isIntArray(arrayValue_)) {
                    return this.root.appendManyGeneralizeIntegerDouble(arrayValue_, otherSizeValue_, otherValue_);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(ArrayAppendManyNodeGen root, Object otherSizeValue) {
            return new AppendManyGeneralizeIntegerDouble0Node_(root, otherSizeValue);
        }
    }

    @GeneratedBy(methodName="appendManyLongIntoInteger(DynamicObject, int, long[])", value=ArrayAppendManyNode.class)
    private static final class AppendManyLongIntoIntegerNode_
    extends BaseNode_ {
        private final Class<?> otherSizeImplicitType;

        AppendManyLongIntoIntegerNode_(ArrayAppendManyNodeGen root, Object otherSizeValue) {
            super(root, 12);
            this.otherSizeImplicitType = RubyTypesGen.getImplicitIntegerClass(otherSizeValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.otherSizeImplicitType == ((AppendManyLongIntoIntegerNode_)other).otherSizeImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            long[] otherValue_;
            int otherSizeValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherSizeValue = this.executeOtherSize_((Frame)frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), otherSizeValue, otherValue);
            }
            try {
                if (this.otherSizeImplicitType == Integer.TYPE) {
                    otherSizeValue_ = this.root.otherSize_.executeInteger(frameValue);
                } else {
                    Object otherSizeValue__ = this.executeOtherSize_((Frame)frameValue);
                    otherSizeValue_ = RubyTypesGen.expectImplicitInteger(otherSizeValue__, this.otherSizeImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult(), otherValue);
            }
            try {
                otherValue_ = ArrayAppendManyNodeGen.expectLongArray(this.root.other_.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, otherSizeValue_, ex.getResult());
            }
            if (ArrayGuards.isIntArray(arrayValue_)) {
                return this.root.appendManyLongIntoInteger(arrayValue_, otherSizeValue_, otherValue_);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, otherSizeValue_, otherValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, int otherSizeValue, Object otherValue) {
            if (otherValue instanceof long[]) {
                long[] otherValue_ = (long[])otherValue;
                if (ArrayGuards.isIntArray(arrayValue)) {
                    return this.root.appendManyLongIntoInteger(arrayValue, otherSizeValue, otherValue_);
                }
            }
            return this.getNext().executeDynamicObject1(arrayValue, otherSizeValue, otherValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(otherSizeValue, this.otherSizeImplicitType) && otherValue instanceof long[]) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int otherSizeValue_ = RubyTypesGen.asImplicitInteger(otherSizeValue, this.otherSizeImplicitType);
                long[] otherValue_ = (long[])otherValue;
                if (ArrayGuards.isIntArray(arrayValue_)) {
                    return this.root.appendManyLongIntoInteger(arrayValue_, otherSizeValue_, otherValue_);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(ArrayAppendManyNodeGen root, Object otherSizeValue) {
            return new AppendManyLongIntoIntegerNode_(root, otherSizeValue);
        }
    }

    @GeneratedBy(methodName="appendManyBoxIntoObject(DynamicObject, int, double[], ConditionProfile)", value=ArrayAppendManyNode.class)
    private static final class AppendManyBoxIntoObject2Node_
    extends BaseNode_ {
        private final ConditionProfile extendProfile;
        private final Class<?> otherSizeImplicitType;

        AppendManyBoxIntoObject2Node_(ArrayAppendManyNodeGen root, Object otherSizeValue, ConditionProfile extendProfile) {
            super(root, 11);
            this.otherSizeImplicitType = RubyTypesGen.getImplicitIntegerClass(otherSizeValue);
            this.extendProfile = extendProfile;
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.otherSizeImplicitType == ((AppendManyBoxIntoObject2Node_)other).otherSizeImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            double[] otherValue_;
            int otherSizeValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherSizeValue = this.executeOtherSize_((Frame)frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), otherSizeValue, otherValue);
            }
            try {
                if (this.otherSizeImplicitType == Integer.TYPE) {
                    otherSizeValue_ = this.root.otherSize_.executeInteger(frameValue);
                } else {
                    Object otherSizeValue__ = this.executeOtherSize_((Frame)frameValue);
                    otherSizeValue_ = RubyTypesGen.expectImplicitInteger(otherSizeValue__, this.otherSizeImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult(), otherValue);
            }
            try {
                otherValue_ = ArrayAppendManyNodeGen.expectDoubleArray(this.root.other_.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, otherSizeValue_, ex.getResult());
            }
            if (ArrayGuards.isObjectArray(arrayValue_)) {
                return this.root.appendManyBoxIntoObject(arrayValue_, otherSizeValue_, otherValue_, this.extendProfile);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, otherSizeValue_, otherValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, int otherSizeValue, Object otherValue) {
            if (otherValue instanceof double[]) {
                double[] otherValue_ = (double[])otherValue;
                if (ArrayGuards.isObjectArray(arrayValue)) {
                    return this.root.appendManyBoxIntoObject(arrayValue, otherSizeValue, otherValue_, this.extendProfile);
                }
            }
            return this.getNext().executeDynamicObject1(arrayValue, otherSizeValue, otherValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(otherSizeValue, this.otherSizeImplicitType) && otherValue instanceof double[]) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int otherSizeValue_ = RubyTypesGen.asImplicitInteger(otherSizeValue, this.otherSizeImplicitType);
                double[] otherValue_ = (double[])otherValue;
                if (ArrayGuards.isObjectArray(arrayValue_)) {
                    return this.root.appendManyBoxIntoObject(arrayValue_, otherSizeValue_, otherValue_, this.extendProfile);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(ArrayAppendManyNodeGen root, Object otherSizeValue, ConditionProfile extendProfile) {
            return new AppendManyBoxIntoObject2Node_(root, otherSizeValue, extendProfile);
        }
    }

    @GeneratedBy(methodName="appendManyBoxIntoObject(DynamicObject, int, long[], ConditionProfile)", value=ArrayAppendManyNode.class)
    private static final class AppendManyBoxIntoObject1Node_
    extends BaseNode_ {
        private final ConditionProfile extendProfile;
        private final Class<?> otherSizeImplicitType;

        AppendManyBoxIntoObject1Node_(ArrayAppendManyNodeGen root, Object otherSizeValue, ConditionProfile extendProfile) {
            super(root, 10);
            this.otherSizeImplicitType = RubyTypesGen.getImplicitIntegerClass(otherSizeValue);
            this.extendProfile = extendProfile;
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.otherSizeImplicitType == ((AppendManyBoxIntoObject1Node_)other).otherSizeImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            long[] otherValue_;
            int otherSizeValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherSizeValue = this.executeOtherSize_((Frame)frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), otherSizeValue, otherValue);
            }
            try {
                if (this.otherSizeImplicitType == Integer.TYPE) {
                    otherSizeValue_ = this.root.otherSize_.executeInteger(frameValue);
                } else {
                    Object otherSizeValue__ = this.executeOtherSize_((Frame)frameValue);
                    otherSizeValue_ = RubyTypesGen.expectImplicitInteger(otherSizeValue__, this.otherSizeImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult(), otherValue);
            }
            try {
                otherValue_ = ArrayAppendManyNodeGen.expectLongArray(this.root.other_.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, otherSizeValue_, ex.getResult());
            }
            if (ArrayGuards.isObjectArray(arrayValue_)) {
                return this.root.appendManyBoxIntoObject(arrayValue_, otherSizeValue_, otherValue_, this.extendProfile);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, otherSizeValue_, otherValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, int otherSizeValue, Object otherValue) {
            if (otherValue instanceof long[]) {
                long[] otherValue_ = (long[])otherValue;
                if (ArrayGuards.isObjectArray(arrayValue)) {
                    return this.root.appendManyBoxIntoObject(arrayValue, otherSizeValue, otherValue_, this.extendProfile);
                }
            }
            return this.getNext().executeDynamicObject1(arrayValue, otherSizeValue, otherValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(otherSizeValue, this.otherSizeImplicitType) && otherValue instanceof long[]) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int otherSizeValue_ = RubyTypesGen.asImplicitInteger(otherSizeValue, this.otherSizeImplicitType);
                long[] otherValue_ = (long[])otherValue;
                if (ArrayGuards.isObjectArray(arrayValue_)) {
                    return this.root.appendManyBoxIntoObject(arrayValue_, otherSizeValue_, otherValue_, this.extendProfile);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(ArrayAppendManyNodeGen root, Object otherSizeValue, ConditionProfile extendProfile) {
            return new AppendManyBoxIntoObject1Node_(root, otherSizeValue, extendProfile);
        }
    }

    @GeneratedBy(methodName="appendManyBoxIntoObject(DynamicObject, int, int[], ConditionProfile)", value=ArrayAppendManyNode.class)
    private static final class AppendManyBoxIntoObject0Node_
    extends BaseNode_ {
        private final ConditionProfile extendProfile;
        private final Class<?> otherSizeImplicitType;

        AppendManyBoxIntoObject0Node_(ArrayAppendManyNodeGen root, Object otherSizeValue, ConditionProfile extendProfile) {
            super(root, 9);
            this.otherSizeImplicitType = RubyTypesGen.getImplicitIntegerClass(otherSizeValue);
            this.extendProfile = extendProfile;
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.otherSizeImplicitType == ((AppendManyBoxIntoObject0Node_)other).otherSizeImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            int[] otherValue_;
            int otherSizeValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherSizeValue = this.executeOtherSize_((Frame)frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), otherSizeValue, otherValue);
            }
            try {
                if (this.otherSizeImplicitType == Integer.TYPE) {
                    otherSizeValue_ = this.root.otherSize_.executeInteger(frameValue);
                } else {
                    Object otherSizeValue__ = this.executeOtherSize_((Frame)frameValue);
                    otherSizeValue_ = RubyTypesGen.expectImplicitInteger(otherSizeValue__, this.otherSizeImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult(), otherValue);
            }
            try {
                otherValue_ = ArrayAppendManyNodeGen.expectIntArray(this.root.other_.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, otherSizeValue_, ex.getResult());
            }
            if (ArrayGuards.isObjectArray(arrayValue_)) {
                return this.root.appendManyBoxIntoObject(arrayValue_, otherSizeValue_, otherValue_, this.extendProfile);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, otherSizeValue_, otherValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, int otherSizeValue, Object otherValue) {
            if (otherValue instanceof int[]) {
                int[] otherValue_ = (int[])otherValue;
                if (ArrayGuards.isObjectArray(arrayValue)) {
                    return this.root.appendManyBoxIntoObject(arrayValue, otherSizeValue, otherValue_, this.extendProfile);
                }
            }
            return this.getNext().executeDynamicObject1(arrayValue, otherSizeValue, otherValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(otherSizeValue, this.otherSizeImplicitType) && otherValue instanceof int[]) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int otherSizeValue_ = RubyTypesGen.asImplicitInteger(otherSizeValue, this.otherSizeImplicitType);
                int[] otherValue_ = (int[])otherValue;
                if (ArrayGuards.isObjectArray(arrayValue_)) {
                    return this.root.appendManyBoxIntoObject(arrayValue_, otherSizeValue_, otherValue_, this.extendProfile);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(ArrayAppendManyNodeGen root, Object otherSizeValue, ConditionProfile extendProfile) {
            return new AppendManyBoxIntoObject0Node_(root, otherSizeValue, extendProfile);
        }
    }

    @GeneratedBy(methodName="appendManySameType(DynamicObject, int, Object[], ConditionProfile)", value=ArrayAppendManyNode.class)
    private static final class AppendManySameType3Node_
    extends BaseNode_ {
        private final ConditionProfile extendProfile;
        private final Class<?> otherSizeImplicitType;

        AppendManySameType3Node_(ArrayAppendManyNodeGen root, Object otherSizeValue, ConditionProfile extendProfile) {
            super(root, 8);
            this.otherSizeImplicitType = RubyTypesGen.getImplicitIntegerClass(otherSizeValue);
            this.extendProfile = extendProfile;
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.otherSizeImplicitType == ((AppendManySameType3Node_)other).otherSizeImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            Object[] otherValue_;
            int otherSizeValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherSizeValue = this.executeOtherSize_((Frame)frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), otherSizeValue, otherValue);
            }
            try {
                if (this.otherSizeImplicitType == Integer.TYPE) {
                    otherSizeValue_ = this.root.otherSize_.executeInteger(frameValue);
                } else {
                    Object otherSizeValue__ = this.executeOtherSize_((Frame)frameValue);
                    otherSizeValue_ = RubyTypesGen.expectImplicitInteger(otherSizeValue__, this.otherSizeImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult(), otherValue);
            }
            try {
                otherValue_ = this.root.other_.executeObjectArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, otherSizeValue_, ex.getResult());
            }
            if (ArrayGuards.isObjectArray(arrayValue_)) {
                return this.root.appendManySameType(arrayValue_, otherSizeValue_, otherValue_, this.extendProfile);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, otherSizeValue_, otherValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, int otherSizeValue, Object otherValue) {
            if (otherValue instanceof Object[]) {
                Object[] otherValue_ = (Object[])otherValue;
                if (ArrayGuards.isObjectArray(arrayValue)) {
                    return this.root.appendManySameType(arrayValue, otherSizeValue, otherValue_, this.extendProfile);
                }
            }
            return this.getNext().executeDynamicObject1(arrayValue, otherSizeValue, otherValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(otherSizeValue, this.otherSizeImplicitType) && otherValue instanceof Object[]) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int otherSizeValue_ = RubyTypesGen.asImplicitInteger(otherSizeValue, this.otherSizeImplicitType);
                Object[] otherValue_ = (Object[])otherValue;
                if (ArrayGuards.isObjectArray(arrayValue_)) {
                    return this.root.appendManySameType(arrayValue_, otherSizeValue_, otherValue_, this.extendProfile);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(ArrayAppendManyNodeGen root, Object otherSizeValue, ConditionProfile extendProfile) {
            return new AppendManySameType3Node_(root, otherSizeValue, extendProfile);
        }
    }

    @GeneratedBy(methodName="appendManySameType(DynamicObject, int, double[], ConditionProfile)", value=ArrayAppendManyNode.class)
    private static final class AppendManySameType2Node_
    extends BaseNode_ {
        private final ConditionProfile extendProfile;
        private final Class<?> otherSizeImplicitType;

        AppendManySameType2Node_(ArrayAppendManyNodeGen root, Object otherSizeValue, ConditionProfile extendProfile) {
            super(root, 7);
            this.otherSizeImplicitType = RubyTypesGen.getImplicitIntegerClass(otherSizeValue);
            this.extendProfile = extendProfile;
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.otherSizeImplicitType == ((AppendManySameType2Node_)other).otherSizeImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            double[] otherValue_;
            int otherSizeValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherSizeValue = this.executeOtherSize_((Frame)frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), otherSizeValue, otherValue);
            }
            try {
                if (this.otherSizeImplicitType == Integer.TYPE) {
                    otherSizeValue_ = this.root.otherSize_.executeInteger(frameValue);
                } else {
                    Object otherSizeValue__ = this.executeOtherSize_((Frame)frameValue);
                    otherSizeValue_ = RubyTypesGen.expectImplicitInteger(otherSizeValue__, this.otherSizeImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult(), otherValue);
            }
            try {
                otherValue_ = ArrayAppendManyNodeGen.expectDoubleArray(this.root.other_.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, otherSizeValue_, ex.getResult());
            }
            if (ArrayGuards.isDoubleArray(arrayValue_)) {
                return this.root.appendManySameType(arrayValue_, otherSizeValue_, otherValue_, this.extendProfile);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, otherSizeValue_, otherValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, int otherSizeValue, Object otherValue) {
            if (otherValue instanceof double[]) {
                double[] otherValue_ = (double[])otherValue;
                if (ArrayGuards.isDoubleArray(arrayValue)) {
                    return this.root.appendManySameType(arrayValue, otherSizeValue, otherValue_, this.extendProfile);
                }
            }
            return this.getNext().executeDynamicObject1(arrayValue, otherSizeValue, otherValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(otherSizeValue, this.otherSizeImplicitType) && otherValue instanceof double[]) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int otherSizeValue_ = RubyTypesGen.asImplicitInteger(otherSizeValue, this.otherSizeImplicitType);
                double[] otherValue_ = (double[])otherValue;
                if (ArrayGuards.isDoubleArray(arrayValue_)) {
                    return this.root.appendManySameType(arrayValue_, otherSizeValue_, otherValue_, this.extendProfile);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(ArrayAppendManyNodeGen root, Object otherSizeValue, ConditionProfile extendProfile) {
            return new AppendManySameType2Node_(root, otherSizeValue, extendProfile);
        }
    }

    @GeneratedBy(methodName="appendManySameType(DynamicObject, int, long[], ConditionProfile)", value=ArrayAppendManyNode.class)
    private static final class AppendManySameType1Node_
    extends BaseNode_ {
        private final ConditionProfile extendProfile;
        private final Class<?> otherSizeImplicitType;

        AppendManySameType1Node_(ArrayAppendManyNodeGen root, Object otherSizeValue, ConditionProfile extendProfile) {
            super(root, 6);
            this.otherSizeImplicitType = RubyTypesGen.getImplicitIntegerClass(otherSizeValue);
            this.extendProfile = extendProfile;
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.otherSizeImplicitType == ((AppendManySameType1Node_)other).otherSizeImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            long[] otherValue_;
            int otherSizeValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherSizeValue = this.executeOtherSize_((Frame)frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), otherSizeValue, otherValue);
            }
            try {
                if (this.otherSizeImplicitType == Integer.TYPE) {
                    otherSizeValue_ = this.root.otherSize_.executeInteger(frameValue);
                } else {
                    Object otherSizeValue__ = this.executeOtherSize_((Frame)frameValue);
                    otherSizeValue_ = RubyTypesGen.expectImplicitInteger(otherSizeValue__, this.otherSizeImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult(), otherValue);
            }
            try {
                otherValue_ = ArrayAppendManyNodeGen.expectLongArray(this.root.other_.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, otherSizeValue_, ex.getResult());
            }
            if (ArrayGuards.isLongArray(arrayValue_)) {
                return this.root.appendManySameType(arrayValue_, otherSizeValue_, otherValue_, this.extendProfile);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, otherSizeValue_, otherValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, int otherSizeValue, Object otherValue) {
            if (otherValue instanceof long[]) {
                long[] otherValue_ = (long[])otherValue;
                if (ArrayGuards.isLongArray(arrayValue)) {
                    return this.root.appendManySameType(arrayValue, otherSizeValue, otherValue_, this.extendProfile);
                }
            }
            return this.getNext().executeDynamicObject1(arrayValue, otherSizeValue, otherValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(otherSizeValue, this.otherSizeImplicitType) && otherValue instanceof long[]) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int otherSizeValue_ = RubyTypesGen.asImplicitInteger(otherSizeValue, this.otherSizeImplicitType);
                long[] otherValue_ = (long[])otherValue;
                if (ArrayGuards.isLongArray(arrayValue_)) {
                    return this.root.appendManySameType(arrayValue_, otherSizeValue_, otherValue_, this.extendProfile);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(ArrayAppendManyNodeGen root, Object otherSizeValue, ConditionProfile extendProfile) {
            return new AppendManySameType1Node_(root, otherSizeValue, extendProfile);
        }
    }

    @GeneratedBy(methodName="appendManySameType(DynamicObject, int, int[], ConditionProfile)", value=ArrayAppendManyNode.class)
    private static final class AppendManySameType0Node_
    extends BaseNode_ {
        private final ConditionProfile extendProfile;
        private final Class<?> otherSizeImplicitType;

        AppendManySameType0Node_(ArrayAppendManyNodeGen root, Object otherSizeValue, ConditionProfile extendProfile) {
            super(root, 5);
            this.otherSizeImplicitType = RubyTypesGen.getImplicitIntegerClass(otherSizeValue);
            this.extendProfile = extendProfile;
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.otherSizeImplicitType == ((AppendManySameType0Node_)other).otherSizeImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            int[] otherValue_;
            int otherSizeValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherSizeValue = this.executeOtherSize_((Frame)frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), otherSizeValue, otherValue);
            }
            try {
                if (this.otherSizeImplicitType == Integer.TYPE) {
                    otherSizeValue_ = this.root.otherSize_.executeInteger(frameValue);
                } else {
                    Object otherSizeValue__ = this.executeOtherSize_((Frame)frameValue);
                    otherSizeValue_ = RubyTypesGen.expectImplicitInteger(otherSizeValue__, this.otherSizeImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult(), otherValue);
            }
            try {
                otherValue_ = ArrayAppendManyNodeGen.expectIntArray(this.root.other_.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, otherSizeValue_, ex.getResult());
            }
            if (ArrayGuards.isIntArray(arrayValue_)) {
                return this.root.appendManySameType(arrayValue_, otherSizeValue_, otherValue_, this.extendProfile);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, otherSizeValue_, otherValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, int otherSizeValue, Object otherValue) {
            if (otherValue instanceof int[]) {
                int[] otherValue_ = (int[])otherValue;
                if (ArrayGuards.isIntArray(arrayValue)) {
                    return this.root.appendManySameType(arrayValue, otherSizeValue, otherValue_, this.extendProfile);
                }
            }
            return this.getNext().executeDynamicObject1(arrayValue, otherSizeValue, otherValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(otherSizeValue, this.otherSizeImplicitType) && otherValue instanceof int[]) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int otherSizeValue_ = RubyTypesGen.asImplicitInteger(otherSizeValue, this.otherSizeImplicitType);
                int[] otherValue_ = (int[])otherValue;
                if (ArrayGuards.isIntArray(arrayValue_)) {
                    return this.root.appendManySameType(arrayValue_, otherSizeValue_, otherValue_, this.extendProfile);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(ArrayAppendManyNodeGen root, Object otherSizeValue, ConditionProfile extendProfile) {
            return new AppendManySameType0Node_(root, otherSizeValue, extendProfile);
        }
    }

    @GeneratedBy(methodName="appendManyEmpty(DynamicObject, int, Object[])", value=ArrayAppendManyNode.class)
    private static final class AppendManyEmpty3Node_
    extends BaseNode_ {
        private final Class<?> otherSizeImplicitType;

        AppendManyEmpty3Node_(ArrayAppendManyNodeGen root, Object otherSizeValue) {
            super(root, 4);
            this.otherSizeImplicitType = RubyTypesGen.getImplicitIntegerClass(otherSizeValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.otherSizeImplicitType == ((AppendManyEmpty3Node_)other).otherSizeImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            Object[] otherValue_;
            int otherSizeValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherSizeValue = this.executeOtherSize_((Frame)frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), otherSizeValue, otherValue);
            }
            try {
                if (this.otherSizeImplicitType == Integer.TYPE) {
                    otherSizeValue_ = this.root.otherSize_.executeInteger(frameValue);
                } else {
                    Object otherSizeValue__ = this.executeOtherSize_((Frame)frameValue);
                    otherSizeValue_ = RubyTypesGen.expectImplicitInteger(otherSizeValue__, this.otherSizeImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult(), otherValue);
            }
            try {
                otherValue_ = this.root.other_.executeObjectArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, otherSizeValue_, ex.getResult());
            }
            if (ArrayGuards.isEmptyArray(arrayValue_)) {
                return this.root.appendManyEmpty(arrayValue_, otherSizeValue_, otherValue_);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, otherSizeValue_, otherValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, int otherSizeValue, Object otherValue) {
            if (otherValue instanceof Object[]) {
                Object[] otherValue_ = (Object[])otherValue;
                if (ArrayGuards.isEmptyArray(arrayValue)) {
                    return this.root.appendManyEmpty(arrayValue, otherSizeValue, otherValue_);
                }
            }
            return this.getNext().executeDynamicObject1(arrayValue, otherSizeValue, otherValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(otherSizeValue, this.otherSizeImplicitType) && otherValue instanceof Object[]) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int otherSizeValue_ = RubyTypesGen.asImplicitInteger(otherSizeValue, this.otherSizeImplicitType);
                Object[] otherValue_ = (Object[])otherValue;
                if (ArrayGuards.isEmptyArray(arrayValue_)) {
                    return this.root.appendManyEmpty(arrayValue_, otherSizeValue_, otherValue_);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(ArrayAppendManyNodeGen root, Object otherSizeValue) {
            return new AppendManyEmpty3Node_(root, otherSizeValue);
        }
    }

    @GeneratedBy(methodName="appendManyEmpty(DynamicObject, int, double[])", value=ArrayAppendManyNode.class)
    private static final class AppendManyEmpty2Node_
    extends BaseNode_ {
        private final Class<?> otherSizeImplicitType;

        AppendManyEmpty2Node_(ArrayAppendManyNodeGen root, Object otherSizeValue) {
            super(root, 3);
            this.otherSizeImplicitType = RubyTypesGen.getImplicitIntegerClass(otherSizeValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.otherSizeImplicitType == ((AppendManyEmpty2Node_)other).otherSizeImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            double[] otherValue_;
            int otherSizeValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherSizeValue = this.executeOtherSize_((Frame)frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), otherSizeValue, otherValue);
            }
            try {
                if (this.otherSizeImplicitType == Integer.TYPE) {
                    otherSizeValue_ = this.root.otherSize_.executeInteger(frameValue);
                } else {
                    Object otherSizeValue__ = this.executeOtherSize_((Frame)frameValue);
                    otherSizeValue_ = RubyTypesGen.expectImplicitInteger(otherSizeValue__, this.otherSizeImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult(), otherValue);
            }
            try {
                otherValue_ = ArrayAppendManyNodeGen.expectDoubleArray(this.root.other_.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, otherSizeValue_, ex.getResult());
            }
            if (ArrayGuards.isEmptyArray(arrayValue_)) {
                return this.root.appendManyEmpty(arrayValue_, otherSizeValue_, otherValue_);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, otherSizeValue_, otherValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, int otherSizeValue, Object otherValue) {
            if (otherValue instanceof double[]) {
                double[] otherValue_ = (double[])otherValue;
                if (ArrayGuards.isEmptyArray(arrayValue)) {
                    return this.root.appendManyEmpty(arrayValue, otherSizeValue, otherValue_);
                }
            }
            return this.getNext().executeDynamicObject1(arrayValue, otherSizeValue, otherValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(otherSizeValue, this.otherSizeImplicitType) && otherValue instanceof double[]) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int otherSizeValue_ = RubyTypesGen.asImplicitInteger(otherSizeValue, this.otherSizeImplicitType);
                double[] otherValue_ = (double[])otherValue;
                if (ArrayGuards.isEmptyArray(arrayValue_)) {
                    return this.root.appendManyEmpty(arrayValue_, otherSizeValue_, otherValue_);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(ArrayAppendManyNodeGen root, Object otherSizeValue) {
            return new AppendManyEmpty2Node_(root, otherSizeValue);
        }
    }

    @GeneratedBy(methodName="appendManyEmpty(DynamicObject, int, long[])", value=ArrayAppendManyNode.class)
    private static final class AppendManyEmpty1Node_
    extends BaseNode_ {
        private final Class<?> otherSizeImplicitType;

        AppendManyEmpty1Node_(ArrayAppendManyNodeGen root, Object otherSizeValue) {
            super(root, 2);
            this.otherSizeImplicitType = RubyTypesGen.getImplicitIntegerClass(otherSizeValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.otherSizeImplicitType == ((AppendManyEmpty1Node_)other).otherSizeImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            long[] otherValue_;
            int otherSizeValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherSizeValue = this.executeOtherSize_((Frame)frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), otherSizeValue, otherValue);
            }
            try {
                if (this.otherSizeImplicitType == Integer.TYPE) {
                    otherSizeValue_ = this.root.otherSize_.executeInteger(frameValue);
                } else {
                    Object otherSizeValue__ = this.executeOtherSize_((Frame)frameValue);
                    otherSizeValue_ = RubyTypesGen.expectImplicitInteger(otherSizeValue__, this.otherSizeImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult(), otherValue);
            }
            try {
                otherValue_ = ArrayAppendManyNodeGen.expectLongArray(this.root.other_.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, otherSizeValue_, ex.getResult());
            }
            if (ArrayGuards.isEmptyArray(arrayValue_)) {
                return this.root.appendManyEmpty(arrayValue_, otherSizeValue_, otherValue_);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, otherSizeValue_, otherValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, int otherSizeValue, Object otherValue) {
            if (otherValue instanceof long[]) {
                long[] otherValue_ = (long[])otherValue;
                if (ArrayGuards.isEmptyArray(arrayValue)) {
                    return this.root.appendManyEmpty(arrayValue, otherSizeValue, otherValue_);
                }
            }
            return this.getNext().executeDynamicObject1(arrayValue, otherSizeValue, otherValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(otherSizeValue, this.otherSizeImplicitType) && otherValue instanceof long[]) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int otherSizeValue_ = RubyTypesGen.asImplicitInteger(otherSizeValue, this.otherSizeImplicitType);
                long[] otherValue_ = (long[])otherValue;
                if (ArrayGuards.isEmptyArray(arrayValue_)) {
                    return this.root.appendManyEmpty(arrayValue_, otherSizeValue_, otherValue_);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(ArrayAppendManyNodeGen root, Object otherSizeValue) {
            return new AppendManyEmpty1Node_(root, otherSizeValue);
        }
    }

    @GeneratedBy(methodName="appendManyEmpty(DynamicObject, int, int[])", value=ArrayAppendManyNode.class)
    private static final class AppendManyEmpty0Node_
    extends BaseNode_ {
        private final Class<?> otherSizeImplicitType;

        AppendManyEmpty0Node_(ArrayAppendManyNodeGen root, Object otherSizeValue) {
            super(root, 1);
            this.otherSizeImplicitType = RubyTypesGen.getImplicitIntegerClass(otherSizeValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.otherSizeImplicitType == ((AppendManyEmpty0Node_)other).otherSizeImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            int[] otherValue_;
            int otherSizeValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object otherSizeValue = this.executeOtherSize_((Frame)frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), otherSizeValue, otherValue);
            }
            try {
                if (this.otherSizeImplicitType == Integer.TYPE) {
                    otherSizeValue_ = this.root.otherSize_.executeInteger(frameValue);
                } else {
                    Object otherSizeValue__ = this.executeOtherSize_((Frame)frameValue);
                    otherSizeValue_ = RubyTypesGen.expectImplicitInteger(otherSizeValue__, this.otherSizeImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult(), otherValue);
            }
            try {
                otherValue_ = ArrayAppendManyNodeGen.expectIntArray(this.root.other_.execute(frameValue));
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, otherSizeValue_, ex.getResult());
            }
            if (ArrayGuards.isEmptyArray(arrayValue_)) {
                return this.root.appendManyEmpty(arrayValue_, otherSizeValue_, otherValue_);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, otherSizeValue_, otherValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, int otherSizeValue, Object otherValue) {
            if (otherValue instanceof int[]) {
                int[] otherValue_ = (int[])otherValue;
                if (ArrayGuards.isEmptyArray(arrayValue)) {
                    return this.root.appendManyEmpty(arrayValue, otherSizeValue, otherValue_);
                }
            }
            return this.getNext().executeDynamicObject1(arrayValue, otherSizeValue, otherValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(otherSizeValue, this.otherSizeImplicitType) && otherValue instanceof int[]) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int otherSizeValue_ = RubyTypesGen.asImplicitInteger(otherSizeValue, this.otherSizeImplicitType);
                int[] otherValue_ = (int[])otherValue;
                if (ArrayGuards.isEmptyArray(arrayValue_)) {
                    return this.root.appendManyEmpty(arrayValue_, otherSizeValue_, otherValue_);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(ArrayAppendManyNodeGen root, Object otherSizeValue) {
            return new AppendManyEmpty0Node_(root, otherSizeValue);
        }
    }

    @GeneratedBy(value=ArrayAppendManyNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(ArrayAppendManyNodeGen root) {
            super(root, 0);
        }

        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arrayValue, Object otherSizeValue, Object otherValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arrayValue, otherSizeValue, otherValue));
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            return this.getNext().executeDynamicObject_(arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(ArrayAppendManyNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=ArrayAppendManyNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(ArrayAppendManyNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object otherSizeValue, Object otherValue) {
            return (DynamicObject)this.uninitialized(null, arrayValue, otherSizeValue, otherValue);
        }

        static BaseNode_ create(ArrayAppendManyNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=ArrayAppendManyNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected ArrayAppendManyNodeGen root;

        BaseNode_(ArrayAppendManyNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        protected final void setRoot(Node root) {
            this.root = (ArrayAppendManyNodeGen)root;
        }

        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.array_, this.root.otherSize_, this.root.other_};
        }

        public final Object acceptAndExecute(Frame frameValue, Object arrayValue, Object otherSizeValue, Object otherValue) {
            return this.executeDynamicObject_(arrayValue, otherSizeValue, otherValue);
        }

        public abstract DynamicObject executeDynamicObject_(Object var1, Object var2, Object var3);

        public DynamicObject executeDynamicObject1(DynamicObject arrayValue, int otherSizeValue, Object otherValue) {
            return this.executeDynamicObject_(arrayValue, otherSizeValue, otherValue);
        }

        public Object execute(VirtualFrame frameValue) {
            Object arrayValue_ = this.root.array_.execute(frameValue);
            Object otherSizeValue_ = this.executeOtherSize_((Frame)frameValue);
            Object otherValue_ = this.root.other_.execute(frameValue);
            return this.executeDynamicObject_(arrayValue_, otherSizeValue_, otherValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            return (DynamicObject)this.execute(frameValue);
        }

        protected final SpecializationNode createNext(Frame frameValue, Object arrayValue, Object otherSizeValue, Object otherValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(otherSizeValue)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                if (otherValue instanceof int[] && ArrayGuards.isEmptyArray(arrayValue_)) {
                    return AppendManyEmpty0Node_.create(this.root, otherSizeValue);
                }
                if (otherValue instanceof long[] && ArrayGuards.isEmptyArray(arrayValue_)) {
                    return AppendManyEmpty1Node_.create(this.root, otherSizeValue);
                }
                if (otherValue instanceof double[] && ArrayGuards.isEmptyArray(arrayValue_)) {
                    return AppendManyEmpty2Node_.create(this.root, otherSizeValue);
                }
                if (otherValue instanceof Object[] && ArrayGuards.isEmptyArray(arrayValue_)) {
                    return AppendManyEmpty3Node_.create(this.root, otherSizeValue);
                }
                if (otherValue instanceof int[] && ArrayGuards.isIntArray(arrayValue_)) {
                    ConditionProfile extendProfile5 = ConditionProfile.createBinaryProfile();
                    return AppendManySameType0Node_.create(this.root, otherSizeValue, extendProfile5);
                }
                if (otherValue instanceof long[] && ArrayGuards.isLongArray(arrayValue_)) {
                    ConditionProfile extendProfile6 = ConditionProfile.createBinaryProfile();
                    return AppendManySameType1Node_.create(this.root, otherSizeValue, extendProfile6);
                }
                if (otherValue instanceof double[] && ArrayGuards.isDoubleArray(arrayValue_)) {
                    ConditionProfile extendProfile7 = ConditionProfile.createBinaryProfile();
                    return AppendManySameType2Node_.create(this.root, otherSizeValue, extendProfile7);
                }
                if (otherValue instanceof Object[] && ArrayGuards.isObjectArray(arrayValue_)) {
                    ConditionProfile extendProfile8 = ConditionProfile.createBinaryProfile();
                    return AppendManySameType3Node_.create(this.root, otherSizeValue, extendProfile8);
                }
                if (otherValue instanceof int[] && ArrayGuards.isObjectArray(arrayValue_)) {
                    ConditionProfile extendProfile9 = ConditionProfile.createBinaryProfile();
                    return AppendManyBoxIntoObject0Node_.create(this.root, otherSizeValue, extendProfile9);
                }
                if (otherValue instanceof long[] && ArrayGuards.isObjectArray(arrayValue_)) {
                    ConditionProfile extendProfile10 = ConditionProfile.createBinaryProfile();
                    return AppendManyBoxIntoObject1Node_.create(this.root, otherSizeValue, extendProfile10);
                }
                if (otherValue instanceof double[] && ArrayGuards.isObjectArray(arrayValue_)) {
                    ConditionProfile extendProfile11 = ConditionProfile.createBinaryProfile();
                    return AppendManyBoxIntoObject2Node_.create(this.root, otherSizeValue, extendProfile11);
                }
                if (otherValue instanceof long[] && ArrayGuards.isIntArray(arrayValue_)) {
                    return AppendManyLongIntoIntegerNode_.create(this.root, otherSizeValue);
                }
                if (otherValue instanceof double[] && ArrayGuards.isIntArray(arrayValue_)) {
                    return AppendManyGeneralizeIntegerDouble0Node_.create(this.root, otherSizeValue);
                }
                if (otherValue instanceof Object[] && ArrayGuards.isIntArray(arrayValue_)) {
                    return AppendManyGeneralizeIntegerDouble1Node_.create(this.root, otherSizeValue);
                }
                if (otherValue instanceof double[] && ArrayGuards.isLongArray(arrayValue_)) {
                    return AppendManyGeneralizeLongDouble0Node_.create(this.root, otherSizeValue);
                }
                if (otherValue instanceof Object[] && ArrayGuards.isLongArray(arrayValue_)) {
                    return AppendManyGeneralizeLongDouble1Node_.create(this.root, otherSizeValue);
                }
                if (otherValue instanceof int[] && ArrayGuards.isDoubleArray(arrayValue_)) {
                    return AppendManyGeneralizeDoubleIntegerNode_.create(this.root, otherSizeValue);
                }
                if (otherValue instanceof long[] && ArrayGuards.isDoubleArray(arrayValue_)) {
                    return AppendManyGeneralizeDoubleLongNode_.create(this.root, otherSizeValue);
                }
                if (otherValue instanceof Object[] && ArrayGuards.isDoubleArray(arrayValue_)) {
                    return AppendManyGeneralizeDoubleObjectNode_.create(this.root, otherSizeValue);
                }
            }
            return null;
        }

        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeOtherSize_(Frame frameValue) {
            Object object;
            Class otherSizeType_ = this.root.otherSizeType_;
            if (otherSizeType_ == Integer.TYPE) {
                return this.root.otherSize_.executeInteger((VirtualFrame)frameValue);
            }
            if (otherSizeType_ != null) return this.root.otherSize_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.otherSize_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.otherSizeType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.otherSizeType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.otherSizeType_ = _type;
            return object;
        }
    }
}

