/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import org.jcodings.Encoding;
import org.joni.Region;
import org.joni.exception.ValueException;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.TaintResultNode;
import org.jruby.truffle.nodes.coerce.ToIntNode;
import org.jruby.truffle.nodes.coerce.ToIntNodeGen;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.StringGuards;
import org.jruby.truffle.nodes.core.UnaryCoreMethodNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.ArrayOperations;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.util.ByteList;
import org.jruby.util.StringSupport;

@CoreClass(name="MatchData")
public abstract class MatchDataNodes {
    public static Object[] getCaptures(DynamicObject matchData) {
        assert (RubyGuards.isRubyMatchData(matchData));
        return ArrayUtils.extractRange(Layouts.MATCH_DATA.getValues(matchData), 1, Layouts.MATCH_DATA.getValues(matchData).length);
    }

    public static Object begin(RubyContext context, DynamicObject matchData, int index) {
        int b = Layouts.MATCH_DATA.getRegion((DynamicObject)matchData).beg[index];
        if (b < 0) {
            return context.getCoreLibrary().getNilObject();
        }
        if (!StringGuards.isSingleByteOptimizable(Layouts.MATCH_DATA.getSource(matchData))) {
            b = MatchDataNodes.getCharOffsets((DynamicObject)matchData).beg[index];
        }
        return b;
    }

    public static Object end(RubyContext context, DynamicObject matchData, int index) {
        int e = Layouts.MATCH_DATA.getRegion((DynamicObject)matchData).end[index];
        if (e < 0) {
            return context.getCoreLibrary().getNilObject();
        }
        if (!StringGuards.isSingleByteOptimizable(Layouts.MATCH_DATA.getSource(matchData))) {
            e = MatchDataNodes.getCharOffsets((DynamicObject)matchData).end[index];
        }
        return e;
    }

    private static void updatePairs(ByteList source, Encoding encoding, Pair[] pairs) {
        int p;
        Arrays.sort(pairs);
        int length = pairs.length;
        byte[] bytes = source.getUnsafeBytes();
        int s = p = source.getBegin();
        int c = 0;
        for (int i = 0; i < length; ++i) {
            int q = s + pairs[i].bytePos;
            pairs[i].charPos = c += StringSupport.strLength((Encoding)encoding, (byte[])bytes, (int)p, (int)q);
            p = q;
        }
    }

    private static Region getCharOffsetsManyRegs(DynamicObject matchData, ByteList source, Encoding encoding) {
        Region regs = Layouts.MATCH_DATA.getRegion(matchData);
        int numRegs = regs.numRegs;
        Region charOffsets = new Region(numRegs);
        if (encoding.maxLength() == 1) {
            for (int i = 0; i < numRegs; ++i) {
                charOffsets.beg[i] = regs.beg[i];
                charOffsets.end[i] = regs.end[i];
            }
            return charOffsets;
        }
        Object[] pairs = new Pair[numRegs * 2];
        for (int i = 0; i < pairs.length; ++i) {
            pairs[i] = new Pair();
        }
        int numPos = 0;
        for (int i = 0; i < numRegs; ++i) {
            if (regs.beg[i] < 0) continue;
            pairs[numPos++].bytePos = regs.beg[i];
            pairs[numPos++].bytePos = regs.end[i];
        }
        MatchDataNodes.updatePairs(source, encoding, (Pair[])pairs);
        Pair key = new Pair();
        for (int i = 0; i < regs.numRegs; ++i) {
            if (regs.beg[i] < 0) {
                charOffsets.end[i] = -1;
                charOffsets.beg[i] = -1;
                continue;
            }
            key.bytePos = regs.beg[i];
            charOffsets.beg[i] = ((Pair)pairs[Arrays.binarySearch((Object[])pairs, (Object)key)]).charPos;
            key.bytePos = regs.end[i];
            charOffsets.end[i] = ((Pair)pairs[Arrays.binarySearch((Object[])pairs, (Object)key)]).charPos;
        }
        return charOffsets;
    }

    public static Region getCharOffsets(DynamicObject matchData) {
        Region charOffsets = Layouts.MATCH_DATA.getCharOffsets(matchData);
        if (charOffsets != null) {
            return charOffsets;
        }
        return MatchDataNodes.createCharOffsets(matchData);
    }

    @CompilerDirectives.TruffleBoundary
    private static Region createCharOffsets(DynamicObject matchData) {
        ByteList source = StringOperations.getByteList(Layouts.MATCH_DATA.getSource(matchData));
        Encoding enc = source.getEncoding();
        Region charOffsets = MatchDataNodes.getCharOffsetsManyRegs(matchData, source, enc);
        Layouts.MATCH_DATA.setCharOffsets(matchData, charOffsets);
        return charOffsets;
    }

    public static final class Pair
    implements Comparable<Pair> {
        int bytePos;
        int charPos;

        @Override
        public int compareTo(Pair pair) {
            return this.bytePos - pair.bytePos;
        }
    }

    @NodeChild(value="self")
    public static abstract class RubiniusSourceNode
    extends RubyNode {
        public RubiniusSourceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject rubiniusSource(DynamicObject matchData) {
            return Layouts.MATCH_DATA.getSource(matchData);
        }
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends UnaryCoreMethodNode {
        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            throw new RaiseException(this.getContext().getCoreLibrary().typeErrorAllocatorUndefinedFor(rubyClass, this));
        }
    }

    @CoreMethod(names={"regexp"})
    public static abstract class RegexpNode
    extends CoreMethodArrayArgumentsNode {
        public RegexpNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject regexp(DynamicObject matchData) {
            return Layouts.MATCH_DATA.getRegexp(matchData);
        }
    }

    @CoreMethod(names={"to_s"})
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject toS(DynamicObject matchData) {
            ByteList bytes = StringOperations.getByteList(Layouts.MATCH_DATA.getGlobal(matchData)).dup();
            return this.createString(bytes);
        }
    }

    @CoreMethod(names={"to_a"})
    public static abstract class ToANode
    extends CoreMethodArrayArgumentsNode {
        public ToANode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject toA(DynamicObject matchData) {
            Object[] objects = ArrayUtils.copy(Layouts.MATCH_DATA.getValues(matchData));
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), objects, objects.length);
        }
    }

    @CoreMethod(names={"post_match"})
    public static abstract class PostMatchNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TaintResultNode taintResultNode = new TaintResultNode(this.getContext(), this.getSourceSection());

        public PostMatchNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object postMatch(DynamicObject matchData) {
            return this.taintResultNode.maybeTaint(Layouts.MATCH_DATA.getSource(matchData), Layouts.MATCH_DATA.getPost(matchData));
        }
    }

    @CoreMethod(names={"pre_match"})
    public static abstract class PreMatchNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TaintResultNode taintResultNode = new TaintResultNode(this.getContext(), this.getSourceSection());

        public PreMatchNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object preMatch(DynamicObject matchData) {
            return this.taintResultNode.maybeTaint(Layouts.MATCH_DATA.getSource(matchData), Layouts.MATCH_DATA.getPre(matchData));
        }
    }

    @CoreMethod(names={"length", "size"})
    public static abstract class LengthNode
    extends CoreMethodArrayArgumentsNode {
        public LengthNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int length(DynamicObject matchData) {
            return Layouts.MATCH_DATA.getValues(matchData).length;
        }
    }

    @CoreMethod(names={"full"})
    public static abstract class FullNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode newTupleNode;

        public FullNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object full(VirtualFrame frame, DynamicObject matchData) {
            if (Layouts.MATCH_DATA.getFullTuple(matchData) != null) {
                return Layouts.MATCH_DATA.getFullTuple(matchData);
            }
            if (this.newTupleNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.newTupleNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            Object fullTuple = this.newTupleNode.call(frame, this.getContext().getCoreLibrary().getTupleClass(), "create", null, Layouts.MATCH_DATA.getBegin(matchData), Layouts.MATCH_DATA.getEnd(matchData));
            Layouts.MATCH_DATA.setFullTuple(matchData, fullTuple);
            return fullTuple;
        }
    }

    @CoreMethod(names={"end"}, required=1, lowerFixnumParameters={1})
    public static abstract class EndNode
    extends CoreMethodArrayArgumentsNode {
        public EndNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"inBounds(matchData, index)"})
        public Object end(DynamicObject matchData, int index) {
            return MatchDataNodes.end(this.getContext(), matchData, index);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!inBounds(matchData, index)"})
        public Object endError(DynamicObject matchData, int index) {
            throw new RaiseException(this.getContext().getCoreLibrary().indexError(String.format("index %d out of matches", index), this));
        }

        protected boolean inBounds(DynamicObject matchData, int index) {
            return index >= 0 && index < Layouts.MATCH_DATA.getRegion((DynamicObject)matchData).numRegs;
        }
    }

    @CoreMethod(names={"captures"})
    public static abstract class CapturesNode
    extends CoreMethodArrayArgumentsNode {
        public CapturesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject toA(DynamicObject matchData) {
            Object[] objects = MatchDataNodes.getCaptures(matchData);
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), objects, objects.length);
        }
    }

    @CoreMethod(names={"begin"}, required=1, lowerFixnumParameters={1})
    public static abstract class BeginNode
    extends CoreMethodArrayArgumentsNode {
        public BeginNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"inBounds(matchData, index)"})
        public Object begin(DynamicObject matchData, int index) {
            return MatchDataNodes.begin(this.getContext(), matchData, index);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!inBounds(matchData, index)"})
        public Object beginError(DynamicObject matchData, int index) {
            throw new RaiseException(this.getContext().getCoreLibrary().indexError(String.format("index %d out of matches", index), this));
        }

        protected boolean inBounds(DynamicObject matchData, int index) {
            return index >= 0 && index < Layouts.MATCH_DATA.getRegion((DynamicObject)matchData).numRegs;
        }
    }

    @CoreMethod(names={"[]"}, required=1, optional=1, lowerFixnumParameters={0}, taintFromSelf=true)
    public static abstract class GetIndexNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ToIntNode toIntNode;

        public GetIndexNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object getIndex(DynamicObject matchData, int index, NotProvided length) {
            Object[] values = Layouts.MATCH_DATA.getValues(matchData);
            int normalizedIndex = ArrayOperations.normalizeIndex(values.length, index);
            if (normalizedIndex < 0 || normalizedIndex >= values.length) {
                return this.nil();
            }
            return values[normalizedIndex];
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object getIndex(DynamicObject matchData, int index, int length) {
            Object[] values = Layouts.MATCH_DATA.getValues(matchData);
            int normalizedIndex = ArrayOperations.normalizeIndex(values.length, index);
            Object[] store = Arrays.copyOfRange(values, normalizedIndex, normalizedIndex + length);
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), store, length);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubySymbol(index)"})
        public Object getIndexSymbol(DynamicObject matchData, DynamicObject index, NotProvided length) {
            try {
                ByteList value = Layouts.SYMBOL.getByteList(index);
                int i = Layouts.REGEXP.getRegex(Layouts.MATCH_DATA.getRegexp(matchData)).nameToBackrefNumber(value.getUnsafeBytes(), value.getBegin(), value.getBegin() + value.getRealSize(), Layouts.MATCH_DATA.getRegion(matchData));
                return this.getIndex(matchData, i, NotProvided.INSTANCE);
            }
            catch (ValueException e) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().indexError(String.format("undefined group name reference: %s", Layouts.SYMBOL.getString(index)), this));
            }
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(index)"})
        public Object getIndexString(DynamicObject matchData, DynamicObject index, NotProvided length) {
            try {
                ByteList value = StringOperations.getByteList(index);
                int i = Layouts.REGEXP.getRegex(Layouts.MATCH_DATA.getRegexp(matchData)).nameToBackrefNumber(value.getUnsafeBytes(), value.getBegin(), value.getBegin() + value.getRealSize(), Layouts.MATCH_DATA.getRegion(matchData));
                return this.getIndex(matchData, i, NotProvided.INSTANCE);
            }
            catch (ValueException e) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().indexError(String.format("undefined group name reference: %s", index.toString()), this));
            }
        }

        @Specialization(guards={"!isRubySymbol(index)", "!isRubyString(index)", "!isIntegerFixnumRange(index)"})
        public Object getIndex(VirtualFrame frame, DynamicObject matchData, Object index, NotProvided length) {
            CompilerDirectives.transferToInterpreter();
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.getIndex(matchData, this.toIntNode.doInt(frame, index), NotProvided.INSTANCE);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isIntegerFixnumRange(range)"})
        public Object getIndex(DynamicObject matchData, DynamicObject range, NotProvided len) {
            Object[] values = Layouts.MATCH_DATA.getValues(matchData);
            int normalizedIndex = ArrayOperations.normalizeIndex(values.length, Layouts.INTEGER_FIXNUM_RANGE.getBegin(range));
            int end = ArrayOperations.normalizeIndex(values.length, Layouts.INTEGER_FIXNUM_RANGE.getEnd(range));
            int exclusiveEnd = ArrayOperations.clampExclusiveIndex(values.length, Layouts.INTEGER_FIXNUM_RANGE.getExcludedEnd(range) ? end : end + 1);
            int length = exclusiveEnd - normalizedIndex;
            Object[] store = Arrays.copyOfRange(values, normalizedIndex, normalizedIndex + length);
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), store, length);
        }
    }
}

